---------------------------------------------------------------------------
-- This VHDL file was developed by Daniel Llamocca (2013).  It may be
-- freely copied and/or distributed at no cost.  Any persons using this
-- file for any purpose do so at their own risk, and are responsible for
-- the results of such use.  Daniel Llamocca does not guarantee that
-- this file is complete, correct, or fit for any particular purpose.
-- NO WARRANTY OF ANY KIND IS EXPRESSED OR IMPLIED.  This notice must
-- accompany any copy of this file.
--------------------------------------------------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
 
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--USE ieee.numeric_std.ALL;
 
ENTITY tb_iter_sign_mult IS
    generic (N: INTEGER:= 12;
             M: INTEGER:= 8);
END tb_iter_sign_mult;
 
ARCHITECTURE behavior OF tb_iter_sign_mult IS 
 
    -- Component Declaration for the Unit Under Test (UUT)  
    component iter_sign_mult
        port (clock, resetn, s: in std_logic;
              A: in std_logic_vector (N-1 downto 0);
              B: in std_logic_vector (M-1 downto 0);
              P: out std_logic_vector (N+M -1 downto 0);
              done: out std_logic);
    end component;       

   --Inputs
   signal clock : std_logic := '0';
   signal resetn : std_logic := '0';
   signal s : std_logic := '0';
   signal A : std_logic_vector(N-1 downto 0) := (others => '0');
   signal B : std_logic_vector(M-1 downto 0) := (others => '0');

 	--Outputs
   signal P : std_logic_vector(N+M-1 downto 0);
   signal done : std_logic;

   -- Clock period definitions
   constant clock_period : time := 10 ns;
 
BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: iter_sign_mult PORT MAP (
          clock => clock,
          resetn => resetn,
          s => s,
          A => A,
          B => B,
          P => P,
          done => done
        );

   -- Clock process definitions
   clock_process :process
   begin
		clock <= '0';
		wait for clock_period/2;
		clock <= '1';
		wait for clock_period/2;
   end process;
 

   -- Stimulus process
   stim_proc: process
   begin		
      -- hold reset state for 100 ns.
      wait for 100 ns; resetn <= '1';

      -- insert stimulus here 
		A <= x"FED"; B <= x"FC"; s <= '1'; wait for clock_period;
		s <= '0';
		
		wait for clock_period*(N+5);
		A <= x"48A"; B <= x"FE"; s <= '1'; wait for clock_period;
		s <= '0';
		
		wait for clock_period*(N+5);
        A <= x"78C"; B <= x"F4"; s <= '1'; wait for clock_period;
        s <= '0';

		wait for clock_period*(N+5);
        A <= x"78D"; B <= x"61"; s <= '1'; wait for clock_period;
        s <= '0';
        
      wait;
   end process;

END;
