---------------------------------------------------------------------------
-- This VHDL file was developed by Daniel Llamocca (2013).  It may be
-- freely copied and/or distributed at no cost.  Any persons using this
-- file for any purpose do so at their own risk, and are responsible for
-- the results of such use.  Daniel Llamocca does not guarantee that
-- this file is complete, correct, or fit for any particular purpose.
-- NO WARRANTY OF ANY KIND IS EXPRESSED OR IMPLIED.  This notice must
-- accompany any copy of this file.
--------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity iter_sign_mult is
	generic (N: INTEGER:= 12;
	         M: INTEGER:= 8);
	port (clock, resetn, s: in std_logic;
	      A: in std_logic_vector (N-1 downto 0);
	      B: in std_logic_vector (M-1 downto 0);
		  P: out std_logic_vector (N+M -1 downto 0);
	      done: out std_logic);
end iter_sign_mult;

architecture Behavioral of iter_sign_mult is

    component iter_mult
        generic (N: INTEGER:= 12;
                 M: INTEGER:= 8);
        port (clock, resetn, s: in std_logic;
              dA: in std_logic_vector (N-1 downto 0);
              dB: in std_logic_vector (M-1 downto 0);
              P: out std_logic_vector (N+M -1 downto 0);
              done: out std_logic);
    end component;
	
	component my_addsub
		generic (N: INTEGER:= 4);
		port(	addsub   : in std_logic;
				x, y     : in std_logic_vector (N-1 downto 0);
				s        : out std_logic_vector (N-1 downto 0);
				overflow : out std_logic;
				cout     : out std_logic);
	end component;
	
	component my_rege
		generic (N: INTEGER:= 4);
		port ( clock, resetn: in std_logic;
				 E, sclr: in std_logic; -- sclr: Synchronous clear
				 D: in std_logic_vector (N-1 downto 0);
				 Q: out std_logic_vector (N-1 downto 0));
	end component;

    component dffe
        Port ( d : in  STD_LOGIC;
                clrn: in std_logic:= '1';
                  prn: in std_logic:= '1';
               clk : in  STD_LOGIC;
                  ena: in std_logic;
               q : out  STD_LOGIC);
    end component;

	signal Aq, As: std_logic_vector (N-1 downto 0);
	signal Bq, Bs: std_logic_vector (M-1 downto 0);
	signal sq, sqq, aux, donep: std_logic;
	signal Pt, dP: std_logic_vector (N+M -1 downto 0);
	
begin

ds: dffe port map (d => s, clrn => resetn, prn => '1' , clk => clock, ena => '1', q => sq);

-- Register A:
rA: my_rege generic map (N => N)
	port map (clock => clock, resetn => resetn, E => '1', sclr => '0', D => A, Q => Aq);

-- Register B:
rB: my_rege generic map (N => M)
	port map (clock => clock, resetn => resetn, E => '1', sclr => '0', D => B, Q => Bq);
	 
aux <= Aq(N-1) xor Bq(M-1);

db: dffe port map (d => aux, clrn => resetn, prn => '1' , clk => clock, ena => sq, q => sqq);

--	Adder/Subtractor for A:
ga: my_addsub generic map (N => N)
    port map (addsub => Aq(N-1), x => (others => '0'), y => Aq, s => As);

--	Adder/Subtractor for B:
gb: my_addsub generic map (N => M)
    port map (addsub => Bq(M-1), x => (others => '0'), y => Bq, s => Bs);

ma: iter_mult generic map (N=>N, M=>M)
    port map (clock => clock, resetn => resetn, s => sq, dA => As, dB => Bs, P => Pt, done => donep);
    	 
--	 Adder:
gP: my_addsub generic map (N => N+M)
    port map (addsub => sqq, x => (others => '0'), y => Pt, s => dP);
	 
-- Register P:
rP: my_rege generic map (N => N+M)
	port map (clock => clock, resetn => resetn, E => '1', sclr => '0', D => dP, Q => P);
	
dd: dffe port map (d => donep, clrn => resetn, prn => '1' , clk => clock, ena => '1', q => done);

end Behavioral;

