% Sam Bellestri, Joshua Mack, Nia Simmonds IREECE 2015
% plotResource:
%   Used to generate "LUTs vs Register usage" plots

% Bit widths that were analyzed
bits = [76,72,68,64,60,56,52,48,44,40,36,32,28,24];
% x^y LUT usage for each of those corresponding bit-widths
xyLUT = [8243,7665,7108,6626,6070,5219,4745,4120,3549,2930,2489,2090,1644,1288];
% x^y Register usage for each of those corresponding bit-widths
xyReg = [719, 683, 647, 614, 572, 535, 497, 458, 420, 383, 347, 311, 275, 239];

% e^x LUT usage for each of those corresponding bit-widths
exLUT = [2450, 2360, 2229, 2127, 1996, 1859, 1717, 1591, 1460, 1322, 1191, 1016, 886, 747];
% e^x Register usage for each of those corresponding bit-widths
exReg = [568, 540, 512, 487, 453, 421, 392, 363, 331, 302, 274, 245, 217, 189];

lnxLUT = [2560,2438,2322,2192,2026,1906,1757,1605,1443,1302,1202,1059,928,786];
lnxReg = [568,540,512,485,450,421,389,360,329,300,270,242,215,186];

% Optional line to close all currently open plots
% close all;
% Open a figure and begin plotting
figure 
h = scatter(exLUT,exReg,'r');
hold on
i = scatter(xyLUT,xyReg,'g');
j = scatter(lnxLUT,lnxReg,'b');
% Set the colors, sizes, and shapes of each graph's markers
for n = 1:length(h)
  set(j(n), 'MarkerFaceColor', 'b', 'SizeData', 16, 'Marker', 'd');
  set(i(n), 'MarkerFaceColor', 'g', 'SizeData', 16, 'Marker', 'o');
  set(h(n), 'MarkerFaceColor', 'r', 'SizeData', 16, 'Marker', '*');
end
% Add labels and things to make everything look nice
x_label = xlabel('LUTs','FontName','Helvetica');
set(x_label,'FontSize',12);
y_label = ylabel('Registers');
set(y_label,'FontSize',12);
h_legend = legend('{e}^{x}','{x}^{y}','ln(x)','Location','southeast');
set(h_legend,'FontSize',10);
title('Hardware Resource Utilization','FontSize',12);

