% Joshua Mack, Sam Bellestri, Nia Simmonds IREECE 2015
% plotConvergenceRanges_xToTheY:
%   Generates the plot that shows the different intervals of convergence for different values of M
%   in Expanded Hyperbolic CORDIC

function [] = plotConvergenceRanges_xToTheY

    M = [2.09113 3.44515 5.16215 7.23371 9.65581 12.42644 15.54462 19.00987 22.82194 26.98070 31.48609];
    myStrs = {'M = 0' 'M = 1' 'M = 2' 'M = 3' 'M = 4' 'M = 5' 'M = 6' 'M = 7' 'M = 8' 'M = 9' 'M = 10'}; 
    x = 0.1:0.001:12;
    
    cc = parula(11);
    
    figure();
    % Plot the positive graphs
    for i = 1:1:length(M)
        % This commented-out section of code can be used to highlight a particular case.
        % Here, when M = 5, the curve is highlighted red and made slightly thicker.
        
        % if i ~= 6
            plot(x, M(i)./log(x), 'color', cc(i,:)); hold on;
        % else
        %     plot(x, M(i)./log(x), 'color', 'red', 'linewidth', 2); hold on;
        % end
    end

    %Add legends here to avoid confusion with the inverted graphs
    legend(myStrs);

    %Plot the inverted graphs
    for i = 1:1:length(M)
        % if i ~= 6
            plot(x, -M(i)./log(x), 'color', cc(i,:)); hold on;
        % else
        %     plot(x, -M(i)./log(x), 'color', 'red', 'linewidth', 2); hold on;
        % end
    end

    %Add the finishing touches
    axis([0.1 12 -70 70]);
%     title('$\mid$y$\mid$ $\leq$ $\frac{\theta_{Max}(M)}{\mid ln(x)\mid}$', 'Interpreter', 'laTex', 'FontSize', 18);
    set(gca,'FontSize',12,'FontWeight','Bold');
    xlabel('X'); ylabel('Y');
    
    return;
end