% Joshua Mack, Sam Bellestri, Nia Simmonds IREECE 2015
% generateLUTs:
%   Generates floating-point CORDIC lookup tables, both the expanded LUT and the basic CORDIC LUT
%   Returns strings containing the filenames that the LUTs were saved to, with filename1 the LUT for the negative iterations
%   and filename2 the LUT for the positive iterations

function [filename1, filename2] = generateLUTs(iterations,expWidth,fracWidth)
  
    dataWidth = expWidth+fracWidth+1;
    q = quantizer('float', [dataWidth expWidth]);
    M = 5;
    
    filename1 = [num2str(dataWidth),'BitExpandedLUT.txt'];
    filename2 = [num2str(dataWidth),'BitLUT.txt'];
    
    file = fopen(filename1, 'wt');
    for i = 0: 1: M
      fprintf(file,'%s\n', num2bin(q,atanh(1-2^(-i-2))));
    end
    fclose(file);
  
    file = fopen(filename2,'wt');
    for i = 1: 1: iterations
       fprintf(file,'%s\n', num2bin(q,atanh(2^(-i)))); 
    end
    fclose(file);
    
    return;
end