% Joshua Mack, Sam Bellestri, Nia Simmonds IREECE 2015
% generateFixedLUTs:
%   Generates fixed-point CORDIC lookup tables, both the expanded LUT and the basic CORDIC LUT
%   Returns strings containing the filenames that the LUTs were saved to, with filename1 the LUT for the negative iterations
%   and filename2 the LUT for the positive iterations


function [fileName1, fileName2] = generateFixedLUTs(iterations,intWidth,fracWidth)
  
    dataWidth = intWidth+fracWidth;
    q = quantizer('fixed', [dataWidth fracWidth]);
    M = 5;
    
    fileName1 = strcat('',num2str(intWidth), '_', num2str(fracWidth),'BitExpandedLUT_Fixed','.txt');
    fileName2 = strcat('',num2str(intWidth), '_', num2str(fracWidth),'BitLUT_Fixed','.txt');
    
    file = fopen(fileName1, 'wt');
    for i = 0: 1: M
      fprintf(file,'%s\n', num2bin(q,atanh(1-2^(-i-2))));
    end
    fclose(file);
  
    file = fopen(fileName2, 'wt');
    for i = 1: 1: iterations
       fprintf(file,'%s\n', num2bin(q,atanh(2^(-i)))); 
    end
    fclose(file);

    return;
end