% Joshua Mack, Sam Bellestri, Nia Simmonds IREECE 2015
% convertPlotAndPSNR_xToTheY_Fixed:
%   Takes in the test domain used in a given testbench file along with the corresponding integer and fractional widths of the fixed-point format and number of iterations
%   And then looks for a corresponding results textfile of the form "(numIters)iterations(intWidth + fracWidth)bits_xToTheY_Fixed.txt" 
%   inside the "FixedPt_xToTheY_VivadoResults" directory within the current Matlab operating directory.
%   If it doesn't the file, it displays an error message and exits, and if the file doesn't have the number of points as specified by xPoints * yPoints,
%   Then it also returns an error and exits. 

function myPSNR = convertPlotAndPSNR_xToTheY_Fixed(xLower, xUpper, xPoints, yPoints, intWidth, fracWidth, numIters)
    
    % Delcare some variables
    dataWidth = intWidth+fracWidth;
    q = quantizer('fixed', [dataWidth fracWidth]);
    xRange = linspace(xLower, xUpper, xPoints); 
    % yRange = linspace(yLower, yUpper, yPoints);
    fileName = [num2str(numIters), 'iterations', num2str(dataWidth), 'bits_xToTheY_Fixed.txt'];
    
    % Attempt to open the results file. If not found, print an error and exit with psnr = -123456, 
    % which indicates for the corresponding "UltimateTestScript" that the current test case needs to be repeated.
    file1 = fopen(['./FixedPt_xToTheY_VivadoResults/', fileName], 'r');
    if file1 == -1
        fprintf('----------------------------------------------------\n');
        display(['xToTheY results not found for ', num2str(intWidth+fracWidth), ' bits, ', num2str(numIters), ' iterations.']);
        fprintf('----------------------------------------------------\n');
        myPSNR = -123456;
        return;
    end

    % Extract the values into a cell array of strings
    s1 = textscan(file1,'%s');
    fclose(file1);
    
    myPowStrs = s1{1};

    % If we don't have xPoints * yPoints data points, print an error and exit with psnr = -123456, 
    % which indicates for the corresponding "UltimateTestScript" that the current test case needs to be repeated.
    if length(myPowStrs) ~= xPoints*yPoints
        fprintf('----------------------------------------------------\n');
        display(['The Vivado simulator did not finish for ', num2str(intWidth+fracWidth), ' bits, ', num2str(numIters), ' iterations.']);
        fprintf('----------------------------------------------------\n');
        myPSNR = -123456;
        return;
    end
    
    myXToTheYs = zeros(xPoints, yPoints);
    
    % Extract the numerical values from each corresponding string
    % (j, i) because 'surf' wants things in the order surf(yVals, xVals, zVals) 
    % So switch x and y to make it right.
    valNum = 1;
    for i = 1:1:xPoints
        for j = 1:1:yPoints
            myXToTheYs(j, i) = bin2num(q, cell2mat(myPowStrs(valNum)));
            valNum = valNum + 1;
        end
    end

    % Generate reference Matlab values
    matlabPows = zeros(xPoints, yPoints);
    for i = 1:1:xPoints
        yRange = linspace(-12.42644/log(xRange(i)), 12.42644/log(xRange(i)), yPoints);
        for j = 1:1:yPoints
            matlabPows(j, i) = xRange(i)^yRange(j);
        end
    end
    
    % Calculate PSNR and exit
    maxVal = 2^(18) - 2^(-fracWidth);
    myPSNR = psnr(myXToTheYs, matlabPows, maxVal);
    display(myPSNR);
    return;
    
end