% Joshua Mack, Sam Bellestri, Nia Simmonds IREECE 2015
% convertPlotAndPSNR_eToTheX_Fixed:
%   Takes in the test domain used in a given testbench file along with the corresponding integer and fractional widths of the format and number of iterations
%   And then looks for a corresponding results textfile of the form "(numIters)iterations(intWidth + fracWidth)bits_eToTheX_Fixed.txt" 
%   inside the "FixedPt_eToTheX_VivadoResults" directory within your current Matlab operating directory.
%   If it doesn't the file, it displays an error message and exits, and if the file doesn't have the number of points as specified by xPoints,
%   Then it also returns an error and exits. 

function myPSNR = convertPlotAndPSNR_eToTheX_Fixed(xLower, xUpper, xPoints, intWidth, fracWidth, numIters)
    
    % Variable delcarations
    dataWidth = intWidth+fracWidth;
    q = quantizer('fixed', [dataWidth fracWidth]);
    xRange = linspace(xLower, xUpper, xPoints); 
    fileName = [num2str(numIters), 'iterations', num2str(dataWidth), 'bits_eToTheX_fixed.txt'];
    
    % Attempt to open the e^x simulation results in the folder "FixedPt_eToTheX_VivadoResults" within Matlab's operating directory
    file1 = fopen(['./FixedPt_eToTheX_VivadoResults/', fileName], 'r');
    if file1 == -1
        % If the results file isn't found, print an error and return psnr = -123456, an error code in the corresponding UltimateTestScript file
        fprintf('----------------------------------------------------\n');
        display(['eToTheX results not found for ', num2str(intWidth+fracWidth), ' bits, ', num2str(numIters), ' iterations.']);
        fprintf('----------------------------------------------------\n');
        myPSNR = -123456;
        return;
    end
    
    % Extract the strings into a cell array
    s1 = textscan(file1,'%s');
    fclose(file1);
    
    myExpStrs = s1{1};
    
    % Check that we have the expected number of values. If not, report an error.
    if length(myExpStrs) ~= xPoints
        fprintf('----------------------------------------------------\n');
        display(['The Vivado simulator failed for ', num2str(intWidth+fracWidth), ' bits, ', num2str(numIters), ' iterations.']);
        fprintf('----------------------------------------------------\n');
        myPSNR = -123456;
        return;
    end

    myEToTheXs = zeros(xPoints, 1);

    % Extract the numerical values from the corresponding strings    
    for i = 1:1:xPoints
        myEToTheXs(i) = bin2num(q, cell2mat(myExpStrs(i)));
    end
    
    % Optional section of code used for plotting specific test cases while iterating through the corresponding "UltimateTestScript" script
    if dataWidth == 24 && numIters == 8 || dataWidth == 28 && numIters == 8 || dataWidth == 32 && numIters == 12
        figure();
        plot(xRange, exp(xRange)); hold all;
        myPlot = plot(xRange, myEToTheXs); hold all;
        legend(myPlot, [num2str(intWidth+fracWidth), ' Bits, ', num2str(numIters), ' iters']);
    end

    % Generate the reference Matlab values
    matlabExps = zeros(length(xRange), 1);
    for i = 1:1:length(xRange)
        matlabExps(i) = exp(xRange(i));
    end
    
    % Calculate the PSNR
    maxVal = 2^(18) - 2^(-fracWidth);
    myPSNR = psnr(myEToTheXs, matlabExps, maxVal);
    display(myPSNR);
    return;
    
end