% Joshua Mack, Sam Bellestri, Nia Simmonds IREECE 2015
% convertPlotAndPSNR_eToTheX:
%   Takes in the test domain used in a given testbench file along with the corresponding exponent and fractional widths of the format and number of iterations
%   And then looks for a corresponding results textfile of the form "(numIters)iterations(expWidth + fracWidth + 1)bits_eToTheX.txt" 
%   inside the "FloP_eToTheX_VivadoResults" directory within your current Matlab operating directory.
%   If it doesn't the file, it displays an error message and exits, and if the file doesn't have the number of points as specified by xPoints,
%   Then it also returns an error and exits. 

function myPSNR = convertPlotAndPSNR_eToTheX(xLower, xUpper, xPoints, expWidth, fracWidth, numIters)
    
    % Variable declarations
    dataWidth = expWidth+fracWidth+1;
    q = quantizer('float', [dataWidth expWidth]);
    xRange = linspace(xLower, xUpper, xPoints); 
    fileName = [num2str(numIters), 'iterations', num2str(dataWidth), 'bits_eToTheX.txt'];
    
    % Attempt to open the results file
    file1 = fopen(['./FloP_eToTheX_VivadoResults/', fileName], 'r');
    if file1 == -1
        % If the file isn't found, print an error and exit
        fprintf('----------------------------------------------------\n');
        display(['eToTheX results not found for ', num2str(expWidth+fracWidth+1), ' bits, ', num2str(numIters), ' iterations.']);
        fprintf('----------------------------------------------------\n');
        myPSNR = -123456;
        return;
    end

    % Extract the results into a cell array of strings
    s1 = textscan(file1,'%s');
    fclose(file1);
    
    myExpStrs = s1{1};
    
    % If we don't have xPoints data points, print an error and exit
    if length(myExpStrs) ~= xPoints
        fprintf('----------------------------------------------------\n');
        display(['The Vivado simulator failed for ', num2str(expWidth+fracWidth+1), ' bits, ', num2str(numIters), ' iterations.']);
        fprintf('----------------------------------------------------\n');
        myPSNR = -123456;
        return;
    end

    myEToTheXs = zeros(xPoints, 1);
    
    % Convert the strings into their numerical values
    for i = 1:1:xPoints
        myEToTheXs(i) = bin2num(q, cell2mat(myExpStrs(i)));
    end
    
    % Optional section of code that can be used to plot specific cases as they occur in the corresponding "UltimateTestScript" file
    if dataWidth == 16 && numIters == 8 || dataWidth == 20 && numIters == 12 || dataWidth == 24 && numIters == 16
        figure();
        plot(xRange, exp(xRange)); hold all;
        myPlot = plot(xRange, myEToTheXs); hold all;
        legend(myPlot, [num2str(expWidth+fracWidth+1), ' Bits, ', num2str(numIters), ' iters']);
    end
    
    % Generate the reference Matlab values
    matlabExps = zeros(length(xRange), 1);
    for i = 1:1:length(xRange)
        matlabExps(i) = exp(xRange(i));
    end
    
    % Calculate PSNR and exit
    maxVal = exp(max(xRange));
    myPSNR = psnr(myEToTheXs, matlabExps, maxVal);
    display(myPSNR);
    return;
    
end