% Joshua Mack, Sam Bellestri, Nia Simmonds IREECE 2015
% convertPlotAndPSNR_coshX_sinhX_Fixed:
%   Takes in the test domain used in a given testbench file along with the corresponding integer and fractional widths of the format and number of iterations
%   And then looks for a corresponding results textfiles of the form "(numIters)iterations(intWidth + fracWidth)bits_cosh_fixed.txt" and "(numIters)iterations(intWidth + fracWidth)bits_sinh_fixed.txt"
%   inside the "FixedPt_coshX_VivadoResults" and "FixedPt_sinhX_VivadoResults" directories within your current Matlab operating directory.
%   If it doesn't find one of the files, it displays an error message, and if each file doesn't have the number of points as specified by xPoints,
%   Then it also returns an error and exits. 

function [coshPSNR, sinhPSNR] = convertPlotAndPSNR_coshX_sinhX_Fixed(xLower, xUpper, xPoints, intWidth, fracWidth, numIters)
    
    % Declare some variables
    dataWidth = intWidth+fracWidth;
    q = quantizer('fixed', [dataWidth fracWidth]);
    xRange = linspace(xLower, xUpper, xPoints); 
    
    % Filenames that will attempt to be opened
    fileName1 = [num2str(numIters), 'iterations', num2str(dataWidth), 'bits_cosh_fixed.txt'];
    fileName2 = [num2str(numIters), 'iterations', num2str(dataWidth), 'bits_sinh_fixed.txt'];
    
    % Attempt to open coshX results
    file1 = fopen(['./FixedPt_coshX_VivadoResults/', fileName1], 'r');
    if file1 == -1
        % If cosh results fail to open, displays an error and returns psnr = -123456, which is used as an error code in the corresponding UltimateTestScript file.
        display(['Cosh results failed to open for ', num2str(intWidth+fracWidth), ' bits, ', num2str(numIters), ' iterations.']);
        coshPSNR = -123456;
        return;
    end
    % Read the coshX results into a cell array
    s1 = textscan(file1,'%s');
    fclose(file1);

    % Attempt to open sinhX results
    file2 = fopen(['./FixedPt_sinhX_VivadoResults/', fileName2], 'r');
    if file1 == -1
        % If sinh results fail to open, displays an error and returns psnr = -123456, which is used as an error code in the corresponding UltimateTestScript file.
        display(['Sinh results failed to open for ', num2str(intWidth+fracWidth), ' bits, ', num2str(numIters), ' iterations.']);
        sinhPSNR = -123456;
        return;
    end
    % Read the sinhX results into a cell array
    s2 = textscan(file2,'%s');
    fclose(file2);
    
    myCoshStrs = s1{1};
    mySinhStrs = s2{1};

    % If either results array is lacking in the expected number of points, report an error.
    if length(myCoshStrs) ~= xPoints && length(mySinhStrs) ~= xPoints
        display(['The Vivado simulator failed for ', num2str(intWidth+fracWidth), ' bits, ', num2str(numIters), ' iterations.']);
        coshPSNR = -123456;
        sinhPSNR = -123456;
        return;
    end
    
    % Allocate some memory
    myCoshs = zeros(xPoints, 1);
    mySinhs = zeros(xPoints, 1);
    
    % Read the numerical values from each string cell array.
    for i = 1:1:xPoints
        myCoshs(i) = bin2num(q, cell2mat(myCoshStrs(i)));
        mySinhs(i) = bin2num(q, cell2mat(mySinhStrs(i)));
    end
    
    % Uncomment these lines if plotting is desired
    % close all;
    % figure();
    % subplot(1, 2, 1);
    % plot(xRange, myCoshs);
    % subplot(1, 2, 2);
    % plot(xRange, mySinhs);

    % Allocate memory for Matlab comparision values
    matlabCoshs = zeros(xPoints, 1);
    matlabSinhs = zeros(xPoints, 1);
    % Generate Matlab comparison values
    for i = 1:1:xPoints
        matlabCoshs(i) = cosh(xRange(i));
        matlabSinhs(i) = sinh(xRange(i));
    end
    
    % The maximum value attainable in the format with
    % the minimum number of integer bits necessary to
    % represent all values up to max(cosh(xRange))
    maxVal = 2^(17) - 2^(-fracWidth);
    coshPSNR = psnr(myCoshs, matlabCoshs, maxVal);
    sinhPSNR = psnr(mySinhs, matlabSinhs, maxVal);
    
    display(coshPSNR);
    display(sinhPSNR);
    return;
    
end