% Joshua Mack, Sam Bellestri, Nia Simmonds IREECE 2015
% convertPlotAndPSNR_NaturalLogX_Fixed:
%   Takes in the test domain used in a given testbench file along with the corresponding integer and fractional widths of the fixed-point format and number of iterations
%   And then looks for a corresponding results textfile of the form "(numIters)iterations(intWidth + fracWidth)bits_NaturalLogX_Fixed.txt" 
%   inside the "FixedPt_NaturalLogX_VivadoResults" directory within your current Matlab operating directory.
%   If it doesn't the file, it displays an error message and exits, and if the file doesn't have the number of points as specified by xPoints,
%   Then it also returns an error and exits. 

function myPSNR = convertPlotAndPSNR_NaturalLogX_Fixed(xLower, xUpper, xPoints, intWidth, fracWidth, numIters)
    
    % Declare some variables
    dataWidth = intWidth+fracWidth;
    q = quantizer('fixed', [dataWidth fracWidth]);
    xRange = linspace(xLower, xUpper, xPoints); 
    fileName = [num2str(numIters), 'iterations', num2str(fracWidth), 'fracBits', num2str(intWidth), 'intBits_NaturalLogX_fixed.txt'];
    
    % Attempt to open the results file, and print an error and exit if the file isn't found.
    file1 = fopen(['./FixedPt_NaturalLogX_VivadoResults/', fileName], 'r');
    if file1 == -1
        fprintf('----------------------------------------------------\n');
        display(['NaturalLogX results not found for ', num2str(intWidth+fracWidth), ' bits, ', num2str(numIters), ' iterations.']);
        fprintf('----------------------------------------------------\n');
        myPSNR = -123456;
        return;
    end

    % Scan the results into a cell array of strings
    s1 = textscan(file1,'%s');
    fclose(file1);
    
    myLogStrs = s1{1};
    
    % If we don't have xPoints data points, then print an error and exit
    if length(myLogStrs) ~= xPoints
        fprintf('----------------------------------------------------\n');
        display(['The Vivado simulator failed for ', num2str(intWidth+fracWidth), ' bits, ', num2str(numIters), ' iterations.']);
        fprintf('----------------------------------------------------\n');
        myPSNR = -123456;
        return;
    end

    myNaturalLogXs = zeros(xPoints, 1);
    
    % Extract the numerical values from each corresponding string
    for i = 1:1:xPoints
        myNaturalLogXs(i) = bin2num(q, cell2mat(myLogStrs(i)));
    end
    
    % Optional segment of code that can be used to create plots of ln(x) for certain chosen test cases
    if dataWidth == 68 && numIters == 32 || dataWidth == 72 && numIters == 32 || dataWidth == 76 && numIters == 32
        figure();
        plot(xRange, log(xRange)); hold all;
        myPlot = plot(xRange, myNaturalLogXs); hold all;
        legend(myPlot, [num2str(intWidth+fracWidth), ' Bits, ', num2str(numIters), ' iters']);
    end

    % Generate reference Matlab values
    matlabLogs = zeros(length(xRange), 1);
    for i = 1:1:length(xRange)
        matlabLogs(i) = log(xRange(i));
    end
    
    % Calculate PSNR and exit
    maxVal = 2^(5) - 2^(-fracWidth);
    myPSNR = psnr(myNaturalLogXs, matlabLogs, maxVal);
    display(myPSNR);
    return;
    
end