% Joshua Mack, Sam Bellestri, Nia Simmonds IREECE 2015
% convertPlotAndPSNR_NaturalLogX:
%   Takes in the test domain used in a given testbench file along with the corresponding exponent and fractional widths of the format and number of iterations
%   And then looks for a corresponding results textfile of the form "(numIters)iterations(expWidth + fracWidth + 1)bits_NaturalLogX.txt" 
%   inside the "FloP_NaturalLogX_VivadoResults" directory within your current Matlab operating directory.
%   If it doesn't the file, it displays an error message and exits, and if the file doesn't have the number of points as specified by xPoints,
%   Then it also returns an error and exits. 

function myPSNR = convertPlotAndPSNR_NaturalLogX(xLower, xUpper, xPoints, expWidth, fracWidth, numIters)
    
    % Variable declarations
    dataWidth = expWidth+fracWidth+1;
    q = quantizer('float', [dataWidth expWidth]);
    xRange = linspace(xLower, xUpper, xPoints); 
    fileName = [num2str(numIters), 'iterations', num2str(dataWidth), 'bits_NaturalLogX.txt'];
    
    % Attempt to open the testbench results file
    file1 = fopen(['./FloP_NaturalLogX_VivadoResults/', fileName], 'r');
    if file1 == -1
        % If the file isn't found, print an error and exit
        fprintf('----------------------------------------------------\n');
        display(['NaturalLogX results not found for ', num2str(expWidth+fracWidth+1), ' bits, ', num2str(numIters), ' iterations.']);
        fprintf('----------------------------------------------------\n');
        myPSNR = -123456;
        return;
    end

    % Extract the results into a cell array of strings
    s1 = textscan(file1,'%s');
    fclose(file1);
    
    myLogStrs = s1{1};

    % If we don't have xPoints data points, print an error and exit.
    if length(myLogStrs) ~= xPoints
        fprintf('----------------------------------------------------\n');
        display(['The Vivado simulator failed for ', num2str(expWidth+fracWidth+1), ' bits, ', num2str(numIters), ' iterations.']);
        fprintf('----------------------------------------------------\n');
        myPSNR = -123456;
        return;
    end
    
    myLogs = zeros(xPoints, 1);
    
    % Extract the numerical values from each corresponding string.
    for i = 1:1:xPoints
        myLogs(i) = bin2num(q, cell2mat(myLogStrs(i)));
    end
    
    % Optional segment of code that can be used to plot specific cases as they arise in the corresponding "UltimateTestScript" file
    if dataWidth == 40 && numIters == 28 || dataWidth == 44 && numIters == 32 || dataWidth == 48 && numIters == 36%(dataWidth == 16 || dataWidth == 20 || dataWidth == 24)
        figure();
        plot(xRange, log(xRange)); hold all;
        myPlot = plot(xRange, myLogs); hold all;
        legend(myPlot, [num2str(expWidth+fracWidth+1), ' Bits, ', num2str(numIters), ' iters']);
    end

    % Generate the reference Matlab values
    matlabLogs = zeros(length(xRange), 1);
    for i = 1:1:length(xRange)
        matlabLogs(i) = log(xRange(i));
    end
    
    % Calculate PSNR and exit.
    maxVal = log(max(xRange));
    myPSNR = psnr(myLogs, matlabLogs, maxVal);
    display(myPSNR);
    return;
    
end