% Joshua Mack, Sam Bellestri, Nia Simmonds IREECE 2015
% PlotPareto_xToTheY:
%   Used to generate the Pareto diagram for a given set of PSNR results.
%   The "myPSNR" column is a column of PSNR values from a spreadsheet organized as, for example, 
%   "(12 bits, 12 iterations), (12 bits, 16 iterations), ... (12 bits, 40 iterations), (16 bits, 12 iterations), ..., (76 bits, 40 iterations)"
%   The "myResoruces" column is a column of FPGA slice usage from a spreadsheet organized from smallest bit width to largest bit width (example: 12 bits to 76 bits) 

%Raw column from spreadsheet
myPSNR = [22.215273
            22.215273
            22.215273
            22.215273
            22.215273
            22.215273
            22.215273
            22.215273
            22.215273
            42.417066
            42.417066
            42.417066
            42.417066
            42.417066
            42.417066
            42.417066
            42.417066
            42.417066
            43.947803
            43.956806
            43.956806
            43.956806
            43.956806
            43.956806
            43.956806
            43.956806
            43.956806
            59.022308
            59.455261
            59.452331
            59.452331
            59.452331
            59.452331
            59.452331
            59.452331
            59.452331
            50.781355
            50.775769
            50.766871
            50.766664
            50.766664
            50.766664
            50.766664
            50.766664
            50.766664
            68.783942
            90.636812
            104.995607
            105.284877
            105.284837
            105.284837
            105.284837
            105.284837
            105.284837
            68.783942
            90.774678
            116.428781
            128.065724
            128.392256
            128.404408
            128.404408
            128.404408
            128.404408
            68.783906
            90.777216
            116.716528
            137.296058
            141.308077
            141.540665
            141.554623
            141.554623
            141.554623
            68.783906
            90.777216
            116.716528
            137.296058
            141.308077
            141.540665
            141.554623
            141.554623
            141.554623
            68.783906
            90.777216
            116.716528
            137.296058
            141.308077
            141.540665
            141.554623
            141.554623
            141.554623
            68.783906
            90.777216
            116.716528
            137.296058
            141.308077
            141.540665
            141.554623
            141.554623
            141.554623
            68.783906
            90.777216
            116.716528
            137.296058
            141.308077
            141.540665
            141.554623
            141.554623
            141.554623
            68.783906
            90.777216
            116.716528
            137.296058
            141.308077
            141.540665
            141.554623
            141.554623
            141.554623
            68.783906
            90.777216
            116.716528
            137.296058
            141.308077
            141.540665
            141.554623
            141.554623
            141.554623];
%Raw column from spreadsheet
myResources = [382
                480
                601
                710
                829
                993
                1145
                1312
                1439
                1661
                1811
                1939
                2088
                2241];   

% Matrix to separate by bit-width/resources. Splits the column back into an array that can be indexed as "(bit width, num iterations)"
% Left/Right = number of iterations
% Up/Down = number of resources
myPSNRSep = zeros(length(myResources), length(myPSNR)/length(myResources));
% This line can be used if the resource usage instead comes in as max->min when it needs to be min->max
% myResourcesFlip = (fliplr(myResources'))';
myResourcesFlip = myResources;

% PSNR-Length
pLen = length(myPSNR)/length(myResources);
% Resources-Length
rLen = length(myResources);

% Separate the data.
for i = 1:1:rLen
   myPSNRSep(i, :) = myPSNR((pLen*(i-1)+1):1:(pLen*i)); 
end

% Open a figure and plot it
figure();
% Generate a color map to make things look nice
cc = hsv(length(myPSNRSep));
% Plot the plots and create the accompanying labels
for i = 1:1:length(myPSNRSep)
    myPlots(i, :) = plot(myPSNRSep(i,:), myResourcesFlip(i), 'd', 'color', cc(i, :), 'MarkerFaceColor', cc(i, :), 'MarkerSize', 4.0); hold on;
    bitStrs{i} = [num2str(4*i+20), ' bits'];
end
% Add a title to the graph
title('${X}^{Y}$ Resources vs PSNR', 'interpreter' ,'laTex');
% Add a legend to the graph
legend(myPlots(:, 1), bitStrs);
% Reverse the x-axis and change the font size and weight of that legend, the axis labels, and the axis tick-marks
set(gca, 'XDir', 'Reverse', 'FontSize', 11, 'FontWeight', 'bold'); 
% Make the title nice and large
set(get(gca,'title'),'FontSize',14);
% And label the axes
xlabel('PSNR [dB]');
ylabel('Slices');