library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use std.textio.all;
use ieee.std_logic_textio.all;
library std;
use std.env.all;
use ieee.std_logic_1164.all;
use ieee.math_real."floor";
use ieee.math_real."log2";
use ieee.numeric_std.all;

entity FloP_xToTheY_Generic_tb is
 end FloP_xToTheY_Generic_tb;

architecture Behavioral of FloP_xToTheY_Generic_tb is
component FloP_xToTheY is
Generic ( fileName1 : string := "16BitExpandedLUT.txt"; fileName2 : string := "16BitLUT.txt"; 
 expWidth : integer := 6; fracWidth : integer := 9; iterWidth : integer := 4 );
Port ( x, y, InverseScalingFactor : in std_logic_vector(expWidth+fracWidth downto 0);
clk, start : in std_logic;
M, N : in std_logic_vector(iterWidth-1 downto 0);
output : out std_logic_vector(expWidth+fracWidth downto 0);
done : out std_logic );
end component;

constant file1 : string := "16BitExpandedLUT.txt";
constant file2 : string := "16BitLUT.txt";
constant expWidth : integer := 6;
constant fracWidth : integer := 9;
constant iterWidth : integer := 4;
signal clk, start, done : std_logic;
signal x, y, InvScalFact, output : std_logic_vector (expWidth+fracWidth downto 0);
signal M, N : std_logic_vector (iterWidth-1 downto 0);
begin
myXToTheY : FloP_xToTheY Generic Map(fileName1 => file1, fileName2 => file2,
expWidth => expWidth, fracWidth => fracWidth, iterWidth => iterWidth)
Port Map(x => x, y => y, InverseScalingFactor => InvScalFact, clk => clk, start => start, M => M, N => N, output => output, done => done);
clock : process begin
clk <= '0'; wait for 1 ns;
clk <= '1'; wait for 1 ns;
end process;

testProc : process
FILE test_out_data1: TEXT open WRITE_MODE is "8iterations16bits_xToTheY.txt";
variable L1              : LINE;

begin

-- Using N = "8", M = "5"
N <= "1000"; M <= "0101";
-- The main pieces that need to be in place to get nonscaled, separated values of Cosh and Sinh.
InvScalFact <= "0101001111100010";

-------------------------Begin Testing----------------------------
-- Iteration 1
-- 0.000004
x <= "0001101000011010";
-- 1.000000
y <= "0011111000000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 2
-- 0.000004
x <= "0001101000011010";
-- 0.777778
y <= "0011110100011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 3
-- 0.000004
x <= "0001101000011010";
-- 0.555556
y <= "0011110000111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 4
-- 0.000004
x <= "0001101000011010";
-- 0.333333
y <= "0011101010101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 5
-- 0.000004
x <= "0001101000011010";
-- 0.111111
y <= "0011011110001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 6
-- 0.000004
x <= "0001101000011010";
-- -0.111111
y <= "1011011110001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 7
-- 0.000004
x <= "0001101000011010";
-- -0.333333
y <= "1011101010101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 8
-- 0.000004
x <= "0001101000011010";
-- -0.555556
y <= "1011110000111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 9
-- 0.000004
x <= "0001101000011010";
-- -0.777778
y <= "1011110100011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 10
-- 0.000004
x <= "0001101000011010";
-- -1.000000
y <= "1011111000000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 11
-- 1673.200764
x <= "0101001101000100";
-- -1.674160
y <= "1011111101011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 12
-- 1673.200764
x <= "0101001101000100";
-- -1.302124
y <= "1011111010011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 13
-- 1673.200764
x <= "0101001101000100";
-- -0.930089
y <= "1011110110111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 14
-- 1673.200764
x <= "0101001101000100";
-- -0.558053
y <= "1011110000111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 15
-- 1673.200764
x <= "0101001101000100";
-- -0.186018
y <= "1011100011111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 16
-- 1673.200764
x <= "0101001101000100";
-- 0.186018
y <= "0011100011111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 17
-- 1673.200764
x <= "0101001101000100";
-- 0.558053
y <= "0011110000111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 18
-- 1673.200764
x <= "0101001101000100";
-- 0.930089
y <= "0011110110111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 19
-- 1673.200764
x <= "0101001101000100";
-- 1.302124
y <= "0011111010011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 20
-- 1673.200764
x <= "0101001101000100";
-- 1.674160
y <= "0011111101011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 21
-- 3346.401525
x <= "0101010101000100";
-- -1.531172
y <= "1011111100010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 22
-- 3346.401525
x <= "0101010101000100";
-- -1.190911
y <= "1011111001100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 23
-- 3346.401525
x <= "0101010101000100";
-- -0.850651
y <= "1011110101101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 24
-- 3346.401525
x <= "0101010101000100";
-- -0.510391
y <= "1011110000001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 25
-- 3346.401525
x <= "0101010101000100";
-- -0.170130
y <= "1011100010111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 26
-- 3346.401525
x <= "0101010101000100";
-- 0.170130
y <= "0011100010111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 27
-- 3346.401525
x <= "0101010101000100";
-- 0.510391
y <= "0011110000001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 28
-- 3346.401525
x <= "0101010101000100";
-- 0.850651
y <= "0011110101100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 29
-- 3346.401525
x <= "0101010101000100";
-- 1.190911
y <= "0011111001100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 30
-- 3346.401525
x <= "0101010101000100";
-- 1.531172
y <= "0011111100001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 31
-- 5019.602285
x <= "0101011001110011";
-- -1.458313
y <= "1011111011101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 32
-- 5019.602285
x <= "0101011001110011";
-- -1.134243
y <= "1011111001000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 33
-- 5019.602285
x <= "0101011001110011";
-- -0.810174
y <= "1011110100111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 34
-- 5019.602285
x <= "0101011001110011";
-- -0.486104
y <= "1011101111100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 35
-- 5019.602285
x <= "0101011001110011";
-- -0.162035
y <= "1011100010011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 36
-- 5019.602285
x <= "0101011001110011";
-- 0.162035
y <= "0011100010010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 37
-- 5019.602285
x <= "0101011001110011";
-- 0.486104
y <= "0011101111100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 38
-- 5019.602285
x <= "0101011001110011";
-- 0.810174
y <= "0011110100111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 39
-- 5019.602285
x <= "0101011001110011";
-- 1.134243
y <= "0011111001000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 40
-- 5019.602285
x <= "0101011001110011";
-- 1.458313
y <= "0011111011101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 41
-- 6692.803046
x <= "0101011101000100";
-- -1.410687
y <= "1011111011010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 42
-- 6692.803046
x <= "0101011101000100";
-- -1.097201
y <= "1011111000110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 43
-- 6692.803046
x <= "0101011101000100";
-- -0.783715
y <= "1011110100100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 44
-- 6692.803046
x <= "0101011101000100";
-- -0.470229
y <= "1011101111000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 45
-- 6692.803046
x <= "0101011101000100";
-- -0.156743
y <= "1011100010000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 46
-- 6692.803046
x <= "0101011101000100";
-- 0.156743
y <= "0011100010000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 47
-- 6692.803046
x <= "0101011101000100";
-- 0.470229
y <= "0011101111000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 48
-- 6692.803046
x <= "0101011101000100";
-- 0.783715
y <= "0011110100100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 49
-- 6692.803046
x <= "0101011101000100";
-- 1.097201
y <= "0011111000110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 50
-- 6692.803046
x <= "0101011101000100";
-- 1.410687
y <= "0011111011010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 51
-- 8366.003806
x <= "0101100000001010";
-- -1.375834
y <= "1011111011000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 52
-- 8366.003806
x <= "0101100000001010";
-- -1.070093
y <= "1011111000100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 53
-- 8366.003806
x <= "0101100000001010";
-- -0.764352
y <= "1011110100001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 54
-- 8366.003806
x <= "0101100000001010";
-- -0.458611
y <= "1011101110101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 55
-- 8366.003806
x <= "0101100000001010";
-- -0.152870
y <= "1011100001110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 56
-- 8366.003806
x <= "0101100000001010";
-- 0.152870
y <= "0011100001110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 57
-- 8366.003806
x <= "0101100000001010";
-- 0.458611
y <= "0011101110101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 58
-- 8366.003806
x <= "0101100000001010";
-- 0.764352
y <= "0011110100001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 59
-- 8366.003806
x <= "0101100000001010";
-- 1.070093
y <= "0011111000100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 60
-- 8366.003806
x <= "0101100000001010";
-- 1.375834
y <= "0011111011000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 61
-- 10039.204567
x <= "0101100001110011";
-- -1.348611
y <= "1011111010110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 62
-- 10039.204567
x <= "0101100001110011";
-- -1.048919
y <= "1011111000011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 63
-- 10039.204567
x <= "0101100001110011";
-- -0.749228
y <= "1011110100000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 64
-- 10039.204567
x <= "0101100001110011";
-- -0.449537
y <= "1011101110011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 65
-- 10039.204567
x <= "0101100001110011";
-- -0.149846
y <= "1011100001100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 66
-- 10039.204567
x <= "0101100001110011";
-- 0.149846
y <= "0011100001100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 67
-- 10039.204567
x <= "0101100001110011";
-- 0.449537
y <= "0011101110011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 68
-- 10039.204567
x <= "0101100001110011";
-- 0.749228
y <= "0011110011111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 69
-- 10039.204567
x <= "0101100001110011";
-- 1.048919
y <= "0011111000011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 70
-- 10039.204567
x <= "0101100001110011";
-- 1.348611
y <= "0011111010110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 71
-- 11712.405327
x <= "0101100011011100";
-- -1.326420
y <= "1011111010101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 72
-- 11712.405327
x <= "0101100011011100";
-- -1.031660
y <= "1011111000010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 73
-- 11712.405327
x <= "0101100011011100";
-- -0.736900
y <= "1011110011110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 74
-- 11712.405327
x <= "0101100011011100";
-- -0.442140
y <= "1011101110001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 75
-- 11712.405327
x <= "0101100011011100";
-- -0.147380
y <= "1011100001011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 76
-- 11712.405327
x <= "0101100011011100";
-- 0.147380
y <= "0011100001011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 77
-- 11712.405327
x <= "0101100011011100";
-- 0.442140
y <= "0011101110001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 78
-- 11712.405327
x <= "0101100011011100";
-- 0.736900
y <= "0011110011110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 79
-- 11712.405327
x <= "0101100011011100";
-- 1.031660
y <= "0011111000010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 80
-- 11712.405327
x <= "0101100011011100";
-- 1.326420
y <= "0011111010100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 81
-- 13385.606087
x <= "0101100101000100";
-- -1.307780
y <= "1011111010011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 82
-- 13385.606087
x <= "0101100101000100";
-- -1.017162
y <= "1011111000001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 83
-- 13385.606087
x <= "0101100101000100";
-- -0.726544
y <= "1011110011101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 84
-- 13385.606087
x <= "0101100101000100";
-- -0.435927
y <= "1011101101111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 85
-- 13385.606087
x <= "0101100101000100";
-- -0.145309
y <= "1011100001010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 86
-- 13385.606087
x <= "0101100101000100";
-- 0.145309
y <= "0011100001010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 87
-- 13385.606087
x <= "0101100101000100";
-- 0.435927
y <= "0011101101111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 88
-- 13385.606087
x <= "0101100101000100";
-- 0.726544
y <= "0011110011100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 89
-- 13385.606087
x <= "0101100101000100";
-- 1.017162
y <= "0011111000001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 90
-- 13385.606087
x <= "0101100101000100";
-- 1.307780
y <= "0011111010011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 91
-- 15058.806848
x <= "0101100110101101";
-- -1.291768
y <= "1011111010010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 92
-- 15058.806848
x <= "0101100110101101";
-- -1.004708
y <= "1011111000000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 93
-- 15058.806848
x <= "0101100110101101";
-- -0.717649
y <= "1011110011011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 94
-- 15058.806848
x <= "0101100110101101";
-- -0.430589
y <= "1011101101110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 95
-- 15058.806848
x <= "0101100110101101";
-- -0.143530
y <= "1011100001001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 96
-- 15058.806848
x <= "0101100110101101";
-- 0.143530
y <= "0011100001001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 97
-- 15058.806848
x <= "0101100110101101";
-- 0.430589
y <= "0011101101110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 98
-- 15058.806848
x <= "0101100110101101";
-- 0.717649
y <= "0011110011011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 99
-- 15058.806848
x <= "0101100110101101";
-- 1.004708
y <= "0011111000000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 100
-- 15058.806848
x <= "0101100110101101";
-- 1.291768
y <= "0011111010010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 101
-- 16732.007608
x <= "0101101000001010";
-- -1.277773
y <= "1011111010001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 102
-- 16732.007608
x <= "0101101000001010";
-- -0.993823
y <= "1011110111111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 103
-- 16732.007608
x <= "0101101000001010";
-- -0.709874
y <= "1011110011010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 104
-- 16732.007608
x <= "0101101000001010";
-- -0.425924
y <= "1011101101101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 105
-- 16732.007608
x <= "0101101000001010";
-- -0.141975
y <= "1011100001000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 106
-- 16732.007608
x <= "0101101000001010";
-- 0.141975
y <= "0011100001000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 107
-- 16732.007608
x <= "0101101000001010";
-- 0.425924
y <= "0011101101101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 108
-- 16732.007608
x <= "0101101000001010";
-- 0.709874
y <= "0011110011010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 109
-- 16732.007608
x <= "0101101000001010";
-- 0.993823
y <= "0011110111111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 110
-- 16732.007608
x <= "0101101000001010";
-- 1.277773
y <= "0011111010001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 111
-- 18405.208369
x <= "0101101000111111";
-- -1.265371
y <= "1011111010001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 112
-- 18405.208369
x <= "0101101000111111";
-- -0.984178
y <= "1011110111110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 113
-- 18405.208369
x <= "0101101000111111";
-- -0.702984
y <= "1011110011010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 114
-- 18405.208369
x <= "0101101000111111";
-- -0.421790
y <= "1011101101100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 115
-- 18405.208369
x <= "0101101000111111";
-- -0.140597
y <= "1011100001000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 116
-- 18405.208369
x <= "0101101000111111";
-- 0.140597
y <= "0011100000111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 117
-- 18405.208369
x <= "0101101000111111";
-- 0.421790
y <= "0011101101011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 118
-- 18405.208369
x <= "0101101000111111";
-- 0.702984
y <= "0011110011001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 119
-- 18405.208369
x <= "0101101000111111";
-- 0.984178
y <= "0011110111101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 120
-- 18405.208369
x <= "0101101000111111";
-- 1.265371
y <= "0011111010000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 121
-- 20078.409129
x <= "0101101001110011";
-- -1.254258
y <= "1011111010000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 122
-- 20078.409129
x <= "0101101001110011";
-- -0.975534
y <= "1011110111100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 123
-- 20078.409129
x <= "0101101001110011";
-- -0.696810
y <= "1011110011001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 124
-- 20078.409129
x <= "0101101001110011";
-- -0.418086
y <= "1011101101011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 125
-- 20078.409129
x <= "0101101001110011";
-- -0.139362
y <= "1011100000111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 126
-- 20078.409129
x <= "0101101001110011";
-- 0.139362
y <= "0011100000111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 127
-- 20078.409129
x <= "0101101001110011";
-- 0.418086
y <= "0011101101011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 128
-- 20078.409129
x <= "0101101001110011";
-- 0.696810
y <= "0011110011001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 129
-- 20078.409129
x <= "0101101001110011";
-- 0.975534
y <= "0011110111100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 130
-- 20078.409129
x <= "0101101001110011";
-- 1.254258
y <= "0011111010000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 131
-- 21751.609889
x <= "0101101010100111";
-- -1.244206
y <= "1011111001111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 132
-- 21751.609889
x <= "0101101010100111";
-- -0.967716
y <= "1011110111011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 133
-- 21751.609889
x <= "0101101010100111";
-- -0.691226
y <= "1011110011000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 134
-- 21751.609889
x <= "0101101010100111";
-- -0.414735
y <= "1011101101010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 135
-- 21751.609889
x <= "0101101010100111";
-- -0.138245
y <= "1011100000110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 136
-- 21751.609889
x <= "0101101010100111";
-- 0.138245
y <= "0011100000110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 137
-- 21751.609889
x <= "0101101010100111";
-- 0.414735
y <= "0011101101010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 138
-- 21751.609889
x <= "0101101010100111";
-- 0.691226
y <= "0011110011000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 139
-- 21751.609889
x <= "0101101010100111";
-- 0.967716
y <= "0011110111011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 140
-- 21751.609889
x <= "0101101010100111";
-- 1.244206
y <= "0011111001111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 141
-- 23424.810650
x <= "0101101011011100";
-- -1.235042
y <= "1011111001111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 142
-- 23424.810650
x <= "0101101011011100";
-- -0.960588
y <= "1011110111011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 143
-- 23424.810650
x <= "0101101011011100";
-- -0.686135
y <= "1011110010111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 144
-- 23424.810650
x <= "0101101011011100";
-- -0.411681
y <= "1011101101001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 145
-- 23424.810650
x <= "0101101011011100";
-- -0.137227
y <= "1011100000110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 146
-- 23424.810650
x <= "0101101011011100";
-- 0.137227
y <= "0011100000110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 147
-- 23424.810650
x <= "0101101011011100";
-- 0.411681
y <= "0011101101001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 148
-- 23424.810650
x <= "0101101011011100";
-- 0.686135
y <= "0011110010111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 149
-- 23424.810650
x <= "0101101011011100";
-- 0.960588
y <= "0011110111010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 150
-- 23424.810650
x <= "0101101011011100";
-- 1.235042
y <= "0011111001111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 151
-- 25098.011410
x <= "0101101100010000";
-- -1.226631
y <= "1011111001110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 152
-- 25098.011410
x <= "0101101100010000";
-- -0.954046
y <= "1011110111010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 153
-- 25098.011410
x <= "0101101100010000";
-- -0.681462
y <= "1011110010111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 154
-- 25098.011410
x <= "0101101100010000";
-- -0.408877
y <= "1011101101000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 155
-- 25098.011410
x <= "0101101100010000";
-- -0.136292
y <= "1011100000101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 156
-- 25098.011410
x <= "0101101100010000";
-- 0.136292
y <= "0011100000101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 157
-- 25098.011410
x <= "0101101100010000";
-- 0.408877
y <= "0011101101000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 158
-- 25098.011410
x <= "0101101100010000";
-- 0.681462
y <= "0011110010111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 159
-- 25098.011410
x <= "0101101100010000";
-- 0.954046
y <= "0011110111010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 160
-- 25098.011410
x <= "0101101100010000";
-- 1.226631
y <= "0011111001110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 161
-- 26771.212171
x <= "0101101101000100";
-- -1.218866
y <= "1011111001110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 162
-- 26771.212171
x <= "0101101101000100";
-- -0.948007
y <= "1011110111001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 163
-- 26771.212171
x <= "0101101101000100";
-- -0.677148
y <= "1011110010110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 164
-- 26771.212171
x <= "0101101101000100";
-- -0.406289
y <= "1011101101000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 165
-- 26771.212171
x <= "0101101101000100";
-- -0.135430
y <= "1011100000101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 166
-- 26771.212171
x <= "0101101101000100";
-- 0.135430
y <= "0011100000101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 167
-- 26771.212171
x <= "0101101101000100";
-- 0.406289
y <= "0011101101000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 168
-- 26771.212171
x <= "0101101101000100";
-- 0.677148
y <= "0011110010110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 169
-- 26771.212171
x <= "0101101101000100";
-- 0.948007
y <= "0011110111001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 170
-- 26771.212171
x <= "0101101101000100";
-- 1.218866
y <= "0011111001110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 171
-- 28444.412931
x <= "0101101101111000";
-- -1.211661
y <= "1011111001101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 172
-- 28444.412931
x <= "0101101101111000";
-- -0.942403
y <= "1011110111000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 173
-- 28444.412931
x <= "0101101101111000";
-- -0.673145
y <= "1011110010110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 174
-- 28444.412931
x <= "0101101101111000";
-- -0.403887
y <= "1011101100111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 175
-- 28444.412931
x <= "0101101101111000";
-- -0.134629
y <= "1011100000101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 176
-- 28444.412931
x <= "0101101101111000";
-- 0.134629
y <= "0011100000100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 177
-- 28444.412931
x <= "0101101101111000";
-- 0.403887
y <= "0011101100111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 178
-- 28444.412931
x <= "0101101101111000";
-- 0.673145
y <= "0011110010110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 179
-- 28444.412931
x <= "0101101101111000";
-- 0.942403
y <= "0011110111000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 180
-- 28444.412931
x <= "0101101101111000";
-- 1.211661
y <= "0011111001101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 181
-- 30117.613692
x <= "0101101110101101";
-- -1.204945
y <= "1011111001101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 182
-- 30117.613692
x <= "0101101110101101";
-- -0.937180
y <= "1011110111000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 183
-- 30117.613692
x <= "0101101110101101";
-- -0.669414
y <= "1011110010101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 184
-- 30117.613692
x <= "0101101110101101";
-- -0.401648
y <= "1011101100110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 185
-- 30117.613692
x <= "0101101110101101";
-- -0.133883
y <= "1011100000100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 186
-- 30117.613692
x <= "0101101110101101";
-- 0.133883
y <= "0011100000100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 187
-- 30117.613692
x <= "0101101110101101";
-- 0.401648
y <= "0011101100110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 188
-- 30117.613692
x <= "0101101110101101";
-- 0.669414
y <= "0011110010101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 189
-- 30117.613692
x <= "0101101110101101";
-- 0.937180
y <= "0011110110111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 190
-- 30117.613692
x <= "0101101110101101";
-- 1.204945
y <= "0011111001101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 191
-- 31790.814452
x <= "0101101111100001";
-- -1.198661
y <= "1011111001100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 192
-- 31790.814452
x <= "0101101111100001";
-- -0.932292
y <= "1011110110111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 193
-- 31790.814452
x <= "0101101111100001";
-- -0.665923
y <= "1011110010101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 194
-- 31790.814452
x <= "0101101111100001";
-- -0.399554
y <= "1011101100110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 195
-- 31790.814452
x <= "0101101111100001";
-- -0.133185
y <= "1011100000100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 196
-- 31790.814452
x <= "0101101111100001";
-- 0.133185
y <= "0011100000100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 197
-- 31790.814452
x <= "0101101111100001";
-- 0.399554
y <= "0011101100110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 198
-- 31790.814452
x <= "0101101111100001";
-- 0.665923
y <= "0011110010101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 199
-- 31790.814452
x <= "0101101111100001";
-- 0.932292
y <= "0011110110111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 200
-- 31790.814452
x <= "0101101111100001";
-- 1.198661
y <= "0011111001100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 201
-- 33464.015212
x <= "0101110000001010";
-- -1.192760
y <= "1011111001100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 202
-- 33464.015212
x <= "0101110000001010";
-- -0.927702
y <= "1011110110110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 203
-- 33464.015212
x <= "0101110000001010";
-- -0.662644
y <= "1011110010100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 204
-- 33464.015212
x <= "0101110000001010";
-- -0.397587
y <= "1011101100101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 205
-- 33464.015212
x <= "0101110000001010";
-- -0.132529
y <= "1011100000011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 206
-- 33464.015212
x <= "0101110000001010";
-- 0.132529
y <= "0011100000011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 207
-- 33464.015212
x <= "0101110000001010";
-- 0.397587
y <= "0011101100101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 208
-- 33464.015212
x <= "0101110000001010";
-- 0.662644
y <= "0011110010100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 209
-- 33464.015212
x <= "0101110000001010";
-- 0.927702
y <= "0011110110110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 210
-- 33464.015212
x <= "0101110000001010";
-- 1.192760
y <= "0011111001100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 211
-- 35137.215973
x <= "0101110000100101";
-- -1.187200
y <= "1011111001100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 212
-- 35137.215973
x <= "0101110000100101";
-- -0.923378
y <= "1011110110110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 213
-- 35137.215973
x <= "0101110000100101";
-- -0.659555
y <= "1011110010100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 214
-- 35137.215973
x <= "0101110000100101";
-- -0.395733
y <= "1011101100101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 215
-- 35137.215973
x <= "0101110000100101";
-- -0.131911
y <= "1011100000011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 216
-- 35137.215973
x <= "0101110000100101";
-- 0.131911
y <= "0011100000011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 217
-- 35137.215973
x <= "0101110000100101";
-- 0.395733
y <= "0011101100101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 218
-- 35137.215973
x <= "0101110000100101";
-- 0.659555
y <= "0011110010100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 219
-- 35137.215973
x <= "0101110000100101";
-- 0.923378
y <= "0011110110110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 220
-- 35137.215973
x <= "0101110000100101";
-- 1.187200
y <= "0011111001011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 221
-- 36810.416733
x <= "0101110000111111";
-- -1.181947
y <= "1011111001011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 222
-- 36810.416733
x <= "0101110000111111";
-- -0.919292
y <= "1011110110101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 223
-- 36810.416733
x <= "0101110000111111";
-- -0.656637
y <= "1011110010100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 224
-- 36810.416733
x <= "0101110000111111";
-- -0.393982
y <= "1011101100100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 225
-- 36810.416733
x <= "0101110000111111";
-- -0.131327
y <= "1011100000011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 226
-- 36810.416733
x <= "0101110000111111";
-- 0.131327
y <= "0011100000011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 227
-- 36810.416733
x <= "0101110000111111";
-- 0.393982
y <= "0011101100100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 228
-- 36810.416733
x <= "0101110000111111";
-- 0.656637
y <= "0011110010100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 229
-- 36810.416733
x <= "0101110000111111";
-- 0.919292
y <= "0011110110101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 230
-- 36810.416733
x <= "0101110000111111";
-- 1.181947
y <= "0011111001011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 231
-- 38483.617494
x <= "0101110001011001";
-- -1.176970
y <= "1011111001011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 232
-- 38483.617494
x <= "0101110001011001";
-- -0.915421
y <= "1011110110101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 233
-- 38483.617494
x <= "0101110001011001";
-- -0.653872
y <= "1011110010011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 234
-- 38483.617494
x <= "0101110001011001";
-- -0.392323
y <= "1011101100100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 235
-- 38483.617494
x <= "0101110001011001";
-- -0.130774
y <= "1011100000011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 236
-- 38483.617494
x <= "0101110001011001";
-- 0.130774
y <= "0011100000010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 237
-- 38483.617494
x <= "0101110001011001";
-- 0.392323
y <= "0011101100100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 238
-- 38483.617494
x <= "0101110001011001";
-- 0.653872
y <= "0011110010011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 239
-- 38483.617494
x <= "0101110001011001";
-- 0.915421
y <= "0011110110101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 240
-- 38483.617494
x <= "0101110001011001";
-- 1.176970
y <= "0011111001011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 241
-- 40156.818254
x <= "0101110001110011";
-- -1.172245
y <= "1011111001011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 242
-- 40156.818254
x <= "0101110001110011";
-- -0.911746
y <= "1011110110100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 243
-- 40156.818254
x <= "0101110001110011";
-- -0.651247
y <= "1011110010011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 244
-- 40156.818254
x <= "0101110001110011";
-- -0.390748
y <= "1011101100100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 245
-- 40156.818254
x <= "0101110001110011";
-- -0.130249
y <= "1011100000010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 246
-- 40156.818254
x <= "0101110001110011";
-- 0.130249
y <= "0011100000010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 247
-- 40156.818254
x <= "0101110001110011";
-- 0.390748
y <= "0011101100100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 248
-- 40156.818254
x <= "0101110001110011";
-- 0.651247
y <= "0011110010011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 249
-- 40156.818254
x <= "0101110001110011";
-- 0.911746
y <= "0011110110100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 250
-- 40156.818254
x <= "0101110001110011";
-- 1.172245
y <= "0011111001011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 251
-- 41830.019015
x <= "0101110010001101";
-- -1.167748
y <= "1011111001010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 252
-- 41830.019015
x <= "0101110010001101";
-- -0.908249
y <= "1011110110100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 253
-- 41830.019015
x <= "0101110010001101";
-- -0.648749
y <= "1011110010011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 254
-- 41830.019015
x <= "0101110010001101";
-- -0.389249
y <= "1011101100011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 255
-- 41830.019015
x <= "0101110010001101";
-- -0.129750
y <= "1011100000010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 256
-- 41830.019015
x <= "0101110010001101";
-- 0.129750
y <= "0011100000010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 257
-- 41830.019015
x <= "0101110010001101";
-- 0.389249
y <= "0011101100011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 258
-- 41830.019015
x <= "0101110010001101";
-- 0.648749
y <= "0011110010011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 259
-- 41830.019015
x <= "0101110010001101";
-- 0.908249
y <= "0011110110100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 260
-- 41830.019015
x <= "0101110010001101";
-- 1.167748
y <= "0011111001010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 261
-- 43503.219775
x <= "0101110010100111";
-- -1.163460
y <= "1011111001010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 262
-- 43503.219775
x <= "0101110010100111";
-- -0.904913
y <= "1011110110011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 263
-- 43503.219775
x <= "0101110010100111";
-- -0.646367
y <= "1011110010010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 264
-- 43503.219775
x <= "0101110010100111";
-- -0.387820
y <= "1011101100011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 265
-- 43503.219775
x <= "0101110010100111";
-- -0.129273
y <= "1011100000010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 266
-- 43503.219775
x <= "0101110010100111";
-- 0.129273
y <= "0011100000010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 267
-- 43503.219775
x <= "0101110010100111";
-- 0.387820
y <= "0011101100011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 268
-- 43503.219775
x <= "0101110010100111";
-- 0.646367
y <= "0011110010010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 269
-- 43503.219775
x <= "0101110010100111";
-- 0.904913
y <= "0011110110011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 270
-- 43503.219775
x <= "0101110010100111";
-- 1.163460
y <= "0011111001010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 271
-- 45176.420535
x <= "0101110011000001";
-- -1.159363
y <= "1011111001010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 272
-- 45176.420535
x <= "0101110011000001";
-- -0.901727
y <= "1011110110011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 273
-- 45176.420535
x <= "0101110011000001";
-- -0.644091
y <= "1011110010010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 274
-- 45176.420535
x <= "0101110011000001";
-- -0.386454
y <= "1011101100011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 275
-- 45176.420535
x <= "0101110011000001";
-- -0.128818
y <= "1011100000010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 276
-- 45176.420535
x <= "0101110011000001";
-- 0.128818
y <= "0011100000001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 277
-- 45176.420535
x <= "0101110011000001";
-- 0.386454
y <= "0011101100010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 278
-- 45176.420535
x <= "0101110011000001";
-- 0.644091
y <= "0011110010010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 279
-- 45176.420535
x <= "0101110011000001";
-- 0.901727
y <= "0011110110011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 280
-- 45176.420535
x <= "0101110011000001";
-- 1.159363
y <= "0011111001010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 281
-- 46849.621296
x <= "0101110011011100";
-- -1.155443
y <= "1011111001010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 282
-- 46849.621296
x <= "0101110011011100";
-- -0.898678
y <= "1011110110011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 283
-- 46849.621296
x <= "0101110011011100";
-- -0.641913
y <= "1011110010010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 284
-- 46849.621296
x <= "0101110011011100";
-- -0.385148
y <= "1011101100010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 285
-- 46849.621296
x <= "0101110011011100";
-- -0.128383
y <= "1011100000001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 286
-- 46849.621296
x <= "0101110011011100";
-- 0.128383
y <= "0011100000001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 287
-- 46849.621296
x <= "0101110011011100";
-- 0.385148
y <= "0011101100010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 288
-- 46849.621296
x <= "0101110011011100";
-- 0.641913
y <= "0011110010010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 289
-- 46849.621296
x <= "0101110011011100";
-- 0.898678
y <= "0011110110011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 290
-- 46849.621296
x <= "0101110011011100";
-- 1.155443
y <= "0011111001001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 291
-- 48522.822056
x <= "0101110011110110";
-- -1.151685
y <= "1011111001001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 292
-- 48522.822056
x <= "0101110011110110";
-- -0.895755
y <= "1011110110010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 293
-- 48522.822056
x <= "0101110011110110";
-- -0.639825
y <= "1011110010010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 294
-- 48522.822056
x <= "0101110011110110";
-- -0.383895
y <= "1011101100010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 295
-- 48522.822056
x <= "0101110011110110";
-- -0.127965
y <= "1011100000001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 296
-- 48522.822056
x <= "0101110011110110";
-- 0.127965
y <= "0011100000001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 297
-- 48522.822056
x <= "0101110011110110";
-- 0.383895
y <= "0011101100010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 298
-- 48522.822056
x <= "0101110011110110";
-- 0.639825
y <= "0011110010001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 299
-- 48522.822056
x <= "0101110011110110";
-- 0.895755
y <= "0011110110010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 300
-- 48522.822056
x <= "0101110011110110";
-- 1.151685
y <= "0011111001001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 301
-- 50196.022817
x <= "0101110100010000";
-- -1.148078
y <= "1011111001001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 302
-- 50196.022817
x <= "0101110100010000";
-- -0.892949
y <= "1011110110010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 303
-- 50196.022817
x <= "0101110100010000";
-- -0.637821
y <= "1011110010001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 304
-- 50196.022817
x <= "0101110100010000";
-- -0.382693
y <= "1011101100010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 305
-- 50196.022817
x <= "0101110100010000";
-- -0.127564
y <= "1011100000001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 306
-- 50196.022817
x <= "0101110100010000";
-- 0.127564
y <= "0011100000001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 307
-- 50196.022817
x <= "0101110100010000";
-- 0.382693
y <= "0011101100001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 308
-- 50196.022817
x <= "0101110100010000";
-- 0.637821
y <= "0011110010001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 309
-- 50196.022817
x <= "0101110100010000";
-- 0.892949
y <= "0011110110010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 310
-- 50196.022817
x <= "0101110100010000";
-- 1.148078
y <= "0011111001001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 311
-- 51869.223577
x <= "0101110100101010";
-- -1.144610
y <= "1011111001001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 312
-- 51869.223577
x <= "0101110100101010";
-- -0.890252
y <= "1011110110010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 313
-- 51869.223577
x <= "0101110100101010";
-- -0.635895
y <= "1011110010001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 314
-- 51869.223577
x <= "0101110100101010";
-- -0.381537
y <= "1011101100001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 315
-- 51869.223577
x <= "0101110100101010";
-- -0.127179
y <= "1011100000001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 316
-- 51869.223577
x <= "0101110100101010";
-- 0.127179
y <= "0011100000001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 317
-- 51869.223577
x <= "0101110100101010";
-- 0.381537
y <= "0011101100001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 318
-- 51869.223577
x <= "0101110100101010";
-- 0.635895
y <= "0011110010001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 319
-- 51869.223577
x <= "0101110100101010";
-- 0.890252
y <= "0011110110001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 320
-- 51869.223577
x <= "0101110100101010";
-- 1.144610
y <= "0011111001001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 321
-- 53542.424337
x <= "0101110101000100";
-- -1.141273
y <= "1011111001001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 322
-- 53542.424337
x <= "0101110101000100";
-- -0.887657
y <= "1011110110001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 323
-- 53542.424337
x <= "0101110101000100";
-- -0.634040
y <= "1011110010001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 324
-- 53542.424337
x <= "0101110101000100";
-- -0.380424
y <= "1011101100001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 325
-- 53542.424337
x <= "0101110101000100";
-- -0.126808
y <= "1011100000001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 326
-- 53542.424337
x <= "0101110101000100";
-- 0.126808
y <= "0011100000000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 327
-- 53542.424337
x <= "0101110101000100";
-- 0.380424
y <= "0011101100001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 328
-- 53542.424337
x <= "0101110101000100";
-- 0.634040
y <= "0011110010001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 329
-- 53542.424337
x <= "0101110101000100";
-- 0.887657
y <= "0011110110001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 330
-- 53542.424337
x <= "0101110101000100";
-- 1.141273
y <= "0011111001001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 331
-- 55215.625098
x <= "0101110101011110";
-- -1.138056
y <= "1011111001000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 332
-- 55215.625098
x <= "0101110101011110";
-- -0.885155
y <= "1011110110001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 333
-- 55215.625098
x <= "0101110101011110";
-- -0.632254
y <= "1011110010001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 334
-- 55215.625098
x <= "0101110101011110";
-- -0.379352
y <= "1011101100001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 335
-- 55215.625098
x <= "0101110101011110";
-- -0.126451
y <= "1011100000000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 336
-- 55215.625098
x <= "0101110101011110";
-- 0.126451
y <= "0011100000000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 337
-- 55215.625098
x <= "0101110101011110";
-- 0.379352
y <= "0011101100001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 338
-- 55215.625098
x <= "0101110101011110";
-- 0.632254
y <= "0011110010000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 339
-- 55215.625098
x <= "0101110101011110";
-- 0.885155
y <= "0011110110001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 340
-- 55215.625098
x <= "0101110101011110";
-- 1.138056
y <= "0011111001000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 341
-- 56888.825858
x <= "0101110101111000";
-- -1.134953
y <= "1011111001000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 342
-- 56888.825858
x <= "0101110101111000";
-- -0.882742
y <= "1011110110001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 343
-- 56888.825858
x <= "0101110101111000";
-- -0.630530
y <= "1011110010000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 344
-- 56888.825858
x <= "0101110101111000";
-- -0.378318
y <= "1011101100000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 345
-- 56888.825858
x <= "0101110101111000";
-- -0.126106
y <= "1011100000000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 346
-- 56888.825858
x <= "0101110101111000";
-- 0.126106
y <= "0011100000000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 347
-- 56888.825858
x <= "0101110101111000";
-- 0.378318
y <= "0011101100000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 348
-- 56888.825858
x <= "0101110101111000";
-- 0.630530
y <= "0011110010000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 349
-- 56888.825858
x <= "0101110101111000";
-- 0.882742
y <= "0011110110000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 350
-- 56888.825858
x <= "0101110101111000";
-- 1.134953
y <= "0011111001000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 351
-- 58562.026619
x <= "0101110110010011";
-- -1.131957
y <= "1011111001000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 352
-- 58562.026619
x <= "0101110110010011";
-- -0.880411
y <= "1011110110000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 353
-- 58562.026619
x <= "0101110110010011";
-- -0.628865
y <= "1011110010000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 354
-- 58562.026619
x <= "0101110110010011";
-- -0.377319
y <= "1011101100000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 355
-- 58562.026619
x <= "0101110110010011";
-- -0.125773
y <= "1011100000000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 356
-- 58562.026619
x <= "0101110110010011";
-- 0.125773
y <= "0011100000000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 357
-- 58562.026619
x <= "0101110110010011";
-- 0.377319
y <= "0011101100000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 358
-- 58562.026619
x <= "0101110110010011";
-- 0.628865
y <= "0011110010000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 359
-- 58562.026619
x <= "0101110110010011";
-- 0.880411
y <= "0011110110000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 360
-- 58562.026619
x <= "0101110110010011";
-- 1.131957
y <= "0011111001000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 361
-- 60235.227379
x <= "0101110110101101";
-- -1.129059
y <= "1011111001000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 362
-- 60235.227379
x <= "0101110110101101";
-- -0.878157
y <= "1011110110000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 363
-- 60235.227379
x <= "0101110110101101";
-- -0.627255
y <= "1011110010000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 364
-- 60235.227379
x <= "0101110110101101";
-- -0.376353
y <= "1011101100000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 365
-- 60235.227379
x <= "0101110110101101";
-- -0.125451
y <= "1011100000000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 366
-- 60235.227379
x <= "0101110110101101";
-- 0.125451
y <= "0011100000000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 367
-- 60235.227379
x <= "0101110110101101";
-- 0.376353
y <= "0011101100000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 368
-- 60235.227379
x <= "0101110110101101";
-- 0.627255
y <= "0011110010000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 369
-- 60235.227379
x <= "0101110110101101";
-- 0.878157
y <= "0011110110000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 370
-- 60235.227379
x <= "0101110110101101";
-- 1.129059
y <= "0011111001000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 371
-- 61908.428140
x <= "0101110111000111";
-- -1.126255
y <= "1011111001000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 372
-- 61908.428140
x <= "0101110111000111";
-- -0.875976
y <= "1011110110000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 373
-- 61908.428140
x <= "0101110111000111";
-- -0.625697
y <= "1011110010000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 374
-- 61908.428140
x <= "0101110111000111";
-- -0.375418
y <= "1011101100000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 375
-- 61908.428140
x <= "0101110111000111";
-- -0.125139
y <= "1011100000000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 376
-- 61908.428140
x <= "0101110111000111";
-- 0.125139
y <= "0011100000000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 377
-- 61908.428140
x <= "0101110111000111";
-- 0.375418
y <= "0011101100000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 378
-- 61908.428140
x <= "0101110111000111";
-- 0.625697
y <= "0011110010000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 379
-- 61908.428140
x <= "0101110111000111";
-- 0.875976
y <= "0011110110000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 380
-- 61908.428140
x <= "0101110111000111";
-- 1.126255
y <= "0011111001000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 381
-- 63581.628900
x <= "0101110111100001";
-- -1.123540
y <= "1011111001000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 382
-- 63581.628900
x <= "0101110111100001";
-- -0.873864
y <= "1011110101111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 383
-- 63581.628900
x <= "0101110111100001";
-- -0.624189
y <= "1011110010000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 384
-- 63581.628900
x <= "0101110111100001";
-- -0.374513
y <= "1011101100000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 385
-- 63581.628900
x <= "0101110111100001";
-- -0.124838
y <= "1011011111111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 386
-- 63581.628900
x <= "0101110111100001";
-- 0.124838
y <= "0011011111111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 387
-- 63581.628900
x <= "0101110111100001";
-- 0.374513
y <= "0011101011111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 388
-- 63581.628900
x <= "0101110111100001";
-- 0.624189
y <= "0011110001111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 389
-- 63581.628900
x <= "0101110111100001";
-- 0.873864
y <= "0011110101111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 390
-- 63581.628900
x <= "0101110111100001";
-- 1.123540
y <= "0011111000111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 391
-- 65254.829660
x <= "0101110111111011";
-- -1.120907
y <= "1011111000111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 392
-- 65254.829660
x <= "0101110111111011";
-- -0.871817
y <= "1011110101111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 393
-- 65254.829660
x <= "0101110111111011";
-- -0.622726
y <= "1011110001111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 394
-- 65254.829660
x <= "0101110111111011";
-- -0.373636
y <= "1011101011111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 395
-- 65254.829660
x <= "0101110111111011";
-- -0.124545
y <= "1011011111111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 396
-- 65254.829660
x <= "0101110111111011";
-- 0.124545
y <= "0011011111111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 397
-- 65254.829660
x <= "0101110111111011";
-- 0.373636
y <= "0011101011111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 398
-- 65254.829660
x <= "0101110111111011";
-- 0.622726
y <= "0011110001111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 399
-- 65254.829660
x <= "0101110111111011";
-- 0.871817
y <= "0011110101111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 400
-- 65254.829660
x <= "0101110111111011";
-- 1.120907
y <= "0011111000111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 401
-- 66928.030421
x <= "0101111000001010";
-- -1.118353
y <= "1011111000111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 402
-- 66928.030421
x <= "0101111000001010";
-- -0.869830
y <= "1011110101111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 403
-- 66928.030421
x <= "0101111000001010";
-- -0.621307
y <= "1011110001111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 404
-- 66928.030421
x <= "0101111000001010";
-- -0.372784
y <= "1011101011111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 405
-- 66928.030421
x <= "0101111000001010";
-- -0.124261
y <= "1011011111111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 406
-- 66928.030421
x <= "0101111000001010";
-- 0.124261
y <= "0011011111111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 407
-- 66928.030421
x <= "0101111000001010";
-- 0.372784
y <= "0011101011111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 408
-- 66928.030421
x <= "0101111000001010";
-- 0.621307
y <= "0011110001111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 409
-- 66928.030421
x <= "0101111000001010";
-- 0.869830
y <= "0011110101111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 410
-- 66928.030421
x <= "0101111000001010";
-- 1.118353
y <= "0011111000111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 411
-- 68601.231181
x <= "0101111000010111";
-- -1.115873
y <= "1011111000111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 412
-- 68601.231181
x <= "0101111000010111";
-- -0.867902
y <= "1011110101111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 413
-- 68601.231181
x <= "0101111000010111";
-- -0.619930
y <= "1011110001111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 414
-- 68601.231181
x <= "0101111000010111";
-- -0.371958
y <= "1011101011111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 415
-- 68601.231181
x <= "0101111000010111";
-- -0.123986
y <= "1011011111111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 416
-- 68601.231181
x <= "0101111000010111";
-- 0.123986
y <= "0011011111110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 417
-- 68601.231181
x <= "0101111000010111";
-- 0.371958
y <= "0011101011111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 418
-- 68601.231181
x <= "0101111000010111";
-- 0.619930
y <= "0011110001111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 419
-- 68601.231181
x <= "0101111000010111";
-- 0.867902
y <= "0011110101111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 420
-- 68601.231181
x <= "0101111000010111";
-- 1.115873
y <= "0011111000111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 421
-- 70274.431942
x <= "0101111000100101";
-- -1.113464
y <= "1011111000111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 422
-- 70274.431942
x <= "0101111000100101";
-- -0.866028
y <= "1011110101110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 423
-- 70274.431942
x <= "0101111000100101";
-- -0.618591
y <= "1011110001111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 424
-- 70274.431942
x <= "0101111000100101";
-- -0.371155
y <= "1011101011111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 425
-- 70274.431942
x <= "0101111000100101";
-- -0.123718
y <= "1011011111110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 426
-- 70274.431942
x <= "0101111000100101";
-- 0.123718
y <= "0011011111110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 427
-- 70274.431942
x <= "0101111000100101";
-- 0.371155
y <= "0011101011111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 428
-- 70274.431942
x <= "0101111000100101";
-- 0.618591
y <= "0011110001111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 429
-- 70274.431942
x <= "0101111000100101";
-- 0.866028
y <= "0011110101110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 430
-- 70274.431942
x <= "0101111000100101";
-- 1.113464
y <= "0011111000111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 431
-- 71947.632702
x <= "0101111000110010";
-- -1.111121
y <= "1011111000111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 432
-- 71947.632702
x <= "0101111000110010";
-- -0.864205
y <= "1011110101110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 433
-- 71947.632702
x <= "0101111000110010";
-- -0.617290
y <= "1011110001111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 434
-- 71947.632702
x <= "0101111000110010";
-- -0.370374
y <= "1011101011110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 435
-- 71947.632702
x <= "0101111000110010";
-- -0.123458
y <= "1011011111110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 436
-- 71947.632702
x <= "0101111000110010";
-- 0.123458
y <= "0011011111110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 437
-- 71947.632702
x <= "0101111000110010";
-- 0.370374
y <= "0011101011110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 438
-- 71947.632702
x <= "0101111000110010";
-- 0.617290
y <= "0011110001111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 439
-- 71947.632702
x <= "0101111000110010";
-- 0.864205
y <= "0011110101110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 440
-- 71947.632702
x <= "0101111000110010";
-- 1.111121
y <= "0011111000111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 441
-- 73620.833462
x <= "0101111000111111";
-- -1.108842
y <= "1011111000111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 442
-- 73620.833462
x <= "0101111000111111";
-- -0.862433
y <= "1011110101110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 443
-- 73620.833462
x <= "0101111000111111";
-- -0.616023
y <= "1011110001110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 444
-- 73620.833462
x <= "0101111000111111";
-- -0.369614
y <= "1011101011110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 445
-- 73620.833462
x <= "0101111000111111";
-- -0.123205
y <= "1011011111110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 446
-- 73620.833462
x <= "0101111000111111";
-- 0.123205
y <= "0011011111110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 447
-- 73620.833462
x <= "0101111000111111";
-- 0.369614
y <= "0011101011110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 448
-- 73620.833462
x <= "0101111000111111";
-- 0.616023
y <= "0011110001110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 449
-- 73620.833462
x <= "0101111000111111";
-- 0.862433
y <= "0011110101110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 450
-- 73620.833462
x <= "0101111000111111";
-- 1.108842
y <= "0011111000110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 451
-- 75294.034223
x <= "0101111001001100";
-- -1.106623
y <= "1011111000110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 452
-- 75294.034223
x <= "0101111001001100";
-- -0.860707
y <= "1011110101110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 453
-- 75294.034223
x <= "0101111001001100";
-- -0.614790
y <= "1011110001110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 454
-- 75294.034223
x <= "0101111001001100";
-- -0.368874
y <= "1011101011110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 455
-- 75294.034223
x <= "0101111001001100";
-- -0.122958
y <= "1011011111110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 456
-- 75294.034223
x <= "0101111001001100";
-- 0.122958
y <= "0011011111101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 457
-- 75294.034223
x <= "0101111001001100";
-- 0.368874
y <= "0011101011110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 458
-- 75294.034223
x <= "0101111001001100";
-- 0.614790
y <= "0011110001110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 459
-- 75294.034223
x <= "0101111001001100";
-- 0.860707
y <= "0011110101110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 460
-- 75294.034223
x <= "0101111001001100";
-- 1.106623
y <= "0011111000110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 461
-- 76967.234983
x <= "0101111001011001";
-- -1.104461
y <= "1011111000110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 462
-- 76967.234983
x <= "0101111001011001";
-- -0.859025
y <= "1011110101110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 463
-- 76967.234983
x <= "0101111001011001";
-- -0.613589
y <= "1011110001110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 464
-- 76967.234983
x <= "0101111001011001";
-- -0.368154
y <= "1011101011110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 465
-- 76967.234983
x <= "0101111001011001";
-- -0.122718
y <= "1011011111101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 466
-- 76967.234983
x <= "0101111001011001";
-- 0.122718
y <= "0011011111101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 467
-- 76967.234983
x <= "0101111001011001";
-- 0.368154
y <= "0011101011110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 468
-- 76967.234983
x <= "0101111001011001";
-- 0.613589
y <= "0011110001110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 469
-- 76967.234983
x <= "0101111001011001";
-- 0.859025
y <= "0011110101101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 470
-- 76967.234983
x <= "0101111001011001";
-- 1.104461
y <= "0011111000110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 471
-- 78640.435744
x <= "0101111001100110";
-- -1.102354
y <= "1011111000110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 472
-- 78640.435744
x <= "0101111001100110";
-- -0.857386
y <= "1011110101101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 473
-- 78640.435744
x <= "0101111001100110";
-- -0.612419
y <= "1011110001110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 474
-- 78640.435744
x <= "0101111001100110";
-- -0.367451
y <= "1011101011110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 475
-- 78640.435744
x <= "0101111001100110";
-- -0.122484
y <= "1011011111101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 476
-- 78640.435744
x <= "0101111001100110";
-- 0.122484
y <= "0011011111101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 477
-- 78640.435744
x <= "0101111001100110";
-- 0.367451
y <= "0011101011110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 478
-- 78640.435744
x <= "0101111001100110";
-- 0.612419
y <= "0011110001110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 479
-- 78640.435744
x <= "0101111001100110";
-- 0.857386
y <= "0011110101101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 480
-- 78640.435744
x <= "0101111001100110";
-- 1.102354
y <= "0011111000110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 481
-- 80313.636504
x <= "0101111001110011";
-- -1.100299
y <= "1011111000110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 482
-- 80313.636504
x <= "0101111001110011";
-- -0.855788
y <= "1011110101101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 483
-- 80313.636504
x <= "0101111001110011";
-- -0.611277
y <= "1011110001110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 484
-- 80313.636504
x <= "0101111001110011";
-- -0.366766
y <= "1011101011110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 485
-- 80313.636504
x <= "0101111001110011";
-- -0.122255
y <= "1011011111101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 486
-- 80313.636504
x <= "0101111001110011";
-- 0.122255
y <= "0011011111101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 487
-- 80313.636504
x <= "0101111001110011";
-- 0.366766
y <= "0011101011101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 488
-- 80313.636504
x <= "0101111001110011";
-- 0.611277
y <= "0011110001110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 489
-- 80313.636504
x <= "0101111001110011";
-- 0.855788
y <= "0011110101101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 490
-- 80313.636504
x <= "0101111001110011";
-- 1.100299
y <= "0011111000110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 491
-- 81986.837265
x <= "0101111010000000";
-- -1.098294
y <= "1011111000110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 492
-- 81986.837265
x <= "0101111010000000";
-- -0.854228
y <= "1011110101101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 493
-- 81986.837265
x <= "0101111010000000";
-- -0.610163
y <= "1011110001110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 494
-- 81986.837265
x <= "0101111010000000";
-- -0.366098
y <= "1011101011101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 495
-- 81986.837265
x <= "0101111010000000";
-- -0.122033
y <= "1011011111101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 496
-- 81986.837265
x <= "0101111010000000";
-- 0.122033
y <= "0011011111100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 497
-- 81986.837265
x <= "0101111010000000";
-- 0.366098
y <= "0011101011101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 498
-- 81986.837265
x <= "0101111010000000";
-- 0.610163
y <= "0011110001110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 499
-- 81986.837265
x <= "0101111010000000";
-- 0.854228
y <= "0011110101101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 500
-- 81986.837265
x <= "0101111010000000";
-- 1.098294
y <= "0011111000110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 501
-- 83660.038025
x <= "0101111010001101";
-- -1.096336
y <= "1011111000110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 502
-- 83660.038025
x <= "0101111010001101";
-- -0.852706
y <= "1011110101101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 503
-- 83660.038025
x <= "0101111010001101";
-- -0.609076
y <= "1011110001110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 504
-- 83660.038025
x <= "0101111010001101";
-- -0.365445
y <= "1011101011101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 505
-- 83660.038025
x <= "0101111010001101";
-- -0.121815
y <= "1011011111100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 506
-- 83660.038025
x <= "0101111010001101";
-- 0.121815
y <= "0011011111100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 507
-- 83660.038025
x <= "0101111010001101";
-- 0.365445
y <= "0011101011101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 508
-- 83660.038025
x <= "0101111010001101";
-- 0.609076
y <= "0011110001101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 509
-- 83660.038025
x <= "0101111010001101";
-- 0.852706
y <= "0011110101101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 510
-- 83660.038025
x <= "0101111010001101";
-- 1.096336
y <= "0011111000110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 511
-- 85333.238785
x <= "0101111010011010";
-- -1.094424
y <= "1011111000110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 512
-- 85333.238785
x <= "0101111010011010";
-- -0.851219
y <= "1011110101101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 513
-- 85333.238785
x <= "0101111010011010";
-- -0.608013
y <= "1011110001101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 514
-- 85333.238785
x <= "0101111010011010";
-- -0.364808
y <= "1011101011101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 515
-- 85333.238785
x <= "0101111010011010";
-- -0.121603
y <= "1011011111100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 516
-- 85333.238785
x <= "0101111010011010";
-- 0.121603
y <= "0011011111100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 517
-- 85333.238785
x <= "0101111010011010";
-- 0.364808
y <= "0011101011101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 518
-- 85333.238785
x <= "0101111010011010";
-- 0.608013
y <= "0011110001101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 519
-- 85333.238785
x <= "0101111010011010";
-- 0.851219
y <= "0011110101100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 520
-- 85333.238785
x <= "0101111010011010";
-- 1.094424
y <= "0011111000110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 521
-- 87006.439546
x <= "0101111010100111";
-- -1.092556
y <= "1011111000110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 522
-- 87006.439546
x <= "0101111010100111";
-- -0.849765
y <= "1011110101100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 523
-- 87006.439546
x <= "0101111010100111";
-- -0.606975
y <= "1011110001101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 524
-- 87006.439546
x <= "0101111010100111";
-- -0.364185
y <= "1011101011101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 525
-- 87006.439546
x <= "0101111010100111";
-- -0.121395
y <= "1011011111100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 526
-- 87006.439546
x <= "0101111010100111";
-- 0.121395
y <= "0011011111100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 527
-- 87006.439546
x <= "0101111010100111";
-- 0.364185
y <= "0011101011101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 528
-- 87006.439546
x <= "0101111010100111";
-- 0.606975
y <= "0011110001101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 529
-- 87006.439546
x <= "0101111010100111";
-- 0.849765
y <= "0011110101100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 530
-- 87006.439546
x <= "0101111010100111";
-- 1.092556
y <= "0011111000101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 531
-- 88679.640306
x <= "0101111010110100";
-- -1.090729
y <= "1011111000101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 532
-- 88679.640306
x <= "0101111010110100";
-- -0.848345
y <= "1011110101100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 533
-- 88679.640306
x <= "0101111010110100";
-- -0.605960
y <= "1011110001101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 534
-- 88679.640306
x <= "0101111010110100";
-- -0.363576
y <= "1011101011101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 535
-- 88679.640306
x <= "0101111010110100";
-- -0.121192
y <= "1011011111100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 536
-- 88679.640306
x <= "0101111010110100";
-- 0.121192
y <= "0011011111100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 537
-- 88679.640306
x <= "0101111010110100";
-- 0.363576
y <= "0011101011101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 538
-- 88679.640306
x <= "0101111010110100";
-- 0.605960
y <= "0011110001101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 539
-- 88679.640306
x <= "0101111010110100";
-- 0.848345
y <= "0011110101100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 540
-- 88679.640306
x <= "0101111010110100";
-- 1.090729
y <= "0011111000101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 541
-- 90352.841067
x <= "0101111011000001";
-- -1.088942
y <= "1011111000101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 542
-- 90352.841067
x <= "0101111011000001";
-- -0.846955
y <= "1011110101100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 543
-- 90352.841067
x <= "0101111011000001";
-- -0.604968
y <= "1011110001101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 544
-- 90352.841067
x <= "0101111011000001";
-- -0.362981
y <= "1011101011101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 545
-- 90352.841067
x <= "0101111011000001";
-- -0.120994
y <= "1011011111100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 546
-- 90352.841067
x <= "0101111011000001";
-- 0.120994
y <= "0011011111011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 547
-- 90352.841067
x <= "0101111011000001";
-- 0.362981
y <= "0011101011100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 548
-- 90352.841067
x <= "0101111011000001";
-- 0.604968
y <= "0011110001101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 549
-- 90352.841067
x <= "0101111011000001";
-- 0.846955
y <= "0011110101100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 550
-- 90352.841067
x <= "0101111011000001";
-- 1.088942
y <= "0011111000101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 551
-- 92026.041827
x <= "0101111011001110";
-- -1.087194
y <= "1011111000101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 552
-- 92026.041827
x <= "0101111011001110";
-- -0.845595
y <= "1011110101100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 553
-- 92026.041827
x <= "0101111011001110";
-- -0.603997
y <= "1011110001101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 554
-- 92026.041827
x <= "0101111011001110";
-- -0.362398
y <= "1011101011100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 555
-- 92026.041827
x <= "0101111011001110";
-- -0.120799
y <= "1011011111011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 556
-- 92026.041827
x <= "0101111011001110";
-- 0.120799
y <= "0011011111011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 557
-- 92026.041827
x <= "0101111011001110";
-- 0.362398
y <= "0011101011100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 558
-- 92026.041827
x <= "0101111011001110";
-- 0.603997
y <= "0011110001101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 559
-- 92026.041827
x <= "0101111011001110";
-- 0.845595
y <= "0011110101100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 560
-- 92026.041827
x <= "0101111011001110";
-- 1.087194
y <= "0011111000101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 561
-- 93699.242588
x <= "0101111011011100";
-- -1.085483
y <= "1011111000101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 562
-- 93699.242588
x <= "0101111011011100";
-- -0.844264
y <= "1011110101100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 563
-- 93699.242588
x <= "0101111011011100";
-- -0.603046
y <= "1011110001101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 564
-- 93699.242588
x <= "0101111011011100";
-- -0.361828
y <= "1011101011100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 565
-- 93699.242588
x <= "0101111011011100";
-- -0.120609
y <= "1011011111011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 566
-- 93699.242588
x <= "0101111011011100";
-- 0.120609
y <= "0011011111011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 567
-- 93699.242588
x <= "0101111011011100";
-- 0.361828
y <= "0011101011100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 568
-- 93699.242588
x <= "0101111011011100";
-- 0.603046
y <= "0011110001101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 569
-- 93699.242588
x <= "0101111011011100";
-- 0.844264
y <= "0011110101100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 570
-- 93699.242588
x <= "0101111011011100";
-- 1.085483
y <= "0011111000101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 571
-- 95372.443348
x <= "0101111011101001";
-- -1.083807
y <= "1011111000101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 572
-- 95372.443348
x <= "0101111011101001";
-- -0.842961
y <= "1011110101100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 573
-- 95372.443348
x <= "0101111011101001";
-- -0.602115
y <= "1011110001101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 574
-- 95372.443348
x <= "0101111011101001";
-- -0.361269
y <= "1011101011100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 575
-- 95372.443348
x <= "0101111011101001";
-- -0.120423
y <= "1011011111011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 576
-- 95372.443348
x <= "0101111011101001";
-- 0.120423
y <= "0011011111011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 577
-- 95372.443348
x <= "0101111011101001";
-- 0.361269
y <= "0011101011100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 578
-- 95372.443348
x <= "0101111011101001";
-- 0.602115
y <= "0011110001101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 579
-- 95372.443348
x <= "0101111011101001";
-- 0.842961
y <= "0011110101011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 580
-- 95372.443348
x <= "0101111011101001";
-- 1.083807
y <= "0011111000101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 581
-- 97045.644108
x <= "0101111011110110";
-- -1.082166
y <= "1011111000101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 582
-- 97045.644108
x <= "0101111011110110";
-- -0.841684
y <= "1011110101011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 583
-- 97045.644108
x <= "0101111011110110";
-- -0.601203
y <= "1011110001101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 584
-- 97045.644108
x <= "0101111011110110";
-- -0.360722
y <= "1011101011100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 585
-- 97045.644108
x <= "0101111011110110";
-- -0.120241
y <= "1011011111011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 586
-- 97045.644108
x <= "0101111011110110";
-- 0.120241
y <= "0011011111011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 587
-- 97045.644108
x <= "0101111011110110";
-- 0.360722
y <= "0011101011100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 588
-- 97045.644108
x <= "0101111011110110";
-- 0.601203
y <= "0011110001100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 589
-- 97045.644108
x <= "0101111011110110";
-- 0.841684
y <= "0011110101011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 590
-- 97045.644108
x <= "0101111011110110";
-- 1.082166
y <= "0011111000101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 591
-- 98718.844869
x <= "0101111100000011";
-- -1.080557
y <= "1011111000101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 592
-- 98718.844869
x <= "0101111100000011";
-- -0.840433
y <= "1011110101011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 593
-- 98718.844869
x <= "0101111100000011";
-- -0.600309
y <= "1011110001100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 594
-- 98718.844869
x <= "0101111100000011";
-- -0.360186
y <= "1011101011100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 595
-- 98718.844869
x <= "0101111100000011";
-- -0.120062
y <= "1011011111011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 596
-- 98718.844869
x <= "0101111100000011";
-- 0.120062
y <= "0011011111010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 597
-- 98718.844869
x <= "0101111100000011";
-- 0.360186
y <= "0011101011100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 598
-- 98718.844869
x <= "0101111100000011";
-- 0.600309
y <= "0011110001100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 599
-- 98718.844869
x <= "0101111100000011";
-- 0.840433
y <= "0011110101011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 600
-- 98718.844869
x <= "0101111100000011";
-- 1.080557
y <= "0011111000101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 601
-- 100392.045629
x <= "0101111100010000";
-- -1.078980
y <= "1011111000101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 602
-- 100392.045629
x <= "0101111100010000";
-- -0.839207
y <= "1011110101011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 603
-- 100392.045629
x <= "0101111100010000";
-- -0.599433
y <= "1011110001100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 604
-- 100392.045629
x <= "0101111100010000";
-- -0.359660
y <= "1011101011100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 605
-- 100392.045629
x <= "0101111100010000";
-- -0.119887
y <= "1011011111010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 606
-- 100392.045629
x <= "0101111100010000";
-- 0.119887
y <= "0011011111010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 607
-- 100392.045629
x <= "0101111100010000";
-- 0.359660
y <= "0011101011100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 608
-- 100392.045629
x <= "0101111100010000";
-- 0.599433
y <= "0011110001100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 609
-- 100392.045629
x <= "0101111100010000";
-- 0.839207
y <= "0011110101011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 610
-- 100392.045629
x <= "0101111100010000";
-- 1.078980
y <= "0011111000101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 611
-- 102065.246390
x <= "0101111100011101";
-- -1.077434
y <= "1011111000101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 612
-- 102065.246390
x <= "0101111100011101";
-- -0.838004
y <= "1011110101011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 613
-- 102065.246390
x <= "0101111100011101";
-- -0.598574
y <= "1011110001100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 614
-- 102065.246390
x <= "0101111100011101";
-- -0.359145
y <= "1011101011100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 615
-- 102065.246390
x <= "0101111100011101";
-- -0.119715
y <= "1011011111010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 616
-- 102065.246390
x <= "0101111100011101";
-- 0.119715
y <= "0011011111010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 617
-- 102065.246390
x <= "0101111100011101";
-- 0.359145
y <= "0011101011011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 618
-- 102065.246390
x <= "0101111100011101";
-- 0.598574
y <= "0011110001100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 619
-- 102065.246390
x <= "0101111100011101";
-- 0.838004
y <= "0011110101011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 620
-- 102065.246390
x <= "0101111100011101";
-- 1.077434
y <= "0011111000100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 621
-- 103738.447150
x <= "0101111100101010";
-- -1.075917
y <= "1011111000100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 622
-- 103738.447150
x <= "0101111100101010";
-- -0.836824
y <= "1011110101011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 623
-- 103738.447150
x <= "0101111100101010";
-- -0.597732
y <= "1011110001100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 624
-- 103738.447150
x <= "0101111100101010";
-- -0.358639
y <= "1011101011011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 625
-- 103738.447150
x <= "0101111100101010";
-- -0.119546
y <= "1011011111010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 626
-- 103738.447150
x <= "0101111100101010";
-- 0.119546
y <= "0011011111010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 627
-- 103738.447150
x <= "0101111100101010";
-- 0.358639
y <= "0011101011011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 628
-- 103738.447150
x <= "0101111100101010";
-- 0.597732
y <= "0011110001100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 629
-- 103738.447150
x <= "0101111100101010";
-- 0.836824
y <= "0011110101011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 630
-- 103738.447150
x <= "0101111100101010";
-- 1.075917
y <= "0011111000100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 631
-- 105411.647910
x <= "0101111100110111";
-- -1.074428
y <= "1011111000100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 632
-- 105411.647910
x <= "0101111100110111";
-- -0.835667
y <= "1011110101011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 633
-- 105411.647910
x <= "0101111100110111";
-- -0.596905
y <= "1011110001100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 634
-- 105411.647910
x <= "0101111100110111";
-- -0.358143
y <= "1011101011011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 635
-- 105411.647910
x <= "0101111100110111";
-- -0.119381
y <= "1011011111010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 636
-- 105411.647910
x <= "0101111100110111";
-- 0.119381
y <= "0011011111010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 637
-- 105411.647910
x <= "0101111100110111";
-- 0.358143
y <= "0011101011011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 638
-- 105411.647910
x <= "0101111100110111";
-- 0.596905
y <= "0011110001100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 639
-- 105411.647910
x <= "0101111100110111";
-- 0.835667
y <= "0011110101010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 640
-- 105411.647910
x <= "0101111100110111";
-- 1.074428
y <= "0011111000100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 641
-- 107084.848671
x <= "0101111101000100";
-- -1.072967
y <= "1011111000100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 642
-- 107084.848671
x <= "0101111101000100";
-- -0.834530
y <= "1011110101010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 643
-- 107084.848671
x <= "0101111101000100";
-- -0.596093
y <= "1011110001100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 644
-- 107084.848671
x <= "0101111101000100";
-- -0.357656
y <= "1011101011011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 645
-- 107084.848671
x <= "0101111101000100";
-- -0.119219
y <= "1011011111010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 646
-- 107084.848671
x <= "0101111101000100";
-- 0.119219
y <= "0011011111010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 647
-- 107084.848671
x <= "0101111101000100";
-- 0.357656
y <= "0011101011011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 648
-- 107084.848671
x <= "0101111101000100";
-- 0.596093
y <= "0011110001100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 649
-- 107084.848671
x <= "0101111101000100";
-- 0.834530
y <= "0011110101010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 650
-- 107084.848671
x <= "0101111101000100";
-- 1.072967
y <= "0011111000100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 651
-- 108758.049431
x <= "0101111101010001";
-- -1.071533
y <= "1011111000100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 652
-- 108758.049431
x <= "0101111101010001";
-- -0.833415
y <= "1011110101010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 653
-- 108758.049431
x <= "0101111101010001";
-- -0.595296
y <= "1011110001100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 654
-- 108758.049431
x <= "0101111101010001";
-- -0.357178
y <= "1011101011011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 655
-- 108758.049431
x <= "0101111101010001";
-- -0.119059
y <= "1011011111010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 656
-- 108758.049431
x <= "0101111101010001";
-- 0.119059
y <= "0011011111001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 657
-- 108758.049431
x <= "0101111101010001";
-- 0.357178
y <= "0011101011011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 658
-- 108758.049431
x <= "0101111101010001";
-- 0.595296
y <= "0011110001100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 659
-- 108758.049431
x <= "0101111101010001";
-- 0.833415
y <= "0011110101010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 660
-- 108758.049431
x <= "0101111101010001";
-- 1.071533
y <= "0011111000100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 661
-- 110431.250192
x <= "0101111101011110";
-- -1.070124
y <= "1011111000100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 662
-- 110431.250192
x <= "0101111101011110";
-- -0.832319
y <= "1011110101010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 663
-- 110431.250192
x <= "0101111101011110";
-- -0.594513
y <= "1011110001100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 664
-- 110431.250192
x <= "0101111101011110";
-- -0.356708
y <= "1011101011011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 665
-- 110431.250192
x <= "0101111101011110";
-- -0.118903
y <= "1011011111001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 666
-- 110431.250192
x <= "0101111101011110";
-- 0.118903
y <= "0011011111001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 667
-- 110431.250192
x <= "0101111101011110";
-- 0.356708
y <= "0011101011011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 668
-- 110431.250192
x <= "0101111101011110";
-- 0.594513
y <= "0011110001100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 669
-- 110431.250192
x <= "0101111101011110";
-- 0.832319
y <= "0011110101010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 670
-- 110431.250192
x <= "0101111101011110";
-- 1.070124
y <= "0011111000100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 671
-- 112104.450952
x <= "0101111101101011";
-- -1.068740
y <= "1011111000100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 672
-- 112104.450952
x <= "0101111101101011";
-- -0.831242
y <= "1011110101010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 673
-- 112104.450952
x <= "0101111101101011";
-- -0.593744
y <= "1011110001100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 674
-- 112104.450952
x <= "0101111101101011";
-- -0.356247
y <= "1011101011011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 675
-- 112104.450952
x <= "0101111101101011";
-- -0.118749
y <= "1011011111001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 676
-- 112104.450952
x <= "0101111101101011";
-- 0.118749
y <= "0011011111001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 677
-- 112104.450952
x <= "0101111101101011";
-- 0.356247
y <= "0011101011011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 678
-- 112104.450952
x <= "0101111101101011";
-- 0.593744
y <= "0011110001011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 679
-- 112104.450952
x <= "0101111101101011";
-- 0.831242
y <= "0011110101010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 680
-- 112104.450952
x <= "0101111101101011";
-- 1.068740
y <= "0011111000100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 681
-- 113777.651713
x <= "0101111101111000";
-- -1.067380
y <= "1011111000100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 682
-- 113777.651713
x <= "0101111101111000";
-- -0.830184
y <= "1011110101010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 683
-- 113777.651713
x <= "0101111101111000";
-- -0.592989
y <= "1011110001100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 684
-- 113777.651713
x <= "0101111101111000";
-- -0.355793
y <= "1011101011011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 685
-- 113777.651713
x <= "0101111101111000";
-- -0.118598
y <= "1011011111001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 686
-- 113777.651713
x <= "0101111101111000";
-- 0.118598
y <= "0011011111001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 687
-- 113777.651713
x <= "0101111101111000";
-- 0.355793
y <= "0011101011011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 688
-- 113777.651713
x <= "0101111101111000";
-- 0.592989
y <= "0011110001011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 689
-- 113777.651713
x <= "0101111101111000";
-- 0.830184
y <= "0011110101010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 690
-- 113777.651713
x <= "0101111101111000";
-- 1.067380
y <= "0011111000100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 691
-- 115450.852473
x <= "0101111110000101";
-- -1.066043
y <= "1011111000100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 692
-- 115450.852473
x <= "0101111110000101";
-- -0.829145
y <= "1011110101010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 693
-- 115450.852473
x <= "0101111110000101";
-- -0.592246
y <= "1011110001011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 694
-- 115450.852473
x <= "0101111110000101";
-- -0.355348
y <= "1011101011011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 695
-- 115450.852473
x <= "0101111110000101";
-- -0.118449
y <= "1011011111001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 696
-- 115450.852473
x <= "0101111110000101";
-- 0.118449
y <= "0011011111001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 697
-- 115450.852473
x <= "0101111110000101";
-- 0.355348
y <= "0011101011010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 698
-- 115450.852473
x <= "0101111110000101";
-- 0.592246
y <= "0011110001011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 699
-- 115450.852473
x <= "0101111110000101";
-- 0.829145
y <= "0011110101010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 700
-- 115450.852473
x <= "0101111110000101";
-- 1.066043
y <= "0011111000100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 701
-- 117124.053233
x <= "0101111110010011";
-- -1.064729
y <= "1011111000100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 702
-- 117124.053233
x <= "0101111110010011";
-- -0.828123
y <= "1011110101010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 703
-- 117124.053233
x <= "0101111110010011";
-- -0.591516
y <= "1011110001011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 704
-- 117124.053233
x <= "0101111110010011";
-- -0.354910
y <= "1011101011010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 705
-- 117124.053233
x <= "0101111110010011";
-- -0.118303
y <= "1011011111001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 706
-- 117124.053233
x <= "0101111110010011";
-- 0.118303
y <= "0011011111001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 707
-- 117124.053233
x <= "0101111110010011";
-- 0.354910
y <= "0011101011010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 708
-- 117124.053233
x <= "0101111110010011";
-- 0.591516
y <= "0011110001011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 709
-- 117124.053233
x <= "0101111110010011";
-- 0.828123
y <= "0011110101001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 710
-- 117124.053233
x <= "0101111110010011";
-- 1.064729
y <= "0011111000100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 711
-- 118797.253994
x <= "0101111110100000";
-- -1.063436
y <= "1011111000100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 712
-- 118797.253994
x <= "0101111110100000";
-- -0.827117
y <= "1011110101001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 713
-- 118797.253994
x <= "0101111110100000";
-- -0.590798
y <= "1011110001011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 714
-- 118797.253994
x <= "0101111110100000";
-- -0.354479
y <= "1011101011010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 715
-- 118797.253994
x <= "0101111110100000";
-- -0.118160
y <= "1011011111001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 716
-- 118797.253994
x <= "0101111110100000";
-- 0.118160
y <= "0011011111000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 717
-- 118797.253994
x <= "0101111110100000";
-- 0.354479
y <= "0011101011010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 718
-- 118797.253994
x <= "0101111110100000";
-- 0.590798
y <= "0011110001011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 719
-- 118797.253994
x <= "0101111110100000";
-- 0.827117
y <= "0011110101001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 720
-- 118797.253994
x <= "0101111110100000";
-- 1.063436
y <= "0011111000100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 721
-- 120470.454754
x <= "0101111110101101";
-- -1.062165
y <= "1011111000100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 722
-- 120470.454754
x <= "0101111110101101";
-- -0.826128
y <= "1011110101001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 723
-- 120470.454754
x <= "0101111110101101";
-- -0.590092
y <= "1011110001011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 724
-- 120470.454754
x <= "0101111110101101";
-- -0.354055
y <= "1011101011010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 725
-- 120470.454754
x <= "0101111110101101";
-- -0.118018
y <= "1011011111000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 726
-- 120470.454754
x <= "0101111110101101";
-- 0.118018
y <= "0011011111000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 727
-- 120470.454754
x <= "0101111110101101";
-- 0.354055
y <= "0011101011010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 728
-- 120470.454754
x <= "0101111110101101";
-- 0.590092
y <= "0011110001011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 729
-- 120470.454754
x <= "0101111110101101";
-- 0.826128
y <= "0011110101001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 730
-- 120470.454754
x <= "0101111110101101";
-- 1.062165
y <= "0011111000011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 731
-- 122143.655515
x <= "0101111110111010";
-- -1.060914
y <= "1011111000100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 732
-- 122143.655515
x <= "0101111110111010";
-- -0.825156
y <= "1011110101001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 733
-- 122143.655515
x <= "0101111110111010";
-- -0.589397
y <= "1011110001011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 734
-- 122143.655515
x <= "0101111110111010";
-- -0.353638
y <= "1011101011010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 735
-- 122143.655515
x <= "0101111110111010";
-- -0.117879
y <= "1011011111000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 736
-- 122143.655515
x <= "0101111110111010";
-- 0.117879
y <= "0011011111000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 737
-- 122143.655515
x <= "0101111110111010";
-- 0.353638
y <= "0011101011010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 738
-- 122143.655515
x <= "0101111110111010";
-- 0.589397
y <= "0011110001011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 739
-- 122143.655515
x <= "0101111110111010";
-- 0.825156
y <= "0011110101001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 740
-- 122143.655515
x <= "0101111110111010";
-- 1.060914
y <= "0011111000011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 741
-- 123816.856275
x <= "0101111111000111";
-- -1.059683
y <= "1011111000011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 742
-- 123816.856275
x <= "0101111111000111";
-- -0.824198
y <= "1011110101001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 743
-- 123816.856275
x <= "0101111111000111";
-- -0.588713
y <= "1011110001011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 744
-- 123816.856275
x <= "0101111111000111";
-- -0.353228
y <= "1011101011010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 745
-- 123816.856275
x <= "0101111111000111";
-- -0.117743
y <= "1011011111000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 746
-- 123816.856275
x <= "0101111111000111";
-- 0.117743
y <= "0011011111000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 747
-- 123816.856275
x <= "0101111111000111";
-- 0.353228
y <= "0011101011010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 748
-- 123816.856275
x <= "0101111111000111";
-- 0.588713
y <= "0011110001011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 749
-- 123816.856275
x <= "0101111111000111";
-- 0.824198
y <= "0011110101001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 750
-- 123816.856275
x <= "0101111111000111";
-- 1.059683
y <= "0011111000011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 751
-- 125490.057036
x <= "0101111111010100";
-- -1.058472
y <= "1011111000011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 752
-- 125490.057036
x <= "0101111111010100";
-- -0.823256
y <= "1011110101001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 753
-- 125490.057036
x <= "0101111111010100";
-- -0.588040
y <= "1011110001011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 754
-- 125490.057036
x <= "0101111111010100";
-- -0.352824
y <= "1011101011010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 755
-- 125490.057036
x <= "0101111111010100";
-- -0.117608
y <= "1011011111000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 756
-- 125490.057036
x <= "0101111111010100";
-- 0.117608
y <= "0011011111000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 757
-- 125490.057036
x <= "0101111111010100";
-- 0.352824
y <= "0011101011010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 758
-- 125490.057036
x <= "0101111111010100";
-- 0.588040
y <= "0011110001011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 759
-- 125490.057036
x <= "0101111111010100";
-- 0.823256
y <= "0011110101001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 760
-- 125490.057036
x <= "0101111111010100";
-- 1.058472
y <= "0011111000011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 761
-- 127163.257796
x <= "0101111111100001";
-- -1.057279
y <= "1011111000011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 762
-- 127163.257796
x <= "0101111111100001";
-- -0.822328
y <= "1011110101001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 763
-- 127163.257796
x <= "0101111111100001";
-- -0.587377
y <= "1011110001011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 764
-- 127163.257796
x <= "0101111111100001";
-- -0.352426
y <= "1011101011010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 765
-- 127163.257796
x <= "0101111111100001";
-- -0.117475
y <= "1011011111000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 766
-- 127163.257796
x <= "0101111111100001";
-- 0.117475
y <= "0011011111000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 767
-- 127163.257796
x <= "0101111111100001";
-- 0.352426
y <= "0011101011010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 768
-- 127163.257796
x <= "0101111111100001";
-- 0.587377
y <= "0011110001011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 769
-- 127163.257796
x <= "0101111111100001";
-- 0.822328
y <= "0011110101001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 770
-- 127163.257796
x <= "0101111111100001";
-- 1.057279
y <= "0011111000011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 771
-- 128836.458556
x <= "0101111111101110";
-- -1.056104
y <= "1011111000011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 772
-- 128836.458556
x <= "0101111111101110";
-- -0.821415
y <= "1011110101001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 773
-- 128836.458556
x <= "0101111111101110";
-- -0.586725
y <= "1011110001011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 774
-- 128836.458556
x <= "0101111111101110";
-- -0.352035
y <= "1011101011010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 775
-- 128836.458556
x <= "0101111111101110";
-- -0.117345
y <= "1011011111000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 776
-- 128836.458556
x <= "0101111111101110";
-- 0.117345
y <= "0011011111000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 777
-- 128836.458556
x <= "0101111111101110";
-- 0.352035
y <= "0011101011010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 778
-- 128836.458556
x <= "0101111111101110";
-- 0.586725
y <= "0011110001011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 779
-- 128836.458556
x <= "0101111111101110";
-- 0.821415
y <= "0011110101001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 780
-- 128836.458556
x <= "0101111111101110";
-- 1.056104
y <= "0011111000011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 781
-- 130509.659317
x <= "0101111111111011";
-- -1.054947
y <= "1011111000011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 782
-- 130509.659317
x <= "0101111111111011";
-- -0.820515
y <= "1011110101001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 783
-- 130509.659317
x <= "0101111111111011";
-- -0.586082
y <= "1011110001011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 784
-- 130509.659317
x <= "0101111111111011";
-- -0.351649
y <= "1011101011010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 785
-- 130509.659317
x <= "0101111111111011";
-- -0.117216
y <= "1011011111000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 786
-- 130509.659317
x <= "0101111111111011";
-- 0.117216
y <= "0011011111000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 787
-- 130509.659317
x <= "0101111111111011";
-- 0.351649
y <= "0011101011010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 788
-- 130509.659317
x <= "0101111111111011";
-- 0.586082
y <= "0011110001011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 789
-- 130509.659317
x <= "0101111111111011";
-- 0.820515
y <= "0011110101001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 790
-- 130509.659317
x <= "0101111111111011";
-- 1.054947
y <= "0011111000011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 791
-- 132182.860077
x <= "0110000000000100";
-- -1.053808
y <= "1011111000011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 792
-- 132182.860077
x <= "0110000000000100";
-- -0.819628
y <= "1011110101001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 793
-- 132182.860077
x <= "0110000000000100";
-- -0.585449
y <= "1011110001011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 794
-- 132182.860077
x <= "0110000000000100";
-- -0.351269
y <= "1011101011010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 795
-- 132182.860077
x <= "0110000000000100";
-- -0.117090
y <= "1011011111000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 796
-- 132182.860077
x <= "0110000000000100";
-- 0.117090
y <= "0011011110111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 797
-- 132182.860077
x <= "0110000000000100";
-- 0.351269
y <= "0011101011001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 798
-- 132182.860077
x <= "0110000000000100";
-- 0.585449
y <= "0011110001010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 799
-- 132182.860077
x <= "0110000000000100";
-- 0.819628
y <= "0011110101000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 800
-- 132182.860077
x <= "0110000000000100";
-- 1.053808
y <= "0011111000011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 801
-- 133856.060838
x <= "0110000000001010";
-- -1.052685
y <= "1011111000011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 802
-- 133856.060838
x <= "0110000000001010";
-- -0.818755
y <= "1011110101000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 803
-- 133856.060838
x <= "0110000000001010";
-- -0.584825
y <= "1011110001010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 804
-- 133856.060838
x <= "0110000000001010";
-- -0.350895
y <= "1011101011001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 805
-- 133856.060838
x <= "0110000000001010";
-- -0.116965
y <= "1011011110111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 806
-- 133856.060838
x <= "0110000000001010";
-- 0.116965
y <= "0011011110111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 807
-- 133856.060838
x <= "0110000000001010";
-- 0.350895
y <= "0011101011001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 808
-- 133856.060838
x <= "0110000000001010";
-- 0.584825
y <= "0011110001010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 809
-- 133856.060838
x <= "0110000000001010";
-- 0.818755
y <= "0011110101000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 810
-- 133856.060838
x <= "0110000000001010";
-- 1.052685
y <= "0011111000011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 811
-- 135529.261598
x <= "0110000000010001";
-- -1.051578
y <= "1011111000011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 812
-- 135529.261598
x <= "0110000000010001";
-- -0.817894
y <= "1011110101000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 813
-- 135529.261598
x <= "0110000000010001";
-- -0.584210
y <= "1011110001010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 814
-- 135529.261598
x <= "0110000000010001";
-- -0.350526
y <= "1011101011001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 815
-- 135529.261598
x <= "0110000000010001";
-- -0.116842
y <= "1011011110111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 816
-- 135529.261598
x <= "0110000000010001";
-- 0.116842
y <= "0011011110111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 817
-- 135529.261598
x <= "0110000000010001";
-- 0.350526
y <= "0011101011001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 818
-- 135529.261598
x <= "0110000000010001";
-- 0.584210
y <= "0011110001010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 819
-- 135529.261598
x <= "0110000000010001";
-- 0.817894
y <= "0011110101000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 820
-- 135529.261598
x <= "0110000000010001";
-- 1.051578
y <= "0011111000011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 821
-- 137202.462358
x <= "0110000000010111";
-- -1.050487
y <= "1011111000011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 822
-- 137202.462358
x <= "0110000000010111";
-- -0.817046
y <= "1011110101000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 823
-- 137202.462358
x <= "0110000000010111";
-- -0.583604
y <= "1011110001010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 824
-- 137202.462358
x <= "0110000000010111";
-- -0.350162
y <= "1011101011001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 825
-- 137202.462358
x <= "0110000000010111";
-- -0.116721
y <= "1011011110111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 826
-- 137202.462358
x <= "0110000000010111";
-- 0.116721
y <= "0011011110111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 827
-- 137202.462358
x <= "0110000000010111";
-- 0.350162
y <= "0011101011001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 828
-- 137202.462358
x <= "0110000000010111";
-- 0.583604
y <= "0011110001010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 829
-- 137202.462358
x <= "0110000000010111";
-- 0.817046
y <= "0011110101000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 830
-- 137202.462358
x <= "0110000000010111";
-- 1.050487
y <= "0011111000011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 831
-- 138875.663119
x <= "0110000000011110";
-- -1.049412
y <= "1011111000011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 832
-- 138875.663119
x <= "0110000000011110";
-- -0.816209
y <= "1011110101000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 833
-- 138875.663119
x <= "0110000000011110";
-- -0.583007
y <= "1011110001010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 834
-- 138875.663119
x <= "0110000000011110";
-- -0.349804
y <= "1011101011001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 835
-- 138875.663119
x <= "0110000000011110";
-- -0.116601
y <= "1011011110111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 836
-- 138875.663119
x <= "0110000000011110";
-- 0.116601
y <= "0011011110111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 837
-- 138875.663119
x <= "0110000000011110";
-- 0.349804
y <= "0011101011001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 838
-- 138875.663119
x <= "0110000000011110";
-- 0.583007
y <= "0011110001010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 839
-- 138875.663119
x <= "0110000000011110";
-- 0.816209
y <= "0011110101000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 840
-- 138875.663119
x <= "0110000000011110";
-- 1.049412
y <= "0011111000011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 841
-- 140548.863879
x <= "0110000000100101";
-- -1.048352
y <= "1011111000011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 842
-- 140548.863879
x <= "0110000000100101";
-- -0.815385
y <= "1011110101000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 843
-- 140548.863879
x <= "0110000000100101";
-- -0.582418
y <= "1011110001010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 844
-- 140548.863879
x <= "0110000000100101";
-- -0.349451
y <= "1011101011001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 845
-- 140548.863879
x <= "0110000000100101";
-- -0.116484
y <= "1011011110111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 846
-- 140548.863879
x <= "0110000000100101";
-- 0.116484
y <= "0011011110111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 847
-- 140548.863879
x <= "0110000000100101";
-- 0.349451
y <= "0011101011001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 848
-- 140548.863879
x <= "0110000000100101";
-- 0.582418
y <= "0011110001010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 849
-- 140548.863879
x <= "0110000000100101";
-- 0.815385
y <= "0011110101000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 850
-- 140548.863879
x <= "0110000000100101";
-- 1.048352
y <= "0011111000011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 851
-- 142222.064640
x <= "0110000000101011";
-- -1.047306
y <= "1011111000011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 852
-- 142222.064640
x <= "0110000000101011";
-- -0.814571
y <= "1011110101000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 853
-- 142222.064640
x <= "0110000000101011";
-- -0.581837
y <= "1011110001010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 854
-- 142222.064640
x <= "0110000000101011";
-- -0.349102
y <= "1011101011001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 855
-- 142222.064640
x <= "0110000000101011";
-- -0.116367
y <= "1011011110111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 856
-- 142222.064640
x <= "0110000000101011";
-- 0.116367
y <= "0011011110111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 857
-- 142222.064640
x <= "0110000000101011";
-- 0.349102
y <= "0011101011001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 858
-- 142222.064640
x <= "0110000000101011";
-- 0.581837
y <= "0011110001010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 859
-- 142222.064640
x <= "0110000000101011";
-- 0.814571
y <= "0011110101000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 860
-- 142222.064640
x <= "0110000000101011";
-- 1.047306
y <= "0011111000011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 861
-- 143895.265400
x <= "0110000000110010";
-- -1.046275
y <= "1011111000011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 862
-- 143895.265400
x <= "0110000000110010";
-- -0.813769
y <= "1011110101000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 863
-- 143895.265400
x <= "0110000000110010";
-- -0.581264
y <= "1011110001010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 864
-- 143895.265400
x <= "0110000000110010";
-- -0.348758
y <= "1011101011001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 865
-- 143895.265400
x <= "0110000000110010";
-- -0.116253
y <= "1011011110111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 866
-- 143895.265400
x <= "0110000000110010";
-- 0.116253
y <= "0011011110111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 867
-- 143895.265400
x <= "0110000000110010";
-- 0.348758
y <= "0011101011001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 868
-- 143895.265400
x <= "0110000000110010";
-- 0.581264
y <= "0011110001010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 869
-- 143895.265400
x <= "0110000000110010";
-- 0.813769
y <= "0011110101000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 870
-- 143895.265400
x <= "0110000000110010";
-- 1.046275
y <= "0011111000010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 871
-- 145568.466161
x <= "0110000000111000";
-- -1.045257
y <= "1011111000011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 872
-- 145568.466161
x <= "0110000000111000";
-- -0.812978
y <= "1011110101000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 873
-- 145568.466161
x <= "0110000000111000";
-- -0.580699
y <= "1011110001010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 874
-- 145568.466161
x <= "0110000000111000";
-- -0.348419
y <= "1011101011001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 875
-- 145568.466161
x <= "0110000000111000";
-- -0.116140
y <= "1011011110111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 876
-- 145568.466161
x <= "0110000000111000";
-- 0.116140
y <= "0011011110110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 877
-- 145568.466161
x <= "0110000000111000";
-- 0.348419
y <= "0011101011001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 878
-- 145568.466161
x <= "0110000000111000";
-- 0.580699
y <= "0011110001010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 879
-- 145568.466161
x <= "0110000000111000";
-- 0.812978
y <= "0011110101000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 880
-- 145568.466161
x <= "0110000000111000";
-- 1.045257
y <= "0011111000010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 881
-- 147241.666921
x <= "0110000000111111";
-- -1.044254
y <= "1011111000010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 882
-- 147241.666921
x <= "0110000000111111";
-- -0.812197
y <= "1011110101000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 883
-- 147241.666921
x <= "0110000000111111";
-- -0.580141
y <= "1011110001010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 884
-- 147241.666921
x <= "0110000000111111";
-- -0.348085
y <= "1011101011001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 885
-- 147241.666921
x <= "0110000000111111";
-- -0.116028
y <= "1011011110110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 886
-- 147241.666921
x <= "0110000000111111";
-- 0.116028
y <= "0011011110110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 887
-- 147241.666921
x <= "0110000000111111";
-- 0.348085
y <= "0011101011001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 888
-- 147241.666921
x <= "0110000000111111";
-- 0.580141
y <= "0011110001010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 889
-- 147241.666921
x <= "0110000000111111";
-- 0.812197
y <= "0011110100111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 890
-- 147241.666921
x <= "0110000000111111";
-- 1.044254
y <= "0011111000010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 891
-- 148914.867681
x <= "0110000001000101";
-- -1.043263
y <= "1011111000010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 892
-- 148914.867681
x <= "0110000001000101";
-- -0.811427
y <= "1011110100111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 893
-- 148914.867681
x <= "0110000001000101";
-- -0.579590
y <= "1011110001010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 894
-- 148914.867681
x <= "0110000001000101";
-- -0.347754
y <= "1011101011001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 895
-- 148914.867681
x <= "0110000001000101";
-- -0.115918
y <= "1011011110110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 896
-- 148914.867681
x <= "0110000001000101";
-- 0.115918
y <= "0011011110110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 897
-- 148914.867681
x <= "0110000001000101";
-- 0.347754
y <= "0011101011001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 898
-- 148914.867681
x <= "0110000001000101";
-- 0.579590
y <= "0011110001010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 899
-- 148914.867681
x <= "0110000001000101";
-- 0.811427
y <= "0011110100111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 900
-- 148914.867681
x <= "0110000001000101";
-- 1.043263
y <= "0011111000010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 901
-- 150588.068442
x <= "0110000001001100";
-- -1.042285
y <= "1011111000010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 902
-- 150588.068442
x <= "0110000001001100";
-- -0.810666
y <= "1011110100111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 903
-- 150588.068442
x <= "0110000001001100";
-- -0.579047
y <= "1011110001010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 904
-- 150588.068442
x <= "0110000001001100";
-- -0.347428
y <= "1011101011001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 905
-- 150588.068442
x <= "0110000001001100";
-- -0.115809
y <= "1011011110110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 906
-- 150588.068442
x <= "0110000001001100";
-- 0.115809
y <= "0011011110110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 907
-- 150588.068442
x <= "0110000001001100";
-- 0.347428
y <= "0011101011000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 908
-- 150588.068442
x <= "0110000001001100";
-- 0.579047
y <= "0011110001010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 909
-- 150588.068442
x <= "0110000001001100";
-- 0.810666
y <= "0011110100111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 910
-- 150588.068442
x <= "0110000001001100";
-- 1.042285
y <= "0011111000010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 911
-- 152261.269202
x <= "0110000001010010";
-- -1.041320
y <= "1011111000010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 912
-- 152261.269202
x <= "0110000001010010";
-- -0.809916
y <= "1011110100111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 913
-- 152261.269202
x <= "0110000001010010";
-- -0.578511
y <= "1011110001010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 914
-- 152261.269202
x <= "0110000001010010";
-- -0.347107
y <= "1011101011000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 915
-- 152261.269202
x <= "0110000001010010";
-- -0.115702
y <= "1011011110110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 916
-- 152261.269202
x <= "0110000001010010";
-- 0.115702
y <= "0011011110110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 917
-- 152261.269202
x <= "0110000001010010";
-- 0.347107
y <= "0011101011000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 918
-- 152261.269202
x <= "0110000001010010";
-- 0.578511
y <= "0011110001010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 919
-- 152261.269202
x <= "0110000001010010";
-- 0.809916
y <= "0011110100111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 920
-- 152261.269202
x <= "0110000001010010";
-- 1.041320
y <= "0011111000010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 921
-- 153934.469963
x <= "0110000001011001";
-- -1.040367
y <= "1011111000010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 922
-- 153934.469963
x <= "0110000001011001";
-- -0.809175
y <= "1011110100111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 923
-- 153934.469963
x <= "0110000001011001";
-- -0.577982
y <= "1011110001010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 924
-- 153934.469963
x <= "0110000001011001";
-- -0.346789
y <= "1011101011000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 925
-- 153934.469963
x <= "0110000001011001";
-- -0.115596
y <= "1011011110110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 926
-- 153934.469963
x <= "0110000001011001";
-- 0.115596
y <= "0011011110110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 927
-- 153934.469963
x <= "0110000001011001";
-- 0.346789
y <= "0011101011000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 928
-- 153934.469963
x <= "0110000001011001";
-- 0.577982
y <= "0011110001001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 929
-- 153934.469963
x <= "0110000001011001";
-- 0.809175
y <= "0011110100111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 930
-- 153934.469963
x <= "0110000001011001";
-- 1.040367
y <= "0011111000010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 931
-- 155607.670723
x <= "0110000001011111";
-- -1.039426
y <= "1011111000010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 932
-- 155607.670723
x <= "0110000001011111";
-- -0.808443
y <= "1011110100111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 933
-- 155607.670723
x <= "0110000001011111";
-- -0.577459
y <= "1011110001010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 934
-- 155607.670723
x <= "0110000001011111";
-- -0.346475
y <= "1011101011000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 935
-- 155607.670723
x <= "0110000001011111";
-- -0.115492
y <= "1011011110110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 936
-- 155607.670723
x <= "0110000001011111";
-- 0.115492
y <= "0011011110110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 937
-- 155607.670723
x <= "0110000001011111";
-- 0.346475
y <= "0011101011000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 938
-- 155607.670723
x <= "0110000001011111";
-- 0.577459
y <= "0011110001001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 939
-- 155607.670723
x <= "0110000001011111";
-- 0.808443
y <= "0011110100111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 940
-- 155607.670723
x <= "0110000001011111";
-- 1.039426
y <= "0011111000010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 941
-- 157280.871483
x <= "0110000001100110";
-- -1.038497
y <= "1011111000010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 942
-- 157280.871483
x <= "0110000001100110";
-- -0.807720
y <= "1011110100111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 943
-- 157280.871483
x <= "0110000001100110";
-- -0.576943
y <= "1011110001001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 944
-- 157280.871483
x <= "0110000001100110";
-- -0.346166
y <= "1011101011000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 945
-- 157280.871483
x <= "0110000001100110";
-- -0.115389
y <= "1011011110110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 946
-- 157280.871483
x <= "0110000001100110";
-- 0.115389
y <= "0011011110110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 947
-- 157280.871483
x <= "0110000001100110";
-- 0.346166
y <= "0011101011000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 948
-- 157280.871483
x <= "0110000001100110";
-- 0.576943
y <= "0011110001001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 949
-- 157280.871483
x <= "0110000001100110";
-- 0.807720
y <= "0011110100111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 950
-- 157280.871483
x <= "0110000001100110";
-- 1.038497
y <= "0011111000010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 951
-- 158954.072244
x <= "0110000001101100";
-- -1.037580
y <= "1011111000010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 952
-- 158954.072244
x <= "0110000001101100";
-- -0.807006
y <= "1011110100111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 953
-- 158954.072244
x <= "0110000001101100";
-- -0.576433
y <= "1011110001001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 954
-- 158954.072244
x <= "0110000001101100";
-- -0.345860
y <= "1011101011000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 955
-- 158954.072244
x <= "0110000001101100";
-- -0.115287
y <= "1011011110110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 956
-- 158954.072244
x <= "0110000001101100";
-- 0.115287
y <= "0011011110110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 957
-- 158954.072244
x <= "0110000001101100";
-- 0.345860
y <= "0011101011000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 958
-- 158954.072244
x <= "0110000001101100";
-- 0.576433
y <= "0011110001001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 959
-- 158954.072244
x <= "0110000001101100";
-- 0.807006
y <= "0011110100111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 960
-- 158954.072244
x <= "0110000001101100";
-- 1.037580
y <= "0011111000010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 961
-- 160627.273004
x <= "0110000001110011";
-- -1.036673
y <= "1011111000010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 962
-- 160627.273004
x <= "0110000001110011";
-- -0.806302
y <= "1011110100111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 963
-- 160627.273004
x <= "0110000001110011";
-- -0.575930
y <= "1011110001001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 964
-- 160627.273004
x <= "0110000001110011";
-- -0.345558
y <= "1011101011000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 965
-- 160627.273004
x <= "0110000001110011";
-- -0.115186
y <= "1011011110110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 966
-- 160627.273004
x <= "0110000001110011";
-- 0.115186
y <= "0011011110101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 967
-- 160627.273004
x <= "0110000001110011";
-- 0.345558
y <= "0011101011000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 968
-- 160627.273004
x <= "0110000001110011";
-- 0.575930
y <= "0011110001001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 969
-- 160627.273004
x <= "0110000001110011";
-- 0.806302
y <= "0011110100111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 970
-- 160627.273004
x <= "0110000001110011";
-- 1.036673
y <= "0011111000010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 971
-- 162300.473765
x <= "0110000001111001";
-- -1.035778
y <= "1011111000010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 972
-- 162300.473765
x <= "0110000001111001";
-- -0.805605
y <= "1011110100111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 973
-- 162300.473765
x <= "0110000001111001";
-- -0.575432
y <= "1011110001001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 974
-- 162300.473765
x <= "0110000001111001";
-- -0.345259
y <= "1011101011000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 975
-- 162300.473765
x <= "0110000001111001";
-- -0.115086
y <= "1011011110101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 976
-- 162300.473765
x <= "0110000001111001";
-- 0.115086
y <= "0011011110101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 977
-- 162300.473765
x <= "0110000001111001";
-- 0.345259
y <= "0011101011000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 978
-- 162300.473765
x <= "0110000001111001";
-- 0.575432
y <= "0011110001001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 979
-- 162300.473765
x <= "0110000001111001";
-- 0.805605
y <= "0011110100111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 980
-- 162300.473765
x <= "0110000001111001";
-- 1.035778
y <= "0011111000010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 981
-- 163973.674525
x <= "0110000010000000";
-- -1.034893
y <= "1011111000010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 982
-- 163973.674525
x <= "0110000010000000";
-- -0.804917
y <= "1011110100111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 983
-- 163973.674525
x <= "0110000010000000";
-- -0.574941
y <= "1011110001001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 984
-- 163973.674525
x <= "0110000010000000";
-- -0.344964
y <= "1011101011000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 985
-- 163973.674525
x <= "0110000010000000";
-- -0.114988
y <= "1011011110101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 986
-- 163973.674525
x <= "0110000010000000";
-- 0.114988
y <= "0011011110101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 987
-- 163973.674525
x <= "0110000010000000";
-- 0.344964
y <= "0011101011000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 988
-- 163973.674525
x <= "0110000010000000";
-- 0.574941
y <= "0011110001001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 989
-- 163973.674525
x <= "0110000010000000";
-- 0.804917
y <= "0011110100111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 990
-- 163973.674525
x <= "0110000010000000";
-- 1.034893
y <= "0011111000010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 991
-- 165646.875286
x <= "0110000010000111";
-- -1.034019
y <= "1011111000010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 992
-- 165646.875286
x <= "0110000010000111";
-- -0.804237
y <= "1011110100111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 993
-- 165646.875286
x <= "0110000010000111";
-- -0.574455
y <= "1011110001001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 994
-- 165646.875286
x <= "0110000010000111";
-- -0.344673
y <= "1011101011000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 995
-- 165646.875286
x <= "0110000010000111";
-- -0.114891
y <= "1011011110101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 996
-- 165646.875286
x <= "0110000010000111";
-- 0.114891
y <= "0011011110101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 997
-- 165646.875286
x <= "0110000010000111";
-- 0.344673
y <= "0011101011000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 998
-- 165646.875286
x <= "0110000010000111";
-- 0.574455
y <= "0011110001001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 999
-- 165646.875286
x <= "0110000010000111";
-- 0.804237
y <= "0011110100110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1000
-- 165646.875286
x <= "0110000010000111";
-- 1.034019
y <= "0011111000010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1001
-- 167320.076046
x <= "0110000010001101";
-- -1.033155
y <= "1011111000010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1002
-- 167320.076046
x <= "0110000010001101";
-- -0.803565
y <= "1011110100110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1003
-- 167320.076046
x <= "0110000010001101";
-- -0.573975
y <= "1011110001001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1004
-- 167320.076046
x <= "0110000010001101";
-- -0.344385
y <= "1011101011000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1005
-- 167320.076046
x <= "0110000010001101";
-- -0.114795
y <= "1011011110101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1006
-- 167320.076046
x <= "0110000010001101";
-- 0.114795
y <= "0011011110101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1007
-- 167320.076046
x <= "0110000010001101";
-- 0.344385
y <= "0011101011000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1008
-- 167320.076046
x <= "0110000010001101";
-- 0.573975
y <= "0011110001001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1009
-- 167320.076046
x <= "0110000010001101";
-- 0.803565
y <= "0011110100110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1010
-- 167320.076046
x <= "0110000010001101";
-- 1.033155
y <= "0011111000010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1011
-- 168993.276806
x <= "0110000010010100";
-- -1.032301
y <= "1011111000010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1012
-- 168993.276806
x <= "0110000010010100";
-- -0.802901
y <= "1011110100110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1013
-- 168993.276806
x <= "0110000010010100";
-- -0.573501
y <= "1011110001001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1014
-- 168993.276806
x <= "0110000010010100";
-- -0.344100
y <= "1011101011000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1015
-- 168993.276806
x <= "0110000010010100";
-- -0.114700
y <= "1011011110101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1016
-- 168993.276806
x <= "0110000010010100";
-- 0.114700
y <= "0011011110101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1017
-- 168993.276806
x <= "0110000010010100";
-- 0.344100
y <= "0011101011000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1018
-- 168993.276806
x <= "0110000010010100";
-- 0.573501
y <= "0011110001001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1019
-- 168993.276806
x <= "0110000010010100";
-- 0.802901
y <= "0011110100110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1020
-- 168993.276806
x <= "0110000010010100";
-- 1.032301
y <= "0011111000010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1021
-- 170666.477567
x <= "0110000010011010";
-- -1.031457
y <= "1011111000010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1022
-- 170666.477567
x <= "0110000010011010";
-- -0.802244
y <= "1011110100110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1023
-- 170666.477567
x <= "0110000010011010";
-- -0.573031
y <= "1011110001001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1024
-- 170666.477567
x <= "0110000010011010";
-- -0.343819
y <= "1011101011000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1025
-- 170666.477567
x <= "0110000010011010";
-- -0.114606
y <= "1011011110101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1026
-- 170666.477567
x <= "0110000010011010";
-- 0.114606
y <= "0011011110101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1027
-- 170666.477567
x <= "0110000010011010";
-- 0.343819
y <= "0011101011000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1028
-- 170666.477567
x <= "0110000010011010";
-- 0.573031
y <= "0011110001001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1029
-- 170666.477567
x <= "0110000010011010";
-- 0.802244
y <= "0011110100110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1030
-- 170666.477567
x <= "0110000010011010";
-- 1.031457
y <= "0011111000010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1031
-- 172339.678327
x <= "0110000010100001";
-- -1.030622
y <= "1011111000010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1032
-- 172339.678327
x <= "0110000010100001";
-- -0.801595
y <= "1011110100110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1033
-- 172339.678327
x <= "0110000010100001";
-- -0.572568
y <= "1011110001001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1034
-- 172339.678327
x <= "0110000010100001";
-- -0.343541
y <= "1011101011000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1035
-- 172339.678327
x <= "0110000010100001";
-- -0.114514
y <= "1011011110101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1036
-- 172339.678327
x <= "0110000010100001";
-- 0.114514
y <= "0011011110101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1037
-- 172339.678327
x <= "0110000010100001";
-- 0.343541
y <= "0011101010111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1038
-- 172339.678327
x <= "0110000010100001";
-- 0.572568
y <= "0011110001001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1039
-- 172339.678327
x <= "0110000010100001";
-- 0.801595
y <= "0011110100110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1040
-- 172339.678327
x <= "0110000010100001";
-- 1.030622
y <= "0011111000001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1041
-- 174012.879088
x <= "0110000010100111";
-- -1.029797
y <= "1011111000010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1042
-- 174012.879088
x <= "0110000010100111";
-- -0.800953
y <= "1011110100110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1043
-- 174012.879088
x <= "0110000010100111";
-- -0.572109
y <= "1011110001001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1044
-- 174012.879088
x <= "0110000010100111";
-- -0.343266
y <= "1011101011000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1045
-- 174012.879088
x <= "0110000010100111";
-- -0.114422
y <= "1011011110101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1046
-- 174012.879088
x <= "0110000010100111";
-- 0.114422
y <= "0011011110101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1047
-- 174012.879088
x <= "0110000010100111";
-- 0.343266
y <= "0011101010111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1048
-- 174012.879088
x <= "0110000010100111";
-- 0.572109
y <= "0011110001001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1049
-- 174012.879088
x <= "0110000010100111";
-- 0.800953
y <= "0011110100110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1050
-- 174012.879088
x <= "0110000010100111";
-- 1.029797
y <= "0011111000001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1051
-- 175686.079848
x <= "0110000010101110";
-- -1.028981
y <= "1011111000001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1052
-- 175686.079848
x <= "0110000010101110";
-- -0.800318
y <= "1011110100110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1053
-- 175686.079848
x <= "0110000010101110";
-- -0.571656
y <= "1011110001001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1054
-- 175686.079848
x <= "0110000010101110";
-- -0.342994
y <= "1011101010111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1055
-- 175686.079848
x <= "0110000010101110";
-- -0.114331
y <= "1011011110101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1056
-- 175686.079848
x <= "0110000010101110";
-- 0.114331
y <= "0011011110101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1057
-- 175686.079848
x <= "0110000010101110";
-- 0.342994
y <= "0011101010111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1058
-- 175686.079848
x <= "0110000010101110";
-- 0.571656
y <= "0011110001001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1059
-- 175686.079848
x <= "0110000010101110";
-- 0.800318
y <= "0011110100110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1060
-- 175686.079848
x <= "0110000010101110";
-- 1.028981
y <= "0011111000001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1061
-- 177359.280609
x <= "0110000010110100";
-- -1.028174
y <= "1011111000001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1062
-- 177359.280609
x <= "0110000010110100";
-- -0.799691
y <= "1011110100110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1063
-- 177359.280609
x <= "0110000010110100";
-- -0.571208
y <= "1011110001001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1064
-- 177359.280609
x <= "0110000010110100";
-- -0.342725
y <= "1011101010111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1065
-- 177359.280609
x <= "0110000010110100";
-- -0.114242
y <= "1011011110101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1066
-- 177359.280609
x <= "0110000010110100";
-- 0.114242
y <= "0011011110100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1067
-- 177359.280609
x <= "0110000010110100";
-- 0.342725
y <= "0011101010111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1068
-- 177359.280609
x <= "0110000010110100";
-- 0.571208
y <= "0011110001001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1069
-- 177359.280609
x <= "0110000010110100";
-- 0.799691
y <= "0011110100110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1070
-- 177359.280609
x <= "0110000010110100";
-- 1.028174
y <= "0011111000001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1071
-- 179032.481369
x <= "0110000010111011";
-- -1.027376
y <= "1011111000001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1072
-- 179032.481369
x <= "0110000010111011";
-- -0.799070
y <= "1011110100110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1073
-- 179032.481369
x <= "0110000010111011";
-- -0.570764
y <= "1011110001001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1074
-- 179032.481369
x <= "0110000010111011";
-- -0.342459
y <= "1011101010111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1075
-- 179032.481369
x <= "0110000010111011";
-- -0.114153
y <= "1011011110101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1076
-- 179032.481369
x <= "0110000010111011";
-- 0.114153
y <= "0011011110100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1077
-- 179032.481369
x <= "0110000010111011";
-- 0.342459
y <= "0011101010111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1078
-- 179032.481369
x <= "0110000010111011";
-- 0.570764
y <= "0011110001001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1079
-- 179032.481369
x <= "0110000010111011";
-- 0.799070
y <= "0011110100110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1080
-- 179032.481369
x <= "0110000010111011";
-- 1.027376
y <= "0011111000001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1081
-- 180705.682129
x <= "0110000011000001";
-- -1.026586
y <= "1011111000001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1082
-- 180705.682129
x <= "0110000011000001";
-- -0.798456
y <= "1011110100110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1083
-- 180705.682129
x <= "0110000011000001";
-- -0.570326
y <= "1011110001001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1084
-- 180705.682129
x <= "0110000011000001";
-- -0.342195
y <= "1011101010111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1085
-- 180705.682129
x <= "0110000011000001";
-- -0.114065
y <= "1011011110100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1086
-- 180705.682129
x <= "0110000011000001";
-- 0.114065
y <= "0011011110100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1087
-- 180705.682129
x <= "0110000011000001";
-- 0.342195
y <= "0011101010111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1088
-- 180705.682129
x <= "0110000011000001";
-- 0.570326
y <= "0011110001001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1089
-- 180705.682129
x <= "0110000011000001";
-- 0.798456
y <= "0011110100110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1090
-- 180705.682129
x <= "0110000011000001";
-- 1.026586
y <= "0011111000001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1091
-- 182378.882890
x <= "0110000011001000";
-- -1.025805
y <= "1011111000001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1092
-- 182378.882890
x <= "0110000011001000";
-- -0.797848
y <= "1011110100110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1093
-- 182378.882890
x <= "0110000011001000";
-- -0.569892
y <= "1011110001001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1094
-- 182378.882890
x <= "0110000011001000";
-- -0.341935
y <= "1011101010111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1095
-- 182378.882890
x <= "0110000011001000";
-- -0.113978
y <= "1011011110100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1096
-- 182378.882890
x <= "0110000011001000";
-- 0.113978
y <= "0011011110100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1097
-- 182378.882890
x <= "0110000011001000";
-- 0.341935
y <= "0011101010111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1098
-- 182378.882890
x <= "0110000011001000";
-- 0.569892
y <= "0011110001000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1099
-- 182378.882890
x <= "0110000011001000";
-- 0.797848
y <= "0011110100110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1100
-- 182378.882890
x <= "0110000011001000";
-- 1.025805
y <= "0011111000001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1101
-- 184052.083650
x <= "0110000011001110";
-- -1.025032
y <= "1011111000001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1102
-- 184052.083650
x <= "0110000011001110";
-- -0.797247
y <= "1011110100110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1103
-- 184052.083650
x <= "0110000011001110";
-- -0.569462
y <= "1011110001001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1104
-- 184052.083650
x <= "0110000011001110";
-- -0.341677
y <= "1011101010111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1105
-- 184052.083650
x <= "0110000011001110";
-- -0.113892
y <= "1011011110100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1106
-- 184052.083650
x <= "0110000011001110";
-- 0.113892
y <= "0011011110100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1107
-- 184052.083650
x <= "0110000011001110";
-- 0.341677
y <= "0011101010111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1108
-- 184052.083650
x <= "0110000011001110";
-- 0.569462
y <= "0011110001000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1109
-- 184052.083650
x <= "0110000011001110";
-- 0.797247
y <= "0011110100110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1110
-- 184052.083650
x <= "0110000011001110";
-- 1.025032
y <= "0011111000001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1111
-- 185725.284411
x <= "0110000011010101";
-- -1.024268
y <= "1011111000001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1112
-- 185725.284411
x <= "0110000011010101";
-- -0.796653
y <= "1011110100110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1113
-- 185725.284411
x <= "0110000011010101";
-- -0.569038
y <= "1011110001000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1114
-- 185725.284411
x <= "0110000011010101";
-- -0.341423
y <= "1011101010111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1115
-- 185725.284411
x <= "0110000011010101";
-- -0.113808
y <= "1011011110100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1116
-- 185725.284411
x <= "0110000011010101";
-- 0.113808
y <= "0011011110100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1117
-- 185725.284411
x <= "0110000011010101";
-- 0.341423
y <= "0011101010111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1118
-- 185725.284411
x <= "0110000011010101";
-- 0.569038
y <= "0011110001000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1119
-- 185725.284411
x <= "0110000011010101";
-- 0.796653
y <= "0011110100101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1120
-- 185725.284411
x <= "0110000011010101";
-- 1.024268
y <= "0011111000001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1121
-- 187398.485171
x <= "0110000011011100";
-- -1.023511
y <= "1011111000001101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1122
-- 187398.485171
x <= "0110000011011100";
-- -0.796064
y <= "1011110100110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1123
-- 187398.485171
x <= "0110000011011100";
-- -0.568617
y <= "1011110001000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1124
-- 187398.485171
x <= "0110000011011100";
-- -0.341170
y <= "1011101010111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1125
-- 187398.485171
x <= "0110000011011100";
-- -0.113723
y <= "1011011110100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1126
-- 187398.485171
x <= "0110000011011100";
-- 0.113723
y <= "0011011110100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1127
-- 187398.485171
x <= "0110000011011100";
-- 0.341170
y <= "0011101010111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1128
-- 187398.485171
x <= "0110000011011100";
-- 0.568617
y <= "0011110001000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1129
-- 187398.485171
x <= "0110000011011100";
-- 0.796064
y <= "0011110100101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1130
-- 187398.485171
x <= "0110000011011100";
-- 1.023511
y <= "0011111000001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1131
-- 189071.685931
x <= "0110000011100010";
-- -1.022762
y <= "1011111000001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1132
-- 189071.685931
x <= "0110000011100010";
-- -0.795482
y <= "1011110100101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1133
-- 189071.685931
x <= "0110000011100010";
-- -0.568201
y <= "1011110001000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1134
-- 189071.685931
x <= "0110000011100010";
-- -0.340921
y <= "1011101010111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1135
-- 189071.685931
x <= "0110000011100010";
-- -0.113640
y <= "1011011110100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1136
-- 189071.685931
x <= "0110000011100010";
-- 0.113640
y <= "0011011110100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1137
-- 189071.685931
x <= "0110000011100010";
-- 0.340921
y <= "0011101010111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1138
-- 189071.685931
x <= "0110000011100010";
-- 0.568201
y <= "0011110001000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1139
-- 189071.685931
x <= "0110000011100010";
-- 0.795482
y <= "0011110100101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1140
-- 189071.685931
x <= "0110000011100010";
-- 1.022762
y <= "0011111000001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1141
-- 190744.886692
x <= "0110000011101001";
-- -1.022021
y <= "1011111000001100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1142
-- 190744.886692
x <= "0110000011101001";
-- -0.794905
y <= "1011110100101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1143
-- 190744.886692
x <= "0110000011101001";
-- -0.567790
y <= "1011110001000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1144
-- 190744.886692
x <= "0110000011101001";
-- -0.340674
y <= "1011101010111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1145
-- 190744.886692
x <= "0110000011101001";
-- -0.113558
y <= "1011011110100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1146
-- 190744.886692
x <= "0110000011101001";
-- 0.113558
y <= "0011011110100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1147
-- 190744.886692
x <= "0110000011101001";
-- 0.340674
y <= "0011101010111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1148
-- 190744.886692
x <= "0110000011101001";
-- 0.567790
y <= "0011110001000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1149
-- 190744.886692
x <= "0110000011101001";
-- 0.794905
y <= "0011110100101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1150
-- 190744.886692
x <= "0110000011101001";
-- 1.022021
y <= "0011111000001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1151
-- 192418.087452
x <= "0110000011101111";
-- -1.021288
y <= "1011111000001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1152
-- 192418.087452
x <= "0110000011101111";
-- -0.794335
y <= "1011110100101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1153
-- 192418.087452
x <= "0110000011101111";
-- -0.567382
y <= "1011110001000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1154
-- 192418.087452
x <= "0110000011101111";
-- -0.340429
y <= "1011101010111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1155
-- 192418.087452
x <= "0110000011101111";
-- -0.113476
y <= "1011011110100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1156
-- 192418.087452
x <= "0110000011101111";
-- 0.113476
y <= "0011011110100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1157
-- 192418.087452
x <= "0110000011101111";
-- 0.340429
y <= "0011101010111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1158
-- 192418.087452
x <= "0110000011101111";
-- 0.567382
y <= "0011110001000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1159
-- 192418.087452
x <= "0110000011101111";
-- 0.794335
y <= "0011110100101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1160
-- 192418.087452
x <= "0110000011101111";
-- 1.021288
y <= "0011111000001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1161
-- 194091.288213
x <= "0110000011110110";
-- -1.020561
y <= "1011111000001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1162
-- 194091.288213
x <= "0110000011110110";
-- -0.793770
y <= "1011110100101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1163
-- 194091.288213
x <= "0110000011110110";
-- -0.566979
y <= "1011110001000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1164
-- 194091.288213
x <= "0110000011110110";
-- -0.340187
y <= "1011101010111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1165
-- 194091.288213
x <= "0110000011110110";
-- -0.113396
y <= "1011011110100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1166
-- 194091.288213
x <= "0110000011110110";
-- 0.113396
y <= "0011011110100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1167
-- 194091.288213
x <= "0110000011110110";
-- 0.340187
y <= "0011101010111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1168
-- 194091.288213
x <= "0110000011110110";
-- 0.566979
y <= "0011110001000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1169
-- 194091.288213
x <= "0110000011110110";
-- 0.793770
y <= "0011110100101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1170
-- 194091.288213
x <= "0110000011110110";
-- 1.020561
y <= "0011111000001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1171
-- 195764.488973
x <= "0110000011111100";
-- -1.019842
y <= "1011111000001011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1172
-- 195764.488973
x <= "0110000011111100";
-- -0.793211
y <= "1011110100101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1173
-- 195764.488973
x <= "0110000011111100";
-- -0.566579
y <= "1011110001000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1174
-- 195764.488973
x <= "0110000011111100";
-- -0.339947
y <= "1011101010111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1175
-- 195764.488973
x <= "0110000011111100";
-- -0.113316
y <= "1011011110100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1176
-- 195764.488973
x <= "0110000011111100";
-- 0.113316
y <= "0011011110100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1177
-- 195764.488973
x <= "0110000011111100";
-- 0.339947
y <= "0011101010111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1178
-- 195764.488973
x <= "0110000011111100";
-- 0.566579
y <= "0011110001000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1179
-- 195764.488973
x <= "0110000011111100";
-- 0.793211
y <= "0011110100101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1180
-- 195764.488973
x <= "0110000011111100";
-- 1.019842
y <= "0011111000001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1181
-- 197437.689734
x <= "0110000100000011";
-- -1.019131
y <= "1011111000001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1182
-- 197437.689734
x <= "0110000100000011";
-- -0.792657
y <= "1011110100101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1183
-- 197437.689734
x <= "0110000100000011";
-- -0.566184
y <= "1011110001000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1184
-- 197437.689734
x <= "0110000100000011";
-- -0.339710
y <= "1011101010111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1185
-- 197437.689734
x <= "0110000100000011";
-- -0.113237
y <= "1011011110100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1186
-- 197437.689734
x <= "0110000100000011";
-- 0.113237
y <= "0011011110011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1187
-- 197437.689734
x <= "0110000100000011";
-- 0.339710
y <= "0011101010110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1188
-- 197437.689734
x <= "0110000100000011";
-- 0.566184
y <= "0011110001000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1189
-- 197437.689734
x <= "0110000100000011";
-- 0.792657
y <= "0011110100101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1190
-- 197437.689734
x <= "0110000100000011";
-- 1.019131
y <= "0011111000001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1191
-- 199110.890494
x <= "0110000100001001";
-- -1.018426
y <= "1011111000001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1192
-- 199110.890494
x <= "0110000100001001";
-- -0.792109
y <= "1011110100101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1193
-- 199110.890494
x <= "0110000100001001";
-- -0.565792
y <= "1011110001000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1194
-- 199110.890494
x <= "0110000100001001";
-- -0.339475
y <= "1011101010111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1195
-- 199110.890494
x <= "0110000100001001";
-- -0.113158
y <= "1011011110011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1196
-- 199110.890494
x <= "0110000100001001";
-- 0.113158
y <= "0011011110011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1197
-- 199110.890494
x <= "0110000100001001";
-- 0.339475
y <= "0011101010110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1198
-- 199110.890494
x <= "0110000100001001";
-- 0.565792
y <= "0011110001000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1199
-- 199110.890494
x <= "0110000100001001";
-- 0.792109
y <= "0011110100101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1200
-- 199110.890494
x <= "0110000100001001";
-- 1.018426
y <= "0011111000001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1201
-- 200784.091254
x <= "0110000100010000";
-- -1.017728
y <= "1011111000001010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1202
-- 200784.091254
x <= "0110000100010000";
-- -0.791566
y <= "1011110100101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1203
-- 200784.091254
x <= "0110000100010000";
-- -0.565404
y <= "1011110001000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1204
-- 200784.091254
x <= "0110000100010000";
-- -0.339243
y <= "1011101010110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1205
-- 200784.091254
x <= "0110000100010000";
-- -0.113081
y <= "1011011110011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1206
-- 200784.091254
x <= "0110000100010000";
-- 0.113081
y <= "0011011110011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1207
-- 200784.091254
x <= "0110000100010000";
-- 0.339243
y <= "0011101010110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1208
-- 200784.091254
x <= "0110000100010000";
-- 0.565404
y <= "0011110001000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1209
-- 200784.091254
x <= "0110000100010000";
-- 0.791566
y <= "0011110100101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1210
-- 200784.091254
x <= "0110000100010000";
-- 1.017728
y <= "0011111000001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1211
-- 202457.292015
x <= "0110000100010110";
-- -1.017036
y <= "1011111000001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1212
-- 202457.292015
x <= "0110000100010110";
-- -0.791028
y <= "1011110100101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1213
-- 202457.292015
x <= "0110000100010110";
-- -0.565020
y <= "1011110001000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1214
-- 202457.292015
x <= "0110000100010110";
-- -0.339012
y <= "1011101010110111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1215
-- 202457.292015
x <= "0110000100010110";
-- -0.113004
y <= "1011011110011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1216
-- 202457.292015
x <= "0110000100010110";
-- 0.113004
y <= "0011011110011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1217
-- 202457.292015
x <= "0110000100010110";
-- 0.339012
y <= "0011101010110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1218
-- 202457.292015
x <= "0110000100010110";
-- 0.565020
y <= "0011110001000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1219
-- 202457.292015
x <= "0110000100010110";
-- 0.791028
y <= "0011110100101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1220
-- 202457.292015
x <= "0110000100010110";
-- 1.017036
y <= "0011111000001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1221
-- 204130.492775
x <= "0110000100011101";
-- -1.016352
y <= "1011111000001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1222
-- 204130.492775
x <= "0110000100011101";
-- -0.790496
y <= "1011110100101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1223
-- 204130.492775
x <= "0110000100011101";
-- -0.564640
y <= "1011110001000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1224
-- 204130.492775
x <= "0110000100011101";
-- -0.338784
y <= "1011101010110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1225
-- 204130.492775
x <= "0110000100011101";
-- -0.112928
y <= "1011011110011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1226
-- 204130.492775
x <= "0110000100011101";
-- 0.112928
y <= "0011011110011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1227
-- 204130.492775
x <= "0110000100011101";
-- 0.338784
y <= "0011101010110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1228
-- 204130.492775
x <= "0110000100011101";
-- 0.564640
y <= "0011110001000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1229
-- 204130.492775
x <= "0110000100011101";
-- 0.790496
y <= "0011110100101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1230
-- 204130.492775
x <= "0110000100011101";
-- 1.016352
y <= "0011111000001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1231
-- 205803.693536
x <= "0110000100100011";
-- -1.015674
y <= "1011111000001001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1232
-- 205803.693536
x <= "0110000100100011";
-- -0.789968
y <= "1011110100101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1233
-- 205803.693536
x <= "0110000100100011";
-- -0.564263
y <= "1011110001000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1234
-- 205803.693536
x <= "0110000100100011";
-- -0.338558
y <= "1011101010110110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1235
-- 205803.693536
x <= "0110000100100011";
-- -0.112853
y <= "1011011110011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1236
-- 205803.693536
x <= "0110000100100011";
-- 0.112853
y <= "0011011110011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1237
-- 205803.693536
x <= "0110000100100011";
-- 0.338558
y <= "0011101010110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1238
-- 205803.693536
x <= "0110000100100011";
-- 0.564263
y <= "0011110001000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1239
-- 205803.693536
x <= "0110000100100011";
-- 0.789968
y <= "0011110100101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1240
-- 205803.693536
x <= "0110000100100011";
-- 1.015674
y <= "0011111000001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1241
-- 207476.894296
x <= "0110000100101010";
-- -1.015002
y <= "1011111000001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1242
-- 207476.894296
x <= "0110000100101010";
-- -0.789446
y <= "1011110100101001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1243
-- 207476.894296
x <= "0110000100101010";
-- -0.563890
y <= "1011110001000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1244
-- 207476.894296
x <= "0110000100101010";
-- -0.338334
y <= "1011101010110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1245
-- 207476.894296
x <= "0110000100101010";
-- -0.112778
y <= "1011011110011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1246
-- 207476.894296
x <= "0110000100101010";
-- 0.112778
y <= "0011011110011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1247
-- 207476.894296
x <= "0110000100101010";
-- 0.338334
y <= "0011101010110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1248
-- 207476.894296
x <= "0110000100101010";
-- 0.563890
y <= "0011110001000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1249
-- 207476.894296
x <= "0110000100101010";
-- 0.789446
y <= "0011110100101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1250
-- 207476.894296
x <= "0110000100101010";
-- 1.015002
y <= "0011111000000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1251
-- 209150.095057
x <= "0110000100110000";
-- -1.014336
y <= "1011111000001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1252
-- 209150.095057
x <= "0110000100110000";
-- -0.788928
y <= "1011110100101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1253
-- 209150.095057
x <= "0110000100110000";
-- -0.563520
y <= "1011110001000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1254
-- 209150.095057
x <= "0110000100110000";
-- -0.338112
y <= "1011101010110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1255
-- 209150.095057
x <= "0110000100110000";
-- -0.112704
y <= "1011011110011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1256
-- 209150.095057
x <= "0110000100110000";
-- 0.112704
y <= "0011011110011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1257
-- 209150.095057
x <= "0110000100110000";
-- 0.338112
y <= "0011101010110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1258
-- 209150.095057
x <= "0110000100110000";
-- 0.563520
y <= "0011110001000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1259
-- 209150.095057
x <= "0110000100110000";
-- 0.788928
y <= "0011110100100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1260
-- 209150.095057
x <= "0110000100110000";
-- 1.014336
y <= "0011111000000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1261
-- 210823.295817
x <= "0110000100110111";
-- -1.013677
y <= "1011111000001000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1262
-- 210823.295817
x <= "0110000100110111";
-- -0.788416
y <= "1011110100101000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1263
-- 210823.295817
x <= "0110000100110111";
-- -0.563154
y <= "1011110001000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1264
-- 210823.295817
x <= "0110000100110111";
-- -0.337892
y <= "1011101010110101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1265
-- 210823.295817
x <= "0110000100110111";
-- -0.112631
y <= "1011011110011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1266
-- 210823.295817
x <= "0110000100110111";
-- 0.112631
y <= "0011011110011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1267
-- 210823.295817
x <= "0110000100110111";
-- 0.337892
y <= "0011101010110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1268
-- 210823.295817
x <= "0110000100110111";
-- 0.563154
y <= "0011110001000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1269
-- 210823.295817
x <= "0110000100110111";
-- 0.788416
y <= "0011110100100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1270
-- 210823.295817
x <= "0110000100110111";
-- 1.013677
y <= "0011111000000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1271
-- 212496.496577
x <= "0110000100111110";
-- -1.013024
y <= "1011111000000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1272
-- 212496.496577
x <= "0110000100111110";
-- -0.787907
y <= "1011110100100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1273
-- 212496.496577
x <= "0110000100111110";
-- -0.562791
y <= "1011110001000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1274
-- 212496.496577
x <= "0110000100111110";
-- -0.337675
y <= "1011101010110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1275
-- 212496.496577
x <= "0110000100111110";
-- -0.112558
y <= "1011011110011011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1276
-- 212496.496577
x <= "0110000100111110";
-- 0.112558
y <= "0011011110011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1277
-- 212496.496577
x <= "0110000100111110";
-- 0.337675
y <= "0011101010110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1278
-- 212496.496577
x <= "0110000100111110";
-- 0.562791
y <= "0011110001000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1279
-- 212496.496577
x <= "0110000100111110";
-- 0.787907
y <= "0011110100100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1280
-- 212496.496577
x <= "0110000100111110";
-- 1.013024
y <= "0011111000000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1281
-- 214169.697338
x <= "0110000101000100";
-- -1.012377
y <= "1011111000000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1282
-- 214169.697338
x <= "0110000101000100";
-- -0.787404
y <= "1011110100100111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1283
-- 214169.697338
x <= "0110000101000100";
-- -0.562431
y <= "1011110001000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1284
-- 214169.697338
x <= "0110000101000100";
-- -0.337459
y <= "1011101010110100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1285
-- 214169.697338
x <= "0110000101000100";
-- -0.112486
y <= "1011011110011010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1286
-- 214169.697338
x <= "0110000101000100";
-- 0.112486
y <= "0011011110011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1287
-- 214169.697338
x <= "0110000101000100";
-- 0.337459
y <= "0011101010110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1288
-- 214169.697338
x <= "0110000101000100";
-- 0.562431
y <= "0011110000111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1289
-- 214169.697338
x <= "0110000101000100";
-- 0.787404
y <= "0011110100100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1290
-- 214169.697338
x <= "0110000101000100";
-- 1.012377
y <= "0011111000000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1291
-- 215842.898098
x <= "0110000101001011";
-- -1.011735
y <= "1011111000000111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1292
-- 215842.898098
x <= "0110000101001011";
-- -0.786905
y <= "1011110100100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1293
-- 215842.898098
x <= "0110000101001011";
-- -0.562075
y <= "1011110001000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1294
-- 215842.898098
x <= "0110000101001011";
-- -0.337245
y <= "1011101010110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1295
-- 215842.898098
x <= "0110000101001011";
-- -0.112415
y <= "1011011110011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1296
-- 215842.898098
x <= "0110000101001011";
-- 0.112415
y <= "0011011110011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1297
-- 215842.898098
x <= "0110000101001011";
-- 0.337245
y <= "0011101010110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1298
-- 215842.898098
x <= "0110000101001011";
-- 0.562075
y <= "0011110000111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1299
-- 215842.898098
x <= "0110000101001011";
-- 0.786905
y <= "0011110100100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1300
-- 215842.898098
x <= "0110000101001011";
-- 1.011735
y <= "0011111000000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1301
-- 217516.098859
x <= "0110000101010001";
-- -1.011099
y <= "1011111000000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1302
-- 217516.098859
x <= "0110000101010001";
-- -0.786411
y <= "1011110100100110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1303
-- 217516.098859
x <= "0110000101010001";
-- -0.561722
y <= "1011110001000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1304
-- 217516.098859
x <= "0110000101010001";
-- -0.337033
y <= "1011101010110011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1305
-- 217516.098859
x <= "0110000101010001";
-- -0.112344
y <= "1011011110011001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1306
-- 217516.098859
x <= "0110000101010001";
-- 0.112344
y <= "0011011110011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1307
-- 217516.098859
x <= "0110000101010001";
-- 0.337033
y <= "0011101010110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1308
-- 217516.098859
x <= "0110000101010001";
-- 0.561722
y <= "0011110000111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1309
-- 217516.098859
x <= "0110000101010001";
-- 0.786411
y <= "0011110100100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1310
-- 217516.098859
x <= "0110000101010001";
-- 1.011099
y <= "0011111000000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1311
-- 219189.299619
x <= "0110000101011000";
-- -1.010469
y <= "1011111000000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1312
-- 219189.299619
x <= "0110000101011000";
-- -0.785921
y <= "1011110100100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1313
-- 219189.299619
x <= "0110000101011000";
-- -0.561372
y <= "1011110000111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1314
-- 219189.299619
x <= "0110000101011000";
-- -0.336823
y <= "1011101010110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1315
-- 219189.299619
x <= "0110000101011000";
-- -0.112274
y <= "1011011110011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1316
-- 219189.299619
x <= "0110000101011000";
-- 0.112274
y <= "0011011110010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1317
-- 219189.299619
x <= "0110000101011000";
-- 0.336823
y <= "0011101010110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1318
-- 219189.299619
x <= "0110000101011000";
-- 0.561372
y <= "0011110000111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1319
-- 219189.299619
x <= "0110000101011000";
-- 0.785921
y <= "0011110100100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1320
-- 219189.299619
x <= "0110000101011000";
-- 1.010469
y <= "0011111000000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1321
-- 220862.500379
x <= "0110000101011110";
-- -1.009845
y <= "1011111000000110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1322
-- 220862.500379
x <= "0110000101011110";
-- -0.785435
y <= "1011110100100101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1323
-- 220862.500379
x <= "0110000101011110";
-- -0.561025
y <= "1011110000111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1324
-- 220862.500379
x <= "0110000101011110";
-- -0.336615
y <= "1011101010110010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1325
-- 220862.500379
x <= "0110000101011110";
-- -0.112205
y <= "1011011110011000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1326
-- 220862.500379
x <= "0110000101011110";
-- 0.112205
y <= "0011011110010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1327
-- 220862.500379
x <= "0110000101011110";
-- 0.336615
y <= "0011101010110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1328
-- 220862.500379
x <= "0110000101011110";
-- 0.561025
y <= "0011110000111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1329
-- 220862.500379
x <= "0110000101011110";
-- 0.785435
y <= "0011110100100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1330
-- 220862.500379
x <= "0110000101011110";
-- 1.009845
y <= "0011111000000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1331
-- 222535.701140
x <= "0110000101100101";
-- -1.009226
y <= "1011111000000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1332
-- 222535.701140
x <= "0110000101100101";
-- -0.784953
y <= "1011110100100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1333
-- 222535.701140
x <= "0110000101100101";
-- -0.560681
y <= "1011110000111111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1334
-- 222535.701140
x <= "0110000101100101";
-- -0.336409
y <= "1011101010110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1335
-- 222535.701140
x <= "0110000101100101";
-- -0.112136
y <= "1011011110010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1336
-- 222535.701140
x <= "0110000101100101";
-- 0.112136
y <= "0011011110010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1337
-- 222535.701140
x <= "0110000101100101";
-- 0.336409
y <= "0011101010110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1338
-- 222535.701140
x <= "0110000101100101";
-- 0.560681
y <= "0011110000111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1339
-- 222535.701140
x <= "0110000101100101";
-- 0.784953
y <= "0011110100100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1340
-- 222535.701140
x <= "0110000101100101";
-- 1.009226
y <= "0011111000000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1341
-- 224208.901900
x <= "0110000101101011";
-- -1.008612
y <= "1011111000000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1342
-- 224208.901900
x <= "0110000101101011";
-- -0.784476
y <= "1011110100100100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1343
-- 224208.901900
x <= "0110000101101011";
-- -0.560340
y <= "1011110000111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1344
-- 224208.901900
x <= "0110000101101011";
-- -0.336204
y <= "1011101010110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1345
-- 224208.901900
x <= "0110000101101011";
-- -0.112068
y <= "1011011110010111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1346
-- 224208.901900
x <= "0110000101101011";
-- 0.112068
y <= "0011011110010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1347
-- 224208.901900
x <= "0110000101101011";
-- 0.336204
y <= "0011101010110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1348
-- 224208.901900
x <= "0110000101101011";
-- 0.560340
y <= "0011110000111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1349
-- 224208.901900
x <= "0110000101101011";
-- 0.784476
y <= "0011110100100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1350
-- 224208.901900
x <= "0110000101101011";
-- 1.008612
y <= "0011111000000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1351
-- 225882.102661
x <= "0110000101110010";
-- -1.008004
y <= "1011111000000101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1352
-- 225882.102661
x <= "0110000101110010";
-- -0.784003
y <= "1011110100100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1353
-- 225882.102661
x <= "0110000101110010";
-- -0.560002
y <= "1011110000111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1354
-- 225882.102661
x <= "0110000101110010";
-- -0.336001
y <= "1011101010110001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1355
-- 225882.102661
x <= "0110000101110010";
-- -0.112000
y <= "1011011110010110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1356
-- 225882.102661
x <= "0110000101110010";
-- 0.112000
y <= "0011011110010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1357
-- 225882.102661
x <= "0110000101110010";
-- 0.336001
y <= "0011101010110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1358
-- 225882.102661
x <= "0110000101110010";
-- 0.560002
y <= "0011110000111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1359
-- 225882.102661
x <= "0110000101110010";
-- 0.784003
y <= "0011110100100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1360
-- 225882.102661
x <= "0110000101110010";
-- 1.008004
y <= "0011111000000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1361
-- 227555.303421
x <= "0110000101111000";
-- -1.007401
y <= "1011111000000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1362
-- 227555.303421
x <= "0110000101111000";
-- -0.783534
y <= "1011110100100011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1363
-- 227555.303421
x <= "0110000101111000";
-- -0.559667
y <= "1011110000111110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1364
-- 227555.303421
x <= "0110000101111000";
-- -0.335800
y <= "1011101010110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1365
-- 227555.303421
x <= "0110000101111000";
-- -0.111933
y <= "1011011110010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1366
-- 227555.303421
x <= "0110000101111000";
-- 0.111933
y <= "0011011110010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1367
-- 227555.303421
x <= "0110000101111000";
-- 0.335800
y <= "0011101010101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1368
-- 227555.303421
x <= "0110000101111000";
-- 0.559667
y <= "0011110000111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1369
-- 227555.303421
x <= "0110000101111000";
-- 0.783534
y <= "0011110100100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1370
-- 227555.303421
x <= "0110000101111000";
-- 1.007401
y <= "0011111000000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1371
-- 229228.504182
x <= "0110000101111111";
-- -1.006803
y <= "1011111000000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1372
-- 229228.504182
x <= "0110000101111111";
-- -0.783069
y <= "1011110100100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1373
-- 229228.504182
x <= "0110000101111111";
-- -0.559335
y <= "1011110000111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1374
-- 229228.504182
x <= "0110000101111111";
-- -0.335601
y <= "1011101010110000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1375
-- 229228.504182
x <= "0110000101111111";
-- -0.111867
y <= "1011011110010101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1376
-- 229228.504182
x <= "0110000101111111";
-- 0.111867
y <= "0011011110010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1377
-- 229228.504182
x <= "0110000101111111";
-- 0.335601
y <= "0011101010101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1378
-- 229228.504182
x <= "0110000101111111";
-- 0.559335
y <= "0011110000111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1379
-- 229228.504182
x <= "0110000101111111";
-- 0.783069
y <= "0011110100100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1380
-- 229228.504182
x <= "0110000101111111";
-- 1.006803
y <= "0011111000000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1381
-- 230901.704942
x <= "0110000110000101";
-- -1.006210
y <= "1011111000000100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1382
-- 230901.704942
x <= "0110000110000101";
-- -0.782608
y <= "1011110100100010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1383
-- 230901.704942
x <= "0110000110000101";
-- -0.559006
y <= "1011110000111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1384
-- 230901.704942
x <= "0110000110000101";
-- -0.335403
y <= "1011101010101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1385
-- 230901.704942
x <= "0110000110000101";
-- -0.111801
y <= "1011011110010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1386
-- 230901.704942
x <= "0110000110000101";
-- 0.111801
y <= "0011011110010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1387
-- 230901.704942
x <= "0110000110000101";
-- 0.335403
y <= "0011101010101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1388
-- 230901.704942
x <= "0110000110000101";
-- 0.559006
y <= "0011110000111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1389
-- 230901.704942
x <= "0110000110000101";
-- 0.782608
y <= "0011110100100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1390
-- 230901.704942
x <= "0110000110000101";
-- 1.006210
y <= "0011111000000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1391
-- 232574.905702
x <= "0110000110001100";
-- -1.005622
y <= "1011111000000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1392
-- 232574.905702
x <= "0110000110001100";
-- -0.782151
y <= "1011110100100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1393
-- 232574.905702
x <= "0110000110001100";
-- -0.558679
y <= "1011110000111101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1394
-- 232574.905702
x <= "0110000110001100";
-- -0.335207
y <= "1011101010101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1395
-- 232574.905702
x <= "0110000110001100";
-- -0.111736
y <= "1011011110010100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1396
-- 232574.905702
x <= "0110000110001100";
-- 0.111736
y <= "0011011110010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1397
-- 232574.905702
x <= "0110000110001100";
-- 0.335207
y <= "0011101010101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1398
-- 232574.905702
x <= "0110000110001100";
-- 0.558679
y <= "0011110000111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1399
-- 232574.905702
x <= "0110000110001100";
-- 0.782151
y <= "0011110100100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1400
-- 232574.905702
x <= "0110000110001100";
-- 1.005622
y <= "0011111000000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1401
-- 234248.106463
x <= "0110000110010011";
-- -1.005039
y <= "1011111000000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1402
-- 234248.106463
x <= "0110000110010011";
-- -0.781697
y <= "1011110100100001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1403
-- 234248.106463
x <= "0110000110010011";
-- -0.558355
y <= "1011110000111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1404
-- 234248.106463
x <= "0110000110010011";
-- -0.335013
y <= "1011101010101111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1405
-- 234248.106463
x <= "0110000110010011";
-- -0.111671
y <= "1011011110010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1406
-- 234248.106463
x <= "0110000110010011";
-- 0.111671
y <= "0011011110010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1407
-- 234248.106463
x <= "0110000110010011";
-- 0.335013
y <= "0011101010101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1408
-- 234248.106463
x <= "0110000110010011";
-- 0.558355
y <= "0011110000111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1409
-- 234248.106463
x <= "0110000110010011";
-- 0.781697
y <= "0011110100100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1410
-- 234248.106463
x <= "0110000110010011";
-- 1.005039
y <= "0011111000000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1411
-- 235921.307223
x <= "0110000110011001";
-- -1.004461
y <= "1011111000000011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1412
-- 235921.307223
x <= "0110000110011001";
-- -0.781247
y <= "1011110100100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1413
-- 235921.307223
x <= "0110000110011001";
-- -0.558034
y <= "1011110000111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1414
-- 235921.307223
x <= "0110000110011001";
-- -0.334820
y <= "1011101010101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1415
-- 235921.307223
x <= "0110000110011001";
-- -0.111607
y <= "1011011110010011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1416
-- 235921.307223
x <= "0110000110011001";
-- 0.111607
y <= "0011011110010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1417
-- 235921.307223
x <= "0110000110011001";
-- 0.334820
y <= "0011101010101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1418
-- 235921.307223
x <= "0110000110011001";
-- 0.558034
y <= "0011110000111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1419
-- 235921.307223
x <= "0110000110011001";
-- 0.781247
y <= "0011110100011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1420
-- 235921.307223
x <= "0110000110011001";
-- 1.004461
y <= "0011111000000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1421
-- 237594.507984
x <= "0110000110100000";
-- -1.003887
y <= "1011111000000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1422
-- 237594.507984
x <= "0110000110100000";
-- -0.780801
y <= "1011110100100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1423
-- 237594.507984
x <= "0110000110100000";
-- -0.557715
y <= "1011110000111100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1424
-- 237594.507984
x <= "0110000110100000";
-- -0.334629
y <= "1011101010101110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1425
-- 237594.507984
x <= "0110000110100000";
-- -0.111543
y <= "1011011110010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1426
-- 237594.507984
x <= "0110000110100000";
-- 0.111543
y <= "0011011110010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1427
-- 237594.507984
x <= "0110000110100000";
-- 0.334629
y <= "0011101010101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1428
-- 237594.507984
x <= "0110000110100000";
-- 0.557715
y <= "0011110000111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1429
-- 237594.507984
x <= "0110000110100000";
-- 0.780801
y <= "0011110100011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1430
-- 237594.507984
x <= "0110000110100000";
-- 1.003887
y <= "0011111000000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1431
-- 239267.708744
x <= "0110000110100110";
-- -1.003319
y <= "1011111000000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1432
-- 239267.708744
x <= "0110000110100110";
-- -0.780359
y <= "1011110100100000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1433
-- 239267.708744
x <= "0110000110100110";
-- -0.557399
y <= "1011110000111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1434
-- 239267.708744
x <= "0110000110100110";
-- -0.334440
y <= "1011101010101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1435
-- 239267.708744
x <= "0110000110100110";
-- -0.111480
y <= "1011011110010010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1436
-- 239267.708744
x <= "0110000110100110";
-- 0.111480
y <= "0011011110010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1437
-- 239267.708744
x <= "0110000110100110";
-- 0.334440
y <= "0011101010101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1438
-- 239267.708744
x <= "0110000110100110";
-- 0.557399
y <= "0011110000111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1439
-- 239267.708744
x <= "0110000110100110";
-- 0.780359
y <= "0011110100011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1440
-- 239267.708744
x <= "0110000110100110";
-- 1.003319
y <= "0011111000000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1441
-- 240940.909504
x <= "0110000110101101";
-- -1.002754
y <= "1011111000000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1442
-- 240940.909504
x <= "0110000110101101";
-- -0.779920
y <= "1011110100011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1443
-- 240940.909504
x <= "0110000110101101";
-- -0.557086
y <= "1011110000111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1444
-- 240940.909504
x <= "0110000110101101";
-- -0.334251
y <= "1011101010101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1445
-- 240940.909504
x <= "0110000110101101";
-- -0.111417
y <= "1011011110010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1446
-- 240940.909504
x <= "0110000110101101";
-- 0.111417
y <= "0011011110010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1447
-- 240940.909504
x <= "0110000110101101";
-- 0.334251
y <= "0011101010101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1448
-- 240940.909504
x <= "0110000110101101";
-- 0.557086
y <= "0011110000111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1449
-- 240940.909504
x <= "0110000110101101";
-- 0.779920
y <= "0011110100011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1450
-- 240940.909504
x <= "0110000110101101";
-- 1.002754
y <= "0011111000000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1451
-- 242614.110265
x <= "0110000110110011";
-- -1.002195
y <= "1011111000000010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1452
-- 242614.110265
x <= "0110000110110011";
-- -0.779485
y <= "1011110100011111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1453
-- 242614.110265
x <= "0110000110110011";
-- -0.556775
y <= "1011110000111011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1454
-- 242614.110265
x <= "0110000110110011";
-- -0.334065
y <= "1011101010101101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1455
-- 242614.110265
x <= "0110000110110011";
-- -0.111355
y <= "1011011110010001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1456
-- 242614.110265
x <= "0110000110110011";
-- 0.111355
y <= "0011011110010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1457
-- 242614.110265
x <= "0110000110110011";
-- 0.334065
y <= "0011101010101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1458
-- 242614.110265
x <= "0110000110110011";
-- 0.556775
y <= "0011110000111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1459
-- 242614.110265
x <= "0110000110110011";
-- 0.779485
y <= "0011110100011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1460
-- 242614.110265
x <= "0110000110110011";
-- 1.002195
y <= "0011111000000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1461
-- 244287.311025
x <= "0110000110111010";
-- -1.001639
y <= "1011111000000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1462
-- 244287.311025
x <= "0110000110111010";
-- -0.779053
y <= "1011110100011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1463
-- 244287.311025
x <= "0110000110111010";
-- -0.556466
y <= "1011110000111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1464
-- 244287.311025
x <= "0110000110111010";
-- -0.333880
y <= "1011101010101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1465
-- 244287.311025
x <= "0110000110111010";
-- -0.111293
y <= "1011011110010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1466
-- 244287.311025
x <= "0110000110111010";
-- 0.111293
y <= "0011011110001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1467
-- 244287.311025
x <= "0110000110111010";
-- 0.333880
y <= "0011101010101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1468
-- 244287.311025
x <= "0110000110111010";
-- 0.556466
y <= "0011110000111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1469
-- 244287.311025
x <= "0110000110111010";
-- 0.779053
y <= "0011110100011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1470
-- 244287.311025
x <= "0110000110111010";
-- 1.001639
y <= "0011111000000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1471
-- 245960.511786
x <= "0110000111000000";
-- -1.001089
y <= "1011111000000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1472
-- 245960.511786
x <= "0110000111000000";
-- -0.778625
y <= "1011110100011110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1473
-- 245960.511786
x <= "0110000111000000";
-- -0.556160
y <= "1011110000111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1474
-- 245960.511786
x <= "0110000111000000";
-- -0.333696
y <= "1011101010101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1475
-- 245960.511786
x <= "0110000111000000";
-- -0.111232
y <= "1011011110010000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1476
-- 245960.511786
x <= "0110000111000000";
-- 0.111232
y <= "0011011110001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1477
-- 245960.511786
x <= "0110000111000000";
-- 0.333696
y <= "0011101010101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1478
-- 245960.511786
x <= "0110000111000000";
-- 0.556160
y <= "0011110000111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1479
-- 245960.511786
x <= "0110000111000000";
-- 0.778625
y <= "0011110100011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1480
-- 245960.511786
x <= "0110000111000000";
-- 1.001089
y <= "0011111000000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1481
-- 247633.712546
x <= "0110000111000111";
-- -1.000542
y <= "1011111000000001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1482
-- 247633.712546
x <= "0110000111000111";
-- -0.778199
y <= "1011110100011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1483
-- 247633.712546
x <= "0110000111000111";
-- -0.555857
y <= "1011110000111010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1484
-- 247633.712546
x <= "0110000111000111";
-- -0.333514
y <= "1011101010101100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1485
-- 247633.712546
x <= "0110000111000111";
-- -0.111171
y <= "1011011110001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1486
-- 247633.712546
x <= "0110000111000111";
-- 0.111171
y <= "0011011110001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1487
-- 247633.712546
x <= "0110000111000111";
-- 0.333514
y <= "0011101010101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1488
-- 247633.712546
x <= "0110000111000111";
-- 0.555857
y <= "0011110000111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1489
-- 247633.712546
x <= "0110000111000111";
-- 0.778199
y <= "0011110100011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1490
-- 247633.712546
x <= "0110000111000111";
-- 1.000542
y <= "0011111000000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1491
-- 249306.913307
x <= "0110000111001101";
-- -1.000000
y <= "1011111000000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1492
-- 249306.913307
x <= "0110000111001101";
-- -0.777778
y <= "1011110100011101";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1493
-- 249306.913307
x <= "0110000111001101";
-- -0.555556
y <= "1011110000111001";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1494
-- 249306.913307
x <= "0110000111001101";
-- -0.333333
y <= "1011101010101011";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1495
-- 249306.913307
x <= "0110000111001101";
-- -0.111111
y <= "1011011110001111";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1496
-- 249306.913307
x <= "0110000111001101";
-- 0.111111
y <= "0011011110001110";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1497
-- 249306.913307
x <= "0110000111001101";
-- 0.333333
y <= "0011101010101010";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1498
-- 249306.913307
x <= "0110000111001101";
-- 0.555556
y <= "0011110000111000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1499
-- 249306.913307
x <= "0110000111001101";
-- 0.777778
y <= "0011110100011100";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

-- Iteration 1500
-- 249306.913307
x <= "0110000111001101";
-- 1.000000
y <= "0011111000000000";
start <= '1'; wait for 2 ns; start <= '0'; wait for 500 ns;
write(L1, output);
writeline(test_out_data1,L1);

stop(0);
end process;
end Behavioral;
