library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use std.textio.all;
use ieee.std_logic_textio.all;
library std;
use std.env.all;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity FloP_FullCORDIC_Generic_tb is
end FloP_FullCORDIC_Generic_tb;

architecture Behavioral of FloP_FullCORDIC_Generic_tb is
	component FloP_FullCORDIC_Generic is
	Generic ( fileName1 : string := "64BitExpandedLUT.txt"; fileName2 : string := "64BitLUT.txt"; 
		expWidth : integer := 11; fracWidth : integer := 52; iterWidth : integer := 6 );
	Port ( clk, start, mode : in STD_LOGIC;
		N, M : in STD_LOGIC_VECTOR (iterWidth-1 downto 0);
		x0,y0,z0 : in STD_LOGIC_VECTOR (expWidth+fracWidth downto 0);
		xOut,yOut,zOut : out STD_LOGIC_VECTOR (expWidth+fracWidth downto 0);
		done : out STD_LOGIC );
	end component;

	constant fileName1 : string := "64BitExpandedLUT.txt";
	constant fileName2 : string := "64BitLUT.txt";
	constant expWidth : integer := 11;
	constant fracWidth : integer := 52;
	constant iterWidth : integer := 6;
	signal clk_tb, start_tb, mode_tb, done : std_logic;
	signal x0, y0, z0, xn, yn, zn : std_logic_vector (expWidth+fracWidth downto 0);
	signal N, M : std_logic_vector (iterWidth-1 downto 0);

	begin

	myCORDIC : FloP_FullCORDIC_Generic Generic Map(fileName1 => fileName1, fileName2 => fileName2,
		expWidth => expWidth, fracWidth => fracWidth, iterWidth => iterWidth)
		Port Map(clk_tb, start_tb, mode_tb, N, M, x0, y0, z0, xn, yn, zn, done);

	clock : process begin
		clk_tb <= '0'; wait for 1 ns;
		clk_tb <= '1'; wait for 1 ns;
	end process;

	testProc : process
		FILE test_out_data1: TEXT open WRITE_MODE is "52iterations64bits_cosh.txt";
		FILE test_out_data2: TEXT open WRITE_MODE is "52iterations64bits_sinh.txt";
		variable L1              : LINE;
		variable L2              : LINE;

	begin

--------------------------Rotation Mode Tests-----------------------------

		-- Using N = "52"
		N <= "110100"; M <= "000101"; mode_tb <= '0';
		-- The main pieces that need to be in place to get nonscaled, separated values of Cosh and Sinh.
		x0 <= "0100000010011111000000110110100101111011011000101000100000010001";
		-- y0 := 0
		y0 <= "0000000000000000000000000000000000000000000000000000000000000000";


		--z0 := -12.426440
		z0 <= "1100000000101000110110100101011001010111111110110110100110011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.401562
		z0 <= "1100000000101000110011011001100110010000111100110111101001001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.376684
		z0 <= "1100000000101000110000001101110011001001111010111000101011111111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.351807
		z0 <= "1100000000101000101101000010000000000010111000111001101110110011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.326929
		z0 <= "1100000000101000101001110110001100111011110110111010110001100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.302051
		z0 <= "1100000000101000100110101010011001110100110100111011110100011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.277173
		z0 <= "1100000000101000100011011110100110101101110010111100110111001110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.252296
		z0 <= "1100000000101000100000010010110011100110110000111101111010000001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.227418
		z0 <= "1100000000101000011101000111000000011111101110111110111100110101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.202540
		z0 <= "1100000000101000011001111011001101011000101100111111111111101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.177662
		z0 <= "1100000000101000010110101111011010010001101011000001000010011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.152785
		z0 <= "1100000000101000010011100011100111001010101001000010000101001111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.127907
		z0 <= "1100000000101000010000010111110100000011100111000011001000000011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.103029
		z0 <= "1100000000101000001101001100000000111100100101000100001010110111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.078151
		z0 <= "1100000000101000001010000000001101110101100011000101001101101010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.053274
		z0 <= "1100000000101000000110110100011010101110100001000110010000011110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.028396
		z0 <= "1100000000101000000011101000100111100111011111000111010011010001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -12.003518
		z0 <= "1100000000101000000000011100110100100000011101001000010110000101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.978640
		z0 <= "1100000000100111111101010001000001011001011011001001011000111001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.953763
		z0 <= "1100000000100111111010000101001110010010011001001010011011101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.928885
		z0 <= "1100000000100111110110111001011011001011010111001011011110100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.904007
		z0 <= "1100000000100111110011101101101000000100010101001100100001010011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.879129
		z0 <= "1100000000100111110000100001110100111101010011001101100100000111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.854252
		z0 <= "1100000000100111101101010110000001110110010001001110100110111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.829374
		z0 <= "1100000000100111101010001010001110101111001111001111101001101110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.804496
		z0 <= "1100000000100111100110111110011011101000001101010000101100100010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.779618
		z0 <= "1100000000100111100011110010101000100001001011010001101111010101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.754741
		z0 <= "1100000000100111100000100110110101011010001001010010110010001001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.729863
		z0 <= "1100000000100111011101011011000010010011000111010011110100111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.704985
		z0 <= "1100000000100111011010001111001111001100000101010100110111110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.680107
		z0 <= "1100000000100111010111000011011100000101000011010101111010100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.655230
		z0 <= "1100000000100111010011110111101000111110000001010110111101010111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.630352
		z0 <= "1100000000100111010000101011110101110110111111011000000000001011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.605474
		z0 <= "1100000000100111001101100000000010101111111101011001000010111110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.580596
		z0 <= "1100000000100111001010010100001111101000111011011010000101110010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.555718
		z0 <= "1100000000100111000111001000011100100001111001011011001000100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.530841
		z0 <= "1100000000100111000011111100101001011010110111011100001011011001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.505963
		z0 <= "1100000000100111000000110000110110010011110101011101001110001101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.481085
		z0 <= "1100000000100110111101100101000011001100110011011110010001000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.456207
		z0 <= "1100000000100110111010011001010000000101110001011111010011110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.431330
		z0 <= "1100000000100110110111001101011100111110101111100000010110101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.406452
		z0 <= "1100000000100110110100000001101001110111101101100001011001011011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.381574
		z0 <= "1100000000100110110000110101110110110000101011100010011100001111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.356696
		z0 <= "1100000000100110101101101010000011101001101001100011011111000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.331819
		z0 <= "1100000000100110101010011110010000100010100111100100100001110110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.306941
		z0 <= "1100000000100110100111010010011101011011100101100101100100101001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.282063
		z0 <= "1100000000100110100100000110101010010100100011100110100111011101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.257185
		z0 <= "1100000000100110100000111010110111001101100001100111101010010001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.232308
		z0 <= "1100000000100110011101101111000100000110011111101000101101000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.207430
		z0 <= "1100000000100110011010100011010000111111011101101001101111111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.182552
		z0 <= "1100000000100110010111010111011101111000011011101010110010101011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.157674
		z0 <= "1100000000100110010100001011101010110001011001101011110101011111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.132797
		z0 <= "1100000000100110010000111111110111101010010111101100111000010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.107919
		z0 <= "1100000000100110001101110100000100100011010101101101111011000110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.083041
		z0 <= "1100000000100110001010101000010001011100010011101110111101111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.058163
		z0 <= "1100000000100110000111011100011110010101010001110000000000101101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.033286
		z0 <= "1100000000100110000100010000101011001110001111110001000011100001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -11.008408
		z0 <= "1100000000100110000001000100111000000111001101110010000110010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.983530
		z0 <= "1100000000100101111101111001000101000000001011110011001001001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.958652
		z0 <= "1100000000100101111010101101010001111001001001110100001011111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.933775
		z0 <= "1100000000100101110111100001011110110010000111110101001110101111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.908897
		z0 <= "1100000000100101110100010101101011101011000101110110010001100011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.884019
		z0 <= "1100000000100101110001001001111000100100000011110111010100010110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.859141
		z0 <= "1100000000100101101101111110000101011101000001111000010111001010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.834264
		z0 <= "1100000000100101101010110010010010010101111111111001011001111110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.809386
		z0 <= "1100000000100101100111100110011111001110111101111010011100110001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.784508
		z0 <= "1100000000100101100100011010101100000111111011111011011111100101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.759630
		z0 <= "1100000000100101100001001110111001000000111001111100100010011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.734752
		z0 <= "1100000000100101011110000011000101111001110111111101100101001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.709875
		z0 <= "1100000000100101011010110111010010110010110101111110101000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.684997
		z0 <= "1100000000100101010111101011011111101011110011111111101010110011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.660119
		z0 <= "1100000000100101010100011111101100100100110010000000101101100111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.635241
		z0 <= "1100000000100101010001010011111001011101110000000001110000011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.610364
		z0 <= "1100000000100101001110001000000110010110101110000010110011001110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.585486
		z0 <= "1100000000100101001010111100010011001111101100000011110110000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.560608
		z0 <= "1100000000100101000111110000100000001000101010000100111000110101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.535730
		z0 <= "1100000000100101000100100100101101000001101000000101111011101001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.510853
		z0 <= "1100000000100101000001011000111001111010100110000110111110011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.485975
		z0 <= "1100000000100100111110001101000110110011100100001000000001010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.461097
		z0 <= "1100000000100100111011000001010011101100100010001001000100000011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.436219
		z0 <= "1100000000100100110111110101100000100101100000001010000110110111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.411342
		z0 <= "1100000000100100110100101001101101011110011110001011001001101011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.386464
		z0 <= "1100000000100100110001011101111010010111011100001100001100011110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.361586
		z0 <= "1100000000100100101110010010000111010000011010001101001111010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.336708
		z0 <= "1100000000100100101011000110010100001001011000001110010010000101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.311831
		z0 <= "1100000000100100100111111010100001000010010110001111010100111001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.286953
		z0 <= "1100000000100100100100101110101101111011010100010000010111101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.262075
		z0 <= "1100000000100100100001100010111010110100010010010001011010100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.237197
		z0 <= "1100000000100100011110010111000111101101010000010010011101010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.212320
		z0 <= "1100000000100100011011001011010100100110001110010011100000000111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.187442
		z0 <= "1100000000100100010111111111100001011111001100010100100010111011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.162564
		z0 <= "1100000000100100010100110011101110011000001010010101100101101110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.137686
		z0 <= "1100000000100100010001100111111011010001001000010110101000100010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.112809
		z0 <= "1100000000100100001110011100001000001010000110010111101011010110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.087931
		z0 <= "1100000000100100001011010000010101000011000100011000101110001001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.063053
		z0 <= "1100000000100100001000000100100001111100000010011001110000111101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.038175
		z0 <= "1100000000100100000100111000101110110101000000011010110011110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -10.013297
		z0 <= "1100000000100100000001101100111011101101111110011011110110100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.988420
		z0 <= "1100000000100011111110100001001000100110111100011100111001011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.963542
		z0 <= "1100000000100011111011010101010101011111111010011101111100001011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.938664
		z0 <= "1100000000100011111000001001100010011000111000011110111110111111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.913786
		z0 <= "1100000000100011110100111101101111010001110110100000000001110010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.888909
		z0 <= "1100000000100011110001110001111100001010110100100001000100100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.864031
		z0 <= "1100000000100011101110100110001001000011110010100010000111011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.839153
		z0 <= "1100000000100011101011011010010101111100110000100011001010001101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.814275
		z0 <= "1100000000100011101000001110100010110101101110100100001101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.789398
		z0 <= "1100000000100011100101000010101111101110101100100101001111110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.764520
		z0 <= "1100000000100011100001110110111100100111101010100110010010101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.739642
		z0 <= "1100000000100011011110101011001001100000101000100111010101011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.714764
		z0 <= "1100000000100011011011011111010110011001100110101000011000001111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.689887
		z0 <= "1100000000100011011000010011100011010010100100101001011011000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.665009
		z0 <= "1100000000100011010101000111110000001011100010101010011101110110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.640131
		z0 <= "1100000000100011010001111011111101000100100000101011100000101010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.615253
		z0 <= "1100000000100011001110110000001001111101011110101100100011011110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.590376
		z0 <= "1100000000100011001011100100010110110110011100101101100110010001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.565498
		z0 <= "1100000000100011001000011000100011101111011010101110101001000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.540620
		z0 <= "1100000000100011000101001100110000101000011000101111101011111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.515742
		z0 <= "1100000000100011000010000000111101100001010110110000101110101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.490865
		z0 <= "1100000000100010111110110101001010011010010100110001110001011111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.465987
		z0 <= "1100000000100010111011101001010111010011010010110010110100010011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.441109
		z0 <= "1100000000100010111000011101100100001100010000110011110111000111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.416231
		z0 <= "1100000000100010110101010001110001000101001110110100111001111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.391354
		z0 <= "1100000000100010110010000101111101111110001100110101111100101110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.366476
		z0 <= "1100000000100010101110111010001010110111001010110110111111100001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.341598
		z0 <= "1100000000100010101011101110010111110000001000111000000010010101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.316720
		z0 <= "1100000000100010101000100010100100101001000110111001000101001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.291843
		z0 <= "1100000000100010100101010110110001100010000100111010000111111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.266965
		z0 <= "1100000000100010100010001010111110011011000010111011001010110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.242087
		z0 <= "1100000000100010011110111111001011010100000000111100001101100011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.217209
		z0 <= "1100000000100010011011110011011000001100111110111101010000010111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.192331
		z0 <= "1100000000100010011000100111100101000101111100111110010011001010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.167454
		z0 <= "1100000000100010010101011011110001111110111010111111010101111110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.142576
		z0 <= "1100000000100010010010001111111110110111111001000000011000110010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.117698
		z0 <= "1100000000100010001111000100001011110000110111000001011011100101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.092820
		z0 <= "1100000000100010001011111000011000101001110101000010011110011001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.067943
		z0 <= "1100000000100010001000101100100101100010110011000011100001001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.043065
		z0 <= "1100000000100010000101100000110010011011110001000100100100000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -9.018187
		z0 <= "1100000000100010000010010100111111010100101111000101100110110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.993309
		z0 <= "1100000000100001111111001001001100001101101101000110101001100111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.968432
		z0 <= "1100000000100001111011111101011001000110101011000111101100011011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.943554
		z0 <= "1100000000100001111000110001100101111111101001001000101111001110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.918676
		z0 <= "1100000000100001110101100101110010111000100111001001110010000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.893798
		z0 <= "1100000000100001110010011001111111110001100101001010110100110101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.868921
		z0 <= "1100000000100001101111001110001100101010100011001011110111101001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.844043
		z0 <= "1100000000100001101100000010011001100011100001001100111010011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.819165
		z0 <= "1100000000100001101000110110100110011100011111001101111101010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.794287
		z0 <= "1100000000100001100101101010110011010101011101001111000000000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.769410
		z0 <= "1100000000100001100010011111000000001110011011010000000010110111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.744532
		z0 <= "1100000000100001011111010011001101000111011001010001000101101011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.719654
		z0 <= "1100000000100001011100000111011010000000010111010010001000011110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.694776
		z0 <= "1100000000100001011000111011100110111001010101010011001011010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.669899
		z0 <= "1100000000100001010101101111110011110010010011010100001110000110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.645021
		z0 <= "1100000000100001010010100100000000101011010001010101010000111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.620143
		z0 <= "1100000000100001001111011000001101100100001111010110010011101101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.595265
		z0 <= "1100000000100001001100001100011010011101001101010111010110100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.570388
		z0 <= "1100000000100001001001000000100111010110001011011000011001010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.545510
		z0 <= "1100000000100001000101110100110100001111001001011001011100001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.520632
		z0 <= "1100000000100001000010101001000001001000000111011010011110111011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.495754
		z0 <= "1100000000100000111111011101001110000001000101011011100001101111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.470877
		z0 <= "1100000000100000111100010001011010111010000011011100100100100010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.445999
		z0 <= "1100000000100000111001000101100111110011000001011101100111010110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.421121
		z0 <= "1100000000100000110101111001110100101011111111011110101010001010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.396243
		z0 <= "1100000000100000110010101110000001100100111101011111101100111110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.371365
		z0 <= "1100000000100000101111100010001110011101111011100000101111110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.346488
		z0 <= "1100000000100000101100010110011011010110111001100001110010100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.321610
		z0 <= "1100000000100000101001001010101000001111110111100010110101011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.296732
		z0 <= "1100000000100000100101111110110101001000110101100011111000001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.271854
		z0 <= "1100000000100000100010110011000010000001110011100100111010111111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.246977
		z0 <= "1100000000100000011111100111001110111010110001100101111101110010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.222099
		z0 <= "1100000000100000011100011011011011110011101111100111000000100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.197221
		z0 <= "1100000000100000011001001111101000101100101101101000000011011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.172343
		z0 <= "1100000000100000010110000011110101100101101011101001000110001101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.147466
		z0 <= "1100000000100000010010111000000010011110101001101010001001000001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.122588
		z0 <= "1100000000100000001111101100001111010111100111101011001011110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.097710
		z0 <= "1100000000100000001100100000011100010000100101101100001110101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.072832
		z0 <= "1100000000100000001001010100101001001001100011101101010001011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.047955
		z0 <= "1100000000100000000110001000110110000010100001101110010100010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -8.023077
		z0 <= "1100000000100000000010111101000010111011011111101111010111000011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.998199
		z0 <= "1100000000011111111111100010011111101000111011100000110011101101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.973321
		z0 <= "1100000000011111111001001010111001011010110111100010111001010101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.948444
		z0 <= "1100000000011111110010110011010011001100110011100100111110111011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.923566
		z0 <= "1100000000011111101100011011101100111110101111100111000100100011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.898688
		z0 <= "1100000000011111100110000100000110110000101011101001001010001010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.873810
		z0 <= "1100000000011111011111101100100000100010100111101011001111110001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.848933
		z0 <= "1100000000011111011001010100111010010100100011101101010101011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.824055
		z0 <= "1100000000011111010010111101010100000110011111101111011010111111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.799177
		z0 <= "1100000000011111001100100101101101111000011011110001100000100111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.774299
		z0 <= "1100000000011111000110001110000111101010010111110011100110001110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.749422
		z0 <= "1100000000011110111111110110100001011100010011110101101011110101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.724544
		z0 <= "1100000000011110111001011110111011001110001111110111110001011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.699666
		z0 <= "1100000000011110110011000111010101000000001011111001110111000011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.674788
		z0 <= "1100000000011110101100101111101110110010000111111011111100101011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.649911
		z0 <= "1100000000011110100110011000001000100100000011111110000010010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.625033
		z0 <= "1100000000011110100000000000100010010110000000000000000111111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.600155
		z0 <= "1100000000011110011001101000111100000111111100000010001101100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.575277
		z0 <= "1100000000011110010011010001010101111001111000000100010011000111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.550399
		z0 <= "1100000000011110001100111001101111101011110100000110011000101111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.525522
		z0 <= "1100000000011110000110100010001001011101110000001000011110010101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.500644
		z0 <= "1100000000011110000000001010100011001111101100001010100011111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.475766
		z0 <= "1100000000011101111001110010111101000001101000001100101001100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.450888
		z0 <= "1100000000011101110011011011010110110011100100001110101111001011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.426011
		z0 <= "1100000000011101101101000011110000100101100000010000110100110011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.401133
		z0 <= "1100000000011101100110101100001010010111011100010010111010011001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.376255
		z0 <= "1100000000011101100000010100100100001001011000010101000000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.351377
		z0 <= "1100000000011101011001111100111101111011010100010111000101101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.326500
		z0 <= "1100000000011101010011100101010111101101010000011001001011001111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.301622
		z0 <= "1100000000011101001101001101110001011111001100011011010000110110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.276744
		z0 <= "1100000000011101000110110110001011010001001000011101010110011101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.251866
		z0 <= "1100000000011101000000011110100101000011000100011111011100000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.226989
		z0 <= "1100000000011100111010000110111110110101000000100001100001101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.202111
		z0 <= "1100000000011100110011101111011000100110111100100011100111010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.177233
		z0 <= "1100000000011100101101010111110010011000111000100101101100111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.152355
		z0 <= "1100000000011100100111000000001100001010110100100111110010100001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.127478
		z0 <= "1100000000011100100000101000100101111100110000101001111000001001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.102600
		z0 <= "1100000000011100011010010000111111101110101100101011111101110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.077722
		z0 <= "1100000000011100010011111001011001100000101000101110000011010110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.052844
		z0 <= "1100000000011100001101100001110011010010100100110000001000111110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.027967
		z0 <= "1100000000011100000111001010001101000100100000110010001110100101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -7.003089
		z0 <= "1100000000011100000000110010100110110110011100110100010100001101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.978211
		z0 <= "1100000000011011111010011011000000101000011000110110011001110011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.953333
		z0 <= "1100000000011011110100000011011010011010010100111000011111011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.928456
		z0 <= "1100000000011011101101101011110100001100010000111010100101000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.903578
		z0 <= "1100000000011011100111010100001101111110001100111100101010101001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.878700
		z0 <= "1100000000011011100000111100100111110000001000111110110000010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.853822
		z0 <= "1100000000011011011010100101000001100010000101000000110101110111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.828945
		z0 <= "1100000000011011010100001101011011010100000001000010111011011110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.804067
		z0 <= "1100000000011011001101110101110101000101111101000101000001000110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.779189
		z0 <= "1100000000011011000111011110001110110111111001000111000110101101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.754311
		z0 <= "1100000000011011000001000110101000101001110101001001001100010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.729433
		z0 <= "1100000000011010111010101111000010011011110001001011010001111011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.704556
		z0 <= "1100000000011010110100010111011100001101101101001101010111100010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.679678
		z0 <= "1100000000011010101101111111110101111111101001001111011101001010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.654800
		z0 <= "1100000000011010100111101000001111110001100101010001100010110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.629922
		z0 <= "1100000000011010100001010000101001100011100001010011101000011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.605045
		z0 <= "1100000000011010011010111001000011010101011101010101101101111111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.580167
		z0 <= "1100000000011010010100100001011101000111011001010111110011100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.555289
		z0 <= "1100000000011010001110001001110110111001010101011001111001001101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.530411
		z0 <= "1100000000011010000111110010010000101011010001011011111110110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.505534
		z0 <= "1100000000011010000001011010101010011101001101011110000100011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.480656
		z0 <= "1100000000011001111011000011000100001111001001100000001010000011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.455778
		z0 <= "1100000000011001110100101011011110000001000101100010001111101011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.430900
		z0 <= "1100000000011001101110010011110111110011000001100100010101010001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.406023
		z0 <= "1100000000011001100111111100010001100100111101100110011010111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.381145
		z0 <= "1100000000011001100001100100101011010110111001101000100000100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.356267
		z0 <= "1100000000011001011011001101000101001000110101101010100110000111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.331389
		z0 <= "1100000000011001010100110101011110111010110001101100101011101110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.306512
		z0 <= "1100000000011001001110011101111000101100101101101110110001010101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.281634
		z0 <= "1100000000011001001000000110010010011110101001110000110110111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.256756
		z0 <= "1100000000011001000001101110101100010000100101110010111100100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.231878
		z0 <= "1100000000011000111011010111000110000010100001110101000010001010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.207001
		z0 <= "1100000000011000110100111111011111110100011101110111000111110010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.182123
		z0 <= "1100000000011000101110100111111001100110011001111001001101011001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.157245
		z0 <= "1100000000011000101000010000010011011000010101111011010011000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.132367
		z0 <= "1100000000011000100001111000101101001010010001111101011000101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.107490
		z0 <= "1100000000011000011011100001000110111100001101111111011110001110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.082612
		z0 <= "1100000000011000010101001001100000101110001010000001100011110110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.057734
		z0 <= "1100000000011000001110110001111010100000000110000011101001011101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.032856
		z0 <= "1100000000011000001000011010010100010010000010000101101111000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -6.007978
		z0 <= "1100000000011000000010000010101110000011111110000111110100101011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.983101
		z0 <= "1100000000010111111011101011000111110101111010001001111010010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.958223
		z0 <= "1100000000010111110101010011100001100111110110001011111111111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.933345
		z0 <= "1100000000010111101110111011111011011001110010001110000101100001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.908467
		z0 <= "1100000000010111101000100100010101001011101110010000001011000111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.883590
		z0 <= "1100000000010111100010001100101110111101101010010010010000101111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.858712
		z0 <= "1100000000010111011011110101001000101111100110010100010110010110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.833834
		z0 <= "1100000000010111010101011101100010100001100010010110011011111110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.808956
		z0 <= "1100000000010111001111000101111100010011011110011000100001100101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.784079
		z0 <= "1100000000010111001000101110010110000101011010011010100111001011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.759201
		z0 <= "1100000000010111000010010110101111110111010110011100101100110011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.734323
		z0 <= "1100000000010110111011111111001001101001010010011110110010011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.709445
		z0 <= "1100000000010110110101100111100011011011001110100000111000000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.684568
		z0 <= "1100000000010110101111001111111101001101001010100010111101101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.659690
		z0 <= "1100000000010110101000111000010110111111000110100101000011001111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.634812
		z0 <= "1100000000010110100010100000110000110001000010100111001000110111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.609934
		z0 <= "1100000000010110011100001001001010100010111110101001001110011110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.585057
		z0 <= "1100000000010110010101110001100100010100111010101011010100000101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.560179
		z0 <= "1100000000010110001111011001111110000110110110101101011001101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.535301
		z0 <= "1100000000010110001001000010010111111000110010101111011111010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.510423
		z0 <= "1100000000010110000010101010110001101010101110110001100100111011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.485546
		z0 <= "1100000000010101111100010011001011011100101010110011101010100010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.460668
		z0 <= "1100000000010101110101111011100101001110100110110101110000001001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.435790
		z0 <= "1100000000010101101111100011111111000000100010110111110101110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.410912
		z0 <= "1100000000010101101001001100011000110010011110111001111011011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.386035
		z0 <= "1100000000010101100010110100110010100100011010111100000000111111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.361157
		z0 <= "1100000000010101011100011101001100010110010110111110000110100101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.336279
		z0 <= "1100000000010101010110000101100110001000010011000000001100001101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.311401
		z0 <= "1100000000010101001111101101111111111010001111000010010001110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.286524
		z0 <= "1100000000010101001001010110011001101100001011000100010111011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.261646
		z0 <= "1100000000010101000010111110110011011110000111000110011101000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.236768
		z0 <= "1100000000010100111100100111001101010000000011001000100010101001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.211890
		z0 <= "1100000000010100110110001111100111000001111111001010101000010001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.187012
		z0 <= "1100000000010100101111111000000000110011111011001100101101111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.162135
		z0 <= "1100000000010100101001100000011010100101110111001110110011100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.137257
		z0 <= "1100000000010100100011001000110100010111110011010000111001000110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.112379
		z0 <= "1100000000010100011100110001001110001001101111010010111110101101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.087501
		z0 <= "1100000000010100010110011001100111111011101011010101000100010101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.062624
		z0 <= "1100000000010100010000000010000001101101100111010111001001111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.037746
		z0 <= "1100000000010100001001101010011011011111100011011001001111100011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -5.012868
		z0 <= "1100000000010100000011010010110101010001011111011011010101001010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.987990
		z0 <= "1100000000010011111100111011001111000011011011011101011010110001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.963113
		z0 <= "1100000000010011110110100011101000110101010111011111100000011001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.938235
		z0 <= "1100000000010011110000001100000010100111010011100001100101111111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.913357
		z0 <= "1100000000010011101001110100011100011001001111100011101011100111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.888479
		z0 <= "1100000000010011100011011100110110001011001011100101110001001110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.863602
		z0 <= "1100000000010011011101000101001111111101000111100111110110110110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.838724
		z0 <= "1100000000010011010110101101101001101111000011101001111100011101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.813846
		z0 <= "1100000000010011010000010110000011100000111111101100000010000011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.788968
		z0 <= "1100000000010011001001111110011101010010111011101110000111101011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.764091
		z0 <= "1100000000010011000011100110110111000100110111110000001101010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.739213
		z0 <= "1100000000010010111101001111010000110110110011110010010010111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.714335
		z0 <= "1100000000010010110110110111101010101000101111110100011000100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.689457
		z0 <= "1100000000010010110000100000000100011010101011110110011110000111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.664580
		z0 <= "1100000000010010101010001000011110001100100111111000100011101111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.639702
		z0 <= "1100000000010010100011110000110111111110100011111010101001010110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.614824
		z0 <= "1100000000010010011101011001010001110000011111111100101110111101";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.589946
		z0 <= "1100000000010010010111000001101011100010011011111110110100100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.565069
		z0 <= "1100000000010010010000101010000101010100011000000000111010001011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.540191
		z0 <= "1100000000010010001010010010011111000110010100000010111111110011";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.515313
		z0 <= "1100000000010010000011111010111000111000010000000101000101011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.490435
		z0 <= "1100000000010001111101100011010010101010001100000111001011000001";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.465558
		z0 <= "1100000000010001110111001011101100011100001000001001010000101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.440680
		z0 <= "1100000000010001110000110100000110001110000100001011010110001111";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.415802
		z0 <= "1100000000010001101010011100100000000000000000001101011011110110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.390924
		z0 <= "1100000000010001100100000100111001110001111100001111100001011110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.366046
		z0 <= "1100000000010001011101101101010011100011111000010001100111000110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.341169
		z0 <= "1100000000010001010111010101101101010101110100010011101100101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.316291
		z0 <= "1100000000010001010000111110000111000111110000010101110010010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.291413
		z0 <= "1100000000010001001010100110100000111001101100010111110111111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.266535
		z0 <= "1100000000010001000100001110111010101011101000011001111101100010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.241658
		z0 <= "1100000000010000111101110111010100011101100100011100000011001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.216780
		z0 <= "1100000000010000110111011111101110001111100000011110001000110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.191902
		z0 <= "1100000000010000110001001000001000000001011100100000001110010110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.167024
		z0 <= "1100000000010000101010110000100001110011011000100010010011111110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.142147
		z0 <= "1100000000010000100100011000111011100101010100100100011001100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.117269
		z0 <= "1100000000010000011110000001010101010111010000100110011111001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.092391
		z0 <= "1100000000010000010111101001101111001001001100101000100100110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.067513
		z0 <= "1100000000010000010001010010001000111011001000101010101010011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.042636
		z0 <= "1100000000010000001010111010100010101101000100101100110000000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -4.017758
		z0 <= "1100000000010000000100100010111100011111000000101110110101101010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.992880
		z0 <= "1100000000001111111100010110101100100001111001100001110110100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.968002
		z0 <= "1100000000001111101111100111100000000101110001100110000001110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.943125
		z0 <= "1100000000001111100010111000010011101001101001101010001100111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.918247
		z0 <= "1100000000001111010110001001000111001101100001101110011000001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.893369
		z0 <= "1100000000001111001001011001111010110001011001110010100011011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.868491
		z0 <= "1100000000001110111100101010101110010101010001110110101110101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.843614
		z0 <= "1100000000001110101111111011100001111001001001111010111001111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.818736
		z0 <= "1100000000001110100011001100010101011101000001111111000101000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.793858
		z0 <= "1100000000001110010110011101001001000000111010000011010000010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.768980
		z0 <= "1100000000001110001001101101111100100100110010000111011011100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.744103
		z0 <= "1100000000001101111100111110110000001000101010001011100110110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.719225
		z0 <= "1100000000001101110000001111100011101100100010001111110010000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.694347
		z0 <= "1100000000001101100011100000010111010000011010010011111101001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.669469
		z0 <= "1100000000001101010110110001001010110100010010011000001000011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.644592
		z0 <= "1100000000001101001010000001111110011000001010011100010011101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.619714
		z0 <= "1100000000001100111101010010110001111100000010100000011110111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.594836
		z0 <= "1100000000001100110000100011100101011111111010100100101010000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.569958
		z0 <= "1100000000001100100011110100011001000011110010101000110101010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.545080
		z0 <= "1100000000001100010111000101001100100111101010101101000000100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.520203
		z0 <= "1100000000001100001010010110000000001011100010110001001011110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.495325
		z0 <= "1100000000001011111101100110110011101111011010110101010111000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.470447
		z0 <= "1100000000001011110000110111100111010011010010111001100010001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.445569
		z0 <= "1100000000001011100100001000011010110111001010111101101101011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.420692
		z0 <= "1100000000001011010111011001001110011011000011000001111000101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.395814
		z0 <= "1100000000001011001010101010000001111110111011000110000011111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.370936
		z0 <= "1100000000001010111101111010110101100010110011001010001111001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.346058
		z0 <= "1100000000001010110001001011101001000110101011001110011010010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.321181
		z0 <= "1100000000001010100100011100011100101010100011010010100101100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.296303
		z0 <= "1100000000001010010111101101010000001110011011010110110000110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.271425
		z0 <= "1100000000001010001010111110000011110010010011011010111100000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.246547
		z0 <= "1100000000001001111110001110110111010110001011011111000111010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.221670
		z0 <= "1100000000001001110001011111101010111010000011100011010010011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.196792
		z0 <= "1100000000001001100100110000011110011101111011100111011101101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.171914
		z0 <= "1100000000001001011000000001010010000001110011101011101000111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.147036
		z0 <= "1100000000001001001011010010000101100101101011101111110100001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.122159
		z0 <= "1100000000001000111110100010111001001001100011110011111111011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.097281
		z0 <= "1100000000001000110001110011101100101101011011111000001010100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.072403
		z0 <= "1100000000001000100101000100100000010001010011111100010101110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.047525
		z0 <= "1100000000001000011000010101010011110101001100000000100001000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -3.022648
		z0 <= "1100000000001000001011100110000111011001000100000100101100010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.997770
		z0 <= "1100000000000111111110110110111010111100111100001000110111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.972892
		z0 <= "1100000000000111110010000111101110100000110100001101000010101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.948014
		z0 <= "1100000000000111100101011000100010000100101100010001001101111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.923137
		z0 <= "1100000000000111011000101001010101101000100100010101011001001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.898259
		z0 <= "1100000000000111001011111010001001001100011100011001100100011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.873381
		z0 <= "1100000000000110111111001010111100110000010100011101101111101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.848503
		z0 <= "1100000000000110110010011011110000010100001100100001111010110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.823626
		z0 <= "1100000000000110100101101100100011111000000100100110000110000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.798748
		z0 <= "1100000000000110011000111101010111011011111100101010010001010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.773870
		z0 <= "1100000000000110001100001110001010111111110100101110011100100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.748992
		z0 <= "1100000000000101111111011110111110100011101100110010100111110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.724114
		z0 <= "1100000000000101110010101111110010000111100100110110110010111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.699237
		z0 <= "1100000000000101100110000000100101101011011100111010111110001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.674359
		z0 <= "1100000000000101011001010001011001001111010100111111001001011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.649481
		z0 <= "1100000000000101001100100010001100110011001101000011010100101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.624603
		z0 <= "1100000000000100111111110011000000010111000101000111011111110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.599726
		z0 <= "1100000000000100110011000011110011111010111101001011101011000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.574848
		z0 <= "1100000000000100100110010100100111011110110101001111110110010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.549970
		z0 <= "1100000000000100011001100101011011000010101101010100000001100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.525092
		z0 <= "1100000000000100001100110110001110100110100101011000001100110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.500215
		z0 <= "1100000000000100000000000111000010001010011101011100010111111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.475337
		z0 <= "1100000000000011110011010111110101101110010101100000100011001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.450459
		z0 <= "1100000000000011100110101000101001010010001101100100101110011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.425581
		z0 <= "1100000000000011011001111001011100110110000101101000111001101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.400704
		z0 <= "1100000000000011001101001010010000011001111101101101000100111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.375826
		z0 <= "1100000000000011000000011011000011111101110101110001010000000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.350948
		z0 <= "1100000000000010110011101011110111100001101101110101011011010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.326070
		z0 <= "1100000000000010100110111100101011000101100101111001100110100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.301193
		z0 <= "1100000000000010011010001101011110101001011101111101110001110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.276315
		z0 <= "1100000000000010001101011110010010001101010110000001111101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.251437
		z0 <= "1100000000000010000000101111000101110001001110000110001000001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.226559
		z0 <= "1100000000000001110011111111111001010101000110001010010011011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.201682
		z0 <= "1100000000000001100111010000101100111000111110001110011110101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.176804
		z0 <= "1100000000000001011010100001100000011100110110010010101001111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.151926
		z0 <= "1100000000000001001101110010010100000000101110010110110101001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.127048
		z0 <= "1100000000000001000001000011000111100100100110011011000000010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.102171
		z0 <= "1100000000000000110100010011111011001000011110011111001011100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.077293
		z0 <= "1100000000000000100111100100101110101100010110100011010110110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.052415
		z0 <= "1100000000000000011010110101100010010000001110100111100010000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.027537
		z0 <= "1100000000000000001110000110010101110100000110101011101101010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -2.002659
		z0 <= "1100000000000000000001010111001001010111111110101111111000011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.977782
		z0 <= "1011111111111111101001001111111001110111101101101000000111010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.952904
		z0 <= "1011111111111111001111110001100000111111011101110000011101111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.928026
		z0 <= "1011111111111110110110010011001000000111001101111000110100010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.903148
		z0 <= "1011111111111110011100110100101111001110111110000001001010110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.878271
		z0 <= "1011111111111110000011010110010110010110101110001001100001001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.853393
		z0 <= "1011111111111101101001110111111101011110011110010001110111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.828515
		z0 <= "1011111111111101010000011001100100100110001110011010001110001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.803637
		z0 <= "1011111111111100110110111011001011101101111110100010100100100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.778760
		z0 <= "1011111111111100011101011100110010110101101110101010111011000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.753882
		z0 <= "1011111111111100000011111110011001111101011110110011010001011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.729004
		z0 <= "1011111111111011101010100000000001000101001110111011100111110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.704126
		z0 <= "1011111111111011010001000001101000001100111111000011111110011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.679249
		z0 <= "1011111111111010110111100011001111010100101111001100010100110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.654371
		z0 <= "1011111111111010011110000100110110011100011111010100101011001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.629493
		z0 <= "1011111111111010000100100110011101100100001111011101000001101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.604615
		z0 <= "1011111111111001101011001000000100101011111111100101011000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.579738
		z0 <= "1011111111111001010001101001101011110011101111101101101110101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.554860
		z0 <= "1011111111111000111000001011010010111011011111110110000101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.529982
		z0 <= "1011111111111000011110101100111010000011001111111110011011011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.505104
		z0 <= "1011111111111000000101001110100001001011000000000110110001111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.480227
		z0 <= "1011111111110111101011110000001000010010110000001111001000010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.455349
		z0 <= "1011111111110111010010010001101111011010100000010111011110111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.430471
		z0 <= "1011111111110110111000110011010110100010010000011111110101010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.405593
		z0 <= "1011111111110110011111010100111101101010000000101000001011101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.380716
		z0 <= "1011111111110110000101110110100100110001110000110000100010001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.355838
		z0 <= "1011111111110101101100011000001011111001100000111000111000100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.330960
		z0 <= "1011111111110101010010111001110011000001010001000001001111000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.306082
		z0 <= "1011111111110100111001011011011010001001000001001001100101100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.281205
		z0 <= "1011111111110100011111111101000001010000110001010001111011111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.256327
		z0 <= "1011111111110100000110011110101000011000100001011010010010011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.231449
		z0 <= "1011111111110011101101000000001111100000010001100010101000110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.206571
		z0 <= "1011111111110011010011100001110110101000000001101010111111010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.181693
		z0 <= "1011111111110010111010000011011101101111110001110011010101110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.156816
		z0 <= "1011111111110010100000100101000100110111100001111011101100001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.131938
		z0 <= "1011111111110010000111000110101011111111010010000100000010101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.107060
		z0 <= "1011111111110001101101101000010011000111000010001100011001000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.082182
		z0 <= "1011111111110001010100001001111010001110110010010100101111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.057305
		z0 <= "1011111111110000111010101011100001010110100010011101000110000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.032427
		z0 <= "1011111111110000100001001101001000011110010010100101011100011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -1.007549
		z0 <= "1011111111110000000111101110101111100110000010101101110010110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.982671
		z0 <= "1011111111101111011100100000101101011011100101101100010010100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.957794
		z0 <= "1011111111101110101001100011111011101011000101111100111111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.932916
		z0 <= "1011111111101101110110100111001001111010100110001101101100100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.908038
		z0 <= "1011111111101101000011101010011000001010000110011110011001010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.883160
		z0 <= "1011111111101100010000101101100110011001100110101111000110000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.858283
		z0 <= "1011111111101011011101110000110100101001000110111111110011000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.833405
		z0 <= "1011111111101010101010110100000010111000100111010000100000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.808527
		z0 <= "1011111111101001110111110111010001001000000111100001001101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.783649
		z0 <= "1011111111101001000100111010011111010111100111110001111001110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.758772
		z0 <= "1011111111101000010001111101101101100111001000000010100110100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.733894
		z0 <= "1011111111100111011111000000111011110110101000010011010011100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.709016
		z0 <= "1011111111100110101100000100001010000110001000100100000000100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.684138
		z0 <= "1011111111100101111001000111011000010101101000110100101101010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.659261
		z0 <= "1011111111100101000110001010100110100101001001000101011010010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.634383
		z0 <= "1011111111100100010011001101110100110100101001010110000111000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.609505
		z0 <= "1011111111100011100000010001000011000100001001100110110100000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.584627
		z0 <= "1011111111100010101101010100010001010011101001110111100001000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.559750
		z0 <= "1011111111100001111010010111011111100011001010001000001101110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.534872
		z0 <= "1011111111100001000111011010101101110010101010011000111010110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.509994
		z0 <= "1011111111100000010100011101111100000010001010101001100111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.485116
		z0 <= "1011111111011111000011000010010100100011010101110100101001100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.460239
		z0 <= "1011111111011101011101001000110001000010010110010110000011000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.435361
		z0 <= "1011111111011011110111001111001101100001010110110111011100100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.410483
		z0 <= "1011111111011010010001010101101010000000010111011000110110100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.385605
		z0 <= "1011111111011000101011011100000110011111010111111010010000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.360727
		z0 <= "1011111111010111000101100010100010111110011000011011101010000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.335850
		z0 <= "1011111111010101011111101000111111011101011000111101000100000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.310972
		z0 <= "1011111111010011111001101111011011111100011001011110011101100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.286094
		z0 <= "1011111111010010010011110101111000011011011001111111110111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.261216
		z0 <= "1011111111010000101101111100010100111010011010100001010001000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.236339
		z0 <= "1011111111001110010000000101100010110010110110000101010110000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.211461
		z0 <= "1011111111001011000100010010011011110000110111001000001010000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.186583
		z0 <= "1011111111000111111000011111010100101110111000001010111101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.161705
		z0 <= "1011111111000100101100101100001101101100111001001101110001000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.136828
		z0 <= "1011111111000001100000111001000110101010111010010000100100000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.111950
		z0 <= "1011111110111100101010001011111111010001110110100110110000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.087072
		z0 <= "1011111110110110010010100101110001001101111000101100011000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.062194
		z0 <= "1011111110101111110101111111000110010011110101100011111100000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.037317
		z0 <= "1011111110100011000110110010101010001011111001101111001000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := -0.012439
		z0 <= "1011111110001001011110011000111000001111110111101001100000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.012439
		z0 <= "0011111110001001011110011000111000001111110111101001100000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.037317
		z0 <= "0011111110100011000110110010101010001011111001101111001000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.062194
		z0 <= "0011111110101111110101111111000110010011110101100011111100000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.087072
		z0 <= "0011111110110110010010100101110001001101111000101100011000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.111950
		z0 <= "0011111110111100101010001011111111010001110110100110110000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.136828
		z0 <= "0011111111000001100000111001000110101010111010010000100100000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.161705
		z0 <= "0011111111000100101100101100001101101100111001001101110000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.186583
		z0 <= "0011111111000111111000011111010100101110111000001010111101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.211461
		z0 <= "0011111111001011000100010010011011110000110111001000001010000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.236339
		z0 <= "0011111111001110010000000101100010110010110110000101010110000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.261216
		z0 <= "0011111111010000101101111100010100111010011010100001010001000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.286094
		z0 <= "0011111111010010010011110101111000011011011001111111110111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.310972
		z0 <= "0011111111010011111001101111011011111100011001011110011101100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.335850
		z0 <= "0011111111010101011111101000111111011101011000111101000100000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.360727
		z0 <= "0011111111010111000101100010100010111110011000011011101010000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.385605
		z0 <= "0011111111011000101011011100000110011111010111111010010000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.410483
		z0 <= "0011111111011010010001010101101010000000010111011000110110100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.435361
		z0 <= "0011111111011011110111001111001101100001010110110111011100100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.460239
		z0 <= "0011111111011101011101001000110001000010010110010110000011000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.485116
		z0 <= "0011111111011111000011000010010100100011010101110100101001000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.509994
		z0 <= "0011111111100000010100011101111100000010001010101001100111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.534872
		z0 <= "0011111111100001000111011010101101110010101010011000111010110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.559750
		z0 <= "0011111111100001111010010111011111100011001010001000001101110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.584627
		z0 <= "0011111111100010101101010100010001010011101001110111100001000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.609505
		z0 <= "0011111111100011100000010001000011000100001001100110110100010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.634383
		z0 <= "0011111111100100010011001101110100110100101001010110000111000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.659261
		z0 <= "0011111111100101000110001010100110100101001001000101011010010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.684138
		z0 <= "0011111111100101111001000111011000010101101000110100101101010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.709016
		z0 <= "0011111111100110101100000100001010000110001000100100000000100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.733894
		z0 <= "0011111111100111011111000000111011110110101000010011010011110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.758772
		z0 <= "0011111111101000010001111101101101100111001000000010100110100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.783649
		z0 <= "0011111111101001000100111010011111010111100111110001111001110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.808527
		z0 <= "0011111111101001110111110111010001001000000111100001001100110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.833405
		z0 <= "0011111111101010101010110100000010111000100111010000100000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.858283
		z0 <= "0011111111101011011101110000110100101001000110111111110011010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.883160
		z0 <= "0011111111101100010000101101100110011001100110101111000110000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.908038
		z0 <= "0011111111101101000011101010011000001010000110011110011001010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.932916
		z0 <= "0011111111101101110110100111001001111010100110001101101100100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.957794
		z0 <= "0011111111101110101001100011111011101011000101111100111111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 0.982671
		z0 <= "0011111111101111011100100000101101011011100101101100010010110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.007549
		z0 <= "0011111111110000000111101110101111100110000010101101110010110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.032427
		z0 <= "0011111111110000100001001101001000011110010010100101011100011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.057305
		z0 <= "0011111111110000111010101011100001010110100010011101000110000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.082182
		z0 <= "0011111111110001010100001001111010001110110010010100101111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.107060
		z0 <= "0011111111110001101101101000010011000111000010001100011001001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.131938
		z0 <= "0011111111110010000111000110101011111111010010000100000010100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.156816
		z0 <= "0011111111110010100000100101000100110111100001111011101100001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.181693
		z0 <= "0011111111110010111010000011011101101111110001110011010101110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.206571
		z0 <= "0011111111110011010011100001110110101000000001101010111111010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.231449
		z0 <= "0011111111110011101101000000001111100000010001100010101000110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.256327
		z0 <= "0011111111110100000110011110101000011000100001011010010010011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.281205
		z0 <= "0011111111110100011111111101000001010000110001010001111011111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.306082
		z0 <= "0011111111110100111001011011011010001001000001001001100101100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.330960
		z0 <= "0011111111110101010010111001110011000001010001000001001111000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.355838
		z0 <= "0011111111110101101100011000001011111001100000111000111000100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.380716
		z0 <= "0011111111110110000101110110100100110001110000110000100010001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.405593
		z0 <= "0011111111110110011111010100111101101010000000101000001011101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.430471
		z0 <= "0011111111110110111000110011010110100010010000011111110101010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.455349
		z0 <= "0011111111110111010010010001101111011010100000010111011110110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.480227
		z0 <= "0011111111110111101011110000001000010010110000001111001000010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.505104
		z0 <= "0011111111111000000101001110100001001011000000000110110001111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.529982
		z0 <= "0011111111111000011110101100111010000011001111111110011011011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.554860
		z0 <= "0011111111111000111000001011010010111011011111110110000101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.579738
		z0 <= "0011111111111001010001101001101011110011101111101101101110101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.604615
		z0 <= "0011111111111001101011001000000100101011111111100101011000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.629493
		z0 <= "0011111111111010000100100110011101100100001111011101000001101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.654371
		z0 <= "0011111111111010011110000100110110011100011111010100101011001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.679249
		z0 <= "0011111111111010110111100011001111010100101111001100010100110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.704126
		z0 <= "0011111111111011010001000001101000001100111111000011111110011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.729004
		z0 <= "0011111111111011101010100000000001000101001110111011100111110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.753882
		z0 <= "0011111111111100000011111110011001111101011110110011010001011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.778760
		z0 <= "0011111111111100011101011100110010110101101110101010111010111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.803637
		z0 <= "0011111111111100110110111011001011101101111110100010100100100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.828515
		z0 <= "0011111111111101010000011001100100100110001110011010001110001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.853393
		z0 <= "0011111111111101101001110111111101011110011110010001110111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.878271
		z0 <= "0011111111111110000011010110010110010110101110001001100001001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.903148
		z0 <= "0011111111111110011100110100101111001110111110000001001010110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.928026
		z0 <= "0011111111111110110110010011001000000111001101111000110100010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.952904
		z0 <= "0011111111111111001111110001100000111111011101110000011101111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 1.977782
		z0 <= "0011111111111111101001001111111001110111101101101000000111010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.002659
		z0 <= "0100000000000000000001010111001001010111111110101111111000011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.027537
		z0 <= "0100000000000000001110000110010101110100000110101011101101010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.052415
		z0 <= "0100000000000000011010110101100010010000001110100111100010000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.077293
		z0 <= "0100000000000000100111100100101110101100010110100011010110110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.102171
		z0 <= "0100000000000000110100010011111011001000011110011111001011100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.127048
		z0 <= "0100000000000001000001000011000111100100100110011011000000010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.151926
		z0 <= "0100000000000001001101110010010100000000101110010110110101001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.176804
		z0 <= "0100000000000001011010100001100000011100110110010010101001111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.201682
		z0 <= "0100000000000001100111010000101100111000111110001110011110101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.226559
		z0 <= "0100000000000001110011111111111001010101000110001010010011011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.251437
		z0 <= "0100000000000010000000101111000101110001001110000110001000001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.276315
		z0 <= "0100000000000010001101011110010010001101010110000001111101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.301193
		z0 <= "0100000000000010011010001101011110101001011101111101110001110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.326070
		z0 <= "0100000000000010100110111100101011000101100101111001100110100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.350948
		z0 <= "0100000000000010110011101011110111100001101101110101011011010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.375826
		z0 <= "0100000000000011000000011011000011111101110101110001010000000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.400704
		z0 <= "0100000000000011001101001010010000011001111101101101000100111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.425581
		z0 <= "0100000000000011011001111001011100110110000101101000111001101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.450459
		z0 <= "0100000000000011100110101000101001010010001101100100101110011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.475337
		z0 <= "0100000000000011110011010111110101101110010101100000100011001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.500215
		z0 <= "0100000000000100000000000111000010001010011101011100010111111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.525092
		z0 <= "0100000000000100001100110110001110100110100101011000001100110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.549970
		z0 <= "0100000000000100011001100101011011000010101101010100000001100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.574848
		z0 <= "0100000000000100100110010100100111011110110101001111110110010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.599726
		z0 <= "0100000000000100110011000011110011111010111101001011101011000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.624603
		z0 <= "0100000000000100111111110011000000010111000101000111011111110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.649481
		z0 <= "0100000000000101001100100010001100110011001101000011010100101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.674359
		z0 <= "0100000000000101011001010001011001001111010100111111001001011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.699237
		z0 <= "0100000000000101100110000000100101101011011100111010111110001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.724114
		z0 <= "0100000000000101110010101111110010000111100100110110110010111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.748992
		z0 <= "0100000000000101111111011110111110100011101100110010100111101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.773870
		z0 <= "0100000000000110001100001110001010111111110100101110011100100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.798748
		z0 <= "0100000000000110011000111101010111011011111100101010010001010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.823626
		z0 <= "0100000000000110100101101100100011111000000100100110000110000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.848503
		z0 <= "0100000000000110110010011011110000010100001100100001111010110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.873381
		z0 <= "0100000000000110111111001010111100110000010100011101101111101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.898259
		z0 <= "0100000000000111001011111010001001001100011100011001100100011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.923137
		z0 <= "0100000000000111011000101001010101101000100100010101011001001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.948014
		z0 <= "0100000000000111100101011000100010000100101100010001001101111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.972892
		z0 <= "0100000000000111110010000111101110100000110100001101000010101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 2.997770
		z0 <= "0100000000000111111110110110111010111100111100001000110111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.022648
		z0 <= "0100000000001000001011100110000111011001000100000100101100010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.047525
		z0 <= "0100000000001000011000010101010011110101001100000000100001000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.072403
		z0 <= "0100000000001000100101000100100000010001010011111100010101110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.097281
		z0 <= "0100000000001000110001110011101100101101011011111000001010100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.122159
		z0 <= "0100000000001000111110100010111001001001100011110011111111011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.147036
		z0 <= "0100000000001001001011010010000101100101101011101111110100001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.171914
		z0 <= "0100000000001001011000000001010010000001110011101011101000111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.196792
		z0 <= "0100000000001001100100110000011110011101111011100111011101101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.221670
		z0 <= "0100000000001001110001011111101010111010000011100011010010011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.246547
		z0 <= "0100000000001001111110001110110111010110001011011111000111010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.271425
		z0 <= "0100000000001010001010111110000011110010010011011010111100000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.296303
		z0 <= "0100000000001010010111101101010000001110011011010110110000110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.321181
		z0 <= "0100000000001010100100011100011100101010100011010010100101100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.346058
		z0 <= "0100000000001010110001001011101001000110101011001110011010010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.370936
		z0 <= "0100000000001010111101111010110101100010110011001010001111001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.395814
		z0 <= "0100000000001011001010101010000001111110111011000110000011111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.420692
		z0 <= "0100000000001011010111011001001110011011000011000001111000101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.445569
		z0 <= "0100000000001011100100001000011010110111001010111101101101011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.470447
		z0 <= "0100000000001011110000110111100111010011010010111001100010001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.495325
		z0 <= "0100000000001011111101100110110011101111011010110101010111000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.520203
		z0 <= "0100000000001100001010010110000000001011100010110001001011110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.545080
		z0 <= "0100000000001100010111000101001100100111101010101101000000100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.569958
		z0 <= "0100000000001100100011110100011001000011110010101000110101010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.594836
		z0 <= "0100000000001100110000100011100101011111111010100100101010001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.619714
		z0 <= "0100000000001100111101010010110001111100000010100000011110111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.644592
		z0 <= "0100000000001101001010000001111110011000001010011100010011101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.669469
		z0 <= "0100000000001101010110110001001010110100010010011000001000100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.694347
		z0 <= "0100000000001101100011100000010111010000011010010011111101001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.719225
		z0 <= "0100000000001101110000001111100011101100100010001111110010000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.744103
		z0 <= "0100000000001101111100111110110000001000101010001011100110110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.768980
		z0 <= "0100000000001110001001101101111100100100110010000111011011100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.793858
		z0 <= "0100000000001110010110011101001001000000111010000011010000011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.818736
		z0 <= "0100000000001110100011001100010101011101000001111111000101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.843614
		z0 <= "0100000000001110101111111011100001111001001001111010111001111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.868491
		z0 <= "0100000000001110111100101010101110010101010001110110101110101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.893369
		z0 <= "0100000000001111001001011001111010110001011001110010100011011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.918247
		z0 <= "0100000000001111010110001001000111001101100001101110011000010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.943125
		z0 <= "0100000000001111100010111000010011101001101001101010001101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.968002
		z0 <= "0100000000001111101111100111100000000101110001100110000001110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 3.992880
		z0 <= "0100000000001111111100010110101100100001111001100001110110100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.017758
		z0 <= "0100000000010000000100100010111100011111000000101110110101101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.042636
		z0 <= "0100000000010000001010111010100010101101000100101100110000000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.067513
		z0 <= "0100000000010000010001010010001000111011001000101010101010011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.092391
		z0 <= "0100000000010000010111101001101111001001001100101000100100110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.117269
		z0 <= "0100000000010000011110000001010101010111010000100110011111001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.142147
		z0 <= "0100000000010000100100011000111011100101010100100100011001100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.167024
		z0 <= "0100000000010000101010110000100001110011011000100010010100000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.191902
		z0 <= "0100000000010000110001001000001000000001011100100000001110011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.216780
		z0 <= "0100000000010000110111011111101110001111100000011110001000110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.241658
		z0 <= "0100000000010000111101110111010100011101100100011100000011001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.266535
		z0 <= "0100000000010001000100001110111010101011101000011001111101100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.291413
		z0 <= "0100000000010001001010100110100000111001101100010111110111111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.316291
		z0 <= "0100000000010001010000111110000111000111110000010101110010010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.341169
		z0 <= "0100000000010001010111010101101101010101110100010011101100101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.366046
		z0 <= "0100000000010001011101101101010011100011111000010001100111000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.390924
		z0 <= "0100000000010001100100000100111001110001111100001111100001011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.415802
		z0 <= "0100000000010001101010011100100000000000000000001101011011111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.440680
		z0 <= "0100000000010001110000110100000110001110000100001011010110010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.465558
		z0 <= "0100000000010001110111001011101100011100001000001001010000101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.490435
		z0 <= "0100000000010001111101100011010010101010001100000111001011000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.515313
		z0 <= "0100000000010010000011111010111000111000010000000101000101011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.540191
		z0 <= "0100000000010010001010010010011111000110010100000010111111110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.565069
		z0 <= "0100000000010010010000101010000101010100011000000000111010001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.589946
		z0 <= "0100000000010010010111000001101011100010011011111110110100101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.614824
		z0 <= "0100000000010010011101011001010001110000011111111100101110111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.639702
		z0 <= "0100000000010010100011110000110111111110100011111010101001010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.664580
		z0 <= "0100000000010010101010001000011110001100100111111000100011110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.689457
		z0 <= "0100000000010010110000100000000100011010101011110110011110001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.714335
		z0 <= "0100000000010010110110110111101010101000101111110100011000100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.739213
		z0 <= "0100000000010010111101001111010000110110110011110010010010111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.764091
		z0 <= "0100000000010011000011100110110111000100110111110000001101010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.788968
		z0 <= "0100000000010011001001111110011101010010111011101110000111101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.813846
		z0 <= "0100000000010011010000010110000011100000111111101100000010000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.838724
		z0 <= "0100000000010011010110101101101001101111000011101001111100100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.863602
		z0 <= "0100000000010011011101000101001111111101000111100111110110110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.888479
		z0 <= "0100000000010011100011011100110110001011001011100101110001001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.913357
		z0 <= "0100000000010011101001110100011100011001001111100011101011101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.938235
		z0 <= "0100000000010011110000001100000010100111010011100001100110000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.963113
		z0 <= "0100000000010011110110100011101000110101010111011111100000011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 4.987990
		z0 <= "0100000000010011111100111011001111000011011011011101011010110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.012868
		z0 <= "0100000000010100000011010010110101010001011111011011010101001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.037746
		z0 <= "0100000000010100001001101010011011011111100011011001001111100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.062624
		z0 <= "0100000000010100010000000010000001101101100111010111001001111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.087501
		z0 <= "0100000000010100010110011001100111111011101011010101000100010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.112379
		z0 <= "0100000000010100011100110001001110001001101111010010111110101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.137257
		z0 <= "0100000000010100100011001000110100010111110011010000111001000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.162135
		z0 <= "0100000000010100101001100000011010100101110111001110110011100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.187012
		z0 <= "0100000000010100101111111000000000110011111011001100101101111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.211890
		z0 <= "0100000000010100110110001111100111000001111111001010101000010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.236768
		z0 <= "0100000000010100111100100111001101010000000011001000100010101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.261646
		z0 <= "0100000000010101000010111110110011011110000111000110011101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.286524
		z0 <= "0100000000010101001001010110011001101100001011000100010111011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.311401
		z0 <= "0100000000010101001111101101111111111010001111000010010001110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.336279
		z0 <= "0100000000010101010110000101100110001000010011000000001100001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.361157
		z0 <= "0100000000010101011100011101001100010110010110111110000110101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.386035
		z0 <= "0100000000010101100010110100110010100100011010111100000000111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.410912
		z0 <= "0100000000010101101001001100011000110010011110111001111011011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.435790
		z0 <= "0100000000010101101111100011111111000000100010110111110101110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.460668
		z0 <= "0100000000010101110101111011100101001110100110110101110000001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.485546
		z0 <= "0100000000010101111100010011001011011100101010110011101010100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.510423
		z0 <= "0100000000010110000010101010110001101010101110110001100100111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.535301
		z0 <= "0100000000010110001001000010010111111000110010101111011111010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.560179
		z0 <= "0100000000010110001111011001111110000110110110101101011001101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.585057
		z0 <= "0100000000010110010101110001100100010100111010101011010100000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.609934
		z0 <= "0100000000010110011100001001001010100010111110101001001110100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.634812
		z0 <= "0100000000010110100010100000110000110001000010100111001000110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.659690
		z0 <= "0100000000010110101000111000010110111111000110100101000011010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.684568
		z0 <= "0100000000010110101111001111111101001101001010100010111101101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.709445
		z0 <= "0100000000010110110101100111100011011011001110100000111000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.734323
		z0 <= "0100000000010110111011111111001001101001010010011110110010011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.759201
		z0 <= "0100000000010111000010010110101111110111010110011100101100110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.784079
		z0 <= "0100000000010111001000101110010110000101011010011010100111001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.808956
		z0 <= "0100000000010111001111000101111100010011011110011000100001100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.833834
		z0 <= "0100000000010111010101011101100010100001100010010110011011111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.858712
		z0 <= "0100000000010111011011110101001000101111100110010100010110011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.883590
		z0 <= "0100000000010111100010001100101110111101101010010010010000110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.908467
		z0 <= "0100000000010111101000100100010101001011101110010000001011001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.933345
		z0 <= "0100000000010111101110111011111011011001110010001110000101100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.958223
		z0 <= "0100000000010111110101010011100001100111110110001011111111111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 5.983101
		z0 <= "0100000000010111111011101011000111110101111010001001111010010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.007978
		z0 <= "0100000000011000000010000010101110000011111110000111110100101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.032856
		z0 <= "0100000000011000001000011010010100010010000010000101101111000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.057734
		z0 <= "0100000000011000001110110001111010100000000110000011101001011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.082612
		z0 <= "0100000000011000010101001001100000101110001010000001100011110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.107490
		z0 <= "0100000000011000011011100001000110111100001101111111011110010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.132367
		z0 <= "0100000000011000100001111000101101001010010001111101011000101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.157245
		z0 <= "0100000000011000101000010000010011011000010101111011010011000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.182123
		z0 <= "0100000000011000101110100111111001100110011001111001001101011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.207001
		z0 <= "0100000000011000110100111111011111110100011101110111000111110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.231878
		z0 <= "0100000000011000111011010111000110000010100001110101000010001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.256756
		z0 <= "0100000000011001000001101110101100010000100101110010111100100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.281634
		z0 <= "0100000000011001001000000110010010011110101001110000110110111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.306512
		z0 <= "0100000000011001001110011101111000101100101101101110110001010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.331389
		z0 <= "0100000000011001010100110101011110111010110001101100101011101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.356267
		z0 <= "0100000000011001011011001101000101001000110101101010100110001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.381145
		z0 <= "0100000000011001100001100100101011010110111001101000100000100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.406023
		z0 <= "0100000000011001100111111100010001100100111101100110011010111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.430900
		z0 <= "0100000000011001101110010011110111110011000001100100010101010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.455778
		z0 <= "0100000000011001110100101011011110000001000101100010001111101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.480656
		z0 <= "0100000000011001111011000011000100001111001001100000001010000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.505534
		z0 <= "0100000000011010000001011010101010011101001101011110000100011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.530411
		z0 <= "0100000000011010000111110010010000101011010001011011111110111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.555289
		z0 <= "0100000000011010001110001001110110111001010101011001111001001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.580167
		z0 <= "0100000000011010010100100001011101000111011001010111110011100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.605045
		z0 <= "0100000000011010011010111001000011010101011101010101101110000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.629922
		z0 <= "0100000000011010100001010000101001100011100001010011101000011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.654800
		z0 <= "0100000000011010100111101000001111110001100101010001100010110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.679678
		z0 <= "0100000000011010101101111111110101111111101001001111011101001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.704556
		z0 <= "0100000000011010110100010111011100001101101101001101010111100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.729433
		z0 <= "0100000000011010111010101111000010011011110001001011010001111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.754311
		z0 <= "0100000000011011000001000110101000101001110101001001001100010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.779189
		z0 <= "0100000000011011000111011110001110110111111001000111000110110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.804067
		z0 <= "0100000000011011001101110101110101000101111101000101000001000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.828945
		z0 <= "0100000000011011010100001101011011010100000001000010111011011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.853822
		z0 <= "0100000000011011011010100101000001100010000101000000110101111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.878700
		z0 <= "0100000000011011100000111100100111110000001000111110110000010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.903578
		z0 <= "0100000000011011100111010100001101111110001100111100101010101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.928456
		z0 <= "0100000000011011101101101011110100001100010000111010100101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.953333
		z0 <= "0100000000011011110100000011011010011010010100111000011111011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 6.978211
		z0 <= "0100000000011011111010011011000000101000011000110110011001110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.003089
		z0 <= "0100000000011100000000110010100110110110011100110100010100001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.027967
		z0 <= "0100000000011100000111001010001101000100100000110010001110101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.052844
		z0 <= "0100000000011100001101100001110011010010100100110000001000111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.077722
		z0 <= "0100000000011100010011111001011001100000101000101110000011010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.102600
		z0 <= "0100000000011100011010010000111111101110101100101011111101110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.127478
		z0 <= "0100000000011100100000101000100101111100110000101001111000001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.152355
		z0 <= "0100000000011100100111000000001100001010110100100111110010100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.177233
		z0 <= "0100000000011100101101010111110010011000111000100101101100111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.202111
		z0 <= "0100000000011100110011101111011000100110111100100011100111010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.226989
		z0 <= "0100000000011100111010000110111110110101000000100001100001101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.251866
		z0 <= "0100000000011101000000011110100101000011000100011111011100000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.276744
		z0 <= "0100000000011101000110110110001011010001001000011101010110100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.301622
		z0 <= "0100000000011101001101001101110001011111001100011011010000111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.326500
		z0 <= "0100000000011101010011100101010111101101010000011001001011001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.351377
		z0 <= "0100000000011101011001111100111101111011010100010111000101101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.376255
		z0 <= "0100000000011101100000010100100100001001011000010101000000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.401133
		z0 <= "0100000000011101100110101100001010010111011100010010111010011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.426011
		z0 <= "0100000000011101101101000011110000100101100000010000110100110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.450888
		z0 <= "0100000000011101110011011011010110110011100100001110101111001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.475766
		z0 <= "0100000000011101111001110010111101000001101000001100101001100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.500644
		z0 <= "0100000000011110000000001010100011001111101100001010100011111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.525522
		z0 <= "0100000000011110000110100010001001011101110000001000011110011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.550399
		z0 <= "0100000000011110001100111001101111101011110100000110011000110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.575277
		z0 <= "0100000000011110010011010001010101111001111000000100010011000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.600155
		z0 <= "0100000000011110011001101000111100000111111100000010001101100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.625033
		z0 <= "0100000000011110100000000000100010010110000000000000000111111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.649911
		z0 <= "0100000000011110100110011000001000100100000011111110000010010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.674788
		z0 <= "0100000000011110101100101111101110110010000111111011111100101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.699666
		z0 <= "0100000000011110110011000111010101000000001011111001110111000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.724544
		z0 <= "0100000000011110111001011110111011001110001111110111110001011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.749422
		z0 <= "0100000000011110111111110110100001011100010011110101101011110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.774299
		z0 <= "0100000000011111000110001110000111101010010111110011100110010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.799177
		z0 <= "0100000000011111001100100101101101111000011011110001100000101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.824055
		z0 <= "0100000000011111010010111101010100000110011111101111011011000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.848933
		z0 <= "0100000000011111011001010100111010010100100011101101010101011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.873810
		z0 <= "0100000000011111011111101100100000100010100111101011001111110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.898688
		z0 <= "0100000000011111100110000100000110110000101011101001001010001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.923566
		z0 <= "0100000000011111101100011011101100111110101111100111000100100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.948444
		z0 <= "0100000000011111110010110011010011001100110011100100111110111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.973321
		z0 <= "0100000000011111111001001010111001011010110111100010111001010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 7.998199
		z0 <= "0100000000011111111111100010011111101000111011100000110011101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.023077
		z0 <= "0100000000100000000010111101000010111011011111101111010111000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.047955
		z0 <= "0100000000100000000110001000110110000010100001101110010100010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.072832
		z0 <= "0100000000100000001001010100101001001001100011101101010001011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.097710
		z0 <= "0100000000100000001100100000011100010000100101101100001110101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.122588
		z0 <= "0100000000100000001111101100001111010111100111101011001011110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.147466
		z0 <= "0100000000100000010010111000000010011110101001101010001001000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.172343
		z0 <= "0100000000100000010110000011110101100101101011101001000110001110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.197221
		z0 <= "0100000000100000011001001111101000101100101101101000000011011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.222099
		z0 <= "0100000000100000011100011011011011110011101111100111000000100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.246977
		z0 <= "0100000000100000011111100111001110111010110001100101111101110010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.271854
		z0 <= "0100000000100000100010110011000010000001110011100100111011000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.296732
		z0 <= "0100000000100000100101111110110101001000110101100011111000001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.321610
		z0 <= "0100000000100000101001001010101000001111110111100010110101011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.346488
		z0 <= "0100000000100000101100010110011011010110111001100001110010100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.371365
		z0 <= "0100000000100000101111100010001110011101111011100000101111110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.396243
		z0 <= "0100000000100000110010101110000001100100111101011111101100111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.421121
		z0 <= "0100000000100000110101111001110100101011111111011110101010001010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.445999
		z0 <= "0100000000100000111001000101100111110011000001011101100111010110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.470877
		z0 <= "0100000000100000111100010001011010111010000011011100100100100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.495754
		z0 <= "0100000000100000111111011101001110000001000101011011100001101110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.520632
		z0 <= "0100000000100001000010101001000001001000000111011010011110111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.545510
		z0 <= "0100000000100001000101110100110100001111001001011001011100001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.570388
		z0 <= "0100000000100001001001000000100111010110001011011000011001010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.595265
		z0 <= "0100000000100001001100001100011010011101001101010111010110100010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.620143
		z0 <= "0100000000100001001111011000001101100100001111010110010011101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.645021
		z0 <= "0100000000100001010010100100000000101011010001010101010000111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.669899
		z0 <= "0100000000100001010101101111110011110010010011010100001110000110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.694776
		z0 <= "0100000000100001011000111011100110111001010101010011001011010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.719654
		z0 <= "0100000000100001011100000111011010000000010111010010001000100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.744532
		z0 <= "0100000000100001011111010011001101000111011001010001000101101010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.769410
		z0 <= "0100000000100001100010011111000000001110011011010000000010110110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.794287
		z0 <= "0100000000100001100101101010110011010101011101001111000000000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.819165
		z0 <= "0100000000100001101000110110100110011100011111001101111101010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.844043
		z0 <= "0100000000100001101100000010011001100011100001001100111010011110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.868921
		z0 <= "0100000000100001101111001110001100101010100011001011110111101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.893798
		z0 <= "0100000000100001110010011001111111110001100101001010110100110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.918676
		z0 <= "0100000000100001110101100101110010111000100111001001110010000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.943554
		z0 <= "0100000000100001111000110001100101111111101001001000101111001110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.968432
		z0 <= "0100000000100001111011111101011001000110101011000111101100011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 8.993309
		z0 <= "0100000000100001111111001001001100001101101101000110101001100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.018187
		z0 <= "0100000000100010000010010100111111010100101111000101100110110010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.043065
		z0 <= "0100000000100010000101100000110010011011110001000100100100000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.067943
		z0 <= "0100000000100010001000101100100101100010110011000011100001001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.092820
		z0 <= "0100000000100010001011111000011000101001110101000010011110011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.117698
		z0 <= "0100000000100010001111000100001011110000110111000001011011100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.142576
		z0 <= "0100000000100010010010001111111110110111111001000000011000110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.167454
		z0 <= "0100000000100010010101011011110001111110111010111111010101111110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.192331
		z0 <= "0100000000100010011000100111100101000101111100111110010011001010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.217209
		z0 <= "0100000000100010011011110011011000001100111110111101010000011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.242087
		z0 <= "0100000000100010011110111111001011010100000000111100001101100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.266965
		z0 <= "0100000000100010100010001010111110011011000010111011001010101110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.291843
		z0 <= "0100000000100010100101010110110001100010000100111010000111111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.316720
		z0 <= "0100000000100010101000100010100100101001000110111001000101001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.341598
		z0 <= "0100000000100010101011101110010111110000001000111000000010010110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.366476
		z0 <= "0100000000100010101110111010001010110111001010110110111111100010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.391354
		z0 <= "0100000000100010110010000101111101111110001100110101111100101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.416231
		z0 <= "0100000000100010110101010001110001000101001110110100111001111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.441109
		z0 <= "0100000000100010111000011101100100001100010000110011110111000110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.465987
		z0 <= "0100000000100010111011101001010111010011010010110010110100010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.490865
		z0 <= "0100000000100010111110110101001010011010010100110001110001100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.515742
		z0 <= "0100000000100011000010000000111101100001010110110000101110101010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.540620
		z0 <= "0100000000100011000101001100110000101000011000101111101011111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.565498
		z0 <= "0100000000100011001000011000100011101111011010101110101001000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.590376
		z0 <= "0100000000100011001011100100010110110110011100101101100110010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.615253
		z0 <= "0100000000100011001110110000001001111101011110101100100011011110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.640131
		z0 <= "0100000000100011010001111011111101000100100000101011100000101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.665009
		z0 <= "0100000000100011010101000111110000001011100010101010011101110110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.689887
		z0 <= "0100000000100011011000010011100011010010100100101001011011000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.714764
		z0 <= "0100000000100011011011011111010110011001100110101000011000010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.739642
		z0 <= "0100000000100011011110101011001001100000101000100111010101011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.764520
		z0 <= "0100000000100011100001110110111100100111101010100110010010101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.789398
		z0 <= "0100000000100011100101000010101111101110101100100101001111110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.814275
		z0 <= "0100000000100011101000001110100010110101101110100100001101000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.839153
		z0 <= "0100000000100011101011011010010101111100110000100011001010001110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.864031
		z0 <= "0100000000100011101110100110001001000011110010100010000111011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.888909
		z0 <= "0100000000100011110001110001111100001010110100100001000100100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.913786
		z0 <= "0100000000100011110100111101101111010001110110100000000001110010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.938664
		z0 <= "0100000000100011111000001001100010011000111000011110111110111110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.963542
		z0 <= "0100000000100011111011010101010101011111111010011101111100001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 9.988420
		z0 <= "0100000000100011111110100001001000100110111100011100111001011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.013297
		z0 <= "0100000000100100000001101100111011101101111110011011110110100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.038175
		z0 <= "0100000000100100000100111000101110110101000000011010110011110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.063053
		z0 <= "0100000000100100001000000100100001111100000010011001110000111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.087931
		z0 <= "0100000000100100001011010000010101000011000100011000101110001010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.112809
		z0 <= "0100000000100100001110011100001000001010000110010111101011010110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.137686
		z0 <= "0100000000100100010001100111111011010001001000010110101000100010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.162564
		z0 <= "0100000000100100010100110011101110011000001010010101100101101110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.187442
		z0 <= "0100000000100100010111111111100001011111001100010100100010111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.212320
		z0 <= "0100000000100100011011001011010100100110001110010011100000001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.237197
		z0 <= "0100000000100100011110010111000111101101010000010010011101010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.262075
		z0 <= "0100000000100100100001100010111010110100010010010001011010100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.286953
		z0 <= "0100000000100100100100101110101101111011010100010000010111101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.311831
		z0 <= "0100000000100100100111111010100001000010010110001111010100111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.336708
		z0 <= "0100000000100100101011000110010100001001011000001110010010000110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.361586
		z0 <= "0100000000100100101110010010000111010000011010001101001111010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.386464
		z0 <= "0100000000100100110001011101111010010111011100001100001100011110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.411342
		z0 <= "0100000000100100110100101001101101011110011110001011001001101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.436219
		z0 <= "0100000000100100110111110101100000100101100000001010000110110110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.461097
		z0 <= "0100000000100100111011000001010011101100100010001001000100000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.485975
		z0 <= "0100000000100100111110001101000110110011100100001000000001010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.510853
		z0 <= "0100000000100101000001011000111001111010100110000110111110011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.535730
		z0 <= "0100000000100101000100100100101101000001101000000101111011101010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.560608
		z0 <= "0100000000100101000111110000100000001000101010000100111000110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.585486
		z0 <= "0100000000100101001010111100010011001111101100000011110110000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.610364
		z0 <= "0100000000100101001110001000000110010110101110000010110011001110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.635241
		z0 <= "0100000000100101010001010011111001011101110000000001110000011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.660119
		z0 <= "0100000000100101010100011111101100100100110010000000101101101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.684997
		z0 <= "0100000000100101010111101011011111101011110011111111101010110010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.709875
		z0 <= "0100000000100101011010110111010010110010110101111110101000000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.734752
		z0 <= "0100000000100101011110000011000101111001110111111101100101001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.759630
		z0 <= "0100000000100101100001001110111001000000111001111100100010011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.784508
		z0 <= "0100000000100101100100011010101100000111111011111011011111100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.809386
		z0 <= "0100000000100101100111100110011111001110111101111010011100110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.834264
		z0 <= "0100000000100101101010110010010010010101111111111001011001111110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.859141
		z0 <= "0100000000100101101101111110000101011101000001111000010111001010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.884019
		z0 <= "0100000000100101110001001001111000100100000011110111010100010110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.908897
		z0 <= "0100000000100101110100010101101011101011000101110110010001100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.933775
		z0 <= "0100000000100101110111100001011110110010000111110101001110101110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.958652
		z0 <= "0100000000100101111010101101010001111001001001110100001011111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 10.983530
		z0 <= "0100000000100101111101111001000101000000001011110011001001001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.008408
		z0 <= "0100000000100110000001000100111000000111001101110010000110010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.033286
		z0 <= "0100000000100110000100010000101011001110001111110001000011100010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.058163
		z0 <= "0100000000100110000111011100011110010101010001110000000000101110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.083041
		z0 <= "0100000000100110001010101000010001011100010011101110111101111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.107919
		z0 <= "0100000000100110001101110100000100100011010101101101111011000110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.132797
		z0 <= "0100000000100110010000111111110111101010010111101100111000010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.157674
		z0 <= "0100000000100110010100001011101010110001011001101011110101100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.182552
		z0 <= "0100000000100110010111010111011101111000011011101010110010101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.207430
		z0 <= "0100000000100110011010100011010000111111011101101001101111111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.232308
		z0 <= "0100000000100110011101101111000100000110011111101000101101000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.257185
		z0 <= "0100000000100110100000111010110111001101100001100111101010010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.282063
		z0 <= "0100000000100110100100000110101010010100100011100110100111011110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.306941
		z0 <= "0100000000100110100111010010011101011011100101100101100100101010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.331819
		z0 <= "0100000000100110101010011110010000100010100111100100100001110110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.356696
		z0 <= "0100000000100110101101101010000011101001101001100011011111000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.381574
		z0 <= "0100000000100110110000110101110110110000101011100010011100001110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.406452
		z0 <= "0100000000100110110100000001101001110111101101100001011001011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.431330
		z0 <= "0100000000100110110111001101011100111110101111100000010110101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.456207
		z0 <= "0100000000100110111010011001010000000101110001011111010011110010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.481085
		z0 <= "0100000000100110111101100101000011001100110011011110010001000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.505963
		z0 <= "0100000000100111000000110000110110010011110101011101001110001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.530841
		z0 <= "0100000000100111000011111100101001011010110111011100001011011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.555718
		z0 <= "0100000000100111000111001000011100100001111001011011001000100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.580596
		z0 <= "0100000000100111001010010100001111101000111011011010000101110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.605474
		z0 <= "0100000000100111001101100000000010101111111101011001000010111110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.630352
		z0 <= "0100000000100111010000101011110101110110111111011000000000001010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.655230
		z0 <= "0100000000100111010011110111101000111110000001010110111101011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.680107
		z0 <= "0100000000100111010111000011011100000101000011010101111010100100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.704985
		z0 <= "0100000000100111011010001111001111001100000101010100110111110000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.729863
		z0 <= "0100000000100111011101011011000010010011000111010011110100111100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.754741
		z0 <= "0100000000100111100000100110110101011010001001010010110010001000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.779618
		z0 <= "0100000000100111100011110010101000100001001011010001101111010110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.804496
		z0 <= "0100000000100111100110111110011011101000001101010000101100100010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.829374
		z0 <= "0100000000100111101010001010001110101111001111001111101001101110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.854252
		z0 <= "0100000000100111101101010110000001110110010001001110100110111010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.879129
		z0 <= "0100000000100111110000100001110100111101010011001101100100000110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.904007
		z0 <= "0100000000100111110011101101101000000100010101001100100001010100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.928885
		z0 <= "0100000000100111110110111001011011001011010111001011011110100000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.953763
		z0 <= "0100000000100111111010000101001110010010011001001010011011101100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 11.978640
		z0 <= "0100000000100111111101010001000001011001011011001001011000111000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.003518
		z0 <= "0100000000101000000000011100110100100000011101001000010110000100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.028396
		z0 <= "0100000000101000000011101000100111100111011111000111010011010010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.053274
		z0 <= "0100000000101000000110110100011010101110100001000110010000011110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.078151
		z0 <= "0100000000101000001010000000001101110101100011000101001101101010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.103029
		z0 <= "0100000000101000001101001100000000111100100101000100001010110110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.127907
		z0 <= "0100000000101000010000010111110100000011100111000011001000000010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.152785
		z0 <= "0100000000101000010011100011100111001010101001000010000101010000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.177662
		z0 <= "0100000000101000010110101111011010010001101011000001000010011100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.202540
		z0 <= "0100000000101000011001111011001101011000101100111111111111101000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.227418
		z0 <= "0100000000101000011101000111000000011111101110111110111100110110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.252296
		z0 <= "0100000000101000100000010010110011100110110000111101111010000000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.277173
		z0 <= "0100000000101000100011011110100110101101110010111100110111001110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.302051
		z0 <= "0100000000101000100110101010011001110100110100111011110100011010";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.326929
		z0 <= "0100000000101000101001110110001100111011110110111010110001100110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.351807
		z0 <= "0100000000101000101101000010000000000010111000111001101110110100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.376684
		z0 <= "0100000000101000110000001101110011001001111010111000101011111110";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.401562
		z0 <= "0100000000101000110011011001100110010000111100110111101001001100";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

		--z0 := 12.426440
		z0 <= "0100000000101000110110100101011001010111111110110110100110011000";
		start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
		write(L1,xn);
		writeline(test_out_data1,L1);
		write(L2,yn);
		writeline(test_out_data2,L2);

	stop(0);
	end process;
end Behavioral;
