library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use std.textio.all;
use ieee.std_logic_textio.all;
library std;
use std.env.all;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity Fixed_xToTheY_Generic_tb is
 end Fixed_xToTheY_Generic_tb;

architecture Behavioral of Fixed_xToTheY_Generic_tb is
	component Fixed_xToTheY is
		Generic ( filename1, filename2 : string; intWidth, fracWidth, iterWidth, M, N : integer );
		Port ( x, y, InverseScalingFactor : in std_logic_vector(intWidth+fracWidth-1 downto 0);
			clk, start : in std_logic;
			output : out std_logic_vector(intWidth+fracWidth-1 downto 0);
			done : out std_logic );
	end component;

	constant file1 : string := "44_32BitExpandedLUT_Fixed.txt";
	constant file2 : string := "44_32BitLUT_Fixed.txt";
	constant intWidth : integer := 44;
	constant fracWidth : integer := 32;
	constant iterWidth : integer := 6;
	constant M : integer := 5;
	constant N : integer := 32;

	signal clk, start, done : std_logic;
	signal x, y, InvScalFact, output : std_logic_vector (intWidth+fracWidth-1 downto 0);

	begin

		myXToTheY : Fixed_xToTheY Generic Map(fileName1 => file1, fileName2 => file2,
				intWidth => intWidth, fracWidth => fracWidth, iterWidth => iterWidth, M => M, N => N)
		Port Map(x => x, y => y, InverseScalingFactor => InvScalFact, clk => clk, start => start, output => output, done => done);

		clkProc : process begin
			clk <= '0'; wait for 1 ns;
			clk <= '1'; wait for 1 ns;
		end process;

	testProc : process
		FILE test_out_data1: TEXT open WRITE_MODE is "32iterations76bits_xToTheY_Fixed.txt";
		variable L1              : LINE;
	begin

		--InvScalFact := 1988.741085
		InvScalFact <= "0000000000000000000000000000000001111100010010111101101101111100000011101110";

		-------------------------Begin Testing----------------------------
		-- Iteration 1
		-- 0.000004
		x <= "0000000000000000000000000000000000000000000000000000000000000100001101001011";
		-- 1.000000
		y <= "0000000000000000000000000000000000000000000100000000000000000000000000000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 2
		-- 0.000004
		x <= "0000000000000000000000000000000000000000000000000000000000000100001101001011";
		-- 0.777778
		y <= "0000000000000000000000000000000000000000000011000111000111000111000111000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 3
		-- 0.000004
		x <= "0000000000000000000000000000000000000000000000000000000000000100001101001011";
		-- 0.555556
		y <= "0000000000000000000000000000000000000000000010001110001110001110001110001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 4
		-- 0.000004
		x <= "0000000000000000000000000000000000000000000000000000000000000100001101001011";
		-- 0.333333
		y <= "0000000000000000000000000000000000000000000001010101010101010101010101010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 5
		-- 0.000004
		x <= "0000000000000000000000000000000000000000000000000000000000000100001101001011";
		-- 0.111111
		y <= "0000000000000000000000000000000000000000000000011100011100011100011100011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 6
		-- 0.000004
		x <= "0000000000000000000000000000000000000000000000000000000000000100001101001011";
		-- -0.111111
		y <= "1111111111111111111111111111111111111111111111100011100011100011100011100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 7
		-- 0.000004
		x <= "0000000000000000000000000000000000000000000000000000000000000100001101001011";
		-- -0.333333
		y <= "1111111111111111111111111111111111111111111110101010101010101010101010101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 8
		-- 0.000004
		x <= "0000000000000000000000000000000000000000000000000000000000000100001101001011";
		-- -0.555556
		y <= "1111111111111111111111111111111111111111111101110001110001110001110001110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 9
		-- 0.000004
		x <= "0000000000000000000000000000000000000000000000000000000000000100001101001011";
		-- -0.777778
		y <= "1111111111111111111111111111111111111111111100111000111000111000111000111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 10
		-- 0.000004
		x <= "0000000000000000000000000000000000000000000000000000000000000100001101001011";
		-- -1.000000
		y <= "1111111111111111111111111111111111111111111100000000000000000000000000000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 11
		-- 1673.200764
		x <= "0000000000000000000000000000000001101000100100110011011001010100110000111010";
		-- -1.674160
		y <= "1111111111111111111111111111111111111111111001010011011010100100010010110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 12
		-- 1673.200764
		x <= "0000000000000000000000000000000001101000100100110011011001010100110000111010";
		-- -1.302124
		y <= "1111111111111111111111111111111111111111111010110010101001111111110010001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 13
		-- 1673.200764
		x <= "0000000000000000000000000000000001101000100100110011011001010100110000111010";
		-- -0.930089
		y <= "1111111111111111111111111111111111111111111100010001111001011011010001100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 14
		-- 1673.200764
		x <= "0000000000000000000000000000000001101000100100110011011001010100110000111010";
		-- -0.558053
		y <= "1111111111111111111111111111111111111111111101110001001000110110110000111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 15
		-- 1673.200764
		x <= "0000000000000000000000000000000001101000100100110011011001010100110000111010";
		-- -0.186018
		y <= "1111111111111111111111111111111111111111111111010000011000010010010000010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 16
		-- 1673.200764
		x <= "0000000000000000000000000000000001101000100100110011011001010100110000111010";
		-- 0.186018
		y <= "0000000000000000000000000000000000000000000000101111100111101101101111101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 17
		-- 1673.200764
		x <= "0000000000000000000000000000000001101000100100110011011001010100110000111010";
		-- 0.558053
		y <= "0000000000000000000000000000000000000000000010001110110111001001001111000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 18
		-- 1673.200764
		x <= "0000000000000000000000000000000001101000100100110011011001010100110000111010";
		-- 0.930089
		y <= "0000000000000000000000000000000000000000000011101110000110100100101110011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 19
		-- 1673.200764
		x <= "0000000000000000000000000000000001101000100100110011011001010100110000111010";
		-- 1.302124
		y <= "0000000000000000000000000000000000000000000101001101010110000000001101110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 20
		-- 1673.200764
		x <= "0000000000000000000000000000000001101000100100110011011001010100110000111010";
		-- 1.674160
		y <= "0000000000000000000000000000000000000000000110101100100101011011101101001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 21
		-- 3346.401525
		x <= "0000000000000000000000000000000011010001001001100110110010100101010100101000";
		-- -1.531172
		y <= "1111111111111111111111111111111111111111111001111000000001010010000011100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 22
		-- 3346.401525
		x <= "0000000000000000000000000000000011010001001001100110110010100101010100101000";
		-- -1.190911
		y <= "1111111111111111111111111111111111111111111011001111001000000110111011101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 23
		-- 3346.401525
		x <= "0000000000000000000000000000000011010001001001100110110010100101010100101000";
		-- -0.850651
		y <= "1111111111111111111111111111111111111111111100100110001110111011110011110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 24
		-- 3346.401525
		x <= "0000000000000000000000000000000011010001001001100110110010100101010100101000";
		-- -0.510391
		y <= "1111111111111111111111111111111111111111111101111101010101110000101011110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 25
		-- 3346.401525
		x <= "0000000000000000000000000000000011010001001001100110110010100101010100101000";
		-- -0.170130
		y <= "1111111111111111111111111111111111111111111111010100011100100101100011111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 26
		-- 3346.401525
		x <= "0000000000000000000000000000000011010001001001100110110010100101010100101000";
		-- 0.170130
		y <= "0000000000000000000000000000000000000000000000101011100011011010011100000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 27
		-- 3346.401525
		x <= "0000000000000000000000000000000011010001001001100110110010100101010100101000";
		-- 0.510391
		y <= "0000000000000000000000000000000000000000000010000010101010001111010100001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 28
		-- 3346.401525
		x <= "0000000000000000000000000000000011010001001001100110110010100101010100101000";
		-- 0.850651
		y <= "0000000000000000000000000000000000000000000011011001110001000100001100001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 29
		-- 3346.401525
		x <= "0000000000000000000000000000000011010001001001100110110010100101010100101000";
		-- 1.190911
		y <= "0000000000000000000000000000000000000000000100110000110111111001000100010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 30
		-- 3346.401525
		x <= "0000000000000000000000000000000011010001001001100110110010100101010100101000";
		-- 1.531172
		y <= "0000000000000000000000000000000000000000000110000111111110101101111100011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 31
		-- 5019.602285
		x <= "0000000000000000000000000000000100111001101110011010001011110101111000010111";
		-- -1.458313
		y <= "1111111111111111111111111111111111111111111010001010101010111111111100010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 32
		-- 5019.602285
		x <= "0000000000000000000000000000000100111001101110011010001011110101111000010111";
		-- -1.134243
		y <= "1111111111111111111111111111111111111111111011011101101000100011100000101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 33
		-- 5019.602285
		x <= "0000000000000000000000000000000100111001101110011010001011110101111000010111";
		-- -0.810174
		y <= "1111111111111111111111111111111111111111111100110000100110000111000101000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 34
		-- 5019.602285
		x <= "0000000000000000000000000000000100111001101110011010001011110101111000010111";
		-- -0.486104
		y <= "1111111111111111111111111111111111111111111110000011100011101010101001011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 35
		-- 5019.602285
		x <= "0000000000000000000000000000000100111001101110011010001011110101111000010111";
		-- -0.162035
		y <= "1111111111111111111111111111111111111111111111010110100001001110001101110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 36
		-- 5019.602285
		x <= "0000000000000000000000000000000100111001101110011010001011110101111000010111";
		-- 0.162035
		y <= "0000000000000000000000000000000000000000000000101001011110110001110010001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 37
		-- 5019.602285
		x <= "0000000000000000000000000000000100111001101110011010001011110101111000010111";
		-- 0.486104
		y <= "0000000000000000000000000000000000000000000001111100011100010101010110100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 38
		-- 5019.602285
		x <= "0000000000000000000000000000000100111001101110011010001011110101111000010111";
		-- 0.810174
		y <= "0000000000000000000000000000000000000000000011001111011001111000111010111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 39
		-- 5019.602285
		x <= "0000000000000000000000000000000100111001101110011010001011110101111000010111";
		-- 1.134243
		y <= "0000000000000000000000000000000000000000000100100010010111011100011111010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 40
		-- 5019.602285
		x <= "0000000000000000000000000000000100111001101110011010001011110101111000010111";
		-- 1.458313
		y <= "0000000000000000000000000000000000000000000101110101010101000000000011101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 41
		-- 6692.803046
		x <= "0000000000000000000000000000000110100010010011001101100101000110011100000101";
		-- -1.410687
		y <= "1111111111111111111111111111111111111111111010010110110111010011110011010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 42
		-- 6692.803046
		x <= "0000000000000000000000000000000110100010010011001101100101000110011100000101";
		-- -1.097201
		y <= "1111111111111111111111111111111111111111111011100111000111011101100111111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 43
		-- 6692.803046
		x <= "0000000000000000000000000000000110100010010011001101100101000110011100000101";
		-- -0.783715
		y <= "1111111111111111111111111111111111111111111100110111010111100111011100011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 44
		-- 6692.803046
		x <= "0000000000000000000000000000000110100010010011001101100101000110011100000101";
		-- -0.470229
		y <= "1111111111111111111111111111111111111111111110000111100111110001010001000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 45
		-- 6692.803046
		x <= "0000000000000000000000000000000110100010010011001101100101000110011100000101";
		-- -0.156743
		y <= "1111111111111111111111111111111111111111111111010111110111111011000101101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 46
		-- 6692.803046
		x <= "0000000000000000000000000000000110100010010011001101100101000110011100000101";
		-- 0.156743
		y <= "0000000000000000000000000000000000000000000000101000001000000100111010010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 47
		-- 6692.803046
		x <= "0000000000000000000000000000000110100010010011001101100101000110011100000101";
		-- 0.470229
		y <= "0000000000000000000000000000000000000000000001111000011000001110101110111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 48
		-- 6692.803046
		x <= "0000000000000000000000000000000110100010010011001101100101000110011100000101";
		-- 0.783715
		y <= "0000000000000000000000000000000000000000000011001000101000011000100011100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 49
		-- 6692.803046
		x <= "0000000000000000000000000000000110100010010011001101100101000110011100000101";
		-- 1.097201
		y <= "0000000000000000000000000000000000000000000100011000111000100010011000000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 50
		-- 6692.803046
		x <= "0000000000000000000000000000000110100010010011001101100101000110011100000101";
		-- 1.410687
		y <= "0000000000000000000000000000000000000000000101101001001000101100001100101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 51
		-- 8366.003806
		x <= "0000000000000000000000000000001000001010111000000000111110010110111111110100";
		-- -1.375834
		y <= "1111111111111111111111111111111111111111111010011111110010010101010100101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 52
		-- 8366.003806
		x <= "0000000000000000000000000000001000001010111000000000111110010110111111110100";
		-- -1.070093
		y <= "1111111111111111111111111111111111111111111011101110000011100101111010110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 53
		-- 8366.003806
		x <= "0000000000000000000000000000001000001010111000000000111110010110111111110100";
		-- -0.764352
		y <= "1111111111111111111111111111111111111111111100111100010100110110100000110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 54
		-- 8366.003806
		x <= "0000000000000000000000000000001000001010111000000000111110010110111111110100";
		-- -0.458611
		y <= "1111111111111111111111111111111111111111111110001010100110000111000110111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 55
		-- 8366.003806
		x <= "0000000000000000000000000000001000001010111000000000111110010110111111110100";
		-- -0.152870
		y <= "1111111111111111111111111111111111111111111111011000110111010111101100111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 56
		-- 8366.003806
		x <= "0000000000000000000000000000001000001010111000000000111110010110111111110100";
		-- 0.152870
		y <= "0000000000000000000000000000000000000000000000100111001000101000010011000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 57
		-- 8366.003806
		x <= "0000000000000000000000000000001000001010111000000000111110010110111111110100";
		-- 0.458611
		y <= "0000000000000000000000000000000000000000000001110101011001111000111001000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 58
		-- 8366.003806
		x <= "0000000000000000000000000000001000001010111000000000111110010110111111110100";
		-- 0.764352
		y <= "0000000000000000000000000000000000000000000011000011101011001001011111001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 59
		-- 8366.003806
		x <= "0000000000000000000000000000001000001010111000000000111110010110111111110100";
		-- 1.070093
		y <= "0000000000000000000000000000000000000000000100010001111100011010000101001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 60
		-- 8366.003806
		x <= "0000000000000000000000000000001000001010111000000000111110010110111111110100";
		-- 1.375834
		y <= "0000000000000000000000000000000000000000000101100000001101101010101011010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 61
		-- 10039.204567
		x <= "0000000000000000000000000000001001110011011100110100010111100111100011100010";
		-- -1.348611
		y <= "1111111111111111111111111111111111111111111010100110110000010111001110111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 62
		-- 10039.204567
		x <= "0000000000000000000000000000001001110011011100110100010111100111100011100010";
		-- -1.048919
		y <= "1111111111111111111111111111111111111111111011110011011110100000010010101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 63
		-- 10039.204567
		x <= "0000000000000000000000000000001001110011011100110100010111100111100011100010";
		-- -0.749228
		y <= "1111111111111111111111111111111111111111111101000000001100101001010110100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 64
		-- 10039.204567
		x <= "0000000000000000000000000000001001110011011100110100010111100111100011100010";
		-- -0.449537
		y <= "1111111111111111111111111111111111111111111110001100111010110010011010010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 65
		-- 10039.204567
		x <= "0000000000000000000000000000001001110011011100110100010111100111100011100010";
		-- -0.149846
		y <= "1111111111111111111111111111111111111111111111011001101000111011011110000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 66
		-- 10039.204567
		x <= "0000000000000000000000000000001001110011011100110100010111100111100011100010";
		-- 0.149846
		y <= "0000000000000000000000000000000000000000000000100110010111000100100001111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 67
		-- 10039.204567
		x <= "0000000000000000000000000000001001110011011100110100010111100111100011100010";
		-- 0.449537
		y <= "0000000000000000000000000000000000000000000001110011000101001101100101101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 68
		-- 10039.204567
		x <= "0000000000000000000000000000001001110011011100110100010111100111100011100010";
		-- 0.749228
		y <= "0000000000000000000000000000000000000000000010111111110011010110101001011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 69
		-- 10039.204567
		x <= "0000000000000000000000000000001001110011011100110100010111100111100011100010";
		-- 1.048919
		y <= "0000000000000000000000000000000000000000000100001100100001011111101101010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 70
		-- 10039.204567
		x <= "0000000000000000000000000000001001110011011100110100010111100111100011100010";
		-- 1.348611
		y <= "0000000000000000000000000000000000000000000101011001001111101000110001000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 71
		-- 11712.405327
		x <= "0000000000000000000000000000001011011100000001100111110000111000000111010001";
		-- -1.326420
		y <= "1111111111111111111111111111111111111111111010101100011011111011100111111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 72
		-- 11712.405327
		x <= "0000000000000000000000000000001011011100000001100111110000111000000111010001";
		-- -1.031660
		y <= "1111111111111111111111111111111111111111111011110111111001010001111011011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 73
		-- 11712.405327
		x <= "0000000000000000000000000000001011011100000001100111110000111000000111010001";
		-- -0.736900
		y <= "1111111111111111111111111111111111111111111101000011010110101000001111000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 74
		-- 11712.405327
		x <= "0000000000000000000000000000001011011100000001100111110000111000000111010001";
		-- -0.442140
		y <= "1111111111111111111111111111111111111111111110001110110011111110100010101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 75
		-- 11712.405327
		x <= "0000000000000000000000000000001011011100000001100111110000111000000111010001";
		-- -0.147380
		y <= "1111111111111111111111111111111111111111111111011010010001010100110110001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 76
		-- 11712.405327
		x <= "0000000000000000000000000000001011011100000001100111110000111000000111010001";
		-- 0.147380
		y <= "0000000000000000000000000000000000000000000000100101101110101011001001110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 77
		-- 11712.405327
		x <= "0000000000000000000000000000001011011100000001100111110000111000000111010001";
		-- 0.442140
		y <= "0000000000000000000000000000000000000000000001110001001100000001011101010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 78
		-- 11712.405327
		x <= "0000000000000000000000000000001011011100000001100111110000111000000111010001";
		-- 0.736900
		y <= "0000000000000000000000000000000000000000000010111100101001010111110000111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 79
		-- 11712.405327
		x <= "0000000000000000000000000000001011011100000001100111110000111000000111010001";
		-- 1.031660
		y <= "0000000000000000000000000000000000000000000100001000000110101110000100100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 80
		-- 11712.405327
		x <= "0000000000000000000000000000001011011100000001100111110000111000000111010001";
		-- 1.326420
		y <= "0000000000000000000000000000000000000000000101010011100100000100011000000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 81
		-- 13385.606087
		x <= "0000000000000000000000000000001101000100100110011011001010001000101010111111";
		-- -1.307780
		y <= "1111111111111111111111111111111111111111111010110001001101010101010111111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 82
		-- 13385.606087
		x <= "0000000000000000000000000000001101000100100110011011001010001000101010111111";
		-- -1.017162
		y <= "1111111111111111111111111111111111111111111011111011100110110100001011100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 83
		-- 13385.606087
		x <= "0000000000000000000000000000001101000100100110011011001010001000101010111111";
		-- -0.726544
		y <= "1111111111111111111111111111111111111111111101000110000000010010111111000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 84
		-- 13385.606087
		x <= "0000000000000000000000000000001101000100100110011011001010001000101010111111";
		-- -0.435927
		y <= "1111111111111111111111111111111111111111111110010000011001110001110010101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 85
		-- 13385.606087
		x <= "0000000000000000000000000000001101000100100110011011001010001000101010111111";
		-- -0.145309
		y <= "1111111111111111111111111111111111111111111111011010110011010000100110001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 86
		-- 13385.606087
		x <= "0000000000000000000000000000001101000100100110011011001010001000101010111111";
		-- 0.145309
		y <= "0000000000000000000000000000000000000000000000100101001100101111011001110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 87
		-- 13385.606087
		x <= "0000000000000000000000000000001101000100100110011011001010001000101010111111";
		-- 0.435927
		y <= "0000000000000000000000000000000000000000000001101111100110001110001101010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 88
		-- 13385.606087
		x <= "0000000000000000000000000000001101000100100110011011001010001000101010111111";
		-- 0.726544
		y <= "0000000000000000000000000000000000000000000010111001111111101101000000111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 89
		-- 13385.606087
		x <= "0000000000000000000000000000001101000100100110011011001010001000101010111111";
		-- 1.017162
		y <= "0000000000000000000000000000000000000000000100000100011001001011110100011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 90
		-- 13385.606087
		x <= "0000000000000000000000000000001101000100100110011011001010001000101010111111";
		-- 1.307780
		y <= "0000000000000000000000000000000000000000000101001110110010101010101000000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 91
		-- 15058.806848
		x <= "0000000000000000000000000000001110101101001011001110100011011001001110101110";
		-- -1.291768
		y <= "1111111111111111111111111111111111111111111010110101010011101011100010011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 92
		-- 15058.806848
		x <= "0000000000000000000000000000001110101101001011001110100011011001001110101110";
		-- -1.004708
		y <= "1111111111111111111111111111111111111111111011111110110010110111001100100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 93
		-- 15058.806848
		x <= "0000000000000000000000000000001110101101001011001110100011011001001110101110";
		-- -0.717649
		y <= "1111111111111111111111111111111111111111111101001000010010000010110110101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 94
		-- 15058.806848
		x <= "0000000000000000000000000000001110101101001011001110100011011001001110101110";
		-- -0.430589
		y <= "1111111111111111111111111111111111111111111110010001110001001110100000110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 95
		-- 15058.806848
		x <= "0000000000000000000000000000001110101101001011001110100011011001001110101110";
		-- -0.143530
		y <= "1111111111111111111111111111111111111111111111011011010000011010001010111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 96
		-- 15058.806848
		x <= "0000000000000000000000000000001110101101001011001110100011011001001110101110";
		-- 0.143530
		y <= "0000000000000000000000000000000000000000000000100100101111100101110101000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 97
		-- 15058.806848
		x <= "0000000000000000000000000000001110101101001011001110100011011001001110101110";
		-- 0.430589
		y <= "0000000000000000000000000000000000000000000001101110001110110001011111001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 98
		-- 15058.806848
		x <= "0000000000000000000000000000001110101101001011001110100011011001001110101110";
		-- 0.717649
		y <= "0000000000000000000000000000000000000000000010110111101101111101001001010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 99
		-- 15058.806848
		x <= "0000000000000000000000000000001110101101001011001110100011011001001110101110";
		-- 1.004708
		y <= "0000000000000000000000000000000000000000000100000001001101001000110011011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 100
		-- 15058.806848
		x <= "0000000000000000000000000000001110101101001011001110100011011001001110101110";
		-- 1.291768
		y <= "0000000000000000000000000000000000000000000101001010101100010100011101100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 101
		-- 16732.007608
		x <= "0000000000000000000000000000010000010101110000000001111100101001110010011100";
		-- -1.277773
		y <= "1111111111111111111111111111111111111111111010111000111000111110001110111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 102
		-- 16732.007608
		x <= "0000000000000000000000000000010000010101110000000001111100101001110010011100";
		-- -0.993823
		y <= "1111111111111111111111111111111111111111111100000001100101001100110110010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 103
		-- 16732.007608
		x <= "0000000000000000000000000000010000010101110000000001111100101001110010011100";
		-- -0.709874
		y <= "1111111111111111111111111111111111111111111101001010010001011011011101100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 104
		-- 16732.007608
		x <= "0000000000000000000000000000010000010101110000000001111100101001110010011100";
		-- -0.425924
		y <= "1111111111111111111111111111111111111111111110010010111101101010000100111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 105
		-- 16732.007608
		x <= "0000000000000000000000000000010000010101110000000001111100101001110010011100";
		-- -0.141975
		y <= "1111111111111111111111111111111111111111111111011011101001111000101100010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 106
		-- 16732.007608
		x <= "0000000000000000000000000000010000010101110000000001111100101001110010011100";
		-- 0.141975
		y <= "0000000000000000000000000000000000000000000000100100010110000111010011101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 107
		-- 16732.007608
		x <= "0000000000000000000000000000010000010101110000000001111100101001110010011100";
		-- 0.425924
		y <= "0000000000000000000000000000000000000000000001101101000010010101111011000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 108
		-- 16732.007608
		x <= "0000000000000000000000000000010000010101110000000001111100101001110010011100";
		-- 0.709874
		y <= "0000000000000000000000000000000000000000000010110101101110100100100010011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 109
		-- 16732.007608
		x <= "0000000000000000000000000000010000010101110000000001111100101001110010011100";
		-- 0.993823
		y <= "0000000000000000000000000000000000000000000011111110011010110011001001101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 110
		-- 16732.007608
		x <= "0000000000000000000000000000010000010101110000000001111100101001110010011100";
		-- 1.277773
		y <= "0000000000000000000000000000000000000000000101000111000111000001110001000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 111
		-- 18405.208369
		x <= "0000000000000000000000000000010001111110010100110101010101111010010110001010";
		-- -1.265371
		y <= "1111111111111111111111111111111111111111111010111100000100001001110110010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 112
		-- 18405.208369
		x <= "0000000000000000000000000000010001111110010100110101010101111010010110001010";
		-- -0.984178
		y <= "1111111111111111111111111111111111111111111100000100000011001110110001010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 113
		-- 18405.208369
		x <= "0000000000000000000000000000010001111110010100110101010101111010010110001010";
		-- -0.702984
		y <= "1111111111111111111111111111111111111111111101001100000010010011101100010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 114
		-- 18405.208369
		x <= "0000000000000000000000000000010001111110010100110101010101111010010110001010";
		-- -0.421790
		y <= "1111111111111111111111111111111111111111111110010100000001011000100111011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 115
		-- 18405.208369
		x <= "0000000000000000000000000000010001111110010100110101010101111010010110001010";
		-- -0.140597
		y <= "1111111111111111111111111111111111111111111111011100000000011101100010011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 116
		-- 18405.208369
		x <= "0000000000000000000000000000010001111110010100110101010101111010010110001010";
		-- 0.140597
		y <= "0000000000000000000000000000000000000000000000100011111111100010011101100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 117
		-- 18405.208369
		x <= "0000000000000000000000000000010001111110010100110101010101111010010110001010";
		-- 0.421790
		y <= "0000000000000000000000000000000000000000000001101011111110100111011000100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 118
		-- 18405.208369
		x <= "0000000000000000000000000000010001111110010100110101010101111010010110001010";
		-- 0.702984
		y <= "0000000000000000000000000000000000000000000010110011111101101100010011101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 119
		-- 18405.208369
		x <= "0000000000000000000000000000010001111110010100110101010101111010010110001010";
		-- 0.984178
		y <= "0000000000000000000000000000000000000000000011111011111100110001001110101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 120
		-- 18405.208369
		x <= "0000000000000000000000000000010001111110010100110101010101111010010110001010";
		-- 1.265371
		y <= "0000000000000000000000000000000000000000000101000011111011110110001001101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 121
		-- 20078.409129
		x <= "0000000000000000000000000000010011100110111001101000101111001010111001111001";
		-- -1.254258
		y <= "1111111111111111111111111111111111111111111010111110111010001110110000010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 122
		-- 20078.409129
		x <= "0000000000000000000000000000010011100110111001101000101111001010111001111001";
		-- -0.975534
		y <= "1111111111111111111111111111111111111111111100000110010000110110001001001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 123
		-- 20078.409129
		x <= "0000000000000000000000000000010011100110111001101000101111001010111001111001";
		-- -0.696810
		y <= "1111111111111111111111111111111111111111111101001101100111011101100001111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 124
		-- 20078.409129
		x <= "0000000000000000000000000000010011100110111001101000101111001010111001111001";
		-- -0.418086
		y <= "1111111111111111111111111111111111111111111110010100111110000100111010110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 125
		-- 20078.409129
		x <= "0000000000000000000000000000010011100110111001101000101111001010111001111001";
		-- -0.139362
		y <= "1111111111111111111111111111111111111111111111011100010100101100010011100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 126
		-- 20078.409129
		x <= "0000000000000000000000000000010011100110111001101000101111001010111001111001";
		-- 0.139362
		y <= "0000000000000000000000000000000000000000000000100011101011010011101100011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 127
		-- 20078.409129
		x <= "0000000000000000000000000000010011100110111001101000101111001010111001111001";
		-- 0.418086
		y <= "0000000000000000000000000000000000000000000001101011000001111011000101001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 128
		-- 20078.409129
		x <= "0000000000000000000000000000010011100110111001101000101111001010111001111001";
		-- 0.696810
		y <= "0000000000000000000000000000000000000000000010110010011000100010011110000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 129
		-- 20078.409129
		x <= "0000000000000000000000000000010011100110111001101000101111001010111001111001";
		-- 0.975534
		y <= "0000000000000000000000000000000000000000000011111001101111001001110110110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 130
		-- 20078.409129
		x <= "0000000000000000000000000000010011100110111001101000101111001010111001111001";
		-- 1.254258
		y <= "0000000000000000000000000000000000000000000101000001000101110001001111101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 131
		-- 21751.609889
		x <= "0000000000000000000000000000010101001111011110011100001000011011011101100111";
		-- -1.244206
		y <= "1111111111111111111111111111111111111111111011000001011110111011000101101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 132
		-- 21751.609889
		x <= "0000000000000000000000000000010101001111011110011100001000011011011101100111";
		-- -0.967716
		y <= "1111111111111111111111111111111111111111111100001000010000111100001011100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 133
		-- 21751.609889
		x <= "0000000000000000000000000000010101001111011110011100001000011011011101100111";
		-- -0.691226
		y <= "1111111111111111111111111111111111111111111101001111000010111101010001011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 134
		-- 21751.609889
		x <= "0000000000000000000000000000010101001111011110011100001000011011011101100111";
		-- -0.414735
		y <= "1111111111111111111111111111111111111111111110010101110100111110010111001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 135
		-- 21751.609889
		x <= "0000000000000000000000000000010101001111011110011100001000011011011101100111";
		-- -0.138245
		y <= "1111111111111111111111111111111111111111111111011100100110111111011101000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 136
		-- 21751.609889
		x <= "0000000000000000000000000000010101001111011110011100001000011011011101100111";
		-- 0.138245
		y <= "0000000000000000000000000000000000000000000000100011011001000000100010111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 137
		-- 21751.609889
		x <= "0000000000000000000000000000010101001111011110011100001000011011011101100111";
		-- 0.414735
		y <= "0000000000000000000000000000000000000000000001101010001011000001101000110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 138
		-- 21751.609889
		x <= "0000000000000000000000000000010101001111011110011100001000011011011101100111";
		-- 0.691226
		y <= "0000000000000000000000000000000000000000000010110000111101000010101110100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 139
		-- 21751.609889
		x <= "0000000000000000000000000000010101001111011110011100001000011011011101100111";
		-- 0.967716
		y <= "0000000000000000000000000000000000000000000011110111101111000011110100011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 140
		-- 21751.609889
		x <= "0000000000000000000000000000010101001111011110011100001000011011011101100111";
		-- 1.244206
		y <= "0000000000000000000000000000000000000000000100111110100001000100111010010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 141
		-- 23424.810650
		x <= "0000000000000000000000000000010110111000000011001111100001101100000001010110";
		-- -1.235042
		y <= "1111111111111111111111111111111111111111111011000011110101000100011001101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 142
		-- 23424.810650
		x <= "0000000000000000000000000000010110111000000011001111100001101100000001010110";
		-- -0.960588
		y <= "1111111111111111111111111111111111111111111100001010000101101110000101110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 143
		-- 23424.810650
		x <= "0000000000000000000000000000010110111000000011001111100001101100000001010110";
		-- -0.686135
		y <= "1111111111111111111111111111111111111111111101010000010110010111110001110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 144
		-- 23424.810650
		x <= "0000000000000000000000000000010110111000000011001111100001101100000001010110";
		-- -0.411681
		y <= "1111111111111111111111111111111111111111111110010110100111000001011101111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 145
		-- 23424.810650
		x <= "0000000000000000000000000000010110111000000011001111100001101100000001010110";
		-- -0.137227
		y <= "1111111111111111111111111111111111111111111111011100110111101011001001111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 146
		-- 23424.810650
		x <= "0000000000000000000000000000010110111000000011001111100001101100000001010110";
		-- 0.137227
		y <= "0000000000000000000000000000000000000000000000100011001000010100110110000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 147
		-- 23424.810650
		x <= "0000000000000000000000000000010110111000000011001111100001101100000001010110";
		-- 0.411681
		y <= "0000000000000000000000000000000000000000000001101001011000111110100010000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 148
		-- 23424.810650
		x <= "0000000000000000000000000000010110111000000011001111100001101100000001010110";
		-- 0.686135
		y <= "0000000000000000000000000000000000000000000010101111101001101000001110001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 149
		-- 23424.810650
		x <= "0000000000000000000000000000010110111000000011001111100001101100000001010110";
		-- 0.960588
		y <= "0000000000000000000000000000000000000000000011110101111010010001111010001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 150
		-- 23424.810650
		x <= "0000000000000000000000000000010110111000000011001111100001101100000001010110";
		-- 1.235042
		y <= "0000000000000000000000000000000000000000000100111100001010111011100110010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 151
		-- 25098.011410
		x <= "0000000000000000000000000000011000100000101000000010111010111100100101000100";
		-- -1.226631
		y <= "1111111111111111111111111111111111111111111011000101111110111000000101101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 152
		-- 25098.011410
		x <= "0000000000000000000000000000011000100000101000000010111010111100100101000100";
		-- -0.954046
		y <= "1111111111111111111111111111111111111111111100001011110000111001110110001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 153
		-- 25098.011410
		x <= "0000000000000000000000000000011000100000101000000010111010111100100101000100";
		-- -0.681462
		y <= "1111111111111111111111111111111111111111111101010001100010111011100110101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 154
		-- 25098.011410
		x <= "0000000000000000000000000000011000100000101000000010111010111100100101000100";
		-- -0.408877
		y <= "1111111111111111111111111111111111111111111110010111010100111101010111001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 155
		-- 25098.011410
		x <= "0000000000000000000000000000011000100000101000000010111010111100100101000100";
		-- -0.136292
		y <= "1111111111111111111111111111111111111111111111011101000110111111000111101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 156
		-- 25098.011410
		x <= "0000000000000000000000000000011000100000101000000010111010111100100101000100";
		-- 0.136292
		y <= "0000000000000000000000000000000000000000000000100010111001000000111000010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 157
		-- 25098.011410
		x <= "0000000000000000000000000000011000100000101000000010111010111100100101000100";
		-- 0.408877
		y <= "0000000000000000000000000000000000000000000001101000101011000010101000110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 158
		-- 25098.011410
		x <= "0000000000000000000000000000011000100000101000000010111010111100100101000100";
		-- 0.681462
		y <= "0000000000000000000000000000000000000000000010101110011101000100011001010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 159
		-- 25098.011410
		x <= "0000000000000000000000000000011000100000101000000010111010111100100101000100";
		-- 0.954046
		y <= "0000000000000000000000000000000000000000000011110100001111000110001001110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 160
		-- 25098.011410
		x <= "0000000000000000000000000000011000100000101000000010111010111100100101000100";
		-- 1.226631
		y <= "0000000000000000000000000000000000000000000100111010000001000111111010010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 161
		-- 26771.212171
		x <= "0000000000000000000000000000011010001001001100110110010100001101001000110011";
		-- -1.218866
		y <= "1111111111111111111111111111111111111111111011000111111110000110010010111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 162
		-- 26771.212171
		x <= "0000000000000000000000000000011010001001001100110110010100001101001000110011";
		-- -0.948007
		y <= "1111111111111111111111111111111111111111111100001101010011110110101011001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 163
		-- 26771.212171
		x <= "0000000000000000000000000000011010001001001100110110010100001101001000110011";
		-- -0.677148
		y <= "1111111111111111111111111111111111111111111101010010101001100111000011011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 164
		-- 26771.212171
		x <= "0000000000000000000000000000011010001001001100110110010100001101001000110011";
		-- -0.406289
		y <= "1111111111111111111111111111111111111111111110010111111111010111011011101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 165
		-- 26771.212171
		x <= "0000000000000000000000000000011010001001001100110110010100001101001000110011";
		-- -0.135430
		y <= "1111111111111111111111111111111111111111111111011101010101000111110011111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 166
		-- 26771.212171
		x <= "0000000000000000000000000000011010001001001100110110010100001101001000110011";
		-- 0.135430
		y <= "0000000000000000000000000000000000000000000000100010101010111000001100000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 167
		-- 26771.212171
		x <= "0000000000000000000000000000011010001001001100110110010100001101001000110011";
		-- 0.406289
		y <= "0000000000000000000000000000000000000000000001101000000000101000100100010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 168
		-- 26771.212171
		x <= "0000000000000000000000000000011010001001001100110110010100001101001000110011";
		-- 0.677148
		y <= "0000000000000000000000000000000000000000000010101101010110011000111100100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 169
		-- 26771.212171
		x <= "0000000000000000000000000000011010001001001100110110010100001101001000110011";
		-- 0.948007
		y <= "0000000000000000000000000000000000000000000011110010101100001001010100110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 170
		-- 26771.212171
		x <= "0000000000000000000000000000011010001001001100110110010100001101001000110011";
		-- 1.218866
		y <= "0000000000000000000000000000000000000000000100111000000001111001101101000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 171
		-- 28444.412931
		x <= "0000000000000000000000000000011011110001110001101001101101011101101100100001";
		-- -1.211661
		y <= "1111111111111111111111111111111111111111111011001001110100001001011000010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 172
		-- 28444.412931
		x <= "0000000000000000000000000000011011110001110001101001101101011101101100100001";
		-- -0.942403
		y <= "1111111111111111111111111111111111111111111100001110101111101010110110011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 173
		-- 28444.412931
		x <= "0000000000000000000000000000011011110001110001101001101101011101101100100001";
		-- -0.673145
		y <= "1111111111111111111111111111111111111111111101010011101011001100010100101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 174
		-- 28444.412931
		x <= "0000000000000000000000000000011011110001110001101001101101011101101100100001";
		-- -0.403887
		y <= "1111111111111111111111111111111111111111111110011000100110101101110010110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 175
		-- 28444.412931
		x <= "0000000000000000000000000000011011110001110001101001101101011101101100100001";
		-- -0.134629
		y <= "1111111111111111111111111111111111111111111111011101100010001111010000111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 176
		-- 28444.412931
		x <= "0000000000000000000000000000011011110001110001101001101101011101101100100001";
		-- 0.134629
		y <= "0000000000000000000000000000000000000000000000100010011101110000101111000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 177
		-- 28444.412931
		x <= "0000000000000000000000000000011011110001110001101001101101011101101100100001";
		-- 0.403887
		y <= "0000000000000000000000000000000000000000000001100111011001010010001101001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 178
		-- 28444.412931
		x <= "0000000000000000000000000000011011110001110001101001101101011101101100100001";
		-- 0.673145
		y <= "0000000000000000000000000000000000000000000010101100010100110011101011010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 179
		-- 28444.412931
		x <= "0000000000000000000000000000011011110001110001101001101101011101101100100001";
		-- 0.942403
		y <= "0000000000000000000000000000000000000000000011110001010000010101001001100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 180
		-- 28444.412931
		x <= "0000000000000000000000000000011011110001110001101001101101011101101100100001";
		-- 1.211661
		y <= "0000000000000000000000000000000000000000000100110110001011110110100111101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 181
		-- 30117.613692
		x <= "0000000000000000000000000000011101011010010110011101000110101110010000010000";
		-- -1.204945
		y <= "1111111111111111111111111111111111111111111011001011100010001011001001101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 182
		-- 30117.613692
		x <= "0000000000000000000000000000011101011010010110011101000110101110010000010000";
		-- -0.937180
		y <= "1111111111111111111111111111111111111111111100010000000101001111110010001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 183
		-- 30117.613692
		x <= "0000000000000000000000000000011101011010010110011101000110101110010000010000";
		-- -0.669414
		y <= "1111111111111111111111111111111111111111111101010100101000010100011010101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 184
		-- 30117.613692
		x <= "0000000000000000000000000000011101011010010110011101000110101110010000010000";
		-- -0.401648
		y <= "1111111111111111111111111111111111111111111110011001001011011001000011001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 185
		-- 30117.613692
		x <= "0000000000000000000000000000011101011010010110011101000110101110010000010000";
		-- -0.133883
		y <= "1111111111111111111111111111111111111111111111011101101110011101101011101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 186
		-- 30117.613692
		x <= "0000000000000000000000000000011101011010010110011101000110101110010000010000";
		-- 0.133883
		y <= "0000000000000000000000000000000000000000000000100010010001100010010100010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 187
		-- 30117.613692
		x <= "0000000000000000000000000000011101011010010110011101000110101110010000010000";
		-- 0.401648
		y <= "0000000000000000000000000000000000000000000001100110110100100110111100110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 188
		-- 30117.613692
		x <= "0000000000000000000000000000011101011010010110011101000110101110010000010000";
		-- 0.669414
		y <= "0000000000000000000000000000000000000000000010101011010111101011100101010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 189
		-- 30117.613692
		x <= "0000000000000000000000000000011101011010010110011101000110101110010000010000";
		-- 0.937180
		y <= "0000000000000000000000000000000000000000000011101111111010110000001101110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 190
		-- 30117.613692
		x <= "0000000000000000000000000000011101011010010110011101000110101110010000010000";
		-- 1.204945
		y <= "0000000000000000000000000000000000000000000100110100011101110100110110010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 191
		-- 31790.814452
		x <= "0000000000000000000000000000011111000010111011010000011111111110110011111110";
		-- -1.198661
		y <= "1111111111111111111111111111111111111111111011001101001001001000101000010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 192
		-- 31790.814452
		x <= "0000000000000000000000000000011111000010111011010000011111111110110011111110";
		-- -0.932292
		y <= "1111111111111111111111111111111111111111111100010001010101010100111011110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 193
		-- 31790.814452
		x <= "0000000000000000000000000000011111000010111011010000011111111110110011111110";
		-- -0.665923
		y <= "1111111111111111111111111111111111111111111101010101100001100001001111010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 194
		-- 31790.814452
		x <= "0000000000000000000000000000011111000010111011010000011111111110110011111110";
		-- -0.399554
		y <= "1111111111111111111111111111111111111111111110011001101101101101100010110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 195
		-- 31790.814452
		x <= "0000000000000000000000000000011111000010111011010000011111111110110011111110";
		-- -0.133185
		y <= "1111111111111111111111111111111111111111111111011101111001111001110110010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 196
		-- 31790.814452
		x <= "0000000000000000000000000000011111000010111011010000011111111110110011111110";
		-- 0.133185
		y <= "0000000000000000000000000000000000000000000000100010000110000110001001101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 197
		-- 31790.814452
		x <= "0000000000000000000000000000011111000010111011010000011111111110110011111110";
		-- 0.399554
		y <= "0000000000000000000000000000000000000000000001100110010010010010011101001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 198
		-- 31790.814452
		x <= "0000000000000000000000000000011111000010111011010000011111111110110011111110";
		-- 0.665923
		y <= "0000000000000000000000000000000000000000000010101010011110011110110000101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 199
		-- 31790.814452
		x <= "0000000000000000000000000000011111000010111011010000011111111110110011111110";
		-- 0.932292
		y <= "0000000000000000000000000000000000000000000011101110101010101011000100001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 200
		-- 31790.814452
		x <= "0000000000000000000000000000011111000010111011010000011111111110110011111110";
		-- 1.198661
		y <= "0000000000000000000000000000000000000000000100110010110110110111010111101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 201
		-- 33464.015212
		x <= "0000000000000000000000000000100000101011100000000011111001001111010111101101";
		-- -1.192760
		y <= "1111111111111111111111111111111111111111111011001110101001110100110100000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 202
		-- 33464.015212
		x <= "0000000000000000000000000000100000101011100000000011111001001111010111101101";
		-- -0.927702
		y <= "1111111111111111111111111111111111111111111100010010100000100001111101110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 203
		-- 33464.015212
		x <= "0000000000000000000000000000100000101011100000000011111001001111010111101101";
		-- -0.662644
		y <= "1111111111111111111111111111111111111111111101010110010111001111000111100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 204
		-- 33464.015212
		x <= "0000000000000000000000000000100000101011100000000011111001001111010111101101";
		-- -0.397587
		y <= "1111111111111111111111111111111111111111111110011010001101111100010001010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 205
		-- 33464.015212
		x <= "0000000000000000000000000000100000101011100000000011111001001111010111101101";
		-- -0.132529
		y <= "1111111111111111111111111111111111111111111111011110000100101001011011000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 206
		-- 33464.015212
		x <= "0000000000000000000000000000100000101011100000000011111001001111010111101101";
		-- 0.132529
		y <= "0000000000000000000000000000000000000000000000100001111011010110100100111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 207
		-- 33464.015212
		x <= "0000000000000000000000000000100000101011100000000011111001001111010111101101";
		-- 0.397587
		y <= "0000000000000000000000000000000000000000000001100101110010000011101110101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 208
		-- 33464.015212
		x <= "0000000000000000000000000000100000101011100000000011111001001111010111101101";
		-- 0.662644
		y <= "0000000000000000000000000000000000000000000010101001101000110000111000011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 209
		-- 33464.015212
		x <= "0000000000000000000000000000100000101011100000000011111001001111010111101101";
		-- 0.927702
		y <= "0000000000000000000000000000000000000000000011101101011111011110000010001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 210
		-- 33464.015212
		x <= "0000000000000000000000000000100000101011100000000011111001001111010111101101";
		-- 1.192760
		y <= "0000000000000000000000000000000000000000000100110001010110001011001011111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 211
		-- 35137.215973
		x <= "0000000000000000000000000000100010010100000100110111010010011111111011011011";
		-- -1.187200
		y <= "1111111111111111111111111111111111111111111011010000000100111010101110100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 212
		-- 35137.215973
		x <= "0000000000000000000000000000100010010100000100110111010010011111111011011011";
		-- -0.923378
		y <= "1111111111111111111111111111111111111111111100010011100111011000010110000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 213
		-- 35137.215973
		x <= "0000000000000000000000000000100010010100000100110111010010011111111011011011";
		-- -0.659555
		y <= "1111111111111111111111111111111111111111111101010111001001110101111101011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 214
		-- 35137.215973
		x <= "0000000000000000000000000000100010010100000100110111010010011111111011011011";
		-- -0.395733
		y <= "1111111111111111111111111111111111111111111110011010101100010011100100110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 215
		-- 35137.215973
		x <= "0000000000000000000000000000100010010100000100110111010010011111111011011011";
		-- -0.131911
		y <= "1111111111111111111111111111111111111111111111011110001110110001001100010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 216
		-- 35137.215973
		x <= "0000000000000000000000000000100010010100000100110111010010011111111011011011";
		-- 0.131911
		y <= "0000000000000000000000000000000000000000000000100001110001001110110011101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 217
		-- 35137.215973
		x <= "0000000000000000000000000000100010010100000100110111010010011111111011011011";
		-- 0.395733
		y <= "0000000000000000000000000000000000000000000001100101010011101100011011001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 218
		-- 35137.215973
		x <= "0000000000000000000000000000100010010100000100110111010010011111111011011011";
		-- 0.659555
		y <= "0000000000000000000000000000000000000000000010101000110110001010000010100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 219
		-- 35137.215973
		x <= "0000000000000000000000000000100010010100000100110111010010011111111011011011";
		-- 0.923378
		y <= "0000000000000000000000000000000000000000000011101100011000100111101001111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 220
		-- 35137.215973
		x <= "0000000000000000000000000000100010010100000100110111010010011111111011011011";
		-- 1.187200
		y <= "0000000000000000000000000000000000000000000100101111111011000101010001011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 221
		-- 36810.416733
		x <= "0000000000000000000000000000100011111100101001101010101011110000011111001010";
		-- -1.181947
		y <= "1111111111111111111111111111111111111111111011010001011010111110111111100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 222
		-- 36810.416733
		x <= "0000000000000000000000000000100011111100101001101010101011110000011111001010";
		-- -0.919292
		y <= "1111111111111111111111111111111111111111111100010100101010010100100011001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 223
		-- 36810.416733
		x <= "0000000000000000000000000000100011111100101001101010101011110000011111001010";
		-- -0.656637
		y <= "1111111111111111111111111111111111111111111101010111111001101010000110110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 224
		-- 36810.416733
		x <= "0000000000000000000000000000100011111100101001101010101011110000011111001010";
		-- -0.393982
		y <= "1111111111111111111111111111111111111111111110011011001000111111101010100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 225
		-- 36810.416733
		x <= "0000000000000000000000000000100011111100101001101010101011110000011111001010";
		-- -0.131327
		y <= "1111111111111111111111111111111111111111111111011110011000010101001110001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 226
		-- 36810.416733
		x <= "0000000000000000000000000000100011111100101001101010101011110000011111001010";
		-- 0.131327
		y <= "0000000000000000000000000000000000000000000000100001100111101010110001110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 227
		-- 36810.416733
		x <= "0000000000000000000000000000100011111100101001101010101011110000011111001010";
		-- 0.393982
		y <= "0000000000000000000000000000000000000000000001100100110111000000010101011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 228
		-- 36810.416733
		x <= "0000000000000000000000000000100011111100101001101010101011110000011111001010";
		-- 0.656637
		y <= "0000000000000000000000000000000000000000000010101000000110010101111001001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 229
		-- 36810.416733
		x <= "0000000000000000000000000000100011111100101001101010101011110000011111001010";
		-- 0.919292
		y <= "0000000000000000000000000000000000000000000011101011010101101011011100110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 230
		-- 36810.416733
		x <= "0000000000000000000000000000100011111100101001101010101011110000011111001010";
		-- 1.181947
		y <= "0000000000000000000000000000000000000000000100101110100101000001000000011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 231
		-- 38483.617494
		x <= "0000000000000000000000000000100101100101001110011110000101000001000010111000";
		-- -1.176970
		y <= "1111111111111111111111111111111111111111111011010010101100100001000000110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 232
		-- 38483.617494
		x <= "0000000000000000000000000000100101100101001110011110000101000001000010111000";
		-- -0.915421
		y <= "1111111111111111111111111111111111111111111100010101101001101111000000100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 233
		-- 38483.617494
		x <= "0000000000000000000000000000100101100101001110011110000101000001000010111000";
		-- -0.653872
		y <= "1111111111111111111111111111111111111111111101011000100110111101000000011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 234
		-- 38483.617494
		x <= "0000000000000000000000000000100101100101001110011110000101000001000010111000";
		-- -0.392323
		y <= "1111111111111111111111111111111111111111111110011011100100001011000000010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 235
		-- 38483.617494
		x <= "0000000000000000000000000000100101100101001110011110000101000001000010111000";
		-- -0.130774
		y <= "1111111111111111111111111111111111111111111111011110100001011001000000000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 236
		-- 38483.617494
		x <= "0000000000000000000000000000100101100101001110011110000101000001000010111000";
		-- 0.130774
		y <= "0000000000000000000000000000000000000000000000100001011110100110111111111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 237
		-- 38483.617494
		x <= "0000000000000000000000000000100101100101001110011110000101000001000010111000";
		-- 0.392323
		y <= "0000000000000000000000000000000000000000000001100100011011110100111111101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 238
		-- 38483.617494
		x <= "0000000000000000000000000000100101100101001110011110000101000001000010111000";
		-- 0.653872
		y <= "0000000000000000000000000000000000000000000010100111011001000010111111100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 239
		-- 38483.617494
		x <= "0000000000000000000000000000100101100101001110011110000101000001000010111000";
		-- 0.915421
		y <= "0000000000000000000000000000000000000000000011101010010110010000111111011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 240
		-- 38483.617494
		x <= "0000000000000000000000000000100101100101001110011110000101000001000010111000";
		-- 1.176970
		y <= "0000000000000000000000000000000000000000000100101101010011011110111111001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 241
		-- 40156.818254
		x <= "0000000000000000000000000000100111001101110011010001011110010001100110100111";
		-- -1.172245
		y <= "1111111111111111111111111111111111111111111011010011111001111011111010010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 242
		-- 40156.818254
		x <= "0000000000000000000000000000100111001101110011010001011110010001100110100111";
		-- -0.911746
		y <= "1111111111111111111111111111111111111111111100010110100101111100110100011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 243
		-- 40156.818254
		x <= "0000000000000000000000000000100111001101110011010001011110010001100110100111";
		-- -0.651247
		y <= "1111111111111111111111111111111111111111111101011001010001111101101110101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 244
		-- 40156.818254
		x <= "0000000000000000000000000000100111001101110011010001011110010001100110100111";
		-- -0.390748
		y <= "1111111111111111111111111111111111111111111110011011111101111110101000110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 245
		-- 40156.818254
		x <= "0000000000000000000000000000100111001101110011010001011110010001100110100111";
		-- -0.130249
		y <= "1111111111111111111111111111111111111111111111011110101001111111100010111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 246
		-- 40156.818254
		x <= "0000000000000000000000000000100111001101110011010001011110010001100110100111";
		-- 0.130249
		y <= "0000000000000000000000000000000000000000000000100001010110000000011101000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 247
		-- 40156.818254
		x <= "0000000000000000000000000000100111001101110011010001011110010001100110100111";
		-- 0.390748
		y <= "0000000000000000000000000000000000000000000001100100000010000001010111001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 248
		-- 40156.818254
		x <= "0000000000000000000000000000100111001101110011010001011110010001100110100111";
		-- 0.651247
		y <= "0000000000000000000000000000000000000000000010100110101110000010010001010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 249
		-- 40156.818254
		x <= "0000000000000000000000000000100111001101110011010001011110010001100110100111";
		-- 0.911746
		y <= "0000000000000000000000000000000000000000000011101001011010000011001011100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 250
		-- 40156.818254
		x <= "0000000000000000000000000000100111001101110011010001011110010001100110100111";
		-- 1.172245
		y <= "0000000000000000000000000000000000000000000100101100000110000100000101101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 251
		-- 41830.019015
		x <= "0000000000000000000000000000101000110110011000000100110111100010001010010101";
		-- -1.167748
		y <= "1111111111111111111111111111111111111111111011010101000011100111010001011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 252
		-- 41830.019015
		x <= "0000000000000000000000000000101000110110011000000100110111100010001010010101";
		-- -0.908249
		y <= "1111111111111111111111111111111111111111111100010111011111010000010100101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 253
		-- 41830.019015
		x <= "0000000000000000000000000000101000110110011000000100110111100010001010010101";
		-- -0.648749
		y <= "1111111111111111111111111111111111111111111101011001111010111001010111111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 254
		-- 41830.019015
		x <= "0000000000000000000000000000101000110110011000000100110111100010001010010101";
		-- -0.389249
		y <= "1111111111111111111111111111111111111111111110011100010110100010011011001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 255
		-- 41830.019015
		x <= "0000000000000000000000000000101000110110011000000100110111100010001010010101";
		-- -0.129750
		y <= "1111111111111111111111111111111111111111111111011110110010001011011110011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 256
		-- 41830.019015
		x <= "0000000000000000000000000000101000110110011000000100110111100010001010010101";
		-- 0.129750
		y <= "0000000000000000000000000000000000000000000000100001001101110100100001100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 257
		-- 41830.019015
		x <= "0000000000000000000000000000101000110110011000000100110111100010001010010101";
		-- 0.389249
		y <= "0000000000000000000000000000000000000000000001100011101001011101100100110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 258
		-- 41830.019015
		x <= "0000000000000000000000000000101000110110011000000100110111100010001010010101";
		-- 0.648749
		y <= "0000000000000000000000000000000000000000000010100110000101000110101000000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 259
		-- 41830.019015
		x <= "0000000000000000000000000000101000110110011000000100110111100010001010010101";
		-- 0.908249
		y <= "0000000000000000000000000000000000000000000011101000100000101111101011010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 260
		-- 41830.019015
		x <= "0000000000000000000000000000101000110110011000000100110111100010001010010101";
		-- 1.167748
		y <= "0000000000000000000000000000000000000000000100101010111100011000101110100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 261
		-- 43503.219775
		x <= "0000000000000000000000000000101010011110111100111000010000110010101110000100";
		-- -1.163460
		y <= "1111111111111111111111111111111111111111111011010110001001110111101110000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 262
		-- 43503.219775
		x <= "0000000000000000000000000000101010011110111100111000010000110010101110000100";
		-- -0.904913
		y <= "1111111111111111111111111111111111111111111100011000010101111001100011110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 263
		-- 43503.219775
		x <= "0000000000000000000000000000101010011110111100111000010000110010101110000100";
		-- -0.646367
		y <= "1111111111111111111111111111111111111111111101011010100001111011011001100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 264
		-- 43503.219775
		x <= "0000000000000000000000000000101010011110111100111000010000110010101110000100";
		-- -0.387820
		y <= "1111111111111111111111111111111111111111111110011100101101111101001111010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 265
		-- 43503.219775
		x <= "0000000000000000000000000000101010011110111100111000010000110010101110000100";
		-- -0.129273
		y <= "1111111111111111111111111111111111111111111111011110111001111111000101000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 266
		-- 43503.219775
		x <= "0000000000000000000000000000101010011110111100111000010000110010101110000100";
		-- 0.129273
		y <= "0000000000000000000000000000000000000000000000100001000110000000111010111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 267
		-- 43503.219775
		x <= "0000000000000000000000000000101010011110111100111000010000110010101110000100";
		-- 0.387820
		y <= "0000000000000000000000000000000000000000000001100011010010000010110000101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 268
		-- 43503.219775
		x <= "0000000000000000000000000000101010011110111100111000010000110010101110000100";
		-- 0.646367
		y <= "0000000000000000000000000000000000000000000010100101011110000100100110011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 269
		-- 43503.219775
		x <= "0000000000000000000000000000101010011110111100111000010000110010101110000100";
		-- 0.904913
		y <= "0000000000000000000000000000000000000000000011100111101010000110011100001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 270
		-- 43503.219775
		x <= "0000000000000000000000000000101010011110111100111000010000110010101110000100";
		-- 1.163460
		y <= "0000000000000000000000000000000000000000000100101001110110001000010001111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 271
		-- 45176.420535
		x <= "0000000000000000000000000000101100000111100001101011101010000011010001110010";
		-- -1.159363
		y <= "1111111111111111111111111111111111111111111011010111001100111111011000010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 272
		-- 45176.420535
		x <= "0000000000000000000000000000101100000111100001101011101010000011010001110010";
		-- -0.901727
		y <= "1111111111111111111111111111111111111111111100011001001010000110101000001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 273
		-- 45176.420535
		x <= "0000000000000000000000000000101100000111100001101011101010000011010001110010";
		-- -0.644091
		y <= "1111111111111111111111111111111111111111111101011011000111001101111000001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 274
		-- 45176.420535
		x <= "0000000000000000000000000000101100000111100001101011101010000011010001110010";
		-- -0.386454
		y <= "1111111111111111111111111111111111111111111110011101000100010101001000000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 275
		-- 45176.420535
		x <= "0000000000000000000000000000101100000111100001101011101010000011010001110010";
		-- -0.128818
		y <= "1111111111111111111111111111111111111111111111011111000001011100011000000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 276
		-- 45176.420535
		x <= "0000000000000000000000000000101100000111100001101011101010000011010001110010";
		-- 0.128818
		y <= "0000000000000000000000000000000000000000000000100000111110100011100111111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 277
		-- 45176.420535
		x <= "0000000000000000000000000000101100000111100001101011101010000011010001110010";
		-- 0.386454
		y <= "0000000000000000000000000000000000000000000001100010111011101010110111111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 278
		-- 45176.420535
		x <= "0000000000000000000000000000101100000111100001101011101010000011010001110010";
		-- 0.644091
		y <= "0000000000000000000000000000000000000000000010100100111000110010000111110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 279
		-- 45176.420535
		x <= "0000000000000000000000000000101100000111100001101011101010000011010001110010";
		-- 0.901727
		y <= "0000000000000000000000000000000000000000000011100110110101111001010111110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 280
		-- 45176.420535
		x <= "0000000000000000000000000000101100000111100001101011101010000011010001110010";
		-- 1.159363
		y <= "0000000000000000000000000000000000000000000100101000110011000000100111101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 281
		-- 46849.621296
		x <= "0000000000000000000000000000101101110000000110011111000011010011110101100001";
		-- -1.155443
		y <= "1111111111111111111111111111111111111111111011011000001101001110010001100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 282
		-- 46849.621296
		x <= "0000000000000000000000000000101101110000000110011111000011010011110101100001";
		-- -0.898678
		y <= "1111111111111111111111111111111111111111111100011001111100000011111111011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 283
		-- 46849.621296
		x <= "0000000000000000000000000000101101110000000110011111000011010011110101100001";
		-- -0.641913
		y <= "1111111111111111111111111111111111111111111101011011101010111001101101010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 284
		-- 46849.621296
		x <= "0000000000000000000000000000101101110000000110011111000011010011110101100001";
		-- -0.385148
		y <= "1111111111111111111111111111111111111111111110011101011001101111011011001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 285
		-- 46849.621296
		x <= "0000000000000000000000000000101101110000000110011111000011010011110101100001";
		-- -0.128383
		y <= "1111111111111111111111111111111111111111111111011111001000100101001001000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 286
		-- 46849.621296
		x <= "0000000000000000000000000000101101110000000110011111000011010011110101100001";
		-- 0.128383
		y <= "0000000000000000000000000000000000000000000000100000110111011010110110111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 287
		-- 46849.621296
		x <= "0000000000000000000000000000101101110000000110011111000011010011110101100001";
		-- 0.385148
		y <= "0000000000000000000000000000000000000000000001100010100110010000100100110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 288
		-- 46849.621296
		x <= "0000000000000000000000000000101101110000000110011111000011010011110101100001";
		-- 0.641913
		y <= "0000000000000000000000000000000000000000000010100100010101000110010010101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 289
		-- 46849.621296
		x <= "0000000000000000000000000000101101110000000110011111000011010011110101100001";
		-- 0.898678
		y <= "0000000000000000000000000000000000000000000011100110000011111100000000100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 290
		-- 46849.621296
		x <= "0000000000000000000000000000101101110000000110011111000011010011110101100001";
		-- 1.155443
		y <= "0000000000000000000000000000000000000000000100100111110010110001101110011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 291
		-- 48522.822056
		x <= "0000000000000000000000000000101111011000101011010010011100100100011001001111";
		-- -1.151685
		y <= "1111111111111111111111111111111111111111111011011001001010110010101000001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 292
		-- 48522.822056
		x <= "0000000000000000000000000000101111011000101011010010011100100100011001001111";
		-- -0.895755
		y <= "1111111111111111111111111111111111111111111100011010101011111100101101011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 293
		-- 48522.822056
		x <= "0000000000000000000000000000101111011000101011010010011100100100011001001111";
		-- -0.639825
		y <= "1111111111111111111111111111111111111111111101011100001101000110110010110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 294
		-- 48522.822056
		x <= "0000000000000000000000000000101111011000101011010010011100100100011001001111";
		-- -0.383895
		y <= "1111111111111111111111111111111111111111111110011101101110010000111000000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 295
		-- 48522.822056
		x <= "0000000000000000000000000000101111011000101011010010011100100100011001001111";
		-- -0.127965
		y <= "1111111111111111111111111111111111111111111111011111001111011010111101010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 296
		-- 48522.822056
		x <= "0000000000000000000000000000101111011000101011010010011100100100011001001111";
		-- 0.127965
		y <= "0000000000000000000000000000000000000000000000100000110000100101000010101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 297
		-- 48522.822056
		x <= "0000000000000000000000000000101111011000101011010010011100100100011001001111";
		-- 0.383895
		y <= "0000000000000000000000000000000000000000000001100010010001101111000111111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 298
		-- 48522.822056
		x <= "0000000000000000000000000000101111011000101011010010011100100100011001001111";
		-- 0.639825
		y <= "0000000000000000000000000000000000000000000010100011110010111001001101001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 299
		-- 48522.822056
		x <= "0000000000000000000000000000101111011000101011010010011100100100011001001111";
		-- 0.895755
		y <= "0000000000000000000000000000000000000000000011100101010100000011010010100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 300
		-- 48522.822056
		x <= "0000000000000000000000000000101111011000101011010010011100100100011001001111";
		-- 1.151685
		y <= "0000000000000000000000000000000000000000000100100110110101001101010111110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 301
		-- 50196.022817
		x <= "0000000000000000000000000000110001000001010000000101110101110100111100111110";
		-- -1.148078
		y <= "1111111111111111111111111111111111111111111011011010000101111001000111100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 302
		-- 50196.022817
		x <= "0000000000000000000000000000110001000001010000000101110101110100111100111110";
		-- -0.892949
		y <= "1111111111111111111111111111111111111111111100011011011001111010101001011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 303
		-- 50196.022817
		x <= "0000000000000000000000000000110001000001010000000101110101110100111100111110";
		-- -0.637821
		y <= "1111111111111111111111111111111111111111111101011100101101111100001011010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 304
		-- 50196.022817
		x <= "0000000000000000000000000000110001000001010000000101110101110100111100111110";
		-- -0.382693
		y <= "1111111111111111111111111111111111111111111110011110000001111101101101001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 305
		-- 50196.022817
		x <= "0000000000000000000000000000110001000001010000000101110101110100111100111110";
		-- -0.127564
		y <= "1111111111111111111111111111111111111111111111011111010101111111001111000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 306
		-- 50196.022817
		x <= "0000000000000000000000000000110001000001010000000101110101110100111100111110";
		-- 0.127564
		y <= "0000000000000000000000000000000000000000000000100000101010000000110000111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 307
		-- 50196.022817
		x <= "0000000000000000000000000000110001000001010000000101110101110100111100111110";
		-- 0.382693
		y <= "0000000000000000000000000000000000000000000001100001111110000010010010110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 308
		-- 50196.022817
		x <= "0000000000000000000000000000110001000001010000000101110101110100111100111110";
		-- 0.637821
		y <= "0000000000000000000000000000000000000000000010100011010010000011110100101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 309
		-- 50196.022817
		x <= "0000000000000000000000000000110001000001010000000101110101110100111100111110";
		-- 0.892949
		y <= "0000000000000000000000000000000000000000000011100100100110000101010110100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 310
		-- 50196.022817
		x <= "0000000000000000000000000000110001000001010000000101110101110100111100111110";
		-- 1.148078
		y <= "0000000000000000000000000000000000000000000100100101111010000110111000011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 311
		-- 51869.223577
		x <= "0000000000000000000000000000110010101001110100111001001111000101100000101100";
		-- -1.144610
		y <= "1111111111111111111111111111111111111111111011011010111110101101000110001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 312
		-- 51869.223577
		x <= "0000000000000000000000000000110010101001110100111001001111000101100000101100";
		-- -0.890252
		y <= "1111111111111111111111111111111111111111111100011100000110000110101000010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 313
		-- 51869.223577
		x <= "0000000000000000000000000000110010101001110100111001001111000101100000101100";
		-- -0.635895
		y <= "1111111111111111111111111111111111111111111101011101001101100000001010100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 314
		-- 51869.223577
		x <= "0000000000000000000000000000110010101001110100111001001111000101100000101100";
		-- -0.381537
		y <= "1111111111111111111111111111111111111111111110011110010100111001101100101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 315
		-- 51869.223577
		x <= "0000000000000000000000000000110010101001110100111001001111000101100000101100";
		-- -0.127179
		y <= "1111111111111111111111111111111111111111111111011111011100010011001110111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 316
		-- 51869.223577
		x <= "0000000000000000000000000000110010101001110100111001001111000101100000101100";
		-- 0.127179
		y <= "0000000000000000000000000000000000000000000000100000100011101100110001000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 317
		-- 51869.223577
		x <= "0000000000000000000000000000110010101001110100111001001111000101100000101100";
		-- 0.381537
		y <= "0000000000000000000000000000000000000000000001100001101011000110010011010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 318
		-- 51869.223577
		x <= "0000000000000000000000000000110010101001110100111001001111000101100000101100";
		-- 0.635895
		y <= "0000000000000000000000000000000000000000000010100010110010011111110101011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 319
		-- 51869.223577
		x <= "0000000000000000000000000000110010101001110100111001001111000101100000101100";
		-- 0.890252
		y <= "0000000000000000000000000000000000000000000011100011111001111001010111101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 320
		-- 51869.223577
		x <= "0000000000000000000000000000110010101001110100111001001111000101100000101100";
		-- 1.144610
		y <= "0000000000000000000000000000000000000000000100100101000001010010111001110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 321
		-- 53542.424337
		x <= "0000000000000000000000000000110100010010011001101100101000010110000100011011";
		-- -1.141273
		y <= "1111111111111111111111111111111111111111111011011011110101011000110000100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 322
		-- 53542.424337
		x <= "0000000000000000000000000000110100010010011001101100101000010110000100011011";
		-- -0.887657
		y <= "1111111111111111111111111111111111111111111100011100110000101000100101110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 323
		-- 53542.424337
		x <= "0000000000000000000000000000110100010010011001101100101000010110000100011011";
		-- -0.634040
		y <= "1111111111111111111111111111111111111111111101011101101011111000011010111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 324
		-- 53542.424337
		x <= "0000000000000000000000000000110100010010011001101100101000010110000100011011";
		-- -0.380424
		y <= "1111111111111111111111111111111111111111111110011110100111001000010000001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 325
		-- 53542.424337
		x <= "0000000000000000000000000000110100010010011001101100101000010110000100011011";
		-- -0.126808
		y <= "1111111111111111111111111111111111111111111111011111100010011000000101011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 326
		-- 53542.424337
		x <= "0000000000000000000000000000110100010010011001101100101000010110000100011011";
		-- 0.126808
		y <= "0000000000000000000000000000000000000000000000100000011101100111111010100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 327
		-- 53542.424337
		x <= "0000000000000000000000000000110100010010011001101100101000010110000100011011";
		-- 0.380424
		y <= "0000000000000000000000000000000000000000000001100001011000110111101111110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 328
		-- 53542.424337
		x <= "0000000000000000000000000000110100010010011001101100101000010110000100011011";
		-- 0.634040
		y <= "0000000000000000000000000000000000000000000010100010010100000111100101000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 329
		-- 53542.424337
		x <= "0000000000000000000000000000110100010010011001101100101000010110000100011011";
		-- 0.887657
		y <= "0000000000000000000000000000000000000000000011100011001111010111011010001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 330
		-- 53542.424337
		x <= "0000000000000000000000000000110100010010011001101100101000010110000100011011";
		-- 1.141273
		y <= "0000000000000000000000000000000000000000000100100100001010100111001111011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 331
		-- 55215.625098
		x <= "0000000000000000000000000000110101111010111110100000000001100110101000001001";
		-- -1.138056
		y <= "1111111111111111111111111111111111111111111011011100101010000101010011010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 332
		-- 55215.625098
		x <= "0000000000000000000000000000110101111010111110100000000001100110101000001001";
		-- -0.885155
		y <= "1111111111111111111111111111111111111111111100011101011001100111101011011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 333
		-- 55215.625098
		x <= "0000000000000000000000000000110101111010111110100000000001100110101000001001";
		-- -0.632254
		y <= "1111111111111111111111111111111111111111111101011110001001001010000011100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 334
		-- 55215.625098
		x <= "0000000000000000000000000000110101111010111110100000000001100110101000001001";
		-- -0.379352
		y <= "1111111111111111111111111111111111111111111110011110111000101100011011110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 335
		-- 55215.625098
		x <= "0000000000000000000000000000110101111010111110100000000001100110101000001001";
		-- -0.126451
		y <= "1111111111111111111111111111111111111111111111011111101000001110110011111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 336
		-- 55215.625098
		x <= "0000000000000000000000000000110101111010111110100000000001100110101000001001";
		-- 0.126451
		y <= "0000000000000000000000000000000000000000000000100000010111110001001100000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 337
		-- 55215.625098
		x <= "0000000000000000000000000000110101111010111110100000000001100110101000001001";
		-- 0.379352
		y <= "0000000000000000000000000000000000000000000001100001000111010011100100001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 338
		-- 55215.625098
		x <= "0000000000000000000000000000110101111010111110100000000001100110101000001001";
		-- 0.632254
		y <= "0000000000000000000000000000000000000000000010100001110110110101111100011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 339
		-- 55215.625098
		x <= "0000000000000000000000000000110101111010111110100000000001100110101000001001";
		-- 0.885155
		y <= "0000000000000000000000000000000000000000000011100010100110011000010100100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 340
		-- 55215.625098
		x <= "0000000000000000000000000000110101111010111110100000000001100110101000001001";
		-- 1.138056
		y <= "0000000000000000000000000000000000000000000100100011010101111010101100101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 341
		-- 56888.825858
		x <= "0000000000000000000000000000110111100011100011010011011010110111001011111000";
		-- -1.134953
		y <= "1111111111111111111111111111111111111111111011011101011100111011000010011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 342
		-- 56888.825858
		x <= "0000000000000000000000000000110111100011100011010011011010110111001011111000";
		-- -0.882742
		y <= "1111111111111111111111111111111111111111111100011110000001001010010111010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 343
		-- 56888.825858
		x <= "0000000000000000000000000000110111100011100011010011011010110111001011111000";
		-- -0.630530
		y <= "1111111111111111111111111111111111111111111101011110100101011001101100000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 344
		-- 56888.825858
		x <= "0000000000000000000000000000110111100011100011010011011010110111001011111000";
		-- -0.378318
		y <= "1111111111111111111111111111111111111111111110011111001001101001000000110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 345
		-- 56888.825858
		x <= "0000000000000000000000000000110111100011100011010011011010110111001011111000";
		-- -0.126106
		y <= "1111111111111111111111111111111111111111111111011111101101111000010101100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 346
		-- 56888.825858
		x <= "0000000000000000000000000000110111100011100011010011011010110111001011111000";
		-- 0.126106
		y <= "0000000000000000000000000000000000000000000000100000010010000111101010011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 347
		-- 56888.825858
		x <= "0000000000000000000000000000110111100011100011010011011010110111001011111000";
		-- 0.378318
		y <= "0000000000000000000000000000000000000000000001100000110110010110111111001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 348
		-- 56888.825858
		x <= "0000000000000000000000000000110111100011100011010011011010110111001011111000";
		-- 0.630530
		y <= "0000000000000000000000000000000000000000000010100001011010100110010011111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 349
		-- 56888.825858
		x <= "0000000000000000000000000000110111100011100011010011011010110111001011111000";
		-- 0.882742
		y <= "0000000000000000000000000000000000000000000011100001111110110101101000101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 350
		-- 56888.825858
		x <= "0000000000000000000000000000110111100011100011010011011010110111001011111000";
		-- 1.134953
		y <= "0000000000000000000000000000000000000000000100100010100011000100111101100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 351
		-- 58562.026619
		x <= "0000000000000000000000000000111001001100001000000110110100000111101111100110";
		-- -1.131957
		y <= "1111111111111111111111111111111111111111111011011110001110000001100001000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 352
		-- 58562.026619
		x <= "0000000000000000000000000000111001001100001000000110110100000111101111100110";
		-- -0.880411
		y <= "1111111111111111111111111111111111111111111100011110100111010110100000110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 353
		-- 58562.026619
		x <= "0000000000000000000000000000111001001100001000000110110100000111101111100110";
		-- -0.628865
		y <= "1111111111111111111111111111111111111111111101011111000000101011100000100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 354
		-- 58562.026619
		x <= "0000000000000000000000000000111001001100001000000110110100000111101111100110";
		-- -0.377319
		y <= "1111111111111111111111111111111111111111111110011111011010000000100000010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 355
		-- 58562.026619
		x <= "0000000000000000000000000000111001001100001000000110110100000111101111100110";
		-- -0.125773
		y <= "1111111111111111111111111111111111111111111111011111110011010101100000000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 356
		-- 58562.026619
		x <= "0000000000000000000000000000111001001100001000000110110100000111101111100110";
		-- 0.125773
		y <= "0000000000000000000000000000000000000000000000100000001100101010011111111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 357
		-- 58562.026619
		x <= "0000000000000000000000000000111001001100001000000110110100000111101111100110";
		-- 0.377319
		y <= "0000000000000000000000000000000000000000000001100000100101111111011111101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 358
		-- 58562.026619
		x <= "0000000000000000000000000000111001001100001000000110110100000111101111100110";
		-- 0.628865
		y <= "0000000000000000000000000000000000000000000010100000111111010100011111011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 359
		-- 58562.026619
		x <= "0000000000000000000000000000111001001100001000000110110100000111101111100110";
		-- 0.880411
		y <= "0000000000000000000000000000000000000000000011100001011000101001011111001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 360
		-- 58562.026619
		x <= "0000000000000000000000000000111001001100001000000110110100000111101111100110";
		-- 1.131957
		y <= "0000000000000000000000000000000000000000000100100001110001111110011110111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 361
		-- 60235.227379
		x <= "0000000000000000000000000000111010110100101100111010001101011000010011010101";
		-- -1.129059
		y <= "1111111111111111111111111111111111111111111011011110111101011111100110100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 362
		-- 60235.227379
		x <= "0000000000000000000000000000111010110100101100111010001101011000010011010101";
		-- -0.878157
		y <= "1111111111111111111111111111111111111111111100011111001100010001011110000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 363
		-- 60235.227379
		x <= "0000000000000000000000000000111010110100101100111010001101011000010011010101";
		-- -0.627255
		y <= "1111111111111111111111111111111111111111111101011111011011000011010101011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 364
		-- 60235.227379
		x <= "0000000000000000000000000000111010110100101100111010001101011000010011010101";
		-- -0.376353
		y <= "1111111111111111111111111111111111111111111110011111101001110101001100110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 365
		-- 60235.227379
		x <= "0000000000000000000000000000111010110100101100111010001101011000010011010101";
		-- -0.125451
		y <= "1111111111111111111111111111111111111111111111011111111000100111000100010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 366
		-- 60235.227379
		x <= "0000000000000000000000000000111010110100101100111010001101011000010011010101";
		-- 0.125451
		y <= "0000000000000000000000000000000000000000000000100000000111011000111011101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 367
		-- 60235.227379
		x <= "0000000000000000000000000000111010110100101100111010001101011000010011010101";
		-- 0.376353
		y <= "0000000000000000000000000000000000000000000001100000010110001010110011001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 368
		-- 60235.227379
		x <= "0000000000000000000000000000111010110100101100111010001101011000010011010101";
		-- 0.627255
		y <= "0000000000000000000000000000000000000000000010100000100100111100101010100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 369
		-- 60235.227379
		x <= "0000000000000000000000000000111010110100101100111010001101011000010011010101";
		-- 0.878157
		y <= "0000000000000000000000000000000000000000000011100000110011101110100001111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 370
		-- 60235.227379
		x <= "0000000000000000000000000000111010110100101100111010001101011000010011010101";
		-- 1.129059
		y <= "0000000000000000000000000000000000000000000100100001000010100000011001011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 371
		-- 61908.428140
		x <= "0000000000000000000000000000111100011101010001101101100110101000110111000011";
		-- -1.126255
		y <= "1111111111111111111111111111111111111111111011011111101011011011100011111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 372
		-- 61908.428140
		x <= "0000000000000000000000000000111100011101010001101101100110101000110111000011";
		-- -0.875976
		y <= "1111111111111111111111111111111111111111111100011111110000000000000110100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 373
		-- 61908.428140
		x <= "0000000000000000000000000000111100011101010001101101100110101000110111000011";
		-- -0.625697
		y <= "1111111111111111111111111111111111111111111101011111110100100100101001010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 374
		-- 61908.428140
		x <= "0000000000000000000000000000111100011101010001101101100110101000110111000011";
		-- -0.375418
		y <= "1111111111111111111111111111111111111111111110011111111001001001001011111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 375
		-- 61908.428140
		x <= "0000000000000000000000000000111100011101010001101101100110101000110111000011";
		-- -0.125139
		y <= "1111111111111111111111111111111111111111111111011111111101101101101110101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 376
		-- 61908.428140
		x <= "0000000000000000000000000000111100011101010001101101100110101000110111000011";
		-- 0.125139
		y <= "0000000000000000000000000000000000000000000000100000000010010010010001010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 377
		-- 61908.428140
		x <= "0000000000000000000000000000111100011101010001101101100110101000110111000011";
		-- 0.375418
		y <= "0000000000000000000000000000000000000000000001100000000110110110110100000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 378
		-- 61908.428140
		x <= "0000000000000000000000000000111100011101010001101101100110101000110111000011";
		-- 0.625697
		y <= "0000000000000000000000000000000000000000000010100000001011011011010110101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 379
		-- 61908.428140
		x <= "0000000000000000000000000000111100011101010001101101100110101000110111000011";
		-- 0.875976
		y <= "0000000000000000000000000000000000000000000011100000001111111111111001011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 380
		-- 61908.428140
		x <= "0000000000000000000000000000111100011101010001101101100110101000110111000011";
		-- 1.126255
		y <= "0000000000000000000000000000000000000000000100100000010100100100011100000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 381
		-- 63581.628900
		x <= "0000000000000000000000000000111110000101110110100000111111111001011010110010";
		-- -1.123540
		y <= "1111111111111111111111111111111111111111111011100000010111111011000111110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 382
		-- 63581.628900
		x <= "0000000000000000000000000000111110000101110110100000111111111001011010110010";
		-- -0.873864
		y <= "1111111111111111111111111111111111111111111100100000010010100110110111110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 383
		-- 63581.628900
		x <= "0000000000000000000000000000111110000101110110100000111111111001011010110010";
		-- -0.624189
		y <= "1111111111111111111111111111111111111111111101100000001101010010100111111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 384
		-- 63581.628900
		x <= "0000000000000000000000000000111110000101110110100000111111111001011010110010";
		-- -0.374513
		y <= "1111111111111111111111111111111111111111111110100000000111111110010111111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 385
		-- 63581.628900
		x <= "0000000000000000000000000000111110000101110110100000111111111001011010110010";
		-- -0.124838
		y <= "1111111111111111111111111111111111111111111111100000000010101010000111111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 386
		-- 63581.628900
		x <= "0000000000000000000000000000111110000101110110100000111111111001011010110010";
		-- 0.124838
		y <= "0000000000000000000000000000000000000000000000011111111101010101111000000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 387
		-- 63581.628900
		x <= "0000000000000000000000000000111110000101110110100000111111111001011010110010";
		-- 0.374513
		y <= "0000000000000000000000000000000000000000000001011111111000000001101000000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 388
		-- 63581.628900
		x <= "0000000000000000000000000000111110000101110110100000111111111001011010110010";
		-- 0.624189
		y <= "0000000000000000000000000000000000000000000010011111110010101101011000000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 389
		-- 63581.628900
		x <= "0000000000000000000000000000111110000101110110100000111111111001011010110010";
		-- 0.873864
		y <= "0000000000000000000000000000000000000000000011011111101101011001001000001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 390
		-- 63581.628900
		x <= "0000000000000000000000000000111110000101110110100000111111111001011010110010";
		-- 1.123540
		y <= "0000000000000000000000000000000000000000000100011111101000000100111000001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 391
		-- 65254.829660
		x <= "0000000000000000000000000000111111101110011011010100011001001001111110100000";
		-- -1.120907
		y <= "1111111111111111111111111111111111111111111011100001000011000011100010100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 392
		-- 65254.829660
		x <= "0000000000000000000000000000111111101110011011010100011001001001111110100000";
		-- -0.871817
		y <= "1111111111111111111111111111111111111111111100100000110100001001110111010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 393
		-- 65254.829660
		x <= "0000000000000000000000000000111111101110011011010100011001001001111110100000";
		-- -0.622726
		y <= "1111111111111111111111111111111111111111111101100000100101010000001100000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 394
		-- 65254.829660
		x <= "0000000000000000000000000000111111101110011011010100011001001001111110100000";
		-- -0.373636
		y <= "1111111111111111111111111111111111111111111110100000010110010110100000110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 395
		-- 65254.829660
		x <= "0000000000000000000000000000111111101110011011010100011001001001111110100000";
		-- -0.124545
		y <= "1111111111111111111111111111111111111111111111100000000111011100110101100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 396
		-- 65254.829660
		x <= "0000000000000000000000000000111111101110011011010100011001001001111110100000";
		-- 0.124545
		y <= "0000000000000000000000000000000000000000000000011111111000100011001010011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 397
		-- 65254.829660
		x <= "0000000000000000000000000000111111101110011011010100011001001001111110100000";
		-- 0.373636
		y <= "0000000000000000000000000000000000000000000001011111101001101001011111001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 398
		-- 65254.829660
		x <= "0000000000000000000000000000111111101110011011010100011001001001111110100000";
		-- 0.622726
		y <= "0000000000000000000000000000000000000000000010011111011010101111110011111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 399
		-- 65254.829660
		x <= "0000000000000000000000000000111111101110011011010100011001001001111110100000";
		-- 0.871817
		y <= "0000000000000000000000000000000000000000000011011111001011110110001000101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 400
		-- 65254.829660
		x <= "0000000000000000000000000000111111101110011011010100011001001001111110100000";
		-- 1.120907
		y <= "0000000000000000000000000000000000000000000100011110111100111100011101011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 401
		-- 66928.030421
		x <= "0000000000000000000000000001000001010111000000000111110010011010100010001111";
		-- -1.118353
		y <= "1111111111111111111111111111111111111111111011100001101100111001101001011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 402
		-- 66928.030421
		x <= "0000000000000000000000000001000001010111000000000111110010011010100010001111";
		-- -0.869830
		y <= "1111111111111111111111111111111111111111111100100001010100101100110101100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 403
		-- 66928.030421
		x <= "0000000000000000000000000001000001010111000000000111110010011010100010001111";
		-- -0.621307
		y <= "1111111111111111111111111111111111111111111101100000111100100000000001101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 404
		-- 66928.030421
		x <= "0000000000000000000000000001000001010111000000000111110010011010100010001111";
		-- -0.372784
		y <= "1111111111111111111111111111111111111111111110100000100100010011001101110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 405
		-- 66928.030421
		x <= "0000000000000000000000000001000001010111000000000111110010011010100010001111";
		-- -0.124261
		y <= "1111111111111111111111111111111111111111111111100000001100000110011001111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 406
		-- 66928.030421
		x <= "0000000000000000000000000001000001010111000000000111110010011010100010001111";
		-- 0.124261
		y <= "0000000000000000000000000000000000000000000000011111110011111001100110000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 407
		-- 66928.030421
		x <= "0000000000000000000000000001000001010111000000000111110010011010100010001111";
		-- 0.372784
		y <= "0000000000000000000000000000000000000000000001011111011011101100110010001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 408
		-- 66928.030421
		x <= "0000000000000000000000000001000001010111000000000111110010011010100010001111";
		-- 0.621307
		y <= "0000000000000000000000000000000000000000000010011111000011011111111110010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 409
		-- 66928.030421
		x <= "0000000000000000000000000001000001010111000000000111110010011010100010001111";
		-- 0.869830
		y <= "0000000000000000000000000000000000000000000011011110101011010011001010011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 410
		-- 66928.030421
		x <= "0000000000000000000000000001000001010111000000000111110010011010100010001111";
		-- 1.118353
		y <= "0000000000000000000000000000000000000000000100011110010011000110010110100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 411
		-- 68601.231181
		x <= "0000000000000000000000000001000010111111100100111011001011101011000101111101";
		-- -1.115873
		y <= "1111111111111111111111111111111111111111111011100010010101100001111001001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 412
		-- 68601.231181
		x <= "0000000000000000000000000001000010111111100100111011001011101011000101111101";
		-- -0.867902
		y <= "1111111111111111111111111111111111111111111100100001110100010011001111111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 413
		-- 68601.231181
		x <= "0000000000000000000000000001000010111111100100111011001011101011000101111101";
		-- -0.619930
		y <= "1111111111111111111111111111111111111111111101100001010011000100100110110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 414
		-- 68601.231181
		x <= "0000000000000000000000000001000010111111100100111011001011101011000101111101";
		-- -0.371958
		y <= "1111111111111111111111111111111111111111111110100000110001110101111101101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 415
		-- 68601.231181
		x <= "0000000000000000000000000001000010111111100100111011001011101011000101111101";
		-- -0.123986
		y <= "1111111111111111111111111111111111111111111111100000010000100111010100100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 416
		-- 68601.231181
		x <= "0000000000000000000000000001000010111111100100111011001011101011000101111101";
		-- 0.123986
		y <= "0000000000000000000000000000000000000000000000011111101111011000101011011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 417
		-- 68601.231181
		x <= "0000000000000000000000000001000010111111100100111011001011101011000101111101";
		-- 0.371958
		y <= "0000000000000000000000000000000000000000000001011111001110001010000010010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 418
		-- 68601.231181
		x <= "0000000000000000000000000001000010111111100100111011001011101011000101111101";
		-- 0.619930
		y <= "0000000000000000000000000000000000000000000010011110101100111011011001001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 419
		-- 68601.231181
		x <= "0000000000000000000000000001000010111111100100111011001011101011000101111101";
		-- 0.867902
		y <= "0000000000000000000000000000000000000000000011011110001011101100110000000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 420
		-- 68601.231181
		x <= "0000000000000000000000000001000010111111100100111011001011101011000101111101";
		-- 1.115873
		y <= "0000000000000000000000000000000000000000000100011101101010011110000110110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 421
		-- 70274.431942
		x <= "0000000000000000000000000001000100101000001001101110100100111011101001101100";
		-- -1.113464
		y <= "1111111111111111111111111111111111111111111011100010111101000000011000010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 422
		-- 70274.431942
		x <= "0000000000000000000000000001000100101000001001101110100100111011101001101100";
		-- -0.866028
		y <= "1111111111111111111111111111111111111111111100100010010011000000010010111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 423
		-- 70274.431942
		x <= "0000000000000000000000000001000100101000001001101110100100111011101001101100";
		-- -0.618591
		y <= "1111111111111111111111111111111111111111111101100001101001000000001101100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 424
		-- 70274.431942
		x <= "0000000000000000000000000001000100101000001001101110100100111011101001101100";
		-- -0.371155
		y <= "1111111111111111111111111111111111111111111110100000111111000000001000000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 425
		-- 70274.431942
		x <= "0000000000000000000000000001000100101000001001101110100100111011101001101100";
		-- -0.123718
		y <= "1111111111111111111111111111111111111111111111100000010101000000000010101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 426
		-- 70274.431942
		x <= "0000000000000000000000000001000100101000001001101110100100111011101001101100";
		-- 0.123718
		y <= "0000000000000000000000000000000000000000000000011111101010111111111101010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 427
		-- 70274.431942
		x <= "0000000000000000000000000001000100101000001001101110100100111011101001101100";
		-- 0.371155
		y <= "0000000000000000000000000000000000000000000001011111000000111111110111111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 428
		-- 70274.431942
		x <= "0000000000000000000000000001000100101000001001101110100100111011101001101100";
		-- 0.618591
		y <= "0000000000000000000000000000000000000000000010011110010110111111110010011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 429
		-- 70274.431942
		x <= "0000000000000000000000000001000100101000001001101110100100111011101001101100";
		-- 0.866028
		y <= "0000000000000000000000000000000000000000000011011101101100111111101101000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 430
		-- 70274.431942
		x <= "0000000000000000000000000001000100101000001001101110100100111011101001101100";
		-- 1.113464
		y <= "0000000000000000000000000000000000000000000100011101000010111111100111101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 431
		-- 71947.632702
		x <= "0000000000000000000000000001000110010000101110100001111110001100001101011010";
		-- -1.111121
		y <= "1111111111111111111111111111111111111111111011100011100011011000111010001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 432
		-- 71947.632702
		x <= "0000000000000000000000000001000110010000101110100001111110001100001101011010";
		-- -0.864205
		y <= "1111111111111111111111111111111111111111111100100010110000110110111011100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 433
		-- 71947.632702
		x <= "0000000000000000000000000001000110010000101110100001111110001100001101011010";
		-- -0.617290
		y <= "1111111111111111111111111111111111111111111101100001111110010100111100110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 434
		-- 71947.632702
		x <= "0000000000000000000000000001000110010000101110100001111110001100001101011010";
		-- -0.370374
		y <= "1111111111111111111111111111111111111111111110100001001011110010111110000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 435
		-- 71947.632702
		x <= "0000000000000000000000000001000110010000101110100001111110001100001101011010";
		-- -0.123458
		y <= "1111111111111111111111111111111111111111111111100000011001010000111111010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 436
		-- 71947.632702
		x <= "0000000000000000000000000001000110010000101110100001111110001100001101011010";
		-- 0.123458
		y <= "0000000000000000000000000000000000000000000000011111100110101111000000101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 437
		-- 71947.632702
		x <= "0000000000000000000000000001000110010000101110100001111110001100001101011010";
		-- 0.370374
		y <= "0000000000000000000000000000000000000000000001011110110100001101000001111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 438
		-- 71947.632702
		x <= "0000000000000000000000000001000110010000101110100001111110001100001101011010";
		-- 0.617290
		y <= "0000000000000000000000000000000000000000000010011110000001101011000011001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 439
		-- 71947.632702
		x <= "0000000000000000000000000001000110010000101110100001111110001100001101011010";
		-- 0.864205
		y <= "0000000000000000000000000000000000000000000011011101001111001001000100011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 440
		-- 71947.632702
		x <= "0000000000000000000000000001000110010000101110100001111110001100001101011010";
		-- 1.111121
		y <= "0000000000000000000000000000000000000000000100011100011100100111000101110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 441
		-- 73620.833462
		x <= "0000000000000000000000000001000111111001010011010101010111011100110001001001";
		-- -1.108842
		y <= "1111111111111111111111111111111111111111111011100100001000101110111111111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 442
		-- 73620.833462
		x <= "0000000000000000000000000001000111111001010011010101010111011100110001001001";
		-- -0.862433
		y <= "1111111111111111111111111111111111111111111100100011001101111001111000110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 443
		-- 73620.833462
		x <= "0000000000000000000000000001000111111001010011010101010111011100110001001001";
		-- -0.616023
		y <= "1111111111111111111111111111111111111111111101100010010011000100110001101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 444
		-- 73620.833462
		x <= "0000000000000000000000000001000111111001010011010101010111011100110001001001";
		-- -0.369614
		y <= "1111111111111111111111111111111111111111111110100001011000001111101010101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 445
		-- 73620.833462
		x <= "0000000000000000000000000001000111111001010011010101010111011100110001001001";
		-- -0.123205
		y <= "1111111111111111111111111111111111111111111111100000011101011010100011100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 446
		-- 73620.833462
		x <= "0000000000000000000000000001000111111001010011010101010111011100110001001001";
		-- 0.123205
		y <= "0000000000000000000000000000000000000000000000011111100010100101011100011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 447
		-- 73620.833462
		x <= "0000000000000000000000000001000111111001010011010101010111011100110001001001";
		-- 0.369614
		y <= "0000000000000000000000000000000000000000000001011110100111110000010101010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 448
		-- 73620.833462
		x <= "0000000000000000000000000001000111111001010011010101010111011100110001001001";
		-- 0.616023
		y <= "0000000000000000000000000000000000000000000010011101101100111011001110010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 449
		-- 73620.833462
		x <= "0000000000000000000000000001000111111001010011010101010111011100110001001001";
		-- 0.862433
		y <= "0000000000000000000000000000000000000000000011011100110010000110000111001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 450
		-- 73620.833462
		x <= "0000000000000000000000000001000111111001010011010101010111011100110001001001";
		-- 1.108842
		y <= "0000000000000000000000000000000000000000000100011011110111010001000000000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 451
		-- 75294.034223
		x <= "0000000000000000000000000001001001100001111000001000110000101101010100110111";
		-- -1.106623
		y <= "1111111111111111111111111111111111111111111011100100101101000101111010100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 452
		-- 75294.034223
		x <= "0000000000000000000000000001001001100001111000001000110000101101010100110111";
		-- -0.860707
		y <= "1111111111111111111111111111111111111111111100100011101010001011101101100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 453
		-- 75294.034223
		x <= "0000000000000000000000000001001001100001111000001000110000101101010100110111";
		-- -0.614790
		y <= "1111111111111111111111111111111111111111111101100010100111010001100000100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 454
		-- 75294.034223
		x <= "0000000000000000000000000001001001100001111000001000110000101101010100110111";
		-- -0.368874
		y <= "1111111111111111111111111111111111111111111110100001100100010111010011100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 455
		-- 75294.034223
		x <= "0000000000000000000000000001001001100001111000001000110000101101010100110111";
		-- -0.122958
		y <= "1111111111111111111111111111111111111111111111100000100001011101000110100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 456
		-- 75294.034223
		x <= "0000000000000000000000000001001001100001111000001000110000101101010100110111";
		-- 0.122958
		y <= "0000000000000000000000000000000000000000000000011111011110100010111001011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 457
		-- 75294.034223
		x <= "0000000000000000000000000001001001100001111000001000110000101101010100110111";
		-- 0.368874
		y <= "0000000000000000000000000000000000000000000001011110011011101000101100011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 458
		-- 75294.034223
		x <= "0000000000000000000000000001001001100001111000001000110000101101010100110111";
		-- 0.614790
		y <= "0000000000000000000000000000000000000000000010011101011000101110011111011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 459
		-- 75294.034223
		x <= "0000000000000000000000000001001001100001111000001000110000101101010100110111";
		-- 0.860707
		y <= "0000000000000000000000000000000000000000000011011100010101110100010010011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 460
		-- 75294.034223
		x <= "0000000000000000000000000001001001100001111000001000110000101101010100110111";
		-- 1.106623
		y <= "0000000000000000000000000000000000000000000100011011010010111010000101011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 461
		-- 76967.234983
		x <= "0000000000000000000000000001001011001010011100111100001001111101111000100110";
		-- -1.104461
		y <= "1111111111111111111111111111111111111111111011100101010000100000101100011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 462
		-- 76967.234983
		x <= "0000000000000000000000000001001011001010011100111100001001111101111000100110";
		-- -0.859025
		y <= "1111111111111111111111111111111111111111111100100100000101101110110000110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 463
		-- 76967.234983
		x <= "0000000000000000000000000001001011001010011100111100001001111101111000100110";
		-- -0.613589
		y <= "1111111111111111111111111111111111111111111101100010111010111100110101001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 464
		-- 76967.234983
		x <= "0000000000000000000000000001001011001010011100111100001001111101111000100110";
		-- -0.368154
		y <= "1111111111111111111111111111111111111111111110100001110000001010111001011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 465
		-- 76967.234983
		x <= "0000000000000000000000000001001011001010011100111100001001111101111000100110";
		-- -0.122718
		y <= "1111111111111111111111111111111111111111111111100000100101011000111101110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 466
		-- 76967.234983
		x <= "0000000000000000000000000001001011001010011100111100001001111101111000100110";
		-- 0.122718
		y <= "0000000000000000000000000000000000000000000000011111011010100111000010001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 467
		-- 76967.234983
		x <= "0000000000000000000000000001001011001010011100111100001001111101111000100110";
		-- 0.368154
		y <= "0000000000000000000000000000000000000000000001011110001111110101000110100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 468
		-- 76967.234983
		x <= "0000000000000000000000000001001011001010011100111100001001111101111000100110";
		-- 0.613589
		y <= "0000000000000000000000000000000000000000000010011101000101000011001010110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 469
		-- 76967.234983
		x <= "0000000000000000000000000001001011001010011100111100001001111101111000100110";
		-- 0.859025
		y <= "0000000000000000000000000000000000000000000011011011111010010001001111001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 470
		-- 76967.234983
		x <= "0000000000000000000000000001001011001010011100111100001001111101111000100110";
		-- 1.104461
		y <= "0000000000000000000000000000000000000000000100011010101111011111010011100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 471
		-- 78640.435744
		x <= "0000000000000000000000000001001100110011000001101111100011001110011100010100";
		-- -1.102354
		y <= "1111111111111111111111111111111111111111111011100101110011000010001010100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 472
		-- 78640.435744
		x <= "0000000000000000000000000001001100110011000001101111100011001110011100010100";
		-- -0.857386
		y <= "1111111111111111111111111111111111111111111100100100100000100101001111010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 473
		-- 78640.435744
		x <= "0000000000000000000000000001001100110011000001101111100011001110011100010100";
		-- -0.612419
		y <= "1111111111111111111111111111111111111111111101100011001110001000010100000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 474
		-- 78640.435744
		x <= "0000000000000000000000000001001100110011000001101111100011001110011100010100";
		-- -0.367451
		y <= "1111111111111111111111111111111111111111111110100001111011101011011000110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 475
		-- 78640.435744
		x <= "0000000000000000000000000001001100110011000001101111100011001110011100010100";
		-- -0.122484
		y <= "1111111111111111111111111111111111111111111111100000101001001110011101100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 476
		-- 78640.435744
		x <= "0000000000000000000000000001001100110011000001101111100011001110011100010100";
		-- 0.122484
		y <= "0000000000000000000000000000000000000000000000011111010110110001100010011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 477
		-- 78640.435744
		x <= "0000000000000000000000000001001100110011000001101111100011001110011100010100";
		-- 0.367451
		y <= "0000000000000000000000000000000000000000000001011110000100010100100111001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 478
		-- 78640.435744
		x <= "0000000000000000000000000001001100110011000001101111100011001110011100010100";
		-- 0.612419
		y <= "0000000000000000000000000000000000000000000010011100110001110111101011111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 479
		-- 78640.435744
		x <= "0000000000000000000000000001001100110011000001101111100011001110011100010100";
		-- 0.857386
		y <= "0000000000000000000000000000000000000000000011011011011111011010110000101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 480
		-- 78640.435744
		x <= "0000000000000000000000000001001100110011000001101111100011001110011100010100";
		-- 1.102354
		y <= "0000000000000000000000000000000000000000000100011010001100111101110101011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 481
		-- 80313.636504
		x <= "0000000000000000000000000001001110011011100110100010111100011111000000000010";
		-- -1.100299
		y <= "1111111111111111111111111111111111111111111011100110010100101100111101111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 482
		-- 80313.636504
		x <= "0000000000000000000000000001001110011011100110100010111100011111000000000010";
		-- -0.855788
		y <= "1111111111111111111111111111111111111111111100100100111010110001001100100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 483
		-- 80313.636504
		x <= "0000000000000000000000000001001110011011100110100010111100011111000000000010";
		-- -0.611277
		y <= "1111111111111111111111111111111111111111111101100011100000110101011011010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 484
		-- 80313.636504
		x <= "0000000000000000000000000001001110011011100110100010111100011111000000000010";
		-- -0.366766
		y <= "1111111111111111111111111111111111111111111110100010000110111001101001111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 485
		-- 80313.636504
		x <= "0000000000000000000000000001001110011011100110100010111100011111000000000010";
		-- -0.122255
		y <= "1111111111111111111111111111111111111111111111100000101100111101111000101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 486
		-- 80313.636504
		x <= "0000000000000000000000000001001110011011100110100010111100011111000000000010";
		-- 0.122255
		y <= "0000000000000000000000000000000000000000000000011111010011000010000111010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 487
		-- 80313.636504
		x <= "0000000000000000000000000001001110011011100110100010111100011111000000000010";
		-- 0.366766
		y <= "0000000000000000000000000000000000000000000001011101111001000110010110000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 488
		-- 80313.636504
		x <= "0000000000000000000000000001001110011011100110100010111100011111000000000010";
		-- 0.611277
		y <= "0000000000000000000000000000000000000000000010011100011111001010100100101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 489
		-- 80313.636504
		x <= "0000000000000000000000000001001110011011100110100010111100011111000000000010";
		-- 0.855788
		y <= "0000000000000000000000000000000000000000000011011011000101001110110011011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 490
		-- 80313.636504
		x <= "0000000000000000000000000001001110011011100110100010111100011111000000000010";
		-- 1.100299
		y <= "0000000000000000000000000000000000000000000100011001101011010011000010000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 491
		-- 81986.837265
		x <= "0000000000000000000000000001010000000100001011010110010101101111100011110001";
		-- -1.098294
		y <= "1111111111111111111111111111111111111111111011100110110101100011100100001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 492
		-- 81986.837265
		x <= "0000000000000000000000000001010000000100001011010110010101101111100011110001";
		-- -0.854228
		y <= "1111111111111111111111111111111111111111111100100101010100010100100011001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 493
		-- 81986.837265
		x <= "0000000000000000000000000001010000000100001011010110010101101111100011110001";
		-- -0.610163
		y <= "1111111111111111111111111111111111111111111101100011110011000101100010010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 494
		-- 81986.837265
		x <= "0000000000000000000000000001010000000100001011010110010101101111100011110001";
		-- -0.366098
		y <= "1111111111111111111111111111111111111111111110100010010001110110100001011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 495
		-- 81986.837265
		x <= "0000000000000000000000000001010000000100001011010110010101101111100011110001";
		-- -0.122033
		y <= "1111111111111111111111111111111111111111111111100000110000100111100000011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 496
		-- 81986.837265
		x <= "0000000000000000000000000001010000000100001011010110010101101111100011110001";
		-- 0.122033
		y <= "0000000000000000000000000000000000000000000000011111001111011000011111100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 497
		-- 81986.837265
		x <= "0000000000000000000000000001010000000100001011010110010101101111100011110001";
		-- 0.366098
		y <= "0000000000000000000000000000000000000000000001011101101110001001011110100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 498
		-- 81986.837265
		x <= "0000000000000000000000000001010000000100001011010110010101101111100011110001";
		-- 0.610163
		y <= "0000000000000000000000000000000000000000000010011100001100111010011101101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 499
		-- 81986.837265
		x <= "0000000000000000000000000001010000000100001011010110010101101111100011110001";
		-- 0.854228
		y <= "0000000000000000000000000000000000000000000011011010101011101011011100110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 500
		-- 81986.837265
		x <= "0000000000000000000000000001010000000100001011010110010101101111100011110001";
		-- 1.098294
		y <= "0000000000000000000000000000000000000000000100011001001010011100011011110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 501
		-- 83660.038025
		x <= "0000000000000000000000000001010001101100110000001001101111000000000111011111";
		-- -1.096336
		y <= "1111111111111111111111111111111111111111111011100111010101101000010000110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 502
		-- 83660.038025
		x <= "0000000000000000000000000001010001101100110000001001101111000000000111011111";
		-- -0.852706
		y <= "1111111111111111111111111111111111111111111100100101101101010001000101111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 503
		-- 83660.038025
		x <= "0000000000000000000000000001010001101100110000001001101111000000000111011111";
		-- -0.609076
		y <= "1111111111111111111111111111111111111111111101100100000100111001111011000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 504
		-- 83660.038025
		x <= "0000000000000000000000000001010001101100110000001001101111000000000111011111";
		-- -0.365445
		y <= "1111111111111111111111111111111111111111111110100010011100100010110000010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 505
		-- 83660.038025
		x <= "0000000000000000000000000001010001101100110000001001101111000000000111011111";
		-- -0.121815
		y <= "1111111111111111111111111111111111111111111111100000110100001011100101011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 506
		-- 83660.038025
		x <= "0000000000000000000000000001010001101100110000001001101111000000000111011111";
		-- 0.121815
		y <= "0000000000000000000000000000000000000000000000011111001011110100011010100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 507
		-- 83660.038025
		x <= "0000000000000000000000000001010001101100110000001001101111000000000111011111";
		-- 0.365445
		y <= "0000000000000000000000000000000000000000000001011101100011011101001111101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 508
		-- 83660.038025
		x <= "0000000000000000000000000001010001101100110000001001101111000000000111011111";
		-- 0.609076
		y <= "0000000000000000000000000000000000000000000010011011111011000110000100111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 509
		-- 83660.038025
		x <= "0000000000000000000000000001010001101100110000001001101111000000000111011111";
		-- 0.852706
		y <= "0000000000000000000000000000000000000000000011011010010010101110111010000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 510
		-- 83660.038025
		x <= "0000000000000000000000000001010001101100110000001001101111000000000111011111";
		-- 1.096336
		y <= "0000000000000000000000000000000000000000000100011000101010010111101111001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 511
		-- 85333.238785
		x <= "0000000000000000000000000001010011010101010100111101001000010000101011001110";
		-- -1.094424
		y <= "1111111111111111111111111111111111111111111011100111110100111101001110000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 512
		-- 85333.238785
		x <= "0000000000000000000000000001010011010101010100111101001000010000101011001110";
		-- -0.851219
		y <= "1111111111111111111111111111111111111111111100100110000101101000100000010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 513
		-- 85333.238785
		x <= "0000000000000000000000000001010011010101010100111101001000010000101011001110";
		-- -0.608013
		y <= "1111111111111111111111111111111111111111111101100100010110010011110010100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 514
		-- 85333.238785
		x <= "0000000000000000000000000001010011010101010100111101001000010000101011001110";
		-- -0.364808
		y <= "1111111111111111111111111111111111111111111110100010100110111111000100101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 515
		-- 85333.238785
		x <= "0000000000000000000000000001010011010101010100111101001000010000101011001110";
		-- -0.121603
		y <= "1111111111111111111111111111111111111111111111100000110111101010010110111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 516
		-- 85333.238785
		x <= "0000000000000000000000000001010011010101010100111101001000010000101011001110";
		-- 0.121603
		y <= "0000000000000000000000000000000000000000000000011111001000010101101001000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 517
		-- 85333.238785
		x <= "0000000000000000000000000001010011010101010100111101001000010000101011001110";
		-- 0.364808
		y <= "0000000000000000000000000000000000000000000001011101011001000000111011010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 518
		-- 85333.238785
		x <= "0000000000000000000000000001010011010101010100111101001000010000101011001110";
		-- 0.608013
		y <= "0000000000000000000000000000000000000000000010011011101001101100001101011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 519
		-- 85333.238785
		x <= "0000000000000000000000000001010011010101010100111101001000010000101011001110";
		-- 0.851219
		y <= "0000000000000000000000000000000000000000000011011001111010010111011111101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 520
		-- 85333.238785
		x <= "0000000000000000000000000001010011010101010100111101001000010000101011001110";
		-- 1.094424
		y <= "0000000000000000000000000000000000000000000100011000001011000010110001111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 521
		-- 87006.439546
		x <= "0000000000000000000000000001010100111101111001110000100001100001001110111100";
		-- -1.092556
		y <= "1111111111111111111111111111111111111111111011101000010011100100011101110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 522
		-- 87006.439546
		x <= "0000000000000000000000000001010100111101111001110000100001100001001110111100";
		-- -0.849765
		y <= "1111111111111111111111111111111111111111111100100110011101011100010111001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 523
		-- 87006.439546
		x <= "0000000000000000000000000001010100111101111001110000100001100001001110111100";
		-- -0.606975
		y <= "1111111111111111111111111111111111111111111101100100100111010100010000100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 524
		-- 87006.439546
		x <= "0000000000000000000000000001010100111101111001110000100001100001001110111100";
		-- -0.364185
		y <= "1111111111111111111111111111111111111111111110100010110001001100001001111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 525
		-- 87006.439546
		x <= "0000000000000000000000000001010100111101111001110000100001100001001110111100";
		-- -0.121395
		y <= "1111111111111111111111111111111111111111111111100000111011000100000011010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 526
		-- 87006.439546
		x <= "0000000000000000000000000001010100111101111001110000100001100001001110111100";
		-- 0.121395
		y <= "0000000000000000000000000000000000000000000000011111000100111011111100101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 527
		-- 87006.439546
		x <= "0000000000000000000000000001010100111101111001110000100001100001001110111100";
		-- 0.364185
		y <= "0000000000000000000000000000000000000000000001011101001110110011110110000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 528
		-- 87006.439546
		x <= "0000000000000000000000000001010100111101111001110000100001100001001110111100";
		-- 0.606975
		y <= "0000000000000000000000000000000000000000000010011011011000101011101111011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 529
		-- 87006.439546
		x <= "0000000000000000000000000001010100111101111001110000100001100001001110111100";
		-- 0.849765
		y <= "0000000000000000000000000000000000000000000011011001100010100011101000110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 530
		-- 87006.439546
		x <= "0000000000000000000000000001010100111101111001110000100001100001001110111100";
		-- 1.092556
		y <= "0000000000000000000000000000000000000000000100010111101100011011100010001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 531
		-- 88679.640306
		x <= "0000000000000000000000000001010110100110011110100011111010110001110010101011";
		-- -1.090729
		y <= "1111111111111111111111111111111111111111111011101000110001011111111001100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 532
		-- 88679.640306
		x <= "0000000000000000000000000001010110100110011110100011111010110001110010101011";
		-- -0.848345
		y <= "1111111111111111111111111111111111111111111100100110110100101110001001010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 533
		-- 88679.640306
		x <= "0000000000000000000000000001010110100110011110100011111010110001110010101011";
		-- -0.605960
		y <= "1111111111111111111111111111111111111111111101100100110111111100011000111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 534
		-- 88679.640306
		x <= "0000000000000000000000000001010110100110011110100011111010110001110010101011";
		-- -0.363576
		y <= "1111111111111111111111111111111111111111111110100010111011001010101000100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 535
		-- 88679.640306
		x <= "0000000000000000000000000001010110100110011110100011111010110001110010101011";
		-- -0.121192
		y <= "1111111111111111111111111111111111111111111111100000111110011000111000001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 536
		-- 88679.640306
		x <= "0000000000000000000000000001010110100110011110100011111010110001110010101011";
		-- 0.121192
		y <= "0000000000000000000000000000000000000000000000011111000001100111000111110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 537
		-- 88679.640306
		x <= "0000000000000000000000000001010110100110011110100011111010110001110010101011";
		-- 0.363576
		y <= "0000000000000000000000000000000000000000000001011101000100110101010111011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 538
		-- 88679.640306
		x <= "0000000000000000000000000001010110100110011110100011111010110001110010101011";
		-- 0.605960
		y <= "0000000000000000000000000000000000000000000010011011001000000011100111000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 539
		-- 88679.640306
		x <= "0000000000000000000000000001010110100110011110100011111010110001110010101011";
		-- 0.848345
		y <= "0000000000000000000000000000000000000000000011011001001011010001110110101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 540
		-- 88679.640306
		x <= "0000000000000000000000000001010110100110011110100011111010110001110010101011";
		-- 1.090729
		y <= "0000000000000000000000000000000000000000000100010111001110100000000110011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 541
		-- 90352.841067
		x <= "0000000000000000000000000001011000001111000011010111010100000010010110011001";
		-- -1.088942
		y <= "1111111111111111111111111111111111111111111011101001001110110001010100000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 542
		-- 90352.841067
		x <= "0000000000000000000000000001011000001111000011010111010100000010010110011001";
		-- -0.846955
		y <= "1111111111111111111111111111111111111111111100100111001011011111001111101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 543
		-- 90352.841067
		x <= "0000000000000000000000000001011000001111000011010111010100000010010110011001";
		-- -0.604968
		y <= "1111111111111111111111111111111111111111111101100101001000001101001011001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 544
		-- 90352.841067
		x <= "0000000000000000000000000001011000001111000011010111010100000010010110011001";
		-- -0.362981
		y <= "1111111111111111111111111111111111111111111110100011000100111011000110101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 545
		-- 90352.841067
		x <= "0000000000000000000000000001011000001111000011010111010100000010010110011001";
		-- -0.120994
		y <= "1111111111111111111111111111111111111111111111100001000001101001000010001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 546
		-- 90352.841067
		x <= "0000000000000000000000000001011000001111000011010111010100000010010110011001";
		-- 0.120994
		y <= "0000000000000000000000000000000000000000000000011110111110010110111101110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 547
		-- 90352.841067
		x <= "0000000000000000000000000001011000001111000011010111010100000010010110011001";
		-- 0.362981
		y <= "0000000000000000000000000000000000000000000001011100111011000100111001010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 548
		-- 90352.841067
		x <= "0000000000000000000000000001011000001111000011010111010100000010010110011001";
		-- 0.604968
		y <= "0000000000000000000000000000000000000000000010011010110111110010110100110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 549
		-- 90352.841067
		x <= "0000000000000000000000000001011000001111000011010111010100000010010110011001";
		-- 0.846955
		y <= "0000000000000000000000000000000000000000000011011000110100100000110000010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 550
		-- 90352.841067
		x <= "0000000000000000000000000001011000001111000011010111010100000010010110011001";
		-- 1.088942
		y <= "0000000000000000000000000000000000000000000100010110110001001110101011111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 551
		-- 92026.041827
		x <= "0000000000000000000000000001011001110111101000001010101101010010111010001000";
		-- -1.087194
		y <= "1111111111111111111111111111111111111111111011101001101011011010011001000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 552
		-- 92026.041827
		x <= "0000000000000000000000000001011001110111101000001010101101010010111010001000";
		-- -0.845595
		y <= "1111111111111111111111111111111111111111111100100111100001110000111110001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 553
		-- 92026.041827
		x <= "0000000000000000000000000001011001110111101000001010101101010010111010001000";
		-- -0.603997
		y <= "1111111111111111111111111111111111111111111101100101011000000111100011001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 554
		-- 92026.041827
		x <= "0000000000000000000000000001011001110111101000001010101101010010111010001000";
		-- -0.362398
		y <= "1111111111111111111111111111111111111111111110100011001110011110001000010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 555
		-- 92026.041827
		x <= "0000000000000000000000000001011001110111101000001010101101010010111010001000";
		-- -0.120799
		y <= "1111111111111111111111111111111111111111111111100001000100110100101101011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 556
		-- 92026.041827
		x <= "0000000000000000000000000001011001110111101000001010101101010010111010001000";
		-- 0.120799
		y <= "0000000000000000000000000000000000000000000000011110111011001011010010100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 557
		-- 92026.041827
		x <= "0000000000000000000000000001011001110111101000001010101101010010111010001000";
		-- 0.362398
		y <= "0000000000000000000000000000000000000000000001011100110001100001110111101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 558
		-- 92026.041827
		x <= "0000000000000000000000000001011001110111101000001010101101010010111010001000";
		-- 0.603997
		y <= "0000000000000000000000000000000000000000000010011010100111111000011100110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 559
		-- 92026.041827
		x <= "0000000000000000000000000001011001110111101000001010101101010010111010001000";
		-- 0.845595
		y <= "0000000000000000000000000000000000000000000011011000011110001111000001110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 560
		-- 92026.041827
		x <= "0000000000000000000000000001011001110111101000001010101101010010111010001000";
		-- 1.087194
		y <= "0000000000000000000000000000000000000000000100010110010100100101100110111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 561
		-- 93699.242588
		x <= "0000000000000000000000000001011011100000001100111110000110100011011101110110";
		-- -1.085483
		y <= "1111111111111111111111111111111111111111111011101010000111011100101110000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 562
		-- 93699.242588
		x <= "0000000000000000000000000001011011100000001100111110000110100011011101110110";
		-- -0.844264
		y <= "1111111111111111111111111111111111111111111100100111110111100100100011110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 563
		-- 93699.242588
		x <= "0000000000000000000000000001011011100000001100111110000110100011011101110110";
		-- -0.603046
		y <= "1111111111111111111111111111111111111111111101100101100111101100011001100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 564
		-- 93699.242588
		x <= "0000000000000000000000000001011011100000001100111110000110100011011101110110";
		-- -0.361828
		y <= "1111111111111111111111111111111111111111111110100011010111110100001111010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 565
		-- 93699.242588
		x <= "0000000000000000000000000001011011100000001100111110000110100011011101110110";
		-- -0.120609
		y <= "1111111111111111111111111111111111111111111111100001000111111100000101000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 566
		-- 93699.242588
		x <= "0000000000000000000000000001011011100000001100111110000110100011011101110110";
		-- 0.120609
		y <= "0000000000000000000000000000000000000000000000011110111000000011111010111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 567
		-- 93699.242588
		x <= "0000000000000000000000000001011011100000001100111110000110100011011101110110";
		-- 0.361828
		y <= "0000000000000000000000000000000000000000000001011100101000001011110000101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 568
		-- 93699.242588
		x <= "0000000000000000000000000001011011100000001100111110000110100011011101110110";
		-- 0.603046
		y <= "0000000000000000000000000000000000000000000010011010011000010011100110011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 569
		-- 93699.242588
		x <= "0000000000000000000000000001011011100000001100111110000110100011011101110110";
		-- 0.844264
		y <= "0000000000000000000000000000000000000000000011011000001000011011011100001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 570
		-- 93699.242588
		x <= "0000000000000000000000000001011011100000001100111110000110100011011101110110";
		-- 1.085483
		y <= "0000000000000000000000000000000000000000000100010101111000100011010001111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 571
		-- 95372.443348
		x <= "0000000000000000000000000001011101001000110001110001011111110100000001100101";
		-- -1.083807
		y <= "1111111111111111111111111111111111111111111011101010100010111001110011000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 572
		-- 95372.443348
		x <= "0000000000000000000000000001011101001000110001110001011111110100000001100101";
		-- -0.842961
		y <= "1111111111111111111111111111111111111111111100101000001100111011001011010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 573
		-- 95372.443348
		x <= "0000000000000000000000000001011101001000110001110001011111110100000001100101";
		-- -0.602115
		y <= "1111111111111111111111111111111111111111111101100101110110111100100011011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 574
		-- 95372.443348
		x <= "0000000000000000000000000001011101001000110001110001011111110100000001100101";
		-- -0.361269
		y <= "1111111111111111111111111111111111111111111110100011100000111101111011101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 575
		-- 95372.443348
		x <= "0000000000000000000000000001011101001000110001110001011111110100000001100101";
		-- -0.120423
		y <= "1111111111111111111111111111111111111111111111100001001010111111010011111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 576
		-- 95372.443348
		x <= "0000000000000000000000000001011101001000110001110001011111110100000001100101";
		-- 0.120423
		y <= "0000000000000000000000000000000000000000000000011110110101000000101100000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 577
		-- 95372.443348
		x <= "0000000000000000000000000001011101001000110001110001011111110100000001100101";
		-- 0.361269
		y <= "0000000000000000000000000000000000000000000001011100011111000010000100010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 578
		-- 95372.443348
		x <= "0000000000000000000000000001011101001000110001110001011111110100000001100101";
		-- 0.602115
		y <= "0000000000000000000000000000000000000000000010011010001001000011011100100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 579
		-- 95372.443348
		x <= "0000000000000000000000000001011101001000110001110001011111110100000001100101";
		-- 0.842961
		y <= "0000000000000000000000000000000000000000000011010111110011000100110100101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 580
		-- 95372.443348
		x <= "0000000000000000000000000001011101001000110001110001011111110100000001100101";
		-- 1.083807
		y <= "0000000000000000000000000000000000000000000100010101011101000110001100111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 581
		-- 97045.644108
		x <= "0000000000000000000000000001011110110001010110100100111001000100100101010011";
		-- -1.082166
		y <= "1111111111111111111111111111111111111111111011101010111101110011000010100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 582
		-- 97045.644108
		x <= "0000000000000000000000000001011110110001010110100100111001000100100101010011";
		-- -0.841684
		y <= "1111111111111111111111111111111111111111111100101000100001110101111010111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 583
		-- 97045.644108
		x <= "0000000000000000000000000001011110110001010110100100111001000100100101010011";
		-- -0.601203
		y <= "1111111111111111111111111111111111111111111101100110000101111000110011001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 584
		-- 97045.644108
		x <= "0000000000000000000000000001011110110001010110100100111001000100100101010011";
		-- -0.360722
		y <= "1111111111111111111111111111111111111111111110100011101001111011101011100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 585
		-- 97045.644108
		x <= "0000000000000000000000000001011110110001010110100100111001000100100101010011";
		-- -0.120241
		y <= "1111111111111111111111111111111111111111111111100001001101111110100011110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 586
		-- 97045.644108
		x <= "0000000000000000000000000001011110110001010110100100111001000100100101010011";
		-- 0.120241
		y <= "0000000000000000000000000000000000000000000000011110110010000001011100001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 587
		-- 97045.644108
		x <= "0000000000000000000000000001011110110001010110100100111001000100100101010011";
		-- 0.360722
		y <= "0000000000000000000000000000000000000000000001011100010110000100010100011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 588
		-- 97045.644108
		x <= "0000000000000000000000000001011110110001010110100100111001000100100101010011";
		-- 0.601203
		y <= "0000000000000000000000000000000000000000000010011001111010000111001100110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 589
		-- 97045.644108
		x <= "0000000000000000000000000001011110110001010110100100111001000100100101010011";
		-- 0.841684
		y <= "0000000000000000000000000000000000000000000011010111011110001010000101000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 590
		-- 97045.644108
		x <= "0000000000000000000000000001011110110001010110100100111001000100100101010011";
		-- 1.082166
		y <= "0000000000000000000000000000000000000000000100010101000010001100111101011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 591
		-- 98718.844869
		x <= "0000000000000000000000000001100000011001111011011000010010010101001001000010";
		-- -1.080557
		y <= "1111111111111111111111111111111111111111111011101011011000001001110010010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 592
		-- 98718.844869
		x <= "0000000000000000000000000001100000011001111011011000010010010101001001000010";
		-- -0.840433
		y <= "1111111111111111111111111111111111111111111100101000110110010101110101010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 593
		-- 98718.844869
		x <= "0000000000000000000000000001100000011001111011011000010010010101001001000010";
		-- -0.600309
		y <= "1111111111111111111111111111111111111111111101100110010100100001111000010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 594
		-- 98718.844869
		x <= "0000000000000000000000000001100000011001111011011000010010010101001001000010";
		-- -0.360186
		y <= "1111111111111111111111111111111111111111111110100011110010101101111011011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 595
		-- 98718.844869
		x <= "0000000000000000000000000001100000011001111011011000010010010101001001000010";
		-- -0.120062
		y <= "1111111111111111111111111111111111111111111111100001010000111001111110011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 596
		-- 98718.844869
		x <= "0000000000000000000000000001100000011001111011011000010010010101001001000010";
		-- 0.120062
		y <= "0000000000000000000000000000000000000000000000011110101111000110000001100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 597
		-- 98718.844869
		x <= "0000000000000000000000000001100000011001111011011000010010010101001001000010";
		-- 0.360186
		y <= "0000000000000000000000000000000000000000000001011100001101010010000100100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 598
		-- 98718.844869
		x <= "0000000000000000000000000001100000011001111011011000010010010101001001000010";
		-- 0.600309
		y <= "0000000000000000000000000000000000000000000010011001101011011110000111101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 599
		-- 98718.844869
		x <= "0000000000000000000000000001100000011001111011011000010010010101001001000010";
		-- 0.840433
		y <= "0000000000000000000000000000000000000000000011010111001001101010001010101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 600
		-- 98718.844869
		x <= "0000000000000000000000000001100000011001111011011000010010010101001001000010";
		-- 1.080557
		y <= "0000000000000000000000000000000000000000000100010100100111110110001101101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 601
		-- 100392.045629
		x <= "0000000000000000000000000001100010000010100000001011101011100101101100110000";
		-- -1.078980
		y <= "1111111111111111111111111111111111111111111011101011110001111111010011000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 602
		-- 100392.045629
		x <= "0000000000000000000000000001100010000010100000001011101011100101101100110000";
		-- -0.839207
		y <= "1111111111111111111111111111111111111111111100101001001010011011111001100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 603
		-- 100392.045629
		x <= "0000000000000000000000000001100010000010100000001011101011100101101100110000";
		-- -0.599433
		y <= "1111111111111111111111111111111111111111111101100110100010111000011111111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 604
		-- 100392.045629
		x <= "0000000000000000000000000001100010000010100000001011101011100101101100110000";
		-- -0.359660
		y <= "1111111111111111111111111111111111111111111110100011111011010101000110010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 605
		-- 100392.045629
		x <= "0000000000000000000000000001100010000010100000001011101011100101101100110000";
		-- -0.119887
		y <= "1111111111111111111111111111111111111111111111100001010011110001101100110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 606
		-- 100392.045629
		x <= "0000000000000000000000000001100010000010100000001011101011100101101100110000";
		-- 0.119887
		y <= "0000000000000000000000000000000000000000000000011110101100001110010011001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 607
		-- 100392.045629
		x <= "0000000000000000000000000001100010000010100000001011101011100101101100110000";
		-- 0.359660
		y <= "0000000000000000000000000000000000000000000001011100000100101010111001101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 608
		-- 100392.045629
		x <= "0000000000000000000000000001100010000010100000001011101011100101101100110000";
		-- 0.599433
		y <= "0000000000000000000000000000000000000000000010011001011101000111100000000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 609
		-- 100392.045629
		x <= "0000000000000000000000000001100010000010100000001011101011100101101100110000";
		-- 0.839207
		y <= "0000000000000000000000000000000000000000000011010110110101100100000110011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 610
		-- 100392.045629
		x <= "0000000000000000000000000001100010000010100000001011101011100101101100110000";
		-- 1.078980
		y <= "0000000000000000000000000000000000000000000100010100001110000000101100111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 611
		-- 102065.246390
		x <= "0000000000000000000000000001100011101011000100111111000100110110010000011111";
		-- -1.077434
		y <= "1111111111111111111111111111111111111111111011101100001011010100110001110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 612
		-- 102065.246390
		x <= "0000000000000000000000000001100011101011000100111111000100110110010000011111";
		-- -0.838004
		y <= "1111111111111111111111111111111111111111111100101001011110001001000011001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 613
		-- 102065.246390
		x <= "0000000000000000000000000001100011101011000100111111000100110110010000011111";
		-- -0.598574
		y <= "1111111111111111111111111111111111111111111101100110110000111101010100100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 614
		-- 102065.246390
		x <= "0000000000000000000000000001100011101011000100111111000100110110010000011111";
		-- -0.359145
		y <= "1111111111111111111111111111111111111111111110100100000011110001100101111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 615
		-- 102065.246390
		x <= "0000000000000000000000000001100011101011000100111111000100110110010000011111";
		-- -0.119715
		y <= "1111111111111111111111111111111111111111111111100001010110100101110111010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 616
		-- 102065.246390
		x <= "0000000000000000000000000001100011101011000100111111000100110110010000011111";
		-- 0.119715
		y <= "0000000000000000000000000000000000000000000000011110101001011010001000101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 617
		-- 102065.246390
		x <= "0000000000000000000000000001100011101011000100111111000100110110010000011111";
		-- 0.359145
		y <= "0000000000000000000000000000000000000000000001011011111100001110011010000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 618
		-- 102065.246390
		x <= "0000000000000000000000000001100011101011000100111111000100110110010000011111";
		-- 0.598574
		y <= "0000000000000000000000000000000000000000000010011001001111000010101011011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 619
		-- 102065.246390
		x <= "0000000000000000000000000001100011101011000100111111000100110110010000011111";
		-- 0.838004
		y <= "0000000000000000000000000000000000000000000011010110100001110110111100110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 620
		-- 102065.246390
		x <= "0000000000000000000000000001100011101011000100111111000100110110010000011111";
		-- 1.077434
		y <= "0000000000000000000000000000000000000000000100010011110100101011001110001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 621
		-- 103738.447150
		x <= "0000000000000000000000000001100101010011101001110010011110000110110100001101";
		-- -1.075917
		y <= "1111111111111111111111111111111111111111111011101100100100001011010111010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 622
		-- 103738.447150
		x <= "0000000000000000000000000001100101010011101001110010011110000110110100001101";
		-- -0.836824
		y <= "1111111111111111111111111111111111111111111100101001110001011110001011000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 623
		-- 103738.447150
		x <= "0000000000000000000000000001100101010011101001110010011110000110110100001101";
		-- -0.597732
		y <= "1111111111111111111111111111111111111111111101100110111110110000111110101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 624
		-- 103738.447150
		x <= "0000000000000000000000000001100101010011101001110010011110000110110100001101";
		-- -0.358639
		y <= "1111111111111111111111111111111111111111111110100100001100000011110010011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 625
		-- 103738.447150
		x <= "0000000000000000000000000001100101010011101001110010011110000110110100001101";
		-- -0.119546
		y <= "1111111111111111111111111111111111111111111111100001011001010110100110001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 626
		-- 103738.447150
		x <= "0000000000000000000000000001100101010011101001110010011110000110110100001101";
		-- 0.119546
		y <= "0000000000000000000000000000000000000000000000011110100110101001011001110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 627
		-- 103738.447150
		x <= "0000000000000000000000000001100101010011101001110010011110000110110100001101";
		-- 0.358639
		y <= "0000000000000000000000000000000000000000000001011011110011111100001101100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 628
		-- 103738.447150
		x <= "0000000000000000000000000001100101010011101001110010011110000110110100001101";
		-- 0.597732
		y <= "0000000000000000000000000000000000000000000010011001000001001111000001010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 629
		-- 103738.447150
		x <= "0000000000000000000000000001100101010011101001110010011110000110110100001101";
		-- 0.836824
		y <= "0000000000000000000000000000000000000000000011010110001110100001110100111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 630
		-- 103738.447150
		x <= "0000000000000000000000000001100101010011101001110010011110000110110100001101";
		-- 1.075917
		y <= "0000000000000000000000000000000000000000000100010011011011110100101000101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 631
		-- 105411.647910
		x <= "0000000000000000000000000001100110111100001110100101110111010111010111111100";
		-- -1.074428
		y <= "1111111111111111111111111111111111111111111011101100111100100100001000100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 632
		-- 105411.647910
		x <= "0000000000000000000000000001100110111100001110100101110111010111010111111100";
		-- -0.835667
		y <= "1111111111111111111111111111111111111111111100101010000100011100000110101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 633
		-- 105411.647910
		x <= "0000000000000000000000000001100110111100001110100101110111010111010111111100";
		-- -0.596905
		y <= "1111111111111111111111111111111111111111111101100111001100010100000100101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 634
		-- 105411.647910
		x <= "0000000000000000000000000001100110111100001110100101110111010111010111111100";
		-- -0.358143
		y <= "1111111111111111111111111111111111111111111110100100010100001100000010110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 635
		-- 105411.647910
		x <= "0000000000000000000000000001100110111100001110100101110111010111010111111100";
		-- -0.119381
		y <= "1111111111111111111111111111111111111111111111100001011100000100000000111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 636
		-- 105411.647910
		x <= "0000000000000000000000000001100110111100001110100101110111010111010111111100";
		-- 0.119381
		y <= "0000000000000000000000000000000000000000000000011110100011111011111111000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 637
		-- 105411.647910
		x <= "0000000000000000000000000001100110111100001110100101110111010111010111111100";
		-- 0.358143
		y <= "0000000000000000000000000000000000000000000001011011101011110011111101001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 638
		-- 105411.647910
		x <= "0000000000000000000000000001100110111100001110100101110111010111010111111100";
		-- 0.596905
		y <= "0000000000000000000000000000000000000000000010011000110011101011111011010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 639
		-- 105411.647910
		x <= "0000000000000000000000000001100110111100001110100101110111010111010111111100";
		-- 0.835667
		y <= "0000000000000000000000000000000000000000000011010101111011100011111001010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 640
		-- 105411.647910
		x <= "0000000000000000000000000001100110111100001110100101110111010111010111111100";
		-- 1.074428
		y <= "0000000000000000000000000000000000000000000100010011000011011011110111011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 641
		-- 107084.848671
		x <= "0000000000000000000000000001101000100100110011011001010000100111111011101010";
		-- -1.072967
		y <= "1111111111111111111111111111111111111111111011101101010100100000000111000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 642
		-- 107084.848671
		x <= "0000000000000000000000000001101000100100110011011001010000100111111011101010";
		-- -0.834530
		y <= "1111111111111111111111111111111111111111111100101010010111000011101001000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 643
		-- 107084.848671
		x <= "0000000000000000000000000001101000100100110011011001010000100111111011101010";
		-- -0.596093
		y <= "1111111111111111111111111111111111111111111101100111011001100111001011000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 644
		-- 107084.848671
		x <= "0000000000000000000000000001101000100100110011011001010000100111111011101010";
		-- -0.357656
		y <= "1111111111111111111111111111111111111111111110100100011100001010101101000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 645
		-- 107084.848671
		x <= "0000000000000000000000000001101000100100110011011001010000100111111011101010";
		-- -0.119219
		y <= "1111111111111111111111111111111111111111111111100001011110101110001111000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 646
		-- 107084.848671
		x <= "0000000000000000000000000001101000100100110011011001010000100111111011101010";
		-- 0.119219
		y <= "0000000000000000000000000000000000000000000000011110100001010001110000111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 647
		-- 107084.848671
		x <= "0000000000000000000000000001101000100100110011011001010000100111111011101010";
		-- 0.357656
		y <= "0000000000000000000000000000000000000000000001011011100011110101010010111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 648
		-- 107084.848671
		x <= "0000000000000000000000000001101000100100110011011001010000100111111011101010";
		-- 0.596093
		y <= "0000000000000000000000000000000000000000000010011000100110011000110100111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 649
		-- 107084.848671
		x <= "0000000000000000000000000001101000100100110011011001010000100111111011101010";
		-- 0.834530
		y <= "0000000000000000000000000000000000000000000011010101101000111100010110111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 650
		-- 107084.848671
		x <= "0000000000000000000000000001101000100100110011011001010000100111111011101010";
		-- 1.072967
		y <= "0000000000000000000000000000000000000000000100010010101011011111111000111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 651
		-- 108758.049431
		x <= "0000000000000000000000000001101010001101011000001100101001111000011111011001";
		-- -1.071533
		y <= "1111111111111111111111111111111111111111111011101101101100000000010001011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 652
		-- 108758.049431
		x <= "0000000000000000000000000001101010001101011000001100101001111000011111011001";
		-- -0.833415
		y <= "1111111111111111111111111111111111111111111100101010101001010101100010110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 653
		-- 108758.049431
		x <= "0000000000000000000000000001101010001101011000001100101001111000011111011001";
		-- -0.595296
		y <= "1111111111111111111111111111111111111111111101100111100110101010110100010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 654
		-- 108758.049431
		x <= "0000000000000000000000000001101010001101011000001100101001111000011111011001";
		-- -0.357178
		y <= "1111111111111111111111111111111111111111111110100100100100000000000101110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 655
		-- 108758.049431
		x <= "0000000000000000000000000001101010001101011000001100101001111000011111011001";
		-- -0.119059
		y <= "1111111111111111111111111111111111111111111111100001100001010101010111010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 656
		-- 108758.049431
		x <= "0000000000000000000000000001101010001101011000001100101001111000011111011001";
		-- 0.119059
		y <= "0000000000000000000000000000000000000000000000011110011110101010101000101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 657
		-- 108758.049431
		x <= "0000000000000000000000000001101010001101011000001100101001111000011111011001";
		-- 0.357178
		y <= "0000000000000000000000000000000000000000000001011011011011111111111010001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 658
		-- 108758.049431
		x <= "0000000000000000000000000001101010001101011000001100101001111000011111011001";
		-- 0.595296
		y <= "0000000000000000000000000000000000000000000010011000011001010101001011101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 659
		-- 108758.049431
		x <= "0000000000000000000000000001101010001101011000001100101001111000011111011001";
		-- 0.833415
		y <= "0000000000000000000000000000000000000000000011010101010110101010011101001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 660
		-- 108758.049431
		x <= "0000000000000000000000000001101010001101011000001100101001111000011111011001";
		-- 1.071533
		y <= "0000000000000000000000000000000000000000000100010010010011111111101110100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 661
		-- 110431.250192
		x <= "0000000000000000000000000001101011110101111101000000000011001001000011000111";
		-- -1.070124
		y <= "1111111111111111111111111111111111111111111011101110000011000101100010101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 662
		-- 110431.250192
		x <= "0000000000000000000000000001101011110101111101000000000011001001000011000111";
		-- -0.832319
		y <= "1111111111111111111111111111111111111111111100101010111011010010100010000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 663
		-- 110431.250192
		x <= "0000000000000000000000000001101011110101111101000000000011001001000011000111";
		-- -0.594513
		y <= "1111111111111111111111111111111111111111111101100111110011011111100001011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 664
		-- 110431.250192
		x <= "0000000000000000000000000001101011110101111101000000000011001001000011000111";
		-- -0.356708
		y <= "1111111111111111111111111111111111111111111110100100101011101100100000111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 665
		-- 110431.250192
		x <= "0000000000000000000000000001101011110101111101000000000011001001000011000111";
		-- -0.118903
		y <= "1111111111111111111111111111111111111111111111100001100011111001100000010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 666
		-- 110431.250192
		x <= "0000000000000000000000000001101011110101111101000000000011001001000011000111";
		-- 0.118903
		y <= "0000000000000000000000000000000000000000000000011110011100000110011111101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 667
		-- 110431.250192
		x <= "0000000000000000000000000001101011110101111101000000000011001001000011000111";
		-- 0.356708
		y <= "0000000000000000000000000000000000000000000001011011010100010011011111000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 668
		-- 110431.250192
		x <= "0000000000000000000000000001101011110101111101000000000011001001000011000111";
		-- 0.594513
		y <= "0000000000000000000000000000000000000000000010011000001100100000011110100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 669
		-- 110431.250192
		x <= "0000000000000000000000000001101011110101111101000000000011001001000011000111";
		-- 0.832319
		y <= "0000000000000000000000000000000000000000000011010101000100101101011101111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 670
		-- 110431.250192
		x <= "0000000000000000000000000001101011110101111101000000000011001001000011000111";
		-- 1.070124
		y <= "0000000000000000000000000000000000000000000100010001111100111010011101010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 671
		-- 112104.450952
		x <= "0000000000000000000000000001101101011110100001110011011100011001100110110110";
		-- -1.068740
		y <= "1111111111111111111111111111111111111111111011101110011001110000110011011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 672
		-- 112104.450952
		x <= "0000000000000000000000000001101101011110100001110011011100011001100110110110";
		-- -0.831242
		y <= "1111111111111111111111111111111111111111111100101011001100111011010010101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 673
		-- 112104.450952
		x <= "0000000000000000000000000001101101011110100001110011011100011001100110110110";
		-- -0.593744
		y <= "1111111111111111111111111111111111111111111101101000000000000101110001111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 674
		-- 112104.450952
		x <= "0000000000000000000000000001101101011110100001110011011100011001100110110110";
		-- -0.356247
		y <= "1111111111111111111111111111111111111111111110100100110011010000010001001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 675
		-- 112104.450952
		x <= "0000000000000000000000000001101101011110100001110011011100011001100110110110";
		-- -0.118749
		y <= "1111111111111111111111111111111111111111111111100001100110011010110000011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 676
		-- 112104.450952
		x <= "0000000000000000000000000001101101011110100001110011011100011001100110110110";
		-- 0.118749
		y <= "0000000000000000000000000000000000000000000000011110011001100101001111100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 677
		-- 112104.450952
		x <= "0000000000000000000000000001101101011110100001110011011100011001100110110110";
		-- 0.356247
		y <= "0000000000000000000000000000000000000000000001011011001100101111101110110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 678
		-- 112104.450952
		x <= "0000000000000000000000000001101101011110100001110011011100011001100110110110";
		-- 0.593744
		y <= "0000000000000000000000000000000000000000000010010111111111111010001110000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 679
		-- 112104.450952
		x <= "0000000000000000000000000001101101011110100001110011011100011001100110110110";
		-- 0.831242
		y <= "0000000000000000000000000000000000000000000011010100110011000100101101010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 680
		-- 112104.450952
		x <= "0000000000000000000000000001101101011110100001110011011100011001100110110110";
		-- 1.068740
		y <= "0000000000000000000000000000000000000000000100010001100110001111001100100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 681
		-- 113777.651713
		x <= "0000000000000000000000000001101111000111000110100110110101101010001010100100";
		-- -1.067380
		y <= "1111111111111111111111111111111111111111111011101110110000000010111001100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 682
		-- 113777.651713
		x <= "0000000000000000000000000001101111000111000110100110110101101010001010100100";
		-- -0.830184
		y <= "1111111111111111111111111111111111111111111100101011011110010000011110100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 683
		-- 113777.651713
		x <= "0000000000000000000000000001101111000111000110100110110101101010001010100100";
		-- -0.592989
		y <= "1111111111111111111111111111111111111111111101101000001100011110000011100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 684
		-- 113777.651713
		x <= "0000000000000000000000000001101111000111000110100110110101101010001010100100";
		-- -0.355793
		y <= "1111111111111111111111111111111111111111111110100100111010101011101000100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 685
		-- 113777.651713
		x <= "0000000000000000000000000001101111000111000110100110110101101010001010100100";
		-- -0.118598
		y <= "1111111111111111111111111111111111111111111111100001101000111001001101100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 686
		-- 113777.651713
		x <= "0000000000000000000000000001101111000111000110100110110101101010001010100100";
		-- 0.118598
		y <= "0000000000000000000000000000000000000000000000011110010111000110110010011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 687
		-- 113777.651713
		x <= "0000000000000000000000000001101111000111000110100110110101101010001010100100";
		-- 0.355793
		y <= "0000000000000000000000000000000000000000000001011011000101010100010111011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 688
		-- 113777.651713
		x <= "0000000000000000000000000001101111000111000110100110110101101010001010100100";
		-- 0.592989
		y <= "0000000000000000000000000000000000000000000010010111110011100001111100011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 689
		-- 113777.651713
		x <= "0000000000000000000000000001101111000111000110100110110101101010001010100100";
		-- 0.830184
		y <= "0000000000000000000000000000000000000000000011010100100001101111100001011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 690
		-- 113777.651713
		x <= "0000000000000000000000000001101111000111000110100110110101101010001010100100";
		-- 1.067380
		y <= "0000000000000000000000000000000000000000000100010001001111111101000110011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 691
		-- 115450.852473
		x <= "0000000000000000000000000001110000101111101011011010001110111010101110010011";
		-- -1.066043
		y <= "1111111111111111111111111111111111111111111011101111000101111100101000010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 692
		-- 115450.852473
		x <= "0000000000000000000000000001110000101111101011011010001110111010101110010011";
		-- -0.829145
		y <= "1111111111111111111111111111111111111111111100101011101111010010101101100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 693
		-- 115450.852473
		x <= "0000000000000000000000000001110000101111101011011010001110111010101110010011";
		-- -0.592246
		y <= "1111111111111111111111111111111111111111111101101000011000101000110010110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 694
		-- 115450.852473
		x <= "0000000000000000000000000001110000101111101011011010001110111010101110010011";
		-- -0.355348
		y <= "1111111111111111111111111111111111111111111110100101000001111110111000000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 695
		-- 115450.852473
		x <= "0000000000000000000000000001110000101111101011011010001110111010101110010011";
		-- -0.118449
		y <= "1111111111111111111111111111111111111111111111100001101011010100111101010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 696
		-- 115450.852473
		x <= "0000000000000000000000000001110000101111101011011010001110111010101110010011";
		-- 0.118449
		y <= "0000000000000000000000000000000000000000000000011110010100101011000010101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 697
		-- 115450.852473
		x <= "0000000000000000000000000001110000101111101011011010001110111010101110010011";
		-- 0.355348
		y <= "0000000000000000000000000000000000000000000001011010111110000001000111111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 698
		-- 115450.852473
		x <= "0000000000000000000000000001110000101111101011011010001110111010101110010011";
		-- 0.592246
		y <= "0000000000000000000000000000000000000000000010010111100111010111001101001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 699
		-- 115450.852473
		x <= "0000000000000000000000000001110000101111101011011010001110111010101110010011";
		-- 0.829145
		y <= "0000000000000000000000000000000000000000000011010100010000101101010010011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 700
		-- 115450.852473
		x <= "0000000000000000000000000001110000101111101011011010001110111010101110010011";
		-- 1.066043
		y <= "0000000000000000000000000000000000000000000100010000111010000011010111101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 701
		-- 117124.053233
		x <= "0000000000000000000000000001110010011000010000001101101000001011010010000001";
		-- -1.064729
		y <= "1111111111111111111111111111111111111111111011101111011011011110110000100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 702
		-- 117124.053233
		x <= "0000000000000000000000000001110010011000010000001101101000001011010010000001";
		-- -0.828123
		y <= "1111111111111111111111111111111111111111111100101100000000000010100101101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 703
		-- 117124.053233
		x <= "0000000000000000000000000001110010011000010000001101101000001011010010000001";
		-- -0.591516
		y <= "1111111111111111111111111111111111111111111101101000100100100110011010111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 704
		-- 117124.053233
		x <= "0000000000000000000000000001110010011000010000001101101000001011010010000001";
		-- -0.354910
		y <= "1111111111111111111111111111111111111111111110100101001001001010010000001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 705
		-- 117124.053233
		x <= "0000000000000000000000000001110010011000010000001101101000001011010010000001";
		-- -0.118303
		y <= "1111111111111111111111111111111111111111111111100001101101101110000101011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 706
		-- 117124.053233
		x <= "0000000000000000000000000001110010011000010000001101101000001011010010000001";
		-- 0.118303
		y <= "0000000000000000000000000000000000000000000000011110010010010001111010100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 707
		-- 117124.053233
		x <= "0000000000000000000000000001110010011000010000001101101000001011010010000001";
		-- 0.354910
		y <= "0000000000000000000000000000000000000000000001011010110110110101101111110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 708
		-- 117124.053233
		x <= "0000000000000000000000000001110010011000010000001101101000001011010010000001";
		-- 0.591516
		y <= "0000000000000000000000000000000000000000000010010111011011011001100101000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 709
		-- 117124.053233
		x <= "0000000000000000000000000001110010011000010000001101101000001011010010000001";
		-- 0.828123
		y <= "0000000000000000000000000000000000000000000011010011111111111101011010010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 710
		-- 117124.053233
		x <= "0000000000000000000000000001110010011000010000001101101000001011010010000001";
		-- 1.064729
		y <= "0000000000000000000000000000000000000000000100010000100100100001001111011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 711
		-- 118797.253994
		x <= "0000000000000000000000000001110100000000110101000001000001011011110101110000";
		-- -1.063436
		y <= "1111111111111111111111111111111111111111111011101111110000101010000001000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 712
		-- 118797.253994
		x <= "0000000000000000000000000001110100000000110101000001000001011011110101110000";
		-- -0.827117
		y <= "1111111111111111111111111111111111111111111100101100010000100000101011011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 713
		-- 118797.253994
		x <= "0000000000000000000000000001110100000000110101000001000001011011110101110000";
		-- -0.590798
		y <= "1111111111111111111111111111111111111111111101101000110000010111010101111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 714
		-- 118797.253994
		x <= "0000000000000000000000000001110100000000110101000001000001011011110101110000";
		-- -0.354479
		y <= "1111111111111111111111111111111111111111111110100101010000001110000000010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 715
		-- 118797.253994
		x <= "0000000000000000000000000001110100000000110101000001000001011011110101110000";
		-- -0.118160
		y <= "1111111111111111111111111111111111111111111111100001110000000100101010110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 716
		-- 118797.253994
		x <= "0000000000000000000000000001110100000000110101000001000001011011110101110000";
		-- 0.118160
		y <= "0000000000000000000000000000000000000000000000011110001111111011010101001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 717
		-- 118797.253994
		x <= "0000000000000000000000000001110100000000110101000001000001011011110101110000";
		-- 0.354479
		y <= "0000000000000000000000000000000000000000000001011010101111110001111111101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 718
		-- 118797.253994
		x <= "0000000000000000000000000001110100000000110101000001000001011011110101110000";
		-- 0.590798
		y <= "0000000000000000000000000000000000000000000010010111001111101000101010000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 719
		-- 118797.253994
		x <= "0000000000000000000000000001110100000000110101000001000001011011110101110000";
		-- 0.827117
		y <= "0000000000000000000000000000000000000000000011010011101111011111010100100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 720
		-- 118797.253994
		x <= "0000000000000000000000000001110100000000110101000001000001011011110101110000";
		-- 1.063436
		y <= "0000000000000000000000000000000000000000000100010000001111010101111110111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 721
		-- 120470.454754
		x <= "0000000000000000000000000001110101101001011001110100011010101100011001011110";
		-- -1.062165
		y <= "1111111111111111111111111111111111111111111011110000000101011111000110011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 722
		-- 120470.454754
		x <= "0000000000000000000000000001110101101001011001110100011010101100011001011110";
		-- -0.826128
		y <= "1111111111111111111111111111111111111111111100101100100000101101100001011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 723
		-- 120470.454754
		x <= "0000000000000000000000000001110101101001011001110100011010101100011001011110";
		-- -0.590092
		y <= "1111111111111111111111111111111111111111111101101000111011111011111100011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 724
		-- 120470.454754
		x <= "0000000000000000000000000001110101101001011001110100011010101100011001011110";
		-- -0.354055
		y <= "1111111111111111111111111111111111111111111110100101010111001010010111011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 725
		-- 120470.454754
		x <= "0000000000000000000000000001110101101001011001110100011010101100011001011110";
		-- -0.118018
		y <= "1111111111111111111111111111111111111111111111100001110010011000110010011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 726
		-- 120470.454754
		x <= "0000000000000000000000000001110101101001011001110100011010101100011001011110";
		-- 0.118018
		y <= "0000000000000000000000000000000000000000000000011110001101100111001101100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 727
		-- 120470.454754
		x <= "0000000000000000000000000001110101101001011001110100011010101100011001011110";
		-- 0.354055
		y <= "0000000000000000000000000000000000000000000001011010101000110101101000100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 728
		-- 120470.454754
		x <= "0000000000000000000000000001110101101001011001110100011010101100011001011110";
		-- 0.590092
		y <= "0000000000000000000000000000000000000000000010010111000100000100000011100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 729
		-- 120470.454754
		x <= "0000000000000000000000000001110101101001011001110100011010101100011001011110";
		-- 0.826128
		y <= "0000000000000000000000000000000000000000000011010011011111010010011110100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 730
		-- 120470.454754
		x <= "0000000000000000000000000001110101101001011001110100011010101100011001011110";
		-- 1.062165
		y <= "0000000000000000000000000000000000000000000100001111111010100000111001100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 731
		-- 122143.655515
		x <= "0000000000000000000000000001110111010001111110100111110011111100111101001101";
		-- -1.060914
		y <= "1111111111111111111111111111111111111111111011110000011001111110101011100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 732
		-- 122143.655515
		x <= "0000000000000000000000000001110111010001111110100111110011111100111101001101";
		-- -0.825156
		y <= "1111111111111111111111111111111111111111111100101100110000101001101000111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 733
		-- 122143.655515
		x <= "0000000000000000000000000001110111010001111110100111110011111100111101001101";
		-- -0.589397
		y <= "1111111111111111111111111111111111111111111101101001000111010100100110011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 734
		-- 122143.655515
		x <= "0000000000000000000000000001110111010001111110100111110011111100111101001101";
		-- -0.353638
		y <= "1111111111111111111111111111111111111111111110100101011101111111100011110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 735
		-- 122143.655515
		x <= "0000000000000000000000000001110111010001111110100111110011111100111101001101";
		-- -0.117879
		y <= "1111111111111111111111111111111111111111111111100001110100101010100001010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 736
		-- 122143.655515
		x <= "0000000000000000000000000001110111010001111110100111110011111100111101001101";
		-- 0.117879
		y <= "0000000000000000000000000000000000000000000000011110001011010101011110101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 737
		-- 122143.655515
		x <= "0000000000000000000000000001110111010001111110100111110011111100111101001101";
		-- 0.353638
		y <= "0000000000000000000000000000000000000000000001011010100010000000011100001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 738
		-- 122143.655515
		x <= "0000000000000000000000000001110111010001111110100111110011111100111101001101";
		-- 0.589397
		y <= "0000000000000000000000000000000000000000000010010110111000101011011001100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 739
		-- 122143.655515
		x <= "0000000000000000000000000001110111010001111110100111110011111100111101001101";
		-- 0.825156
		y <= "0000000000000000000000000000000000000000000011010011001111010110010111000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 740
		-- 122143.655515
		x <= "0000000000000000000000000001110111010001111110100111110011111100111101001101";
		-- 1.060914
		y <= "0000000000000000000000000000000000000000000100001111100110000001010100011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 741
		-- 123816.856275
		x <= "0000000000000000000000000001111000111010100011011011001101001101100000111011";
		-- -1.059683
		y <= "1111111111111111111111111111111111111111111011110000101110001001011001000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 742
		-- 123816.856275
		x <= "0000000000000000000000000001111000111010100011011011001101001101100000111011";
		-- -0.824198
		y <= "1111111111111111111111111111111111111111111100101101000000010101100001101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 743
		-- 123816.856275
		x <= "0000000000000000000000000001111000111010100011011011001101001101100000111011";
		-- -0.588713
		y <= "1111111111111111111111111111111111111111111101101001010010100001101010010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 744
		-- 123816.856275
		x <= "0000000000000000000000000001111000111010100011011011001101001101100000111011";
		-- -0.353228
		y <= "1111111111111111111111111111111111111111111110100101100100101101110011000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 745
		-- 123816.856275
		x <= "0000000000000000000000000001111000111010100011011011001101001101100000111011";
		-- -0.117743
		y <= "1111111111111111111111111111111111111111111111100001110110111001111011101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 746
		-- 123816.856275
		x <= "0000000000000000000000000001111000111010100011011011001101001101100000111011";
		-- 0.117743
		y <= "0000000000000000000000000000000000000000000000011110001001000110000100010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 747
		-- 123816.856275
		x <= "0000000000000000000000000001111000111010100011011011001101001101100000111011";
		-- 0.353228
		y <= "0000000000000000000000000000000000000000000001011010011011010010001100111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 748
		-- 123816.856275
		x <= "0000000000000000000000000001111000111010100011011011001101001101100000111011";
		-- 0.588713
		y <= "0000000000000000000000000000000000000000000010010110101101011110010101101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 749
		-- 123816.856275
		x <= "0000000000000000000000000001111000111010100011011011001101001101100000111011";
		-- 0.824198
		y <= "0000000000000000000000000000000000000000000011010010111111101010011110010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 750
		-- 123816.856275
		x <= "0000000000000000000000000001111000111010100011011011001101001101100000111011";
		-- 1.059683
		y <= "0000000000000000000000000000000000000000000100001111010001110110100110111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 751
		-- 125490.057036
		x <= "0000000000000000000000000001111010100011001000001110100110011110000100101010";
		-- -1.058472
		y <= "1111111111111111111111111111111111111111111011110001000001111111110110000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 752
		-- 125490.057036
		x <= "0000000000000000000000000001111010100011001000001110100110011110000100101010";
		-- -0.823256
		y <= "1111111111111111111111111111111111111111111100101101001111110001101010000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 753
		-- 125490.057036
		x <= "0000000000000000000000000001111010100011001000001110100110011110000100101010";
		-- -0.588040
		y <= "1111111111111111111111111111111111111111111101101001011101100011011110000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 754
		-- 125490.057036
		x <= "0000000000000000000000000001111010100011001000001110100110011110000100101010";
		-- -0.352824
		y <= "1111111111111111111111111111111111111111111110100101101011010101010010000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 755
		-- 125490.057036
		x <= "0000000000000000000000000001111010100011001000001110100110011110000100101010";
		-- -0.117608
		y <= "1111111111111111111111111111111111111111111111100001111001000111000110000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 756
		-- 125490.057036
		x <= "0000000000000000000000000001111010100011001000001110100110011110000100101010";
		-- 0.117608
		y <= "0000000000000000000000000000000000000000000000011110000110111000111001111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 757
		-- 125490.057036
		x <= "0000000000000000000000000001111010100011001000001110100110011110000100101010";
		-- 0.352824
		y <= "0000000000000000000000000000000000000000000001011010010100101010101101111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 758
		-- 125490.057036
		x <= "0000000000000000000000000001111010100011001000001110100110011110000100101010";
		-- 0.588040
		y <= "0000000000000000000000000000000000000000000010010110100010011100100001111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 759
		-- 125490.057036
		x <= "0000000000000000000000000001111010100011001000001110100110011110000100101010";
		-- 0.823256
		y <= "0000000000000000000000000000000000000000000011010010110000001110010101111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 760
		-- 125490.057036
		x <= "0000000000000000000000000001111010100011001000001110100110011110000100101010";
		-- 1.058472
		y <= "0000000000000000000000000000000000000000000100001110111110000000001001111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 761
		-- 127163.257796
		x <= "0000000000000000000000000001111100001011101101000001111111101110101000011000";
		-- -1.057279
		y <= "1111111111111111111111111111111111111111111011110001010101100010101000000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 762
		-- 127163.257796
		x <= "0000000000000000000000000001111100001011101101000001111111101110101000011000";
		-- -0.822328
		y <= "1111111111111111111111111111111111111111111100101101011110111110011111001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 763
		-- 127163.257796
		x <= "0000000000000000000000000001111100001011101101000001111111101110101000011000";
		-- -0.587377
		y <= "1111111111111111111111111111111111111111111101101001101000011010010110010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 764
		-- 127163.257796
		x <= "0000000000000000000000000001111100001011101101000001111111101110101000011000";
		-- -0.352426
		y <= "1111111111111111111111111111111111111111111110100101110001110110001101010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 765
		-- 127163.257796
		x <= "0000000000000000000000000001111100001011101101000001111111101110101000011000";
		-- -0.117475
		y <= "1111111111111111111111111111111111111111111111100001111011010010000100011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 766
		-- 127163.257796
		x <= "0000000000000000000000000001111100001011101101000001111111101110101000011000";
		-- 0.117475
		y <= "0000000000000000000000000000000000000000000000011110000100101101111011100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 767
		-- 127163.257796
		x <= "0000000000000000000000000001111100001011101101000001111111101110101000011000";
		-- 0.352426
		y <= "0000000000000000000000000000000000000000000001011010001110001001110010101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 768
		-- 127163.257796
		x <= "0000000000000000000000000001111100001011101101000001111111101110101000011000";
		-- 0.587377
		y <= "0000000000000000000000000000000000000000000010010110010111100101101001101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 769
		-- 127163.257796
		x <= "0000000000000000000000000001111100001011101101000001111111101110101000011000";
		-- 0.822328
		y <= "0000000000000000000000000000000000000000000011010010100001000001100000110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 770
		-- 127163.257796
		x <= "0000000000000000000000000001111100001011101101000001111111101110101000011000";
		-- 1.057279
		y <= "0000000000000000000000000000000000000000000100001110101010011101010111111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 771
		-- 128836.458556
		x <= "0000000000000000000000000001111101110100010001110101011000111111001100000111";
		-- -1.056104
		y <= "1111111111111111111111111111111111111111111011110001101000110010010010111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 772
		-- 128836.458556
		x <= "0000000000000000000000000001111101110100010001110101011000111111001100000111";
		-- -0.821415
		y <= "1111111111111111111111111111111111111111111100101101101101111100011100111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 773
		-- 128836.458556
		x <= "0000000000000000000000000001111101110100010001110101011000111111001100000111";
		-- -0.586725
		y <= "1111111111111111111111111111111111111111111101101001110011000110100110111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 774
		-- 128836.458556
		x <= "0000000000000000000000000001111101110100010001110101011000111111001100000111";
		-- -0.352035
		y <= "1111111111111111111111111111111111111111111110100101111000010000110000111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 775
		-- 128836.458556
		x <= "0000000000000000000000000001111101110100010001110101011000111111001100000111";
		-- -0.117345
		y <= "1111111111111111111111111111111111111111111111100001111101011010111010111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 776
		-- 128836.458556
		x <= "0000000000000000000000000001111101110100010001110101011000111111001100000111";
		-- 0.117345
		y <= "0000000000000000000000000000000000000000000000011110000010100101000101000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 777
		-- 128836.458556
		x <= "0000000000000000000000000001111101110100010001110101011000111111001100000111";
		-- 0.352035
		y <= "0000000000000000000000000000000000000000000001011010000111101111001111000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 778
		-- 128836.458556
		x <= "0000000000000000000000000001111101110100010001110101011000111111001100000111";
		-- 0.586725
		y <= "0000000000000000000000000000000000000000000010010110001100111001011001000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 779
		-- 128836.458556
		x <= "0000000000000000000000000001111101110100010001110101011000111111001100000111";
		-- 0.821415
		y <= "0000000000000000000000000000000000000000000011010010010010000011100011000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 780
		-- 128836.458556
		x <= "0000000000000000000000000001111101110100010001110101011000111111001100000111";
		-- 1.056104
		y <= "0000000000000000000000000000000000000000000100001110010111001101101101000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 781
		-- 130509.659317
		x <= "0000000000000000000000000001111111011100110110101000110010001111101111110101";
		-- -1.054947
		y <= "1111111111111111111111111111111111111111111011110001111011101111011001001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 782
		-- 130509.659317
		x <= "0000000000000000000000000001111111011100110110101000110010001111101111110101";
		-- -0.820515
		y <= "1111111111111111111111111111111111111111111100101101111100101011111110001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 783
		-- 130509.659317
		x <= "0000000000000000000000000001111111011100110110101000110010001111101111110101";
		-- -0.586082
		y <= "1111111111111111111111111111111111111111111101101001111101101000100011010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 784
		-- 130509.659317
		x <= "0000000000000000000000000001111111011100110110101000110010001111101111110101";
		-- -0.351649
		y <= "1111111111111111111111111111111111111111111110100101111110100101001000011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 785
		-- 130509.659317
		x <= "0000000000000000000000000001111111011100110110101000110010001111101111110101";
		-- -0.117216
		y <= "1111111111111111111111111111111111111111111111100001111111100001101101011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 786
		-- 130509.659317
		x <= "0000000000000000000000000001111111011100110110101000110010001111101111110101";
		-- 0.117216
		y <= "0000000000000000000000000000000000000000000000011110000000011110010010100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 787
		-- 130509.659317
		x <= "0000000000000000000000000001111111011100110110101000110010001111101111110101";
		-- 0.351649
		y <= "0000000000000000000000000000000000000000000001011010000001011010110111100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 788
		-- 130509.659317
		x <= "0000000000000000000000000001111111011100110110101000110010001111101111110101";
		-- 0.586082
		y <= "0000000000000000000000000000000000000000000010010110000010010111011100101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 789
		-- 130509.659317
		x <= "0000000000000000000000000001111111011100110110101000110010001111101111110101";
		-- 0.820515
		y <= "0000000000000000000000000000000000000000000011010010000011010100000001110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 790
		-- 130509.659317
		x <= "0000000000000000000000000001111111011100110110101000110010001111101111110101";
		-- 1.054947
		y <= "0000000000000000000000000000000000000000000100001110000100010000100110110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 791
		-- 132182.860077
		x <= "0000000000000000000000000010000001000101011011011100001011100000010011100100";
		-- -1.053808
		y <= "1111111111111111111111111111111111111111111011110010001110011010011011100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 792
		-- 132182.860077
		x <= "0000000000000000000000000010000001000101011011011100001011100000010011100100";
		-- -0.819628
		y <= "1111111111111111111111111111111111111111111100101110001011001101011100100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 793
		-- 132182.860077
		x <= "0000000000000000000000000010000001000101011011011100001011100000010011100100";
		-- -0.585449
		y <= "1111111111111111111111111111111111111111111101101010001000000000011101100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 794
		-- 132182.860077
		x <= "0000000000000000000000000010000001000101011011011100001011100000010011100100";
		-- -0.351269
		y <= "1111111111111111111111111111111111111111111110100110000100110011011110100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 795
		-- 132182.860077
		x <= "0000000000000000000000000010000001000101011011011100001011100000010011100100";
		-- -0.117090
		y <= "1111111111111111111111111111111111111111111111100010000001100110011111100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 796
		-- 132182.860077
		x <= "0000000000000000000000000010000001000101011011011100001011100000010011100100";
		-- 0.117090
		y <= "0000000000000000000000000000000000000000000000011101111110011001100000011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 797
		-- 132182.860077
		x <= "0000000000000000000000000010000001000101011011011100001011100000010011100100";
		-- 0.351269
		y <= "0000000000000000000000000000000000000000000001011001111011001100100001011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 798
		-- 132182.860077
		x <= "0000000000000000000000000010000001000101011011011100001011100000010011100100";
		-- 0.585449
		y <= "0000000000000000000000000000000000000000000010010101110111111111100010011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 799
		-- 132182.860077
		x <= "0000000000000000000000000010000001000101011011011100001011100000010011100100";
		-- 0.819628
		y <= "0000000000000000000000000000000000000000000011010001110100110010100011011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 800
		-- 132182.860077
		x <= "0000000000000000000000000010000001000101011011011100001011100000010011100100";
		-- 1.053808
		y <= "0000000000000000000000000000000000000000000100001101110001100101100100011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 801
		-- 133856.060838
		x <= "0000000000000000000000000010000010101110000000001111100100110000110111010010";
		-- -1.052685
		y <= "1111111111111111111111111111111111111111111011110010100000110011111001111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 802
		-- 133856.060838
		x <= "0000000000000000000000000010000010101110000000001111100100110000110111010010";
		-- -0.818755
		y <= "1111111111111111111111111111111111111111111100101110011001100001010000100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 803
		-- 133856.060838
		x <= "0000000000000000000000000010000010101110000000001111100100110000110111010010";
		-- -0.584825
		y <= "1111111111111111111111111111111111111111111101101010010010001110100111010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 804
		-- 133856.060838
		x <= "0000000000000000000000000010000010101110000000001111100100110000110111010010";
		-- -0.350895
		y <= "1111111111111111111111111111111111111111111110100110001010111011111101111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 805
		-- 133856.060838
		x <= "0000000000000000000000000010000010101110000000001111100100110000110111010010";
		-- -0.116965
		y <= "1111111111111111111111111111111111111111111111100010000011101001010100101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 806
		-- 133856.060838
		x <= "0000000000000000000000000010000010101110000000001111100100110000110111010010";
		-- 0.116965
		y <= "0000000000000000000000000000000000000000000000011101111100010110101011010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 807
		-- 133856.060838
		x <= "0000000000000000000000000010000010101110000000001111100100110000110111010010";
		-- 0.350895
		y <= "0000000000000000000000000000000000000000000001011001110101000100000010000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 808
		-- 133856.060838
		x <= "0000000000000000000000000010000010101110000000001111100100110000110111010010";
		-- 0.584825
		y <= "0000000000000000000000000000000000000000000010010101101101110001011000101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 809
		-- 133856.060838
		x <= "0000000000000000000000000010000010101110000000001111100100110000110111010010";
		-- 0.818755
		y <= "0000000000000000000000000000000000000000000011010001100110011110101111011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 810
		-- 133856.060838
		x <= "0000000000000000000000000010000010101110000000001111100100110000110111010010";
		-- 1.052685
		y <= "0000000000000000000000000000000000000000000100001101011111001100000110000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 811
		-- 135529.261598
		x <= "0000000000000000000000000010000100010110100101000010111110000001011011000001";
		-- -1.051578
		y <= "1111111111111111111111111111111111111111111011110010110010111100010010101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 812
		-- 135529.261598
		x <= "0000000000000000000000000010000100010110100101000010111110000001011011000001";
		-- -0.817894
		y <= "1111111111111111111111111111111111111111111100101110100111100111110010000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 813
		-- 135529.261598
		x <= "0000000000000000000000000010000100010110100101000010111110000001011011000001";
		-- -0.584210
		y <= "1111111111111111111111111111111111111111111101101010011100010011010001011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 814
		-- 135529.261598
		x <= "0000000000000000000000000010000100010110100101000010111110000001011011000001";
		-- -0.350526
		y <= "1111111111111111111111111111111111111111111110100110010000111110110000111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 815
		-- 135529.261598
		x <= "0000000000000000000000000010000100010110100101000010111110000001011011000001";
		-- -0.116842
		y <= "1111111111111111111111111111111111111111111111100010000101101010010000010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 816
		-- 135529.261598
		x <= "0000000000000000000000000010000100010110100101000010111110000001011011000001";
		-- 0.116842
		y <= "0000000000000000000000000000000000000000000000011101111010010101101111101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 817
		-- 135529.261598
		x <= "0000000000000000000000000010000100010110100101000010111110000001011011000001";
		-- 0.350526
		y <= "0000000000000000000000000000000000000000000001011001101111000001001111000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 818
		-- 135529.261598
		x <= "0000000000000000000000000010000100010110100101000010111110000001011011000001";
		-- 0.584210
		y <= "0000000000000000000000000000000000000000000010010101100011101100101110100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 819
		-- 135529.261598
		x <= "0000000000000000000000000010000100010110100101000010111110000001011011000001";
		-- 0.817894
		y <= "0000000000000000000000000000000000000000000011010001011000011000001101111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 820
		-- 135529.261598
		x <= "0000000000000000000000000010000100010110100101000010111110000001011011000001";
		-- 1.051578
		y <= "0000000000000000000000000000000000000000000100001101001101000011101101010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 821
		-- 137202.462358
		x <= "0000000000000000000000000010000101111111001001110110010111010001111110101111";
		-- -1.050487
		y <= "1111111111111111111111111111111111111111111011110011000100110100000011000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 822
		-- 137202.462358
		x <= "0000000000000000000000000010000101111111001001110110010111010001111110101111";
		-- -0.817046
		y <= "1111111111111111111111111111111111111111111100101110110101100001010111101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 823
		-- 137202.462358
		x <= "0000000000000000000000000010000101111111001001110110010111010001111110101111";
		-- -0.583604
		y <= "1111111111111111111111111111111111111111111101101010100110001110101100011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 824
		-- 137202.462358
		x <= "0000000000000000000000000010000101111111001001110110010111010001111110101111";
		-- -0.350162
		y <= "1111111111111111111111111111111111111111111110100110010110111100000001000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 825
		-- 137202.462358
		x <= "0000000000000000000000000010000101111111001001110110010111010001111110101111";
		-- -0.116721
		y <= "1111111111111111111111111111111111111111111111100010000111101001010101101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 826
		-- 137202.462358
		x <= "0000000000000000000000000010000101111111001001110110010111010001111110101111";
		-- 0.116721
		y <= "0000000000000000000000000000000000000000000000011101111000010110101010010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 827
		-- 137202.462358
		x <= "0000000000000000000000000010000101111111001001110110010111010001111110101111";
		-- 0.350162
		y <= "0000000000000000000000000000000000000000000001011001101001000011111110111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 828
		-- 137202.462358
		x <= "0000000000000000000000000010000101111111001001110110010111010001111110101111";
		-- 0.583604
		y <= "0000000000000000000000000000000000000000000010010101011001110001010011100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 829
		-- 137202.462358
		x <= "0000000000000000000000000010000101111111001001110110010111010001111110101111";
		-- 0.817046
		y <= "0000000000000000000000000000000000000000000011010001001010011110101000010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 830
		-- 137202.462358
		x <= "0000000000000000000000000010000101111111001001110110010111010001111110101111";
		-- 1.050487
		y <= "0000000000000000000000000000000000000000000100001100111011001011111100111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 831
		-- 138875.663119
		x <= "0000000000000000000000000010000111100111101110101001110000100010100010011110";
		-- -1.049412
		y <= "1111111111111111111111111111111111111111111011110011010110011011100111001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 832
		-- 138875.663119
		x <= "0000000000000000000000000010000111100111101110101001110000100010100010011110";
		-- -0.816209
		y <= "1111111111111111111111111111111111111111111100101111000011001110010111011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 833
		-- 138875.663119
		x <= "0000000000000000000000000010000111100111101110101001110000100010100010011110";
		-- -0.583007
		y <= "1111111111111111111111111111111111111111111101101010110000000001000111100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 834
		-- 138875.663119
		x <= "0000000000000000000000000010000111100111101110101001110000100010100010011110";
		-- -0.349804
		y <= "1111111111111111111111111111111111111111111110100110011100110011110111101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 835
		-- 138875.663119
		x <= "0000000000000000000000000010000111100111101110101001110000100010100010011110";
		-- -0.116601
		y <= "1111111111111111111111111111111111111111111111100010001001100110100111111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 836
		-- 138875.663119
		x <= "0000000000000000000000000010000111100111101110101001110000100010100010011110";
		-- 0.116601
		y <= "0000000000000000000000000000000000000000000000011101110110011001011000000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 837
		-- 138875.663119
		x <= "0000000000000000000000000010000111100111101110101001110000100010100010011110";
		-- 0.349804
		y <= "0000000000000000000000000000000000000000000001011001100011001100001000010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 838
		-- 138875.663119
		x <= "0000000000000000000000000010000111100111101110101001110000100010100010011110";
		-- 0.583007
		y <= "0000000000000000000000000000000000000000000010010101001111111110111000011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 839
		-- 138875.663119
		x <= "0000000000000000000000000010000111100111101110101001110000100010100010011110";
		-- 0.816209
		y <= "0000000000000000000000000000000000000000000011010000111100110001101000100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 840
		-- 138875.663119
		x <= "0000000000000000000000000010000111100111101110101001110000100010100010011110";
		-- 1.049412
		y <= "0000000000000000000000000000000000000000000100001100101001100100011000110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 841
		-- 140548.863879
		x <= "0000000000000000000000000010001001010000010011011101001001110011000110001100";
		-- -1.048352
		y <= "1111111111111111111111111111111111111111111011110011100111110011011010001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 842
		-- 140548.863879
		x <= "0000000000000000000000000010001001010000010011011101001001110011000110001100";
		-- -0.815385
		y <= "1111111111111111111111111111111111111111111100101111010000101111000110001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 843
		-- 140548.863879
		x <= "0000000000000000000000000010001001010000010011011101001001110011000110001100";
		-- -0.582418
		y <= "1111111111111111111111111111111111111111111101101010111001101010110010000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 844
		-- 140548.863879
		x <= "0000000000000000000000000010001001010000010011011101001001110011000110001100";
		-- -0.349451
		y <= "1111111111111111111111111111111111111111111110100110100010100110011110000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 845
		-- 140548.863879
		x <= "0000000000000000000000000010001001010000010011011101001001110011000110001100";
		-- -0.116484
		y <= "1111111111111111111111111111111111111111111111100010001011100010001010000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 846
		-- 140548.863879
		x <= "0000000000000000000000000010001001010000010011011101001001110011000110001100";
		-- 0.116484
		y <= "0000000000000000000000000000000000000000000000011101110100011101110101111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 847
		-- 140548.863879
		x <= "0000000000000000000000000010001001010000010011011101001001110011000110001100";
		-- 0.349451
		y <= "0000000000000000000000000000000000000000000001011001011101011001100001111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 848
		-- 140548.863879
		x <= "0000000000000000000000000010001001010000010011011101001001110011000110001100";
		-- 0.582418
		y <= "0000000000000000000000000000000000000000000010010101000110010101001101111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 849
		-- 140548.863879
		x <= "0000000000000000000000000010001001010000010011011101001001110011000110001100";
		-- 0.815385
		y <= "0000000000000000000000000000000000000000000011010000101111010000111001110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 850
		-- 140548.863879
		x <= "0000000000000000000000000010001001010000010011011101001001110011000110001100";
		-- 1.048352
		y <= "0000000000000000000000000000000000000000000100001100011000001100100101110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 851
		-- 142222.064640
		x <= "0000000000000000000000000010001010111000111000010000100011000011101001111010";
		-- -1.047306
		y <= "1111111111111111111111111111111111111111111011110011111000111011110101111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 852
		-- 142222.064640
		x <= "0000000000000000000000000010001010111000111000010000100011000011101001111010";
		-- -0.814571
		y <= "1111111111111111111111111111111111111111111100101111011110000011111000001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 853
		-- 142222.064640
		x <= "0000000000000000000000000010001010111000111000010000100011000011101001111010";
		-- -0.581837
		y <= "1111111111111111111111111111111111111111111101101011000011001011111010011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 854
		-- 142222.064640
		x <= "0000000000000000000000000010001010111000111000010000100011000011101001111010";
		-- -0.349102
		y <= "1111111111111111111111111111111111111111111110100110101000010011111100101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 855
		-- 142222.064640
		x <= "0000000000000000000000000010001010111000111000010000100011000011101001111010";
		-- -0.116367
		y <= "1111111111111111111111111111111111111111111111100010001101011011111110111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 856
		-- 142222.064640
		x <= "0000000000000000000000000010001010111000111000010000100011000011101001111010";
		-- 0.116367
		y <= "0000000000000000000000000000000000000000000000011101110010100100000001000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 857
		-- 142222.064640
		x <= "0000000000000000000000000010001010111000111000010000100011000011101001111010";
		-- 0.349102
		y <= "0000000000000000000000000000000000000000000001011001010111101100000011010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 858
		-- 142222.064640
		x <= "0000000000000000000000000010001010111000111000010000100011000011101001111010";
		-- 0.581837
		y <= "0000000000000000000000000000000000000000000010010100111100110100000101100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 859
		-- 142222.064640
		x <= "0000000000000000000000000010001010111000111000010000100011000011101001111010";
		-- 0.814571
		y <= "0000000000000000000000000000000000000000000011010000100001111100000111110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 860
		-- 142222.064640
		x <= "0000000000000000000000000010001010111000111000010000100011000011101001111010";
		-- 1.047306
		y <= "0000000000000000000000000000000000000000000100001100000111000100001010000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 861
		-- 143895.265400
		x <= "0000000000000000000000000010001100100001011101000011111100010100001101101001";
		-- -1.046275
		y <= "1111111111111111111111111111111111111111111011110100001001110101010011100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 862
		-- 143895.265400
		x <= "0000000000000000000000000010001100100001011101000011111100010100001101101001";
		-- -0.813769
		y <= "1111111111111111111111111111111111111111111100101111101011001101000000111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 863
		-- 143895.265400
		x <= "0000000000000000000000000010001100100001011101000011111100010100001101101001";
		-- -0.581264
		y <= "1111111111111111111111111111111111111111111101101011001100100100101110011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 864
		-- 143895.265400
		x <= "0000000000000000000000000010001100100001011101000011111100010100001101101001";
		-- -0.348758
		y <= "1111111111111111111111111111111111111111111110100110101101111100011011110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 865
		-- 143895.265400
		x <= "0000000000000000000000000010001100100001011101000011111100010100001101101001";
		-- -0.116253
		y <= "1111111111111111111111111111111111111111111111100010001111010100001001010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 866
		-- 143895.265400
		x <= "0000000000000000000000000010001100100001011101000011111100010100001101101001";
		-- 0.116253
		y <= "0000000000000000000000000000000000000000000000011101110000101011110110101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 867
		-- 143895.265400
		x <= "0000000000000000000000000010001100100001011101000011111100010100001101101001";
		-- 0.348758
		y <= "0000000000000000000000000000000000000000000001011001010010000011100100001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 868
		-- 143895.265400
		x <= "0000000000000000000000000010001100100001011101000011111100010100001101101001";
		-- 0.581264
		y <= "0000000000000000000000000000000000000000000010010100110011011011010001100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 869
		-- 143895.265400
		x <= "0000000000000000000000000010001100100001011101000011111100010100001101101001";
		-- 0.813769
		y <= "0000000000000000000000000000000000000000000011010000010100110010111111000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 870
		-- 143895.265400
		x <= "0000000000000000000000000010001100100001011101000011111100010100001101101001";
		-- 1.046275
		y <= "0000000000000000000000000000000000000000000100001011110110001010101100011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 871
		-- 145568.466161
		x <= "0000000000000000000000000010001110001010000001110111010101100100110001010111";
		-- -1.045257
		y <= "1111111111111111111111111111111111111111111011110100011010100000001011000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 872
		-- 145568.466161
		x <= "0000000000000000000000000010001110001010000001110111010101100100110001010111";
		-- -0.812978
		y <= "1111111111111111111111111111111111111111111100101111111000001010110011010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 873
		-- 145568.466161
		x <= "0000000000000000000000000010001110001010000001110111010101100100110001010111";
		-- -0.580699
		y <= "1111111111111111111111111111111111111111111101101011010101110101011011100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 874
		-- 145568.466161
		x <= "0000000000000000000000000010001110001010000001110111010101100100110001010111";
		-- -0.348419
		y <= "1111111111111111111111111111111111111111111110100110110011100000000011101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 875
		-- 145568.466161
		x <= "0000000000000000000000000010001110001010000001110111010101100100110001010111";
		-- -0.116140
		y <= "1111111111111111111111111111111111111111111111100010010001001010101011111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 876
		-- 145568.466161
		x <= "0000000000000000000000000010001110001010000001110111010101100100110001010111";
		-- 0.116140
		y <= "0000000000000000000000000000000000000000000000011101101110110101010100000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 877
		-- 145568.466161
		x <= "0000000000000000000000000010001110001010000001110111010101100100110001010111";
		-- 0.348419
		y <= "0000000000000000000000000000000000000000000001011001001100011111111100010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 878
		-- 145568.466161
		x <= "0000000000000000000000000010001110001010000001110111010101100100110001010111";
		-- 0.580699
		y <= "0000000000000000000000000000000000000000000010010100101010001010100100011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 879
		-- 145568.466161
		x <= "0000000000000000000000000010001110001010000001110111010101100100110001010111";
		-- 0.812978
		y <= "0000000000000000000000000000000000000000000011010000000111110101001100101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 880
		-- 145568.466161
		x <= "0000000000000000000000000010001110001010000001110111010101100100110001010111";
		-- 1.045257
		y <= "0000000000000000000000000000000000000000000100001011100101011111110100111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 881
		-- 147241.666921
		x <= "0000000000000000000000000010001111110010100110101010101110110101010101000110";
		-- -1.044254
		y <= "1111111111111111111111111111111111111111111011110100101010111100110011111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 882
		-- 147241.666921
		x <= "0000000000000000000000000010001111110010100110101010101110110101010101000110";
		-- -0.812197
		y <= "1111111111111111111111111111111111111111111100110000000100111101100001010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 883
		-- 147241.666921
		x <= "0000000000000000000000000010001111110010100110101010101110110101010101000110";
		-- -0.580141
		y <= "1111111111111111111111111111111111111111111101101011011110111110001110101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 884
		-- 147241.666921
		x <= "0000000000000000000000000010001111110010100110101010101110110101010101000110";
		-- -0.348085
		y <= "1111111111111111111111111111111111111111111110100110111000111110111011111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 885
		-- 147241.666921
		x <= "0000000000000000000000000010001111110010100110101010101110110101010101000110";
		-- -0.116028
		y <= "1111111111111111111111111111111111111111111111100010010010111111101001010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 886
		-- 147241.666921
		x <= "0000000000000000000000000010001111110010100110101010101110110101010101000110";
		-- 0.116028
		y <= "0000000000000000000000000000000000000000000000011101101101000000010110101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 887
		-- 147241.666921
		x <= "0000000000000000000000000010001111110010100110101010101110110101010101000110";
		-- 0.348085
		y <= "0000000000000000000000000000000000000000000001011001000111000001000100000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 888
		-- 147241.666921
		x <= "0000000000000000000000000010001111110010100110101010101110110101010101000110";
		-- 0.580141
		y <= "0000000000000000000000000000000000000000000010010100100001000001110001010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 889
		-- 147241.666921
		x <= "0000000000000000000000000010001111110010100110101010101110110101010101000110";
		-- 0.812197
		y <= "0000000000000000000000000000000000000000000011001111111011000010011110101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 890
		-- 147241.666921
		x <= "0000000000000000000000000010001111110010100110101010101110110101010101000110";
		-- 1.044254
		y <= "0000000000000000000000000000000000000000000100001011010101000011001100000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 891
		-- 148914.867681
		x <= "0000000000000000000000000010010001011011001011011110001000000101111000110100";
		-- -1.043263
		y <= "1111111111111111111111111111111111111111111011110100111011001011100100011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 892
		-- 148914.867681
		x <= "0000000000000000000000000010010001011011001011011110001000000101111000110100";
		-- -0.811427
		y <= "1111111111111111111111111111111111111111111100110000010001100101011100010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 893
		-- 148914.867681
		x <= "0000000000000000000000000010010001011011001011011110001000000101111000110100";
		-- -0.579590
		y <= "1111111111111111111111111111111111111111111101101011100111111111010100001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 894
		-- 148914.867681
		x <= "0000000000000000000000000010010001011011001011011110001000000101111000110100";
		-- -0.347754
		y <= "1111111111111111111111111111111111111111111110100110111110011001001100001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 895
		-- 148914.867681
		x <= "0000000000000000000000000010010001011011001011011110001000000101111000110100";
		-- -0.115918
		y <= "1111111111111111111111111111111111111111111111100010010100110011000100000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 896
		-- 148914.867681
		x <= "0000000000000000000000000010010001011011001011011110001000000101111000110100";
		-- 0.115918
		y <= "0000000000000000000000000000000000000000000000011101101011001100111011111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 897
		-- 148914.867681
		x <= "0000000000000000000000000010010001011011001011011110001000000101111000110100";
		-- 0.347754
		y <= "0000000000000000000000000000000000000000000001011001000001100110110011110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 898
		-- 148914.867681
		x <= "0000000000000000000000000010010001011011001011011110001000000101111000110100";
		-- 0.579590
		y <= "0000000000000000000000000000000000000000000010010100011000000000101011110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 899
		-- 148914.867681
		x <= "0000000000000000000000000010010001011011001011011110001000000101111000110100";
		-- 0.811427
		y <= "0000000000000000000000000000000000000000000011001111101110011010100011101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 900
		-- 148914.867681
		x <= "0000000000000000000000000010010001011011001011011110001000000101111000110100";
		-- 1.043263
		y <= "0000000000000000000000000000000000000000000100001011000100110100011011100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 901
		-- 150588.068442
		x <= "0000000000000000000000000010010011000011110000010001100001010110011100100011";
		-- -1.042285
		y <= "1111111111111111111111111111111111111111111011110101001011001100110010001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 902
		-- 150588.068442
		x <= "0000000000000000000000000010010011000011110000010001100001010110011100100011";
		-- -0.810666
		y <= "1111111111111111111111111111111111111111111100110000011110000010110101010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 903
		-- 150588.068442
		x <= "0000000000000000000000000010010011000011110000010001100001010110011100100011";
		-- -0.579047
		y <= "1111111111111111111111111111111111111111111101101011110000111000111000010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 904
		-- 150588.068442
		x <= "0000000000000000000000000010010011000011110000010001100001010110011100100011";
		-- -0.347428
		y <= "1111111111111111111111111111111111111111111110100111000011101110111011011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 905
		-- 150588.068442
		x <= "0000000000000000000000000010010011000011110000010001100001010110011100100011";
		-- -0.115809
		y <= "1111111111111111111111111111111111111111111111100010010110100100111110011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 906
		-- 150588.068442
		x <= "0000000000000000000000000010010011000011110000010001100001010110011100100011";
		-- 0.115809
		y <= "0000000000000000000000000000000000000000000000011101101001011011000001100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 907
		-- 150588.068442
		x <= "0000000000000000000000000010010011000011110000010001100001010110011100100011";
		-- 0.347428
		y <= "0000000000000000000000000000000000000000000001011000111100010001000100100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 908
		-- 150588.068442
		x <= "0000000000000000000000000010010011000011110000010001100001010110011100100011";
		-- 0.579047
		y <= "0000000000000000000000000000000000000000000010010100001111000111000111101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 909
		-- 150588.068442
		x <= "0000000000000000000000000010010011000011110000010001100001010110011100100011";
		-- 0.810666
		y <= "0000000000000000000000000000000000000000000011001111100001111101001010101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 910
		-- 150588.068442
		x <= "0000000000000000000000000010010011000011110000010001100001010110011100100011";
		-- 1.042285
		y <= "0000000000000000000000000000000000000000000100001010110100110011001101110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 911
		-- 152261.269202
		x <= "0000000000000000000000000010010100101100010101000100111010100111000000010001";
		-- -1.041320
		y <= "1111111111111111111111111111111111111111111011110101011011000000110010000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 912
		-- 152261.269202
		x <= "0000000000000000000000000010010100101100010101000100111010100111000000010001";
		-- -0.809916
		y <= "1111111111111111111111111111111111111111111100110000101010010101111100010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 913
		-- 152261.269202
		x <= "0000000000000000000000000010010100101100010101000100111010100111000000010001";
		-- -0.578511
		y <= "1111111111111111111111111111111111111111111101101011111001101011000110100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 914
		-- 152261.269202
		x <= "0000000000000000000000000010010100101100010101000100111010100111000000010001";
		-- -0.347107
		y <= "1111111111111111111111111111111111111111111110100111001001000000010000101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 915
		-- 152261.269202
		x <= "0000000000000000000000000010010100101100010101000100111010100111000000010001";
		-- -0.115702
		y <= "1111111111111111111111111111111111111111111111100010011000010101011010111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 916
		-- 152261.269202
		x <= "0000000000000000000000000010010100101100010101000100111010100111000000010001";
		-- 0.115702
		y <= "0000000000000000000000000000000000000000000000011101100111101010100101000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 917
		-- 152261.269202
		x <= "0000000000000000000000000010010100101100010101000100111010100111000000010001";
		-- 0.347107
		y <= "0000000000000000000000000000000000000000000001011000110110111111101111010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 918
		-- 152261.269202
		x <= "0000000000000000000000000010010100101100010101000100111010100111000000010001";
		-- 0.578511
		y <= "0000000000000000000000000000000000000000000010010100000110010100111001011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 919
		-- 152261.269202
		x <= "0000000000000000000000000010010100101100010101000100111010100111000000010001";
		-- 0.809916
		y <= "0000000000000000000000000000000000000000000011001111010101101010000011101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 920
		-- 152261.269202
		x <= "0000000000000000000000000010010100101100010101000100111010100111000000010001";
		-- 1.041320
		y <= "0000000000000000000000000000000000000000000100001010100100111111001101111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 921
		-- 153934.469963
		x <= "0000000000000000000000000010010110010100111001111000010011110111100100000000";
		-- -1.040367
		y <= "1111111111111111111111111111111111111111111011110101101010100111111000010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 922
		-- 153934.469963
		x <= "0000000000000000000000000010010110010100111001111000010011110111100100000000";
		-- -0.809175
		y <= "1111111111111111111111111111111111111111111100110000110110011111000001000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 923
		-- 153934.469963
		x <= "0000000000000000000000000010010110010100111001111000010011110111100100000000";
		-- -0.577982
		y <= "1111111111111111111111111111111111111111111101101100000010010110001001111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 924
		-- 153934.469963
		x <= "0000000000000000000000000010010110010100111001111000010011110111100100000000";
		-- -0.346789
		y <= "1111111111111111111111111111111111111111111110100111001110001101010010110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 925
		-- 153934.469963
		x <= "0000000000000000000000000010010110010100111001111000010011110111100100000000";
		-- -0.115596
		y <= "1111111111111111111111111111111111111111111111100010011010000100011011100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 926
		-- 153934.469963
		x <= "0000000000000000000000000010010110010100111001111000010011110111100100000000";
		-- 0.115596
		y <= "0000000000000000000000000000000000000000000000011101100101111011100100011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 927
		-- 153934.469963
		x <= "0000000000000000000000000010010110010100111001111000010011110111100100000000";
		-- 0.346789
		y <= "0000000000000000000000000000000000000000000001011000110001110010101101001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 928
		-- 153934.469963
		x <= "0000000000000000000000000010010110010100111001111000010011110111100100000000";
		-- 0.577982
		y <= "0000000000000000000000000000000000000000000010010011111101101001110110000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 929
		-- 153934.469963
		x <= "0000000000000000000000000010010110010100111001111000010011110111100100000000";
		-- 0.809175
		y <= "0000000000000000000000000000000000000000000011001111001001100000111110111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 930
		-- 153934.469963
		x <= "0000000000000000000000000010010110010100111001111000010011110111100100000000";
		-- 1.040367
		y <= "0000000000000000000000000000000000000000000100001010010101011000000111101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 931
		-- 155607.670723
		x <= "0000000000000000000000000010010111111101011110101011101101001000000111101110";
		-- -1.039426
		y <= "1111111111111111111111111111111111111111111011110101111010000010011000001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 932
		-- 155607.670723
		x <= "0000000000000000000000000010010111111101011110101011101101001000000111101110";
		-- -0.808443
		y <= "1111111111111111111111111111111111111111111100110001000010011110010010110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 933
		-- 155607.670723
		x <= "0000000000000000000000000010010111111101011110101011101101001000000111101110";
		-- -0.577459
		y <= "1111111111111111111111111111111111111111111101101100001010111010001101011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 934
		-- 155607.670723
		x <= "0000000000000000000000000010010111111101011110101011101101001000000111101110";
		-- -0.346475
		y <= "1111111111111111111111111111111111111111111110100111010011010110001000000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 935
		-- 155607.670723
		x <= "0000000000000000000000000010010111111101011110101011101101001000000111101110";
		-- -0.115492
		y <= "1111111111111111111111111111111111111111111111100010011011110010000010101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 936
		-- 155607.670723
		x <= "0000000000000000000000000010010111111101011110101011101101001000000111101110";
		-- 0.115492
		y <= "0000000000000000000000000000000000000000000000011101100100001101111101010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 937
		-- 155607.670723
		x <= "0000000000000000000000000010010111111101011110101011101101001000000111101110";
		-- 0.346475
		y <= "0000000000000000000000000000000000000000000001011000101100101001110111111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 938
		-- 155607.670723
		x <= "0000000000000000000000000010010111111101011110101011101101001000000111101110";
		-- 0.577459
		y <= "0000000000000000000000000000000000000000000010010011110101000101110010100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 939
		-- 155607.670723
		x <= "0000000000000000000000000010010111111101011110101011101101001000000111101110";
		-- 0.808443
		y <= "0000000000000000000000000000000000000000000011001110111101100001101101001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 940
		-- 155607.670723
		x <= "0000000000000000000000000010010111111101011110101011101101001000000111101110";
		-- 1.039426
		y <= "0000000000000000000000000000000000000000000100001010000101111101100111110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 941
		-- 157280.871483
		x <= "0000000000000000000000000010011001100110000011011111000110011000101011011101";
		-- -1.038497
		y <= "1111111111111111111111111111111111111111111011110110001001010000100100011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 942
		-- 157280.871483
		x <= "0000000000000000000000000010011001100110000011011111000110011000101011011101";
		-- -0.807720
		y <= "1111111111111111111111111111111111111111111100110001001110010011111111111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 943
		-- 157280.871483
		x <= "0000000000000000000000000010011001100110000011011111000110011000101011011101";
		-- -0.576943
		y <= "1111111111111111111111111111111111111111111101101100010011010111011011010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 944
		-- 157280.871483
		x <= "0000000000000000000000000010011001100110000011011111000110011000101011011101";
		-- -0.346166
		y <= "1111111111111111111111111111111111111111111110100111011000011010110110110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 945
		-- 157280.871483
		x <= "0000000000000000000000000010011001100110000011011111000110011000101011011101";
		-- -0.115389
		y <= "1111111111111111111111111111111111111111111111100010011101011110010010010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 946
		-- 157280.871483
		x <= "0000000000000000000000000010011001100110000011011111000110011000101011011101";
		-- 0.115389
		y <= "0000000000000000000000000000000000000000000000011101100010100001101101101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 947
		-- 157280.871483
		x <= "0000000000000000000000000010011001100110000011011111000110011000101011011101";
		-- 0.346166
		y <= "0000000000000000000000000000000000000000000001011000100111100101001001001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 948
		-- 157280.871483
		x <= "0000000000000000000000000010011001100110000011011111000110011000101011011101";
		-- 0.576943
		y <= "0000000000000000000000000000000000000000000010010011101100101000100100101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 949
		-- 157280.871483
		x <= "0000000000000000000000000010011001100110000011011111000110011000101011011101";
		-- 0.807720
		y <= "0000000000000000000000000000000000000000000011001110110001101100000000000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 950
		-- 157280.871483
		x <= "0000000000000000000000000010011001100110000011011111000110011000101011011101";
		-- 1.038497
		y <= "0000000000000000000000000000000000000000000100001001110110101111011011100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 951
		-- 158954.072244
		x <= "0000000000000000000000000010011011001110101000010010011111101001001111001011";
		-- -1.037580
		y <= "1111111111111111111111111111111111111111111011110110011000010010101111011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 952
		-- 158954.072244
		x <= "0000000000000000000000000010011011001110101000010010011111101001001111001011";
		-- -0.807006
		y <= "1111111111111111111111111111111111111111111100110001011010000000010110101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 953
		-- 158954.072244
		x <= "0000000000000000000000000010011011001110101000010010011111101001001111001011";
		-- -0.576433
		y <= "1111111111111111111111111111111111111111111101101100011011101101111101111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 954
		-- 158954.072244
		x <= "0000000000000000000000000010011011001110101000010010011111101001001111001011";
		-- -0.345860
		y <= "1111111111111111111111111111111111111111111110100111011101011011100101001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 955
		-- 158954.072244
		x <= "0000000000000000000000000010011011001110101000010010011111101001001111001011";
		-- -0.115287
		y <= "1111111111111111111111111111111111111111111111100010011111001001001100011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 956
		-- 158954.072244
		x <= "0000000000000000000000000010011011001110101000010010011111101001001111001011";
		-- 0.115287
		y <= "0000000000000000000000000000000000000000000000011101100000110110110011100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 957
		-- 158954.072244
		x <= "0000000000000000000000000010011011001110101000010010011111101001001111001011";
		-- 0.345860
		y <= "0000000000000000000000000000000000000000000001011000100010100100011010110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 958
		-- 158954.072244
		x <= "0000000000000000000000000010011011001110101000010010011111101001001111001011";
		-- 0.576433
		y <= "0000000000000000000000000000000000000000000010010011100100010010000010000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 959
		-- 158954.072244
		x <= "0000000000000000000000000010011011001110101000010010011111101001001111001011";
		-- 0.807006
		y <= "0000000000000000000000000000000000000000000011001110100101111111101001010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 960
		-- 158954.072244
		x <= "0000000000000000000000000010011011001110101000010010011111101001001111001011";
		-- 1.037580
		y <= "0000000000000000000000000000000000000000000100001001100111101101010000100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 961
		-- 160627.273004
		x <= "0000000000000000000000000010011100110111001101000101111000111001110010111010";
		-- -1.036673
		y <= "1111111111111111111111111111111111111111111011110110100111001001001010100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 962
		-- 160627.273004
		x <= "0000000000000000000000000010011100110111001101000101111000111001110010111010";
		-- -0.806302
		y <= "1111111111111111111111111111111111111111111100110001100101100011100100101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 963
		-- 160627.273004
		x <= "0000000000000000000000000010011100110111001101000101111000111001110010111010";
		-- -0.575930
		y <= "1111111111111111111111111111111111111111111101101100100011111101111110101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 964
		-- 160627.273004
		x <= "0000000000000000000000000010011100110111001101000101111000111001110010111010";
		-- -0.345558
		y <= "1111111111111111111111111111111111111111111110100111100010011000011000110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 965
		-- 160627.273004
		x <= "0000000000000000000000000010011100110111001101000101111000111001110010111010";
		-- -0.115186
		y <= "1111111111111111111111111111111111111111111111100010100000110010110010111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 966
		-- 160627.273004
		x <= "0000000000000000000000000010011100110111001101000101111000111001110010111010";
		-- 0.115186
		y <= "0000000000000000000000000000000000000000000000011101011111001101001101000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 967
		-- 160627.273004
		x <= "0000000000000000000000000010011100110111001101000101111000111001110010111010";
		-- 0.345558
		y <= "0000000000000000000000000000000000000000000001011000011101100111100111001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 968
		-- 160627.273004
		x <= "0000000000000000000000000010011100110111001101000101111000111001110010111010";
		-- 0.575930
		y <= "0000000000000000000000000000000000000000000010010011011100000010000001010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 969
		-- 160627.273004
		x <= "0000000000000000000000000010011100110111001101000101111000111001110010111010";
		-- 0.806302
		y <= "0000000000000000000000000000000000000000000011001110011010011100011011010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 970
		-- 160627.273004
		x <= "0000000000000000000000000010011100110111001101000101111000111001110010111010";
		-- 1.036673
		y <= "0000000000000000000000000000000000000000000100001001011000110110110101011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 971
		-- 162300.473765
		x <= "0000000000000000000000000010011110011111110001111001010010001010010110101000";
		-- -1.035778
		y <= "1111111111111111111111111111111111111111111011110110110101110100000110110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 972
		-- 162300.473765
		x <= "0000000000000000000000000010011110011111110001111001010010001010010110101000";
		-- -0.805605
		y <= "1111111111111111111111111111111111111111111100110001110000111101110111000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 973
		-- 162300.473765
		x <= "0000000000000000000000000010011110011111110001111001010010001010010110101000";
		-- -0.575432
		y <= "1111111111111111111111111111111111111111111101101100101100000111100111010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 974
		-- 162300.473765
		x <= "0000000000000000000000000010011110011111110001111001010010001010010110101000";
		-- -0.345259
		y <= "1111111111111111111111111111111111111111111110100111100111010001010111100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 975
		-- 162300.473765
		x <= "0000000000000000000000000010011110011111110001111001010010001010010110101000";
		-- -0.115086
		y <= "1111111111111111111111111111111111111111111111100010100010011011000111110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 976
		-- 162300.473765
		x <= "0000000000000000000000000010011110011111110001111001010010001010010110101000";
		-- 0.115086
		y <= "0000000000000000000000000000000000000000000000011101011101100100111000001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 977
		-- 162300.473765
		x <= "0000000000000000000000000010011110011111110001111001010010001010010110101000";
		-- 0.345259
		y <= "0000000000000000000000000000000000000000000001011000011000101110101000011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 978
		-- 162300.473765
		x <= "0000000000000000000000000010011110011111110001111001010010001010010110101000";
		-- 0.575432
		y <= "0000000000000000000000000000000000000000000010010011010011111000011000101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 979
		-- 162300.473765
		x <= "0000000000000000000000000010011110011111110001111001010010001010010110101000";
		-- 0.805605
		y <= "0000000000000000000000000000000000000000000011001110001111000010001000111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 980
		-- 162300.473765
		x <= "0000000000000000000000000010011110011111110001111001010010001010010110101000";
		-- 1.035778
		y <= "0000000000000000000000000000000000000000000100001001001010001011111001001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 981
		-- 163973.674525
		x <= "0000000000000000000000000010100000001000010110101100101011011010111010010111";
		-- -1.034893
		y <= "1111111111111111111111111111111111111111111011110111000100010011110100100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 982
		-- 163973.674525
		x <= "0000000000000000000000000010100000001000010110101100101011011010111010010111";
		-- -0.804917
		y <= "1111111111111111111111111111111111111111111100110001111100001111011010101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 983
		-- 163973.674525
		x <= "0000000000000000000000000010100000001000010110101100101011011010111010010111";
		-- -0.574941
		y <= "1111111111111111111111111111111111111111111101101100110100001011000000101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 984
		-- 163973.674525
		x <= "0000000000000000000000000010100000001000010110101100101011011010111010010111";
		-- -0.344964
		y <= "1111111111111111111111111111111111111111111110100111101100000110100110110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 985
		-- 163973.674525
		x <= "0000000000000000000000000010100000001000010110101100101011011010111010010111";
		-- -0.114988
		y <= "1111111111111111111111111111111111111111111111100010100100000010001100111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 986
		-- 163973.674525
		x <= "0000000000000000000000000010100000001000010110101100101011011010111010010111";
		-- 0.114988
		y <= "0000000000000000000000000000000000000000000000011101011011111101110011000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 987
		-- 163973.674525
		x <= "0000000000000000000000000010100000001000010110101100101011011010111010010111";
		-- 0.344964
		y <= "0000000000000000000000000000000000000000000001011000010011111001011001001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 988
		-- 163973.674525
		x <= "0000000000000000000000000010100000001000010110101100101011011010111010010111";
		-- 0.574941
		y <= "0000000000000000000000000000000000000000000010010011001011110100111111010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 989
		-- 163973.674525
		x <= "0000000000000000000000000010100000001000010110101100101011011010111010010111";
		-- 0.804917
		y <= "0000000000000000000000000000000000000000000011001110000011110000100101010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 990
		-- 163973.674525
		x <= "0000000000000000000000000010100000001000010110101100101011011010111010010111";
		-- 1.034893
		y <= "0000000000000000000000000000000000000000000100001000111011101100001011011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 991
		-- 165646.875286
		x <= "0000000000000000000000000010100001110000111011100000000100101011011110000101";
		-- -1.034019
		y <= "1111111111111111111111111111111111111111111011110111010010101000100011101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 992
		-- 165646.875286
		x <= "0000000000000000000000000010100001110000111011100000000100101011011110000101";
		-- -0.804237
		y <= "1111111111111111111111111111111111111111111100110010000111011000011011110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 993
		-- 165646.875286
		x <= "0000000000000000000000000010100001110000111011100000000100101011011110000101";
		-- -0.574455
		y <= "1111111111111111111111111111111111111111111101101100111100001000010011110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 994
		-- 165646.875286
		x <= "0000000000000000000000000010100001110000111011100000000100101011011110000101";
		-- -0.344673
		y <= "1111111111111111111111111111111111111111111110100111110000111000001011111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 995
		-- 165646.875286
		x <= "0000000000000000000000000010100001110000111011100000000100101011011110000101";
		-- -0.114891
		y <= "1111111111111111111111111111111111111111111111100010100101101000000011111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 996
		-- 165646.875286
		x <= "0000000000000000000000000010100001110000111011100000000100101011011110000101";
		-- 0.114891
		y <= "0000000000000000000000000000000000000000000000011101011010010111111100000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 997
		-- 165646.875286
		x <= "0000000000000000000000000010100001110000111011100000000100101011011110000101";
		-- 0.344673
		y <= "0000000000000000000000000000000000000000000001011000001111000111110100000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 998
		-- 165646.875286
		x <= "0000000000000000000000000010100001110000111011100000000100101011011110000101";
		-- 0.574455
		y <= "0000000000000000000000000000000000000000000010010011000011110111101100001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 999
		-- 165646.875286
		x <= "0000000000000000000000000010100001110000111011100000000100101011011110000101";
		-- 0.804237
		y <= "0000000000000000000000000000000000000000000011001101111000100111100100001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1000
		-- 165646.875286
		x <= "0000000000000000000000000010100001110000111011100000000100101011011110000101";
		-- 1.034019
		y <= "0000000000000000000000000000000000000000000100001000101101010111011100010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1001
		-- 167320.076046
		x <= "0000000000000000000000000010100011011001100000010011011101111100000001110100";
		-- -1.033155
		y <= "1111111111111111111111111111111111111111111011110111100000110010100011100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1002
		-- 167320.076046
		x <= "0000000000000000000000000010100011011001100000010011011101111100000001110100";
		-- -0.803565
		y <= "1111111111111111111111111111111111111111111100110010010010011001000110010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1003
		-- 167320.076046
		x <= "0000000000000000000000000010100011011001100000010011011101111100000001110100";
		-- -0.573975
		y <= "1111111111111111111111111111111111111111111101101101000011111111101001000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1004
		-- 167320.076046
		x <= "0000000000000000000000000010100011011001100000010011011101111100000001110100";
		-- -0.344385
		y <= "1111111111111111111111111111111111111111111110100111110101100110001011110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1005
		-- 167320.076046
		x <= "0000000000000000000000000010100011011001100000010011011101111100000001110100";
		-- -0.114795
		y <= "1111111111111111111111111111111111111111111111100010100111001100101110100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1006
		-- 167320.076046
		x <= "0000000000000000000000000010100011011001100000010011011101111100000001110100";
		-- 0.114795
		y <= "0000000000000000000000000000000000000000000000011101011000110011010001011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1007
		-- 167320.076046
		x <= "0000000000000000000000000010100011011001100000010011011101111100000001110100";
		-- 0.344385
		y <= "0000000000000000000000000000000000000000000001011000001010011001110100001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1008
		-- 167320.076046
		x <= "0000000000000000000000000010100011011001100000010011011101111100000001110100";
		-- 0.573975
		y <= "0000000000000000000000000000000000000000000010010010111100000000010110111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1009
		-- 167320.076046
		x <= "0000000000000000000000000010100011011001100000010011011101111100000001110100";
		-- 0.803565
		y <= "0000000000000000000000000000000000000000000011001101101101100110111001101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1010
		-- 167320.076046
		x <= "0000000000000000000000000010100011011001100000010011011101111100000001110100";
		-- 1.033155
		y <= "0000000000000000000000000000000000000000000100001000011111001101011100011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1011
		-- 168993.276806
		x <= "0000000000000000000000000010100101000010000101000110110111001100100101100010";
		-- -1.032301
		y <= "1111111111111111111111111111111111111111111011110111101110110010000011001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1012
		-- 168993.276806
		x <= "0000000000000000000000000010100101000010000101000110110111001100100101100010";
		-- -0.802901
		y <= "1111111111111111111111111111111111111111111100110010011101010001100110000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1013
		-- 168993.276806
		x <= "0000000000000000000000000010100101000010000101000110110111001100100101100010";
		-- -0.573501
		y <= "1111111111111111111111111111111111111111111101101101001011110001001000111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1014
		-- 168993.276806
		x <= "0000000000000000000000000010100101000010000101000110110111001100100101100010";
		-- -0.344100
		y <= "1111111111111111111111111111111111111111111110100111111010010000101011101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1015
		-- 168993.276806
		x <= "0000000000000000000000000010100101000010000101000110110111001100100101100010";
		-- -0.114700
		y <= "1111111111111111111111111111111111111111111111100010101000110000001110100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1016
		-- 168993.276806
		x <= "0000000000000000000000000010100101000010000101000110110111001100100101100010";
		-- 0.114700
		y <= "0000000000000000000000000000000000000000000000011101010111001111110001011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1017
		-- 168993.276806
		x <= "0000000000000000000000000010100101000010000101000110110111001100100101100010";
		-- 0.344100
		y <= "0000000000000000000000000000000000000000000001011000000101101111010100010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1018
		-- 168993.276806
		x <= "0000000000000000000000000010100101000010000101000110110111001100100101100010";
		-- 0.573501
		y <= "0000000000000000000000000000000000000000000010010010110100001110110111000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1019
		-- 168993.276806
		x <= "0000000000000000000000000010100101000010000101000110110111001100100101100010";
		-- 0.802901
		y <= "0000000000000000000000000000000000000000000011001101100010101110011001111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1020
		-- 168993.276806
		x <= "0000000000000000000000000010100101000010000101000110110111001100100101100010";
		-- 1.032301
		y <= "0000000000000000000000000000000000000000000100001000010001001101111100110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1021
		-- 170666.477567
		x <= "0000000000000000000000000010100110101010101001111010010000011101001001010001";
		-- -1.031457
		y <= "1111111111111111111111111111111111111111111011110111111100100111010000110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1022
		-- 170666.477567
		x <= "0000000000000000000000000010100110101010101001111010010000011101001001010001";
		-- -0.802244
		y <= "1111111111111111111111111111111111111111111100110010101000000010000110000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1023
		-- 170666.477567
		x <= "0000000000000000000000000010100110101010101001111010010000011101001001010001";
		-- -0.573031
		y <= "1111111111111111111111111111111111111111111101101101010011011100111011001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1024
		-- 170666.477567
		x <= "0000000000000000000000000010100110101010101001111010010000011101001001010001";
		-- -0.343819
		y <= "1111111111111111111111111111111111111111111110100111111110110111110000010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1025
		-- 170666.477567
		x <= "0000000000000000000000000010100110101010101001111010010000011101001001010001";
		-- -0.114606
		y <= "1111111111111111111111111111111111111111111111100010101010010010100101011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1026
		-- 170666.477567
		x <= "0000000000000000000000000010100110101010101001111010010000011101001001010001";
		-- 0.114606
		y <= "0000000000000000000000000000000000000000000000011101010101101101011010100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1027
		-- 170666.477567
		x <= "0000000000000000000000000010100110101010101001111010010000011101001001010001";
		-- 0.343819
		y <= "0000000000000000000000000000000000000000000001011000000001001000001111101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1028
		-- 170666.477567
		x <= "0000000000000000000000000010100110101010101001111010010000011101001001010001";
		-- 0.573031
		y <= "0000000000000000000000000000000000000000000010010010101100100011000100110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1029
		-- 170666.477567
		x <= "0000000000000000000000000010100110101010101001111010010000011101001001010001";
		-- 0.802244
		y <= "0000000000000000000000000000000000000000000011001101010111111101111001111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1030
		-- 170666.477567
		x <= "0000000000000000000000000010100110101010101001111010010000011101001001010001";
		-- 1.031457
		y <= "0000000000000000000000000000000000000000000100001000000011011000101111001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1031
		-- 172339.678327
		x <= "0000000000000000000000000010101000010011001110101101101001101101101100111111";
		-- -1.030622
		y <= "1111111111111111111111111111111111111111111011111000001010010010011010100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1032
		-- 172339.678327
		x <= "0000000000000000000000000010101000010011001110101101101001101101101100111111";
		-- -0.801595
		y <= "1111111111111111111111111111111111111111111100110010110010101010110001000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1033
		-- 172339.678327
		x <= "0000000000000000000000000010101000010011001110101101101001101101101100111111";
		-- -0.572568
		y <= "1111111111111111111111111111111111111111111101101101011011000011000111101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1034
		-- 172339.678327
		x <= "0000000000000000000000000010101000010011001110101101101001101101101100111111";
		-- -0.343541
		y <= "1111111111111111111111111111111111111111111110101000000011011011011110001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1035
		-- 172339.678327
		x <= "0000000000000000000000000010101000010011001110101101101001101101101100111111";
		-- -0.114514
		y <= "1111111111111111111111111111111111111111111111100010101011110011110100101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1036
		-- 172339.678327
		x <= "0000000000000000000000000010101000010011001110101101101001101101101100111111";
		-- 0.114514
		y <= "0000000000000000000000000000000000000000000000011101010100001100001011010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1037
		-- 172339.678327
		x <= "0000000000000000000000000010101000010011001110101101101001101101101100111111";
		-- 0.343541
		y <= "0000000000000000000000000000000000000000000001010111111100100100100001110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1038
		-- 172339.678327
		x <= "0000000000000000000000000010101000010011001110101101101001101101101100111111";
		-- 0.572568
		y <= "0000000000000000000000000000000000000000000010010010100100111100111000010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1039
		-- 172339.678327
		x <= "0000000000000000000000000010101000010011001110101101101001101101101100111111";
		-- 0.801595
		y <= "0000000000000000000000000000000000000000000011001101001101010101001110111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1040
		-- 172339.678327
		x <= "0000000000000000000000000010101000010011001110101101101001101101101100111111";
		-- 1.030622
		y <= "0000000000000000000000000000000000000000000100000111110101101101100101011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1041
		-- 174012.879088
		x <= "0000000000000000000000000010101001111011110011100001000010111110010000101110";
		-- -1.029797
		y <= "1111111111111111111111111111111111111111111011111000010111110011101101110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1042
		-- 174012.879088
		x <= "0000000000000000000000000010101001111011110011100001000010111110010000101110";
		-- -0.800953
		y <= "1111111111111111111111111111111111111111111100110010111101001011110001110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1043
		-- 174012.879088
		x <= "0000000000000000000000000010101001111011110011100001000010111110010000101110";
		-- -0.572109
		y <= "1111111111111111111111111111111111111111111101101101100010100011110101111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1044
		-- 174012.879088
		x <= "0000000000000000000000000010101001111011110011100001000010111110010000101110";
		-- -0.343266
		y <= "1111111111111111111111111111111111111111111110101000000111111011111001111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1045
		-- 174012.879088
		x <= "0000000000000000000000000010101001111011110011100001000010111110010000101110";
		-- -0.114422
		y <= "1111111111111111111111111111111111111111111111100010101101010011111101111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1046
		-- 174012.879088
		x <= "0000000000000000000000000010101001111011110011100001000010111110010000101110";
		-- 0.114422
		y <= "0000000000000000000000000000000000000000000000011101010010101100000010000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1047
		-- 174012.879088
		x <= "0000000000000000000000000010101001111011110011100001000010111110010000101110";
		-- 0.343266
		y <= "0000000000000000000000000000000000000000000001010111111000000100000110000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1048
		-- 174012.879088
		x <= "0000000000000000000000000010101001111011110011100001000010111110010000101110";
		-- 0.572109
		y <= "0000000000000000000000000000000000000000000010010010011101011100001010000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1049
		-- 174012.879088
		x <= "0000000000000000000000000010101001111011110011100001000010111110010000101110";
		-- 0.800953
		y <= "0000000000000000000000000000000000000000000011001101000010110100001110001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1050
		-- 174012.879088
		x <= "0000000000000000000000000010101001111011110011100001000010111110010000101110";
		-- 1.029797
		y <= "0000000000000000000000000000000000000000000100000111101000001100010010001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1051
		-- 175686.079848
		x <= "0000000000000000000000000010101011100100011000010100011100001110110100011100";
		-- -1.028981
		y <= "1111111111111111111111111111111111111111111011111000100101001011010111110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1052
		-- 175686.079848
		x <= "0000000000000000000000000010101011100100011000010100011100001110110100011100";
		-- -0.800318
		y <= "1111111111111111111111111111111111111111111100110011000111100101010010100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1053
		-- 175686.079848
		x <= "0000000000000000000000000010101011100100011000010100011100001110110100011100";
		-- -0.571656
		y <= "1111111111111111111111111111111111111111111101101101101001111111001101001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1054
		-- 175686.079848
		x <= "0000000000000000000000000010101011100100011000010100011100001110110100011100";
		-- -0.342994
		y <= "1111111111111111111111111111111111111111111110101000001100011001000111111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1055
		-- 175686.079848
		x <= "0000000000000000000000000010101011100100011000010100011100001110110100011100";
		-- -0.114331
		y <= "1111111111111111111111111111111111111111111111100010101110110011000010101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1056
		-- 175686.079848
		x <= "0000000000000000000000000010101011100100011000010100011100001110110100011100";
		-- 0.114331
		y <= "0000000000000000000000000000000000000000000000011101010001001100111101010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1057
		-- 175686.079848
		x <= "0000000000000000000000000010101011100100011000010100011100001110110100011100";
		-- 0.342994
		y <= "0000000000000000000000000000000000000000000001010111110011100110111000000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1058
		-- 175686.079848
		x <= "0000000000000000000000000010101011100100011000010100011100001110110100011100";
		-- 0.571656
		y <= "0000000000000000000000000000000000000000000010010010010110000000110010110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1059
		-- 175686.079848
		x <= "0000000000000000000000000010101011100100011000010100011100001110110100011100";
		-- 0.800318
		y <= "0000000000000000000000000000000000000000000011001100111000011010101101011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1060
		-- 175686.079848
		x <= "0000000000000000000000000010101011100100011000010100011100001110110100011100";
		-- 1.028981
		y <= "0000000000000000000000000000000000000000000100000111011010110100101000001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1061
		-- 177359.280609
		x <= "0000000000000000000000000010101101001100111101000111110101011111011000001011";
		-- -1.028174
		y <= "1111111111111111111111111111111111111111111011111000110010011001100101001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1062
		-- 177359.280609
		x <= "0000000000000000000000000010101101001100111101000111110101011111011000001011";
		-- -0.799691
		y <= "1111111111111111111111111111111111111111111100110011010001110111011100111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1063
		-- 177359.280609
		x <= "0000000000000000000000000010101101001100111101000111110101011111011000001011";
		-- -0.571208
		y <= "1111111111111111111111111111111111111111111101101101110001010101010100101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1064
		-- 177359.280609
		x <= "0000000000000000000000000010101101001100111101000111110101011111011000001011";
		-- -0.342725
		y <= "1111111111111111111111111111111111111111111110101000010000110011001100011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1065
		-- 177359.280609
		x <= "0000000000000000000000000010101101001100111101000111110101011111011000001011";
		-- -0.114242
		y <= "1111111111111111111111111111111111111111111111100010110000010001000100001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1066
		-- 177359.280609
		x <= "0000000000000000000000000010101101001100111101000111110101011111011000001011";
		-- 0.114242
		y <= "0000000000000000000000000000000000000000000000011101001111101110111011110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1067
		-- 177359.280609
		x <= "0000000000000000000000000010101101001100111101000111110101011111011000001011";
		-- 0.342725
		y <= "0000000000000000000000000000000000000000000001010111101111001100110011100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1068
		-- 177359.280609
		x <= "0000000000000000000000000010101101001100111101000111110101011111011000001011";
		-- 0.571208
		y <= "0000000000000000000000000000000000000000000010010010001110101010101011010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1069
		-- 177359.280609
		x <= "0000000000000000000000000010101101001100111101000111110101011111011000001011";
		-- 0.799691
		y <= "0000000000000000000000000000000000000000000011001100101110001000100011000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1070
		-- 177359.280609
		x <= "0000000000000000000000000010101101001100111101000111110101011111011000001011";
		-- 1.028174
		y <= "0000000000000000000000000000000000000000000100000111001101100110011010110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1071
		-- 179032.481369
		x <= "0000000000000000000000000010101110110101100001111011001110101111111011111001";
		-- -1.027376
		y <= "1111111111111111111111111111111111111111111011111000111111011110100010010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1072
		-- 179032.481369
		x <= "0000000000000000000000000010101110110101100001111011001110101111111011111001";
		-- -0.799070
		y <= "1111111111111111111111111111111111111111111100110011011100000010011010101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1073
		-- 179032.481369
		x <= "0000000000000000000000000010101110110101100001111011001110101111111011111001";
		-- -0.570764
		y <= "1111111111111111111111111111111111111111111101101101111000100110010011000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1074
		-- 179032.481369
		x <= "0000000000000000000000000010101110110101100001111011001110101111111011111001";
		-- -0.342459
		y <= "1111111111111111111111111111111111111111111110101000010101001010001011011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1075
		-- 179032.481369
		x <= "0000000000000000000000000010101110110101100001111011001110101111111011111001";
		-- -0.114153
		y <= "1111111111111111111111111111111111111111111111100010110001101110000011110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1076
		-- 179032.481369
		x <= "0000000000000000000000000010101110110101100001111011001110101111111011111001";
		-- 0.114153
		y <= "0000000000000000000000000000000000000000000000011101001110010001111100001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1077
		-- 179032.481369
		x <= "0000000000000000000000000010101110110101100001111011001110101111111011111001";
		-- 0.342459
		y <= "0000000000000000000000000000000000000000000001010111101010110101110100100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1078
		-- 179032.481369
		x <= "0000000000000000000000000010101110110101100001111011001110101111111011111001";
		-- 0.570764
		y <= "0000000000000000000000000000000000000000000010010010000111011001101100111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1079
		-- 179032.481369
		x <= "0000000000000000000000000010101110110101100001111011001110101111111011111001";
		-- 0.799070
		y <= "0000000000000000000000000000000000000000000011001100100011111101100101010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1080
		-- 179032.481369
		x <= "0000000000000000000000000010101110110101100001111011001110101111111011111001";
		-- 1.027376
		y <= "0000000000000000000000000000000000000000000100000111000000100001011101101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1081
		-- 180705.682129
		x <= "0000000000000000000000000010110000011110000110101110101000000000011111101000";
		-- -1.026586
		y <= "1111111111111111111111111111111111111111111011111001001100011010011011010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1082
		-- 180705.682129
		x <= "0000000000000000000000000010110000011110000110101110101000000000011111101000";
		-- -0.798456
		y <= "1111111111111111111111111111111111111111111100110011100110000110010101001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1083
		-- 180705.682129
		x <= "0000000000000000000000000010110000011110000110101110101000000000011111101000";
		-- -0.570326
		y <= "1111111111111111111111111111111111111111111101101101111111110010001111001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1084
		-- 180705.682129
		x <= "0000000000000000000000000010110000011110000110101110101000000000011111101000";
		-- -0.342195
		y <= "1111111111111111111111111111111111111111111110101000011001011110001001000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1085
		-- 180705.682129
		x <= "0000000000000000000000000010110000011110000110101110101000000000011111101000";
		-- -0.114065
		y <= "1111111111111111111111111111111111111111111111100010110011001010000011000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1086
		-- 180705.682129
		x <= "0000000000000000000000000010110000011110000110101110101000000000011111101000";
		-- 0.114065
		y <= "0000000000000000000000000000000000000000000000011101001100110101111100111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1087
		-- 180705.682129
		x <= "0000000000000000000000000010110000011110000110101110101000000000011111101000";
		-- 0.342195
		y <= "0000000000000000000000000000000000000000000001010111100110100001110110111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1088
		-- 180705.682129
		x <= "0000000000000000000000000010110000011110000110101110101000000000011111101000";
		-- 0.570326
		y <= "0000000000000000000000000000000000000000000010010010000000001101110000110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1089
		-- 180705.682129
		x <= "0000000000000000000000000010110000011110000110101110101000000000011111101000";
		-- 0.798456
		y <= "0000000000000000000000000000000000000000000011001100011001111001101010110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1090
		-- 180705.682129
		x <= "0000000000000000000000000010110000011110000110101110101000000000011111101000";
		-- 1.026586
		y <= "0000000000000000000000000000000000000000000100000110110011100101100100101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1091
		-- 182378.882890
		x <= "0000000000000000000000000010110010000110101011100010000001010001000011010110";
		-- -1.025805
		y <= "1111111111111111111111111111111111111111111011111001011001001101011011101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1092
		-- 182378.882890
		x <= "0000000000000000000000000010110010000110101011100010000001010001000011010110";
		-- -0.797848
		y <= "1111111111111111111111111111111111111111111100110011110000000011010101100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1093
		-- 182378.882890
		x <= "0000000000000000000000000010110010000110101011100010000001010001000011010110";
		-- -0.569892
		y <= "1111111111111111111111111111111111111111111101101110000110111001001111010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1094
		-- 182378.882890
		x <= "0000000000000000000000000010110010000110101011100010000001010001000011010110";
		-- -0.341935
		y <= "1111111111111111111111111111111111111111111110101000011101101111001001001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1095
		-- 182378.882890
		x <= "0000000000000000000000000010110010000110101011100010000001010001000011010110";
		-- -0.113978
		y <= "1111111111111111111111111111111111111111111111100010110100100101000011000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1096
		-- 182378.882890
		x <= "0000000000000000000000000010110010000110101011100010000001010001000011010110";
		-- 0.113978
		y <= "0000000000000000000000000000000000000000000000011101001011011010111100111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1097
		-- 182378.882890
		x <= "0000000000000000000000000010110010000110101011100010000001010001000011010110";
		-- 0.341935
		y <= "0000000000000000000000000000000000000000000001010111100010010000110110110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1098
		-- 182378.882890
		x <= "0000000000000000000000000010110010000110101011100010000001010001000011010110";
		-- 0.569892
		y <= "0000000000000000000000000000000000000000000010010001111001000110110000101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1099
		-- 182378.882890
		x <= "0000000000000000000000000010110010000110101011100010000001010001000011010110";
		-- 0.797848
		y <= "0000000000000000000000000000000000000000000011001100001111111100101010011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1100
		-- 182378.882890
		x <= "0000000000000000000000000010110010000110101011100010000001010001000011010110";
		-- 1.025805
		y <= "0000000000000000000000000000000000000000000100000110100110110010100100010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1101
		-- 184052.083650
		x <= "0000000000000000000000000010110011101111010000010101011010100001100111000101";
		-- -1.025032
		y <= "1111111111111111111111111111111111111111111011111001100101110111101110101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1102
		-- 184052.083650
		x <= "0000000000000000000000000010110011101111010000010101011010100001100111000101";
		-- -0.797247
		y <= "1111111111111111111111111111111111111111111100110011111001111001100100010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1103
		-- 184052.083650
		x <= "0000000000000000000000000010110011101111010000010101011010100001100111000101";
		-- -0.569462
		y <= "1111111111111111111111111111111111111111111101101110001101111011011001111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1104
		-- 184052.083650
		x <= "0000000000000000000000000010110011101111010000010101011010100001100111000101";
		-- -0.341677
		y <= "1111111111111111111111111111111111111111111110101000100001111101001111100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1105
		-- 184052.083650
		x <= "0000000000000000000000000010110011101111010000010101011010100001100111000101";
		-- -0.113892
		y <= "1111111111111111111111111111111111111111111111100010110101111111000101001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1106
		-- 184052.083650
		x <= "0000000000000000000000000010110011101111010000010101011010100001100111000101";
		-- 0.113892
		y <= "0000000000000000000000000000000000000000000000011101001010000000111010110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1107
		-- 184052.083650
		x <= "0000000000000000000000000010110011101111010000010101011010100001100111000101";
		-- 0.341677
		y <= "0000000000000000000000000000000000000000000001010111011110000010110000011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1108
		-- 184052.083650
		x <= "0000000000000000000000000010110011101111010000010101011010100001100111000101";
		-- 0.569462
		y <= "0000000000000000000000000000000000000000000010010001110010000100100110000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1109
		-- 184052.083650
		x <= "0000000000000000000000000010110011101111010000010101011010100001100111000101";
		-- 0.797247
		y <= "0000000000000000000000000000000000000000000011001100000110000110011011101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1110
		-- 184052.083650
		x <= "0000000000000000000000000010110011101111010000010101011010100001100111000101";
		-- 1.025032
		y <= "0000000000000000000000000000000000000000000100000110011010001000010001010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1111
		-- 185725.284411
		x <= "0000000000000000000000000010110101010111110101001000110011110010001010110011";
		-- -1.024268
		y <= "1111111111111111111111111111111111111111111011111001110010011001011111011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1112
		-- 185725.284411
		x <= "0000000000000000000000000010110101010111110101001000110011110010001010110011";
		-- -0.796653
		y <= "1111111111111111111111111111111111111111111100110100000011101001001010001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1113
		-- 185725.284411
		x <= "0000000000000000000000000010110101010111110101001000110011110010001010110011";
		-- -0.569038
		y <= "1111111111111111111111111111111111111111111101101110010100111000110100111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1114
		-- 185725.284411
		x <= "0000000000000000000000000010110101010111110101001000110011110010001010110011";
		-- -0.341423
		y <= "1111111111111111111111111111111111111111111110101000100110001000011111110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1115
		-- 185725.284411
		x <= "0000000000000000000000000010110101010111110101001000110011110010001010110011";
		-- -0.113808
		y <= "1111111111111111111111111111111111111111111111100010110111011000001010100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1116
		-- 185725.284411
		x <= "0000000000000000000000000010110101010111110101001000110011110010001010110011";
		-- 0.113808
		y <= "0000000000000000000000000000000000000000000000011101001000100111110101011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1117
		-- 185725.284411
		x <= "0000000000000000000000000010110101010111110101001000110011110010001010110011";
		-- 0.341423
		y <= "0000000000000000000000000000000000000000000001010111011001110111100000001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1118
		-- 185725.284411
		x <= "0000000000000000000000000010110101010111110101001000110011110010001010110011";
		-- 0.569038
		y <= "0000000000000000000000000000000000000000000010010001101011000111001011000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1119
		-- 185725.284411
		x <= "0000000000000000000000000010110101010111110101001000110011110010001010110011";
		-- 0.796653
		y <= "0000000000000000000000000000000000000000000011001011111100010110110101110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1120
		-- 185725.284411
		x <= "0000000000000000000000000010110101010111110101001000110011110010001010110011";
		-- 1.024268
		y <= "0000000000000000000000000000000000000000000100000110001101100110100000100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1121
		-- 187398.485171
		x <= "0000000000000000000000000010110111000000011001111100001101000010101110100010";
		-- -1.023511
		y <= "1111111111111111111111111111111111111111111011111001111110110010111000011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1122
		-- 187398.485171
		x <= "0000000000000000000000000010110111000000011001111100001101000010101110100010";
		-- -0.796064
		y <= "1111111111111111111111111111111111111111111100110100001101010010001111011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1123
		-- 187398.485171
		x <= "0000000000000000000000000010110111000000011001111100001101000010101110100010";
		-- -0.568617
		y <= "1111111111111111111111111111111111111111111101101110011011110001100110011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1124
		-- 187398.485171
		x <= "0000000000000000000000000010110111000000011001111100001101000010101110100010";
		-- -0.341170
		y <= "1111111111111111111111111111111111111111111110101000101010010000111101011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1125
		-- 187398.485171
		x <= "0000000000000000000000000010110111000000011001111100001101000010101110100010";
		-- -0.113723
		y <= "1111111111111111111111111111111111111111111111100010111000110000010100011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1126
		-- 187398.485171
		x <= "0000000000000000000000000010110111000000011001111100001101000010101110100010";
		-- 0.113723
		y <= "0000000000000000000000000000000000000000000000011101000111001111101011100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1127
		-- 187398.485171
		x <= "0000000000000000000000000010110111000000011001111100001101000010101110100010";
		-- 0.341170
		y <= "0000000000000000000000000000000000000000000001010111010101101111000010100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1128
		-- 187398.485171
		x <= "0000000000000000000000000010110111000000011001111100001101000010101110100010";
		-- 0.568617
		y <= "0000000000000000000000000000000000000000000010010001100100001110011001100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1129
		-- 187398.485171
		x <= "0000000000000000000000000010110111000000011001111100001101000010101110100010";
		-- 0.796064
		y <= "0000000000000000000000000000000000000000000011001011110010101101110000100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1130
		-- 187398.485171
		x <= "0000000000000000000000000010110111000000011001111100001101000010101110100010";
		-- 1.023511
		y <= "0000000000000000000000000000000000000000000100000110000001001101000111100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1131
		-- 189071.685931
		x <= "0000000000000000000000000010111000101000111110101111100110010011010010010000";
		-- -1.022762
		y <= "1111111111111111111111111111111111111111111011111010001011000100000100000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1132
		-- 189071.685931
		x <= "0000000000000000000000000010111000101000111110101111100110010011010010010000";
		-- -0.795482
		y <= "1111111111111111111111111111111111111111111100110100010110110100111100000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1133
		-- 189071.685931
		x <= "0000000000000000000000000010111000101000111110101111100110010011010010010000";
		-- -0.568201
		y <= "1111111111111111111111111111111111111111111101101110100010100101110100000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1134
		-- 189071.685931
		x <= "0000000000000000000000000010111000101000111110101111100110010011010010010000";
		-- -0.340921
		y <= "1111111111111111111111111111111111111111111110101000101110010110101100000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1135
		-- 189071.685931
		x <= "0000000000000000000000000010111000101000111110101111100110010011010010010000";
		-- -0.113640
		y <= "1111111111111111111111111111111111111111111111100010111010000111100100000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1136
		-- 189071.685931
		x <= "0000000000000000000000000010111000101000111110101111100110010011010010010000";
		-- 0.113640
		y <= "0000000000000000000000000000000000000000000000011101000101111000011011111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1137
		-- 189071.685931
		x <= "0000000000000000000000000010111000101000111110101111100110010011010010010000";
		-- 0.340921
		y <= "0000000000000000000000000000000000000000000001010111010001101001010011111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1138
		-- 189071.685931
		x <= "0000000000000000000000000010111000101000111110101111100110010011010010010000";
		-- 0.568201
		y <= "0000000000000000000000000000000000000000000010010001011101011010001011111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1139
		-- 189071.685931
		x <= "0000000000000000000000000010111000101000111110101111100110010011010010010000";
		-- 0.795482
		y <= "0000000000000000000000000000000000000000000011001011101001001011000011111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1140
		-- 189071.685931
		x <= "0000000000000000000000000010111000101000111110101111100110010011010010010000";
		-- 1.022762
		y <= "0000000000000000000000000000000000000000000100000101110100111011111011111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1141
		-- 190744.886692
		x <= "0000000000000000000000000010111010010001100011100010111111100011110101111111";
		-- -1.022021
		y <= "1111111111111111111111111111111111111111111011111010010111001101001100100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1142
		-- 190744.886692
		x <= "0000000000000000000000000010111010010001100011100010111111100011110101111111";
		-- -0.794905
		y <= "1111111111111111111111111111111111111111111100110100100000010001010111111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1143
		-- 190744.886692
		x <= "0000000000000000000000000010111010010001100011100010111111100011110101111111";
		-- -0.567790
		y <= "1111111111111111111111111111111111111111111101101110101001010101100011011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1144
		-- 190744.886692
		x <= "0000000000000000000000000010111010010001100011100010111111100011110101111111";
		-- -0.340674
		y <= "1111111111111111111111111111111111111111111110101000110010011001101110110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1145
		-- 190744.886692
		x <= "0000000000000000000000000010111010010001100011100010111111100011110101111111";
		-- -0.113558
		y <= "1111111111111111111111111111111111111111111111100010111011011101111010010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1146
		-- 190744.886692
		x <= "0000000000000000000000000010111010010001100011100010111111100011110101111111";
		-- 0.113558
		y <= "0000000000000000000000000000000000000000000000011101000100100010000101101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1147
		-- 190744.886692
		x <= "0000000000000000000000000010111010010001100011100010111111100011110101111111";
		-- 0.340674
		y <= "0000000000000000000000000000000000000000000001010111001101100110010001001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1148
		-- 190744.886692
		x <= "0000000000000000000000000010111010010001100011100010111111100011110101111111";
		-- 0.567790
		y <= "0000000000000000000000000000000000000000000010010001010110101010011100100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1149
		-- 190744.886692
		x <= "0000000000000000000000000010111010010001100011100010111111100011110101111111";
		-- 0.794905
		y <= "0000000000000000000000000000000000000000000011001011011111101110101000000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1150
		-- 190744.886692
		x <= "0000000000000000000000000010111010010001100011100010111111100011110101111111";
		-- 1.022021
		y <= "0000000000000000000000000000000000000000000100000101101000110010110011011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1151
		-- 192418.087452
		x <= "0000000000000000000000000010111011111010001000010110011000110100011001101101";
		-- -1.021288
		y <= "1111111111111111111111111111111111111111111011111010100011001110011011100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1152
		-- 192418.087452
		x <= "0000000000000000000000000010111011111010001000010110011000110100011001101101";
		-- -0.794335
		y <= "1111111111111111111111111111111111111111111100110100101001100111101010101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1153
		-- 192418.087452
		x <= "0000000000000000000000000010111011111010001000010110011000110100011001101101";
		-- -0.567382
		y <= "1111111111111111111111111111111111111111111101101110110000000000111001111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1154
		-- 192418.087452
		x <= "0000000000000000000000000010111011111010001000010110011000110100011001101101";
		-- -0.340429
		y <= "1111111111111111111111111111111111111111111110101000110110011010001001001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1155
		-- 192418.087452
		x <= "0000000000000000000000000010111011111010001000010110011000110100011001101101";
		-- -0.113476
		y <= "1111111111111111111111111111111111111111111111100010111100110011011000011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1156
		-- 192418.087452
		x <= "0000000000000000000000000010111011111010001000010110011000110100011001101101";
		-- 0.113476
		y <= "0000000000000000000000000000000000000000000000011101000011001100100111100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1157
		-- 192418.087452
		x <= "0000000000000000000000000010111011111010001000010110011000110100011001101101";
		-- 0.340429
		y <= "0000000000000000000000000000000000000000000001010111001001100101110110110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1158
		-- 192418.087452
		x <= "0000000000000000000000000010111011111010001000010110011000110100011001101101";
		-- 0.567382
		y <= "0000000000000000000000000000000000000000000010010001001111111111000110000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1159
		-- 192418.087452
		x <= "0000000000000000000000000010111011111010001000010110011000110100011001101101";
		-- 0.794335
		y <= "0000000000000000000000000000000000000000000011001011010110011000010101010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1160
		-- 192418.087452
		x <= "0000000000000000000000000010111011111010001000010110011000110100011001101101";
		-- 1.021288
		y <= "0000000000000000000000000000000000000000000100000101011100110001100100011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1161
		-- 194091.288213
		x <= "0000000000000000000000000010111101100010101101001001110010000100111101011100";
		-- -1.020561
		y <= "1111111111111111111111111111111111111111111011111010101111000111111010100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1162
		-- 194091.288213
		x <= "0000000000000000000000000010111101100010101101001001110010000100111101011100";
		-- -0.793770
		y <= "1111111111111111111111111111111111111111111100110100110010110111111011101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1163
		-- 194091.288213
		x <= "0000000000000000000000000010111101100010101101001001110010000100111101011100";
		-- -0.566979
		y <= "1111111111111111111111111111111111111111111101101110110110100111111100111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1164
		-- 194091.288213
		x <= "0000000000000000000000000010111101100010101101001001110010000100111101011100";
		-- -0.340187
		y <= "1111111111111111111111111111111111111111111110101000111010010111111110001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1165
		-- 194091.288213
		x <= "0000000000000000000000000010111101100010101101001001110010000100111101011100";
		-- -0.113396
		y <= "1111111111111111111111111111111111111111111111100010111110000111111111011000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1166
		-- 194091.288213
		x <= "0000000000000000000000000010111101100010101101001001110010000100111101011100";
		-- 0.113396
		y <= "0000000000000000000000000000000000000000000000011101000001111000000000100111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1167
		-- 194091.288213
		x <= "0000000000000000000000000010111101100010101101001001110010000100111101011100";
		-- 0.340187
		y <= "0000000000000000000000000000000000000000000001010111000101101000000001110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1168
		-- 194091.288213
		x <= "0000000000000000000000000010111101100010101101001001110010000100111101011100";
		-- 0.566979
		y <= "0000000000000000000000000000000000000000000010010001001001011000000011000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1169
		-- 194091.288213
		x <= "0000000000000000000000000010111101100010101101001001110010000100111101011100";
		-- 0.793770
		y <= "0000000000000000000000000000000000000000000011001011001101001000000100010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1170
		-- 194091.288213
		x <= "0000000000000000000000000010111101100010101101001001110010000100111101011100";
		-- 1.020561
		y <= "0000000000000000000000000000000000000000000100000101010000111000000101011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1171
		-- 195764.488973
		x <= "0000000000000000000000000010111111001011010001111101001011010101100001001010";
		-- -1.019842
		y <= "1111111111111111111111111111111111111111111011111010111010111001110010110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1172
		-- 195764.488973
		x <= "0000000000000000000000000010111111001011010001111101001011010101100001001010";
		-- -0.793211
		y <= "1111111111111111111111111111111111111111111100110100111100000010010010001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1173
		-- 195764.488973
		x <= "0000000000000000000000000010111111001011010001111101001011010101100001001010";
		-- -0.566579
		y <= "1111111111111111111111111111111111111111111101101110111101001010110001100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1174
		-- 195764.488973
		x <= "0000000000000000000000000010111111001011010001111101001011010101100001001010";
		-- -0.339947
		y <= "1111111111111111111111111111111111111111111110101000111110010011010000111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1175
		-- 195764.488973
		x <= "0000000000000000000000000010111111001011010001111101001011010101100001001010";
		-- -0.113316
		y <= "1111111111111111111111111111111111111111111111100010111111011011110000010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1176
		-- 195764.488973
		x <= "0000000000000000000000000010111111001011010001111101001011010101100001001010";
		-- 0.113316
		y <= "0000000000000000000000000000000000000000000000011101000000100100001111101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1177
		-- 195764.488973
		x <= "0000000000000000000000000010111111001011010001111101001011010101100001001010";
		-- 0.339947
		y <= "0000000000000000000000000000000000000000000001010111000001101100101111000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1178
		-- 195764.488973
		x <= "0000000000000000000000000010111111001011010001111101001011010101100001001010";
		-- 0.566579
		y <= "0000000000000000000000000000000000000000000010010001000010110101001110011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1179
		-- 195764.488973
		x <= "0000000000000000000000000010111111001011010001111101001011010101100001001010";
		-- 0.793211
		y <= "0000000000000000000000000000000000000000000011001011000011111101101101110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1180
		-- 195764.488973
		x <= "0000000000000000000000000010111111001011010001111101001011010101100001001010";
		-- 1.019842
		y <= "0000000000000000000000000000000000000000000100000101000101000110001101001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1181
		-- 197437.689734
		x <= "0000000000000000000000000011000000110011110110110000100100100110000100111001";
		-- -1.019131
		y <= "1111111111111111111111111111111111111111111011111011000110100100001101011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1182
		-- 197437.689734
		x <= "0000000000000000000000000011000000110011110110110000100100100110000100111001";
		-- -0.792657
		y <= "1111111111111111111111111111111111111111111100110101000101000110110101000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1183
		-- 197437.689734
		x <= "0000000000000000000000000011000000110011110110110000100100100110000100111001";
		-- -0.566184
		y <= "1111111111111111111111111111111111111111111101101111000011101001011100110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1184
		-- 197437.689734
		x <= "0000000000000000000000000011000000110011110110110000100100100110000100111001";
		-- -0.339710
		y <= "1111111111111111111111111111111111111111111110101001000010001100000100011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1185
		-- 197437.689734
		x <= "0000000000000000000000000011000000110011110110110000100100100110000100111001";
		-- -0.113237
		y <= "1111111111111111111111111111111111111111111111100011000000101110101100001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1186
		-- 197437.689734
		x <= "0000000000000000000000000011000000110011110110110000100100100110000100111001";
		-- 0.113237
		y <= "0000000000000000000000000000000000000000000000011100111111010001010011110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1187
		-- 197437.689734
		x <= "0000000000000000000000000011000000110011110110110000100100100110000100111001";
		-- 0.339710
		y <= "0000000000000000000000000000000000000000000001010110111101110011111011100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1188
		-- 197437.689734
		x <= "0000000000000000000000000011000000110011110110110000100100100110000100111001";
		-- 0.566184
		y <= "0000000000000000000000000000000000000000000010010000111100010110100011001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1189
		-- 197437.689734
		x <= "0000000000000000000000000011000000110011110110110000100100100110000100111001";
		-- 0.792657
		y <= "0000000000000000000000000000000000000000000011001010111010111001001010111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1190
		-- 197437.689734
		x <= "0000000000000000000000000011000000110011110110110000100100100110000100111001";
		-- 1.019131
		y <= "0000000000000000000000000000000000000000000100000100111001011011110010100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1191
		-- 199110.890494
		x <= "0000000000000000000000000011000010011100011011100011111101110110101000100111";
		-- -1.018426
		y <= "1111111111111111111111111111111111111111111011111011010010000111010011000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1192
		-- 199110.890494
		x <= "0000000000000000000000000011000010011100011011100011111101110110101000100111";
		-- -0.792109
		y <= "1111111111111111111111111111111111111111111100110101001110000101101011010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1193
		-- 199110.890494
		x <= "0000000000000000000000000011000010011100011011100011111101110110101000100111";
		-- -0.565792
		y <= "1111111111111111111111111111111111111111111101101111001010000100000011011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1194
		-- 199110.890494
		x <= "0000000000000000000000000011000010011100011011100011111101110110101000100111";
		-- -0.339475
		y <= "1111111111111111111111111111111111111111111110101001000110000010011011101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1195
		-- 199110.890494
		x <= "0000000000000000000000000011000010011100011011100011111101110110101000100111";
		-- -0.113158
		y <= "1111111111111111111111111111111111111111111111100011000010000000110011111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1196
		-- 199110.890494
		x <= "0000000000000000000000000011000010011100011011100011111101110110101000100111";
		-- 0.113158
		y <= "0000000000000000000000000000000000000000000000011100111101111111001100000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1197
		-- 199110.890494
		x <= "0000000000000000000000000011000010011100011011100011111101110110101000100111";
		-- 0.339475
		y <= "0000000000000000000000000000000000000000000001010110111001111101100100010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1198
		-- 199110.890494
		x <= "0000000000000000000000000011000010011100011011100011111101110110101000100111";
		-- 0.565792
		y <= "0000000000000000000000000000000000000000000010010000110101111011111100100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1199
		-- 199110.890494
		x <= "0000000000000000000000000011000010011100011011100011111101110110101000100111";
		-- 0.792109
		y <= "0000000000000000000000000000000000000000000011001010110001111010010100101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1200
		-- 199110.890494
		x <= "0000000000000000000000000011000010011100011011100011111101110110101000100111";
		-- 1.018426
		y <= "0000000000000000000000000000000000000000000100000100101101111000101100111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1201
		-- 200784.091254
		x <= "0000000000000000000000000011000100000101000000010111010111000111001100010101";
		-- -1.017728
		y <= "1111111111111111111111111111111111111111111011111011011101100011001100010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1202
		-- 200784.091254
		x <= "0000000000000000000000000011000100000101000000010111010111000111001100010101";
		-- -0.791566
		y <= "1111111111111111111111111111111111111111111100110101010110111110111011011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1203
		-- 200784.091254
		x <= "0000000000000000000000000011000100000101000000010111010111000111001100010101";
		-- -0.565404
		y <= "1111111111111111111111111111111111111111111101101111010000011010101010011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1204
		-- 200784.091254
		x <= "0000000000000000000000000011000100000101000000010111010111000111001100010101";
		-- -0.339243
		y <= "1111111111111111111111111111111111111111111110101001001001110110011001011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1205
		-- 200784.091254
		x <= "0000000000000000000000000011000100000101000000010111010111000111001100010101";
		-- -0.113081
		y <= "1111111111111111111111111111111111111111111111100011000011010010001000011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1206
		-- 200784.091254
		x <= "0000000000000000000000000011000100000101000000010111010111000111001100010101";
		-- 0.113081
		y <= "0000000000000000000000000000000000000000000000011100111100101101110111100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1207
		-- 200784.091254
		x <= "0000000000000000000000000011000100000101000000010111010111000111001100010101";
		-- 0.339243
		y <= "0000000000000000000000000000000000000000000001010110110110001001100110100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1208
		-- 200784.091254
		x <= "0000000000000000000000000011000100000101000000010111010111000111001100010101";
		-- 0.565404
		y <= "0000000000000000000000000000000000000000000010010000101111100101010101100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1209
		-- 200784.091254
		x <= "0000000000000000000000000011000100000101000000010111010111000111001100010101";
		-- 0.791566
		y <= "0000000000000000000000000000000000000000000011001010101001000001000100100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1210
		-- 200784.091254
		x <= "0000000000000000000000000011000100000101000000010111010111000111001100010101";
		-- 1.017728
		y <= "0000000000000000000000000000000000000000000100000100100010011100110011101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1211
		-- 202457.292015
		x <= "0000000000000000000000000011000101101101100101001010110000010111110000000100";
		-- -1.017036
		y <= "1111111111111111111111111111111111111111111011111011101000111000000001100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1212
		-- 202457.292015
		x <= "0000000000000000000000000011000101101101100101001010110000010111110000000100";
		-- -0.791028
		y <= "1111111111111111111111111111111111111111111100110101011111110010101011110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1213
		-- 202457.292015
		x <= "0000000000000000000000000011000101101101100101001010110000010111110000000100";
		-- -0.565020
		y <= "1111111111111111111111111111111111111111111101101111010110101101010110001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1214
		-- 202457.292015
		x <= "0000000000000000000000000011000101101101100101001010110000010111110000000100";
		-- -0.339012
		y <= "1111111111111111111111111111111111111111111110101001001101101000000000100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1215
		-- 202457.292015
		x <= "0000000000000000000000000011000101101101100101001010110000010111110000000100";
		-- -0.113004
		y <= "1111111111111111111111111111111111111111111111100011000100100010101010110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1216
		-- 202457.292015
		x <= "0000000000000000000000000011000101101101100101001010110000010111110000000100";
		-- 0.113004
		y <= "0000000000000000000000000000000000000000000000011100111011011101010101001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1217
		-- 202457.292015
		x <= "0000000000000000000000000011000101101101100101001010110000010111110000000100";
		-- 0.339012
		y <= "0000000000000000000000000000000000000000000001010110110010010111111111011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1218
		-- 202457.292015
		x <= "0000000000000000000000000011000101101101100101001010110000010111110000000100";
		-- 0.565020
		y <= "0000000000000000000000000000000000000000000010010000101001010010101001110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1219
		-- 202457.292015
		x <= "0000000000000000000000000011000101101101100101001010110000010111110000000100";
		-- 0.791028
		y <= "0000000000000000000000000000000000000000000011001010100000001101010100001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1220
		-- 202457.292015
		x <= "0000000000000000000000000011000101101101100101001010110000010111110000000100";
		-- 1.017036
		y <= "0000000000000000000000000000000000000000000100000100010111000111111110011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1221
		-- 204130.492775
		x <= "0000000000000000000000000011000111010110001001111110001001101000010011110010";
		-- -1.016352
		y <= "1111111111111111111111111111111111111111111011111011110100000101111010101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1222
		-- 204130.492775
		x <= "0000000000000000000000000011000111010110001001111110001001101000010011110010";
		-- -0.790496
		y <= "1111111111111111111111111111111111111111111100110101101000100001000011000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1223
		-- 204130.492775
		x <= "0000000000000000000000000011000111010110001001111110001001101000010011110010";
		-- -0.564640
		y <= "1111111111111111111111111111111111111111111101101111011100111100001011010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1224
		-- 204130.492775
		x <= "0000000000000000000000000011000111010110001001111110001001101000010011110010";
		-- -0.338784
		y <= "1111111111111111111111111111111111111111111110101001010001010111010011100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1225
		-- 204130.492775
		x <= "0000000000000000000000000011000111010110001001111110001001101000010011110010";
		-- -0.112928
		y <= "1111111111111111111111111111111111111111111111100011000101110010011011110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1226
		-- 204130.492775
		x <= "0000000000000000000000000011000111010110001001111110001001101000010011110010";
		-- 0.112928
		y <= "0000000000000000000000000000000000000000000000011100111010001101100100001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1227
		-- 204130.492775
		x <= "0000000000000000000000000011000111010110001001111110001001101000010011110010";
		-- 0.338784
		y <= "0000000000000000000000000000000000000000000001010110101110101000101100011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1228
		-- 204130.492775
		x <= "0000000000000000000000000011000111010110001001111110001001101000010011110010";
		-- 0.564640
		y <= "0000000000000000000000000000000000000000000010010000100011000011110100101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1229
		-- 204130.492775
		x <= "0000000000000000000000000011000111010110001001111110001001101000010011110010";
		-- 0.790496
		y <= "0000000000000000000000000000000000000000000011001010010111011110111100111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1230
		-- 204130.492775
		x <= "0000000000000000000000000011000111010110001001111110001001101000010011110010";
		-- 1.016352
		y <= "0000000000000000000000000000000000000000000100000100001011111010000101010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1231
		-- 205803.693536
		x <= "0000000000000000000000000011001000111110101110110001100010111000110111100001";
		-- -1.015674
		y <= "1111111111111111111111111111111111111111111011111011111111001100111111110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1232
		-- 205803.693536
		x <= "0000000000000000000000000011001000111110101110110001100010111000110111100001";
		-- -0.789968
		y <= "1111111111111111111111111111111111111111111100110101110001001010000110111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1233
		-- 205803.693536
		x <= "0000000000000000000000000011001000111110101110110001100010111000110111100001";
		-- -0.564263
		y <= "1111111111111111111111111111111111111111111101101111100011000111001110000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1234
		-- 205803.693536
		x <= "0000000000000000000000000011001000111110101110110001100010111000110111100001";
		-- -0.338558
		y <= "1111111111111111111111111111111111111111111110101001010101000100010101010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1235
		-- 205803.693536
		x <= "0000000000000000000000000011001000111110101110110001100010111000110111100001";
		-- -0.112853
		y <= "1111111111111111111111111111111111111111111111100011000111000001011100011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1236
		-- 205803.693536
		x <= "0000000000000000000000000011001000111110101110110001100010111000110111100001";
		-- 0.112853
		y <= "0000000000000000000000000000000000000000000000011100111000111110100011100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1237
		-- 205803.693536
		x <= "0000000000000000000000000011001000111110101110110001100010111000110111100001";
		-- 0.338558
		y <= "0000000000000000000000000000000000000000000001010110101010111011101010101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1238
		-- 205803.693536
		x <= "0000000000000000000000000011001000111110101110110001100010111000110111100001";
		-- 0.564263
		y <= "0000000000000000000000000000000000000000000010010000011100111000110001111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1239
		-- 205803.693536
		x <= "0000000000000000000000000011001000111110101110110001100010111000110111100001";
		-- 0.789968
		y <= "0000000000000000000000000000000000000000000011001010001110110101111001000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1240
		-- 205803.693536
		x <= "0000000000000000000000000011001000111110101110110001100010111000110111100001";
		-- 1.015674
		y <= "0000000000000000000000000000000000000000000100000100000000110011000000001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1241
		-- 207476.894296
		x <= "0000000000000000000000000011001010100111010011100100111100001001011011001111";
		-- -1.015002
		y <= "1111111111111111111111111111111111111111111011111100001010001101011000010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1242
		-- 207476.894296
		x <= "0000000000000000000000000011001010100111010011100100111100001001011011001111";
		-- -0.789446
		y <= "1111111111111111111111111111111111111111111100110101111001101101111101100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1243
		-- 207476.894296
		x <= "0000000000000000000000000011001010100111010011100100111100001001011011001111";
		-- -0.563890
		y <= "1111111111111111111111111111111111111111111101101111101001001110100010110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1244
		-- 207476.894296
		x <= "0000000000000000000000000011001010100111010011100100111100001001011011001111";
		-- -0.338334
		y <= "1111111111111111111111111111111111111111111110101001011000101111001000000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1245
		-- 207476.894296
		x <= "0000000000000000000000000011001010100111010011100100111100001001011011001111";
		-- -0.112778
		y <= "1111111111111111111111111111111111111111111111100011001000001111101101010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1246
		-- 207476.894296
		x <= "0000000000000000000000000011001010100111010011100100111100001001011011001111";
		-- 0.112778
		y <= "0000000000000000000000000000000000000000000000011100110111110000010010101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1247
		-- 207476.894296
		x <= "0000000000000000000000000011001010100111010011100100111100001001011011001111";
		-- 0.338334
		y <= "0000000000000000000000000000000000000000000001010110100111010000110111111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1248
		-- 207476.894296
		x <= "0000000000000000000000000011001010100111010011100100111100001001011011001111";
		-- 0.563890
		y <= "0000000000000000000000000000000000000000000010010000010110110001011101001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1249
		-- 207476.894296
		x <= "0000000000000000000000000011001010100111010011100100111100001001011011001111";
		-- 0.789446
		y <= "0000000000000000000000000000000000000000000011001010000110010010000010011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1250
		-- 207476.894296
		x <= "0000000000000000000000000011001010100111010011100100111100001001011011001111";
		-- 1.015002
		y <= "0000000000000000000000000000000000000000000100000011110101110010100111101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1251
		-- 209150.095057
		x <= "0000000000000000000000000011001100001111111000011000010101011001111110111110";
		-- -1.014336
		y <= "1111111111111111111111111111111111111111111011111100010101000111001011111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1252
		-- 209150.095057
		x <= "0000000000000000000000000011001100001111111000011000010101011001111110111110";
		-- -0.788928
		y <= "1111111111111111111111111111111111111111111100110110000010001100101100110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1253
		-- 209150.095057
		x <= "0000000000000000000000000011001100001111111000011000010101011001111110111110";
		-- -0.563520
		y <= "1111111111111111111111111111111111111111111101101111101111010010001101110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1254
		-- 209150.095057
		x <= "0000000000000000000000000011001100001111111000011000010101011001111110111110";
		-- -0.338112
		y <= "1111111111111111111111111111111111111111111110101001011100010111101110101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1255
		-- 209150.095057
		x <= "0000000000000000000000000011001100001111111000011000010101011001111110111110";
		-- -0.112704
		y <= "1111111111111111111111111111111111111111111111100011001001011101001111100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1256
		-- 209150.095057
		x <= "0000000000000000000000000011001100001111111000011000010101011001111110111110";
		-- 0.112704
		y <= "0000000000000000000000000000000000000000000000011100110110100010110000011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1257
		-- 209150.095057
		x <= "0000000000000000000000000011001100001111111000011000010101011001111110111110";
		-- 0.338112
		y <= "0000000000000000000000000000000000000000000001010110100011101000010001010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1258
		-- 209150.095057
		x <= "0000000000000000000000000011001100001111111000011000010101011001111110111110";
		-- 0.563520
		y <= "0000000000000000000000000000000000000000000010010000010000101101110010001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1259
		-- 209150.095057
		x <= "0000000000000000000000000011001100001111111000011000010101011001111110111110";
		-- 0.788928
		y <= "0000000000000000000000000000000000000000000011001001111101110011010011001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1260
		-- 209150.095057
		x <= "0000000000000000000000000011001100001111111000011000010101011001111110111110";
		-- 1.014336
		y <= "0000000000000000000000000000000000000000000100000011101010111000110100000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1261
		-- 210823.295817
		x <= "0000000000000000000000000011001101111000011101001011101110101010100010101100";
		-- -1.013677
		y <= "1111111111111111111111111111111111111111111011111100011111111010100001111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1262
		-- 210823.295817
		x <= "0000000000000000000000000011001101111000011101001011101110101010100010101100";
		-- -0.788416
		y <= "1111111111111111111111111111111111111111111100110110001010100110011010010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1263
		-- 210823.295817
		x <= "0000000000000000000000000011001101111000011101001011101110101010100010101100";
		-- -0.563154
		y <= "1111111111111111111111111111111111111111111101101111110101010010010010110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1264
		-- 210823.295817
		x <= "0000000000000000000000000011001101111000011101001011101110101010100010101100";
		-- -0.337892
		y <= "1111111111111111111111111111111111111111111110101001011111111110001011010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1265
		-- 210823.295817
		x <= "0000000000000000000000000011001101111000011101001011101110101010100010101100";
		-- -0.112631
		y <= "1111111111111111111111111111111111111111111111100011001010101010000011110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1266
		-- 210823.295817
		x <= "0000000000000000000000000011001101111000011101001011101110101010100010101100";
		-- 0.112631
		y <= "0000000000000000000000000000000000000000000000011100110101010101111100001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1267
		-- 210823.295817
		x <= "0000000000000000000000000011001101111000011101001011101110101010100010101100";
		-- 0.337892
		y <= "0000000000000000000000000000000000000000000001010110100000000001110100101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1268
		-- 210823.295817
		x <= "0000000000000000000000000011001101111000011101001011101110101010100010101100";
		-- 0.563154
		y <= "0000000000000000000000000000000000000000000010010000001010101101101101001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1269
		-- 210823.295817
		x <= "0000000000000000000000000011001101111000011101001011101110101010100010101100";
		-- 0.788416
		y <= "0000000000000000000000000000000000000000000011001001110101011001100101101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1270
		-- 210823.295817
		x <= "0000000000000000000000000011001101111000011101001011101110101010100010101100";
		-- 1.013677
		y <= "0000000000000000000000000000000000000000000100000011100000000101011110000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1271
		-- 212496.496577
		x <= "0000000000000000000000000011001111100001000001111111000111111011000110011011";
		-- -1.013024
		y <= "1111111111111111111111111111111111111111111011111100101010100111100001010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1272
		-- 212496.496577
		x <= "0000000000000000000000000011001111100001000001111111000111111011000110011011";
		-- -0.787907
		y <= "1111111111111111111111111111111111111111111100110110010010111011001011101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1273
		-- 212496.496577
		x <= "0000000000000000000000000011001111100001000001111111000111111011000110011011";
		-- -0.562791
		y <= "1111111111111111111111111111111111111111111101101111111011001110110110000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1274
		-- 212496.496577
		x <= "0000000000000000000000000011001111100001000001111111000111111011000110011011";
		-- -0.337675
		y <= "1111111111111111111111111111111111111111111110101001100011100010100000011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1275
		-- 212496.496577
		x <= "0000000000000000000000000011001111100001000001111111000111111011000110011011";
		-- -0.112558
		y <= "1111111111111111111111111111111111111111111111100011001011110110001010110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1276
		-- 212496.496577
		x <= "0000000000000000000000000011001111100001000001111111000111111011000110011011";
		-- 0.112558
		y <= "0000000000000000000000000000000000000000000000011100110100001001110101001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1277
		-- 212496.496577
		x <= "0000000000000000000000000011001111100001000001111111000111111011000110011011";
		-- 0.337675
		y <= "0000000000000000000000000000000000000000000001010110011100011101011111100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1278
		-- 212496.496577
		x <= "0000000000000000000000000011001111100001000001111111000111111011000110011011";
		-- 0.562791
		y <= "0000000000000000000000000000000000000000000010010000000100110001001001111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1279
		-- 212496.496577
		x <= "0000000000000000000000000011001111100001000001111111000111111011000110011011";
		-- 0.787907
		y <= "0000000000000000000000000000000000000000000011001001101101000100110100010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1280
		-- 212496.496577
		x <= "0000000000000000000000000011001111100001000001111111000111111011000110011011";
		-- 1.013024
		y <= "0000000000000000000000000000000000000000000100000011010101011000011110101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1281
		-- 214169.697338
		x <= "0000000000000000000000000011010001001001100110110010100001001011101010001001";
		-- -1.012377
		y <= "1111111111111111111111111111111111111111111011111100110101001110010000111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1282
		-- 214169.697338
		x <= "0000000000000000000000000011010001001001100110110010100001001011101010001001";
		-- -0.787404
		y <= "1111111111111111111111111111111111111111111100110110011011001011000110000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1283
		-- 214169.697338
		x <= "0000000000000000000000000011010001001001100110110010100001001011101010001001";
		-- -0.562431
		y <= "1111111111111111111111111111111111111111111101110000000001000111111011001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1284
		-- 214169.697338
		x <= "0000000000000000000000000011010001001001100110110010100001001011101010001001";
		-- -0.337459
		y <= "1111111111111111111111111111111111111111111110101001100111000100110000010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1285
		-- 214169.697338
		x <= "0000000000000000000000000011010001001001100110110010100001001011101010001001";
		-- -0.112486
		y <= "1111111111111111111111111111111111111111111111100011001101000001100101011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1286
		-- 214169.697338
		x <= "0000000000000000000000000011010001001001100110110010100001001011101010001001";
		-- 0.112486
		y <= "0000000000000000000000000000000000000000000000011100110010111110011010100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1287
		-- 214169.697338
		x <= "0000000000000000000000000011010001001001100110110010100001001011101010001001";
		-- 0.337459
		y <= "0000000000000000000000000000000000000000000001010110011000111011001111101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1288
		-- 214169.697338
		x <= "0000000000000000000000000011010001001001100110110010100001001011101010001001";
		-- 0.562431
		y <= "0000000000000000000000000000000000000000000010001111111110111000000100110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1289
		-- 214169.697338
		x <= "0000000000000000000000000011010001001001100110110010100001001011101010001001";
		-- 0.787404
		y <= "0000000000000000000000000000000000000000000011001001100100110100111001111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1290
		-- 214169.697338
		x <= "0000000000000000000000000011010001001001100110110010100001001011101010001001";
		-- 1.012377
		y <= "0000000000000000000000000000000000000000000100000011001010110001101111000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1291
		-- 215842.898098
		x <= "0000000000000000000000000011010010110010001011100101111010011100001101111000";
		-- -1.011735
		y <= "1111111111111111111111111111111111111111111011111100111111101110110111110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1292
		-- 215842.898098
		x <= "0000000000000000000000000011010010110010001011100101111010011100001101111000";
		-- -0.786905
		y <= "1111111111111111111111111111111111111111111100110110100011010110001110111101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1293
		-- 215842.898098
		x <= "0000000000000000000000000011010010110010001011100101111010011100001101111000";
		-- -0.562075
		y <= "1111111111111111111111111111111111111111111101110000000110111101100110000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1294
		-- 215842.898098
		x <= "0000000000000000000000000011010010110010001011100101111010011100001101111000";
		-- -0.337245
		y <= "1111111111111111111111111111111111111111111110101001101010100100111101010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1295
		-- 215842.898098
		x <= "0000000000000000000000000011010010110010001011100101111010011100001101111000";
		-- -0.112415
		y <= "1111111111111111111111111111111111111111111111100011001110001100010100011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1296
		-- 215842.898098
		x <= "0000000000000000000000000011010010110010001011100101111010011100001101111000";
		-- 0.112415
		y <= "0000000000000000000000000000000000000000000000011100110001110011101011100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1297
		-- 215842.898098
		x <= "0000000000000000000000000011010010110010001011100101111010011100001101111000";
		-- 0.337245
		y <= "0000000000000000000000000000000000000000000001010110010101011011000010101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1298
		-- 215842.898098
		x <= "0000000000000000000000000011010010110010001011100101111010011100001101111000";
		-- 0.562075
		y <= "0000000000000000000000000000000000000000000010001111111001000010011001111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1299
		-- 215842.898098
		x <= "0000000000000000000000000011010010110010001011100101111010011100001101111000";
		-- 0.786905
		y <= "0000000000000000000000000000000000000000000011001001011100101001110001000010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1300
		-- 215842.898098
		x <= "0000000000000000000000000011010010110010001011100101111010011100001101111000";
		-- 1.011735
		y <= "0000000000000000000000000000000000000000000100000011000000010001001000001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1301
		-- 217516.098859
		x <= "0000000000000000000000000011010100011010110000011001010011101100110001100110";
		-- -1.011099
		y <= "1111111111111111111111111111111111111111111011111101001010001001011100010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1302
		-- 217516.098859
		x <= "0000000000000000000000000011010100011010110000011001010011101100110001100110";
		-- -0.786411
		y <= "1111111111111111111111111111111111111111111100110110101011011100101011010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1303
		-- 217516.098859
		x <= "0000000000000000000000000011010100011010110000011001010011101100110001100110";
		-- -0.561722
		y <= "1111111111111111111111111111111111111111111101110000001100101111111010011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1304
		-- 217516.098859
		x <= "0000000000000000000000000011010100011010110000011001010011101100110001100110";
		-- -0.337033
		y <= "1111111111111111111111111111111111111111111110101001101110000011001001011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1305
		-- 217516.098859
		x <= "0000000000000000000000000011010100011010110000011001010011101100110001100110";
		-- -0.112344
		y <= "1111111111111111111111111111111111111111111111100011001111010110011000011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1306
		-- 217516.098859
		x <= "0000000000000000000000000011010100011010110000011001010011101100110001100110";
		-- 0.112344
		y <= "0000000000000000000000000000000000000000000000011100110000101001100111100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1307
		-- 217516.098859
		x <= "0000000000000000000000000011010100011010110000011001010011101100110001100110";
		-- 0.337033
		y <= "0000000000000000000000000000000000000000000001010110010001111100110110100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1308
		-- 217516.098859
		x <= "0000000000000000000000000011010100011010110000011001010011101100110001100110";
		-- 0.561722
		y <= "0000000000000000000000000000000000000000000010001111110011010000000101100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1309
		-- 217516.098859
		x <= "0000000000000000000000000011010100011010110000011001010011101100110001100110";
		-- 0.786411
		y <= "0000000000000000000000000000000000000000000011001001010100100011010100101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1310
		-- 217516.098859
		x <= "0000000000000000000000000011010100011010110000011001010011101100110001100110";
		-- 1.011099
		y <= "0000000000000000000000000000000000000000000100000010110101110110100011101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1311
		-- 219189.299619
		x <= "0000000000000000000000000011010110000011010101001100101100111101010101010101";
		-- -1.010469
		y <= "1111111111111111111111111111111111111111111011111101010100011110000100111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1312
		-- 219189.299619
		x <= "0000000000000000000000000011010110000011010101001100101100111101010101010101";
		-- -0.785921
		y <= "1111111111111111111111111111111111111111111100110110110011011110100000010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1313
		-- 219189.299619
		x <= "0000000000000000000000000011010110000011010101001100101100111101010101010101";
		-- -0.561372
		y <= "1111111111111111111111111111111111111111111101110000010010011110111011101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1314
		-- 219189.299619
		x <= "0000000000000000000000000011010110000011010101001100101100111101010101010101";
		-- -0.336823
		y <= "1111111111111111111111111111111111111111111110101001110001011111010110111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1315
		-- 219189.299619
		x <= "0000000000000000000000000011010110000011010101001100101100111101010101010101";
		-- -0.112274
		y <= "1111111111111111111111111111111111111111111111100011010000011111110010010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1316
		-- 219189.299619
		x <= "0000000000000000000000000011010110000011010101001100101100111101010101010101";
		-- 0.112274
		y <= "0000000000000000000000000000000000000000000000011100101111100000001101101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1317
		-- 219189.299619
		x <= "0000000000000000000000000011010110000011010101001100101100111101010101010101";
		-- 0.336823
		y <= "0000000000000000000000000000000000000000000001010110001110100000101001000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1318
		-- 219189.299619
		x <= "0000000000000000000000000011010110000011010101001100101100111101010101010101";
		-- 0.561372
		y <= "0000000000000000000000000000000000000000000010001111101101100001000100010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1319
		-- 219189.299619
		x <= "0000000000000000000000000011010110000011010101001100101100111101010101010101";
		-- 0.785921
		y <= "0000000000000000000000000000000000000000000011001001001100100001011111101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1320
		-- 219189.299619
		x <= "0000000000000000000000000011010110000011010101001100101100111101010101010101";
		-- 1.010469
		y <= "0000000000000000000000000000000000000000000100000010101011100001111011000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1321
		-- 220862.500379
		x <= "0000000000000000000000000011010111101011111010000000000110001101111001000011";
		-- -1.009845
		y <= "1111111111111111111111111111111111111111111011111101011110101100111000000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1322
		-- 220862.500379
		x <= "0000000000000000000000000011010111101011111010000000000110001101111001000011";
		-- -0.785435
		y <= "1111111111111111111111111111111111111111111100110110111011011011110010101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1323
		-- 220862.500379
		x <= "0000000000000000000000000011010111101011111010000000000110001101111001000011";
		-- -0.561025
		y <= "1111111111111111111111111111111111111111111101110000011000001010101101010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1324
		-- 220862.500379
		x <= "0000000000000000000000000011010111101011111010000000000110001101111001000011";
		-- -0.336615
		y <= "1111111111111111111111111111111111111111111110101001110100111001101000000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1325
		-- 220862.500379
		x <= "0000000000000000000000000011010111101011111010000000000110001101111001000011";
		-- -0.112205
		y <= "1111111111111111111111111111111111111111111111100011010001101000100010101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1326
		-- 220862.500379
		x <= "0000000000000000000000000011010111101011111010000000000110001101111001000011";
		-- 0.112205
		y <= "0000000000000000000000000000000000000000000000011100101110010111011101010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1327
		-- 220862.500379
		x <= "0000000000000000000000000011010111101011111010000000000110001101111001000011";
		-- 0.336615
		y <= "0000000000000000000000000000000000000000000001010110001011000110010111111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1328
		-- 220862.500379
		x <= "0000000000000000000000000011010111101011111010000000000110001101111001000011";
		-- 0.561025
		y <= "0000000000000000000000000000000000000000000010001111100111110101010010101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1329
		-- 220862.500379
		x <= "0000000000000000000000000011010111101011111010000000000110001101111001000011";
		-- 0.785435
		y <= "0000000000000000000000000000000000000000000011001001000100100100001101010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1330
		-- 220862.500379
		x <= "0000000000000000000000000011010111101011111010000000000110001101111001000011";
		-- 1.009845
		y <= "0000000000000000000000000000000000000000000100000010100001010011000111111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1331
		-- 222535.701140
		x <= "0000000000000000000000000011011001010100011110110011011111011110011100110010";
		-- -1.009226
		y <= "1111111111111111111111111111111111111111111011111101101000110101111011101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1332
		-- 222535.701140
		x <= "0000000000000000000000000011011001010100011110110011011111011110011100110010";
		-- -0.784953
		y <= "1111111111111111111111111111111111111111111100110111000011010100100111010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1333
		-- 222535.701140
		x <= "0000000000000000000000000011011001010100011110110011011111011110011100110010";
		-- -0.560681
		y <= "1111111111111111111111111111111111111111111101110000011101110011010010111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1334
		-- 222535.701140
		x <= "0000000000000000000000000011011001010100011110110011011111011110011100110010";
		-- -0.336409
		y <= "1111111111111111111111111111111111111111111110101001111000010001111110100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1335
		-- 222535.701140
		x <= "0000000000000000000000000011011001010100011110110011011111011110011100110010";
		-- -0.112136
		y <= "1111111111111111111111111111111111111111111111100011010010110000101010001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1336
		-- 222535.701140
		x <= "0000000000000000000000000011011001010100011110110011011111011110011100110010";
		-- 0.112136
		y <= "0000000000000000000000000000000000000000000000011100101101001111010101110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1337
		-- 222535.701140
		x <= "0000000000000000000000000011011001010100011110110011011111011110011100110010";
		-- 0.336409
		y <= "0000000000000000000000000000000000000000000001010110000111101110000001011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1338
		-- 222535.701140
		x <= "0000000000000000000000000011011001010100011110110011011111011110011100110010";
		-- 0.560681
		y <= "0000000000000000000000000000000000000000000010001111100010001100101101000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1339
		-- 222535.701140
		x <= "0000000000000000000000000011011001010100011110110011011111011110011100110010";
		-- 0.784953
		y <= "0000000000000000000000000000000000000000000011001000111100101011011000101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1340
		-- 222535.701140
		x <= "0000000000000000000000000011011001010100011110110011011111011110011100110010";
		-- 1.009226
		y <= "0000000000000000000000000000000000000000000100000010010111001010000100010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1341
		-- 224208.901900
		x <= "0000000000000000000000000011011010111101000011100110111000101111000000100000";
		-- -1.008612
		y <= "1111111111111111111111111111111111111111111011111101110010111001010101110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1342
		-- 224208.901900
		x <= "0000000000000000000000000011011010111101000011100110111000101111000000100000";
		-- -0.784476
		y <= "1111111111111111111111111111111111111111111100110111001011001001000010101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1343
		-- 224208.901900
		x <= "0000000000000000000000000011011010111101000011100110111000101111000000100000";
		-- -0.560340
		y <= "1111111111111111111111111111111111111111111101110000100011011000101111101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1344
		-- 224208.901900
		x <= "0000000000000000000000000011011010111101000011100110111000101111000000100000";
		-- -0.336204
		y <= "1111111111111111111111111111111111111111111110101001111011101000011100100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1345
		-- 224208.901900
		x <= "0000000000000000000000000011011010111101000011100110111000101111000000100000";
		-- -0.112068
		y <= "1111111111111111111111111111111111111111111111100011010011111000001001100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1346
		-- 224208.901900
		x <= "0000000000000000000000000011011010111101000011100110111000101111000000100000";
		-- 0.112068
		y <= "0000000000000000000000000000000000000000000000011100101100000111110110011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1347
		-- 224208.901900
		x <= "0000000000000000000000000011011010111101000011100110111000101111000000100000";
		-- 0.336204
		y <= "0000000000000000000000000000000000000000000001010110000100010111100011011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1348
		-- 224208.901900
		x <= "0000000000000000000000000011011010111101000011100110111000101111000000100000";
		-- 0.560340
		y <= "0000000000000000000000000000000000000000000010001111011100100111010000010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1349
		-- 224208.901900
		x <= "0000000000000000000000000011011010111101000011100110111000101111000000100000";
		-- 0.784476
		y <= "0000000000000000000000000000000000000000000011001000110100110110111101010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1350
		-- 224208.901900
		x <= "0000000000000000000000000011011010111101000011100110111000101111000000100000";
		-- 1.008612
		y <= "0000000000000000000000000000000000000000000100000010001101000110101010001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1351
		-- 225882.102661
		x <= "0000000000000000000000000011011100100101101000011010010001111111100100001111";
		-- -1.008004
		y <= "1111111111111111111111111111111111111111111011111101111100110111001100010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1352
		-- 225882.102661
		x <= "0000000000000000000000000011011100100101101000011010010001111111100100001111";
		-- -0.784003
		y <= "1111111111111111111111111111111111111111111100110111010010111001001001100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1353
		-- 225882.102661
		x <= "0000000000000000000000000011011100100101101000011010010001111111100100001111";
		-- -0.560002
		y <= "1111111111111111111111111111111111111111111101110000101000111011000110110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1354
		-- 225882.102661
		x <= "0000000000000000000000000011011100100101101000011010010001111111100100001111";
		-- -0.336001
		y <= "1111111111111111111111111111111111111111111110101001111110111101000100000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1355
		-- 225882.102661
		x <= "0000000000000000000000000011011100100101101000011010010001111111100100001111";
		-- -0.112000
		y <= "1111111111111111111111111111111111111111111111100011010100111111000001010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1356
		-- 225882.102661
		x <= "0000000000000000000000000011011100100101101000011010010001111111100100001111";
		-- 0.112000
		y <= "0000000000000000000000000000000000000000000000011100101011000000111110101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1357
		-- 225882.102661
		x <= "0000000000000000000000000011011100100101101000011010010001111111100100001111";
		-- 0.336001
		y <= "0000000000000000000000000000000000000000000001010110000001000010111011111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1358
		-- 225882.102661
		x <= "0000000000000000000000000011011100100101101000011010010001111111100100001111";
		-- 0.560002
		y <= "0000000000000000000000000000000000000000000010001111010111000100111001001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1359
		-- 225882.102661
		x <= "0000000000000000000000000011011100100101101000011010010001111111100100001111";
		-- 0.784003
		y <= "0000000000000000000000000000000000000000000011001000101101000110110110011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1360
		-- 225882.102661
		x <= "0000000000000000000000000011011100100101101000011010010001111111100100001111";
		-- 1.008004
		y <= "0000000000000000000000000000000000000000000100000010000011001000110011101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1361
		-- 227555.303421
		x <= "0000000000000000000000000011011110001110001101001101101011010000000111111101";
		-- -1.007401
		y <= "1111111111111111111111111111111111111111111011111110000110101111100100110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1362
		-- 227555.303421
		x <= "0000000000000000000000000011011110001110001101001101101011010000000111111101";
		-- -0.783534
		y <= "1111111111111111111111111111111111111111111100110111011010100101000000001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1363
		-- 227555.303421
		x <= "0000000000000000000000000011011110001110001101001101101011010000000111111101";
		-- -0.559667
		y <= "1111111111111111111111111111111111111111111101110000101110011010011011100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1364
		-- 227555.303421
		x <= "0000000000000000000000000011011110001110001101001101101011010000000111111101";
		-- -0.335800
		y <= "1111111111111111111111111111111111111111111110101010000010001111110110111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1365
		-- 227555.303421
		x <= "0000000000000000000000000011011110001110001101001101101011010000000111111101";
		-- -0.111933
		y <= "1111111111111111111111111111111111111111111111100011010110000101010010010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1366
		-- 227555.303421
		x <= "0000000000000000000000000011011110001110001101001101101011010000000111111101";
		-- 0.111933
		y <= "0000000000000000000000000000000000000000000000011100101001111010101101101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1367
		-- 227555.303421
		x <= "0000000000000000000000000011011110001110001101001101101011010000000111111101";
		-- 0.335800
		y <= "0000000000000000000000000000000000000000000001010101111101110000001001000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1368
		-- 227555.303421
		x <= "0000000000000000000000000011011110001110001101001101101011010000000111111101";
		-- 0.559667
		y <= "0000000000000000000000000000000000000000000010001111010001100101100100011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1369
		-- 227555.303421
		x <= "0000000000000000000000000011011110001110001101001101101011010000000111111101";
		-- 0.783534
		y <= "0000000000000000000000000000000000000000000011001000100101011010111111110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1370
		-- 227555.303421
		x <= "0000000000000000000000000011011110001110001101001101101011010000000111111101";
		-- 1.007401
		y <= "0000000000000000000000000000000000000000000100000001111001010000011011001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1371
		-- 229228.504182
		x <= "0000000000000000000000000011011111110110110010000001000100100000101011101100";
		-- -1.006803
		y <= "1111111111111111111111111111111111111111111011111110010000100010100100111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1372
		-- 229228.504182
		x <= "0000000000000000000000000011011111110110110010000001000100100000101011101100";
		-- -0.783069
		y <= "1111111111111111111111111111111111111111111100110111100010001100101010111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1373
		-- 229228.504182
		x <= "0000000000000000000000000011011111110110110010000001000100100000101011101100";
		-- -0.559335
		y <= "1111111111111111111111111111111111111111111101110000110011110110110000111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1374
		-- 229228.504182
		x <= "0000000000000000000000000011011111110110110010000001000100100000101011101100";
		-- -0.335601
		y <= "1111111111111111111111111111111111111111111110101010000101100000110110111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1375
		-- 229228.504182
		x <= "0000000000000000000000000011011111110110110010000001000100100000101011101100";
		-- -0.111867
		y <= "1111111111111111111111111111111111111111111111100011010111001010111100111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1376
		-- 229228.504182
		x <= "0000000000000000000000000011011111110110110010000001000100100000101011101100";
		-- 0.111867
		y <= "0000000000000000000000000000000000000000000000011100101000110101000011000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1377
		-- 229228.504182
		x <= "0000000000000000000000000011011111110110110010000001000100100000101011101100";
		-- 0.335601
		y <= "0000000000000000000000000000000000000000000001010101111010011111001001000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1378
		-- 229228.504182
		x <= "0000000000000000000000000011011111110110110010000001000100100000101011101100";
		-- 0.559335
		y <= "0000000000000000000000000000000000000000000010001111001100001001001111000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1379
		-- 229228.504182
		x <= "0000000000000000000000000011011111110110110010000001000100100000101011101100";
		-- 0.783069
		y <= "0000000000000000000000000000000000000000000011001000011101110011010101000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1380
		-- 229228.504182
		x <= "0000000000000000000000000011011111110110110010000001000100100000101011101100";
		-- 1.006803
		y <= "0000000000000000000000000000000000000000000100000001101111011101011011000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1381
		-- 230901.704942
		x <= "0000000000000000000000000011100001011111010110110100011101110001001111011010";
		-- -1.006210
		y <= "1111111111111111111111111111111111111111111011111110011010010000010010001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1382
		-- 230901.704942
		x <= "0000000000000000000000000011100001011111010110110100011101110001001111011010";
		-- -0.782608
		y <= "1111111111111111111111111111111111111111111100110111101001110000001110001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1383
		-- 230901.704942
		x <= "0000000000000000000000000011100001011111010110110100011101110001001111011010";
		-- -0.559006
		y <= "1111111111111111111111111111111111111111111101110000111001010000001010000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1384
		-- 230901.704942
		x <= "0000000000000000000000000011100001011111010110110100011101110001001111011010";
		-- -0.335403
		y <= "1111111111111111111111111111111111111111111110101010001000110000000110000100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1385
		-- 230901.704942
		x <= "0000000000000000000000000011100001011111010110110100011101110001001111011010";
		-- -0.111801
		y <= "1111111111111111111111111111111111111111111111100011011000010000000010000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1386
		-- 230901.704942
		x <= "0000000000000000000000000011100001011111010110110100011101110001001111011010";
		-- 0.111801
		y <= "0000000000000000000000000000000000000000000000011100100111101111111101111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1387
		-- 230901.704942
		x <= "0000000000000000000000000011100001011111010110110100011101110001001111011010";
		-- 0.335403
		y <= "0000000000000000000000000000000000000000000001010101110111001111111001111011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1388
		-- 230901.704942
		x <= "0000000000000000000000000011100001011111010110110100011101110001001111011010";
		-- 0.559006
		y <= "0000000000000000000000000000000000000000000010001111000110101111110101111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1389
		-- 230901.704942
		x <= "0000000000000000000000000011100001011111010110110100011101110001001111011010";
		-- 0.782608
		y <= "0000000000000000000000000000000000000000000011001000010110001111110001110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1390
		-- 230901.704942
		x <= "0000000000000000000000000011100001011111010110110100011101110001001111011010";
		-- 1.006210
		y <= "0000000000000000000000000000000000000000000100000001100101101111101101110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1391
		-- 232574.905702
		x <= "0000000000000000000000000011100011000111111011100111110111000001110011001001";
		-- -1.005622
		y <= "1111111111111111111111111111111111111111111011111110100011111000110001110100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1392
		-- 232574.905702
		x <= "0000000000000000000000000011100011000111111011100111110111000001110011001001";
		-- -0.782151
		y <= "1111111111111111111111111111111111111111111100110111110001001111101101110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1393
		-- 232574.905702
		x <= "0000000000000000000000000011100011000111111011100111110111000001110011001001";
		-- -0.558679
		y <= "1111111111111111111111111111111111111111111101110000111110100110101001111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1394
		-- 232574.905702
		x <= "0000000000000000000000000011100011000111111011100111110111000001110011001001";
		-- -0.335207
		y <= "1111111111111111111111111111111111111111111110101010001011111101100101111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1395
		-- 232574.905702
		x <= "0000000000000000000000000011100011000111111011100111110111000001110011001001";
		-- -0.111736
		y <= "1111111111111111111111111111111111111111111111100011011001010100100001111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1396
		-- 232574.905702
		x <= "0000000000000000000000000011100011000111111011100111110111000001110011001001";
		-- 0.111736
		y <= "0000000000000000000000000000000000000000000000011100100110101011011110000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1397
		-- 232574.905702
		x <= "0000000000000000000000000011100011000111111011100111110111000001110011001001";
		-- 0.335207
		y <= "0000000000000000000000000000000000000000000001010101110100000010011010000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1398
		-- 232574.905702
		x <= "0000000000000000000000000011100011000111111011100111110111000001110011001001";
		-- 0.558679
		y <= "0000000000000000000000000000000000000000000010001111000001011001010110000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1399
		-- 232574.905702
		x <= "0000000000000000000000000011100011000111111011100111110111000001110011001001";
		-- 0.782151
		y <= "0000000000000000000000000000000000000000000011001000001110110000010010001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1400
		-- 232574.905702
		x <= "0000000000000000000000000011100011000111111011100111110111000001110011001001";
		-- 1.005622
		y <= "0000000000000000000000000000000000000000000100000001011100000111001110001011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1401
		-- 234248.106463
		x <= "0000000000000000000000000011100100110000100000011011010000010010010110110111";
		-- -1.005039
		y <= "1111111111111111111111111111111111111111111011111110101101011100001000111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1402
		-- 234248.106463
		x <= "0000000000000000000000000011100100110000100000011011010000010010010110110111";
		-- -0.781697
		y <= "1111111111111111111111111111111111111111111100110111111000101011001110000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1403
		-- 234248.106463
		x <= "0000000000000000000000000011100100110000100000011011010000010010010110110111";
		-- -0.558355
		y <= "1111111111111111111111111111111111111111111101110001000011111010010011001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1404
		-- 234248.106463
		x <= "0000000000000000000000000011100100110000100000011011010000010010010110110111";
		-- -0.335013
		y <= "1111111111111111111111111111111111111111111110101010001111001001011000010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1405
		-- 234248.106463
		x <= "0000000000000000000000000011100100110000100000011011010000010010010110110111";
		-- -0.111671
		y <= "1111111111111111111111111111111111111111111111100011011010011000011101011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1406
		-- 234248.106463
		x <= "0000000000000000000000000011100100110000100000011011010000010010010110110111";
		-- 0.111671
		y <= "0000000000000000000000000000000000000000000000011100100101100111100010100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1407
		-- 234248.106463
		x <= "0000000000000000000000000011100100110000100000011011010000010010010110110111";
		-- 0.335013
		y <= "0000000000000000000000000000000000000000000001010101110000110110100111101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1408
		-- 234248.106463
		x <= "0000000000000000000000000011100100110000100000011011010000010010010110110111";
		-- 0.558355
		y <= "0000000000000000000000000000000000000000000010001110111100000101101100110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1409
		-- 234248.106463
		x <= "0000000000000000000000000011100100110000100000011011010000010010010110110111";
		-- 0.781697
		y <= "0000000000000000000000000000000000000000000011001000000111010100110001111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1410
		-- 234248.106463
		x <= "0000000000000000000000000011100100110000100000011011010000010010010110110111";
		-- 1.005039
		y <= "0000000000000000000000000000000000000000000100000001010010100011110111000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1411
		-- 235921.307223
		x <= "0000000000000000000000000011100110011001000101001110101001100010111010100110";
		-- -1.004461
		y <= "1111111111111111111111111111111111111111111011111110110110111010011100110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1412
		-- 235921.307223
		x <= "0000000000000000000000000011100110011001000101001110101001100010111010100110";
		-- -0.781247
		y <= "1111111111111111111111111111111111111111111100111000000000000010110010110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1413
		-- 235921.307223
		x <= "0000000000000000000000000011100110011001000101001110101001100010111010100110";
		-- -0.558034
		y <= "1111111111111111111111111111111111111111111101110001001001001011001000111010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1414
		-- 235921.307223
		x <= "0000000000000000000000000011100110011001000101001110101001100010111010100110";
		-- -0.334820
		y <= "1111111111111111111111111111111111111111111110101010010010010011011110111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1415
		-- 235921.307223
		x <= "0000000000000000000000000011100110011001000101001110101001100010111010100110";
		-- -0.111607
		y <= "1111111111111111111111111111111111111111111111100011011011011011110100111110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1416
		-- 235921.307223
		x <= "0000000000000000000000000011100110011001000101001110101001100010111010100110";
		-- 0.111607
		y <= "0000000000000000000000000000000000000000000000011100100100100100001011000001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1417
		-- 235921.307223
		x <= "0000000000000000000000000011100110011001000101001110101001100010111010100110";
		-- 0.334820
		y <= "0000000000000000000000000000000000000000000001010101101101101100100001000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1418
		-- 235921.307223
		x <= "0000000000000000000000000011100110011001000101001110101001100010111010100110";
		-- 0.558034
		y <= "0000000000000000000000000000000000000000000010001110110110110100110111000101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1419
		-- 235921.307223
		x <= "0000000000000000000000000011100110011001000101001110101001100010111010100110";
		-- 0.781247
		y <= "0000000000000000000000000000000000000000000011000111111111111101001101001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1420
		-- 235921.307223
		x <= "0000000000000000000000000011100110011001000101001110101001100010111010100110";
		-- 1.004461
		y <= "0000000000000000000000000000000000000000000100000001001001000101100011001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1421
		-- 237594.507984
		x <= "0000000000000000000000000011101000000001101010000010000010110011011110010100";
		-- -1.003887
		y <= "1111111111111111111111111111111111111111111011111111000000010011110010010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1422
		-- 237594.507984
		x <= "0000000000000000000000000011101000000001101010000010000010110011011110010100";
		-- -0.780801
		y <= "1111111111111111111111111111111111111111111100111000000111010110011111111111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1423
		-- 237594.507984
		x <= "0000000000000000000000000011101000000001101010000010000010110011011110010100";
		-- -0.557715
		y <= "1111111111111111111111111111111111111111111101110001001110011001001101101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1424
		-- 237594.507984
		x <= "0000000000000000000000000011101000000001101010000010000010110011011110010100";
		-- -0.334629
		y <= "1111111111111111111111111111111111111111111110101010010101011011111011011011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1425
		-- 237594.507984
		x <= "0000000000000000000000000011101000000001101010000010000010110011011110010100";
		-- -0.111543
		y <= "1111111111111111111111111111111111111111111111100011011100011110101001001001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1426
		-- 237594.507984
		x <= "0000000000000000000000000011101000000001101010000010000010110011011110010100";
		-- 0.111543
		y <= "0000000000000000000000000000000000000000000000011100100011100001010110110110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1427
		-- 237594.507984
		x <= "0000000000000000000000000011101000000001101010000010000010110011011110010100";
		-- 0.334629
		y <= "0000000000000000000000000000000000000000000001010101101010100100000100100100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1428
		-- 237594.507984
		x <= "0000000000000000000000000011101000000001101010000010000010110011011110010100";
		-- 0.557715
		y <= "0000000000000000000000000000000000000000000010001110110001100110110010010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1429
		-- 237594.507984
		x <= "0000000000000000000000000011101000000001101010000010000010110011011110010100";
		-- 0.780801
		y <= "0000000000000000000000000000000000000000000011000111111000101001100000000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1430
		-- 237594.507984
		x <= "0000000000000000000000000011101000000001101010000010000010110011011110010100";
		-- 1.003887
		y <= "0000000000000000000000000000000000000000000100000000111111101100001101101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1431
		-- 239267.708744
		x <= "0000000000000000000000000011101001101010001110110101011100000100000010000011";
		-- -1.003319
		y <= "1111111111111111111111111111111111111111111011111111001001101000001110001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1432
		-- 239267.708744
		x <= "0000000000000000000000000011101001101010001110110101011100000100000010000011";
		-- -0.780359
		y <= "1111111111111111111111111111111111111111111100111000001110100110011001010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1433
		-- 239267.708744
		x <= "0000000000000000000000000011101001101010001110110101011100000100000010000011";
		-- -0.557399
		y <= "1111111111111111111111111111111111111111111101110001010011100100100100010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1434
		-- 239267.708744
		x <= "0000000000000000000000000011101001101010001110110101011100000100000010000011";
		-- -0.334440
		y <= "1111111111111111111111111111111111111111111110101010011000100010101111011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1435
		-- 239267.708744
		x <= "0000000000000000000000000011101001101010001110110101011100000100000010000011";
		-- -0.111480
		y <= "1111111111111111111111111111111111111111111111100011011101100000111010011101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1436
		-- 239267.708744
		x <= "0000000000000000000000000011101001101010001110110101011100000100000010000011";
		-- 0.111480
		y <= "0000000000000000000000000000000000000000000000011100100010011111000101100010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1437
		-- 239267.708744
		x <= "0000000000000000000000000011101001101010001110110101011100000100000010000011";
		-- 0.334440
		y <= "0000000000000000000000000000000000000000000001010101100111011101010000100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1438
		-- 239267.708744
		x <= "0000000000000000000000000011101001101010001110110101011100000100000010000011";
		-- 0.557399
		y <= "0000000000000000000000000000000000000000000010001110101100011011011011101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1439
		-- 239267.708744
		x <= "0000000000000000000000000011101001101010001110110101011100000100000010000011";
		-- 0.780359
		y <= "0000000000000000000000000000000000000000000011000111110001011001100110101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1440
		-- 239267.708744
		x <= "0000000000000000000000000011101001101010001110110101011100000100000010000011";
		-- 1.003319
		y <= "0000000000000000000000000000000000000000000100000000110110010111110001110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1441
		-- 240940.909504
		x <= "0000000000000000000000000011101011010010110011101000110101010100100101110001";
		-- -1.002754
		y <= "1111111111111111111111111111111111111111111011111111010010110111110101010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1442
		-- 240940.909504
		x <= "0000000000000000000000000011101011010010110011101000110101010100100101110001";
		-- -0.779920
		y <= "1111111111111111111111111111111111111111111100111000010101110010100010010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1443
		-- 240940.909504
		x <= "0000000000000000000000000011101011010010110011101000110101010100100101110001";
		-- -0.557086
		y <= "1111111111111111111111111111111111111111111101110001011000101101001111011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1444
		-- 240940.909504
		x <= "0000000000000000000000000011101011010010110011101000110101010100100101110001";
		-- -0.334251
		y <= "1111111111111111111111111111111111111111111110101010011011100111111100011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1445
		-- 240940.909504
		x <= "0000000000000000000000000011101011010010110011101000110101010100100101110001";
		-- -0.111417
		y <= "1111111111111111111111111111111111111111111111100011011110100010101001011110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1446
		-- 240940.909504
		x <= "0000000000000000000000000011101011010010110011101000110101010100100101110001";
		-- 0.111417
		y <= "0000000000000000000000000000000000000000000000011100100001011101010110100001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1447
		-- 240940.909504
		x <= "0000000000000000000000000011101011010010110011101000110101010100100101110001";
		-- 0.334251
		y <= "0000000000000000000000000000000000000000000001010101100100011000000011100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1448
		-- 240940.909504
		x <= "0000000000000000000000000011101011010010110011101000110101010100100101110001";
		-- 0.557086
		y <= "0000000000000000000000000000000000000000000010001110100111010010110000100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1449
		-- 240940.909504
		x <= "0000000000000000000000000011101011010010110011101000110101010100100101110001";
		-- 0.779920
		y <= "0000000000000000000000000000000000000000000011000111101010001101011101101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1450
		-- 240940.909504
		x <= "0000000000000000000000000011101011010010110011101000110101010100100101110001";
		-- 1.002754
		y <= "0000000000000000000000000000000000000000000100000000101101001000001010101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1451
		-- 242614.110265
		x <= "0000000000000000000000000011101100111011011000011100001110100101001001100000";
		-- -1.002195
		y <= "1111111111111111111111111111111111111111111011111111011100000010101100010010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1452
		-- 242614.110265
		x <= "0000000000000000000000000011101100111011011000011100001110100101001001100000";
		-- -0.779485
		y <= "1111111111111111111111111111111111111111111100111000011100111010111110111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1453
		-- 242614.110265
		x <= "0000000000000000000000000011101100111011011000011100001110100101001001100000";
		-- -0.556775
		y <= "1111111111111111111111111111111111111111111101110001011101110011010001011111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1454
		-- 242614.110265
		x <= "0000000000000000000000000011101100111011011000011100001110100101001001100000";
		-- -0.334065
		y <= "1111111111111111111111111111111111111111111110101010011110101011100100000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1455
		-- 242614.110265
		x <= "0000000000000000000000000011101100111011011000011100001110100101001001100000";
		-- -0.111355
		y <= "1111111111111111111111111111111111111111111111100011011111100011110110101100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1456
		-- 242614.110265
		x <= "0000000000000000000000000011101100111011011000011100001110100101001001100000";
		-- 0.111355
		y <= "0000000000000000000000000000000000000000000000011100100000011100001001010011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1457
		-- 242614.110265
		x <= "0000000000000000000000000011101100111011011000011100001110100101001001100000";
		-- 0.334065
		y <= "0000000000000000000000000000000000000000000001010101100001010100011011111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1458
		-- 242614.110265
		x <= "0000000000000000000000000011101100111011011000011100001110100101001001100000";
		-- 0.556775
		y <= "0000000000000000000000000000000000000000000010001110100010001100101110100000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1459
		-- 242614.110265
		x <= "0000000000000000000000000011101100111011011000011100001110100101001001100000";
		-- 0.779485
		y <= "0000000000000000000000000000000000000000000011000111100011000101000001000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1460
		-- 242614.110265
		x <= "0000000000000000000000000011101100111011011000011100001110100101001001100000";
		-- 1.002195
		y <= "0000000000000000000000000000000000000000000100000000100011111101010011101101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1461
		-- 244287.311025
		x <= "0000000000000000000000000011101110100011111101001111100111110101101101001110";
		-- -1.001639
		y <= "1111111111111111111111111111111111111111111011111111100101001000110111101001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1462
		-- 244287.311025
		x <= "0000000000000000000000000011101110100011111101001111100111110101101101001110";
		-- -0.779053
		y <= "1111111111111111111111111111111111111111111100111000100011111111110010011001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1463
		-- 244287.311025
		x <= "0000000000000000000000000011101110100011111101001111100111110101101101001110";
		-- -0.556466
		y <= "1111111111111111111111111111111111111111111101110001100010110110101101001000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1464
		-- 244287.311025
		x <= "0000000000000000000000000011101110100011111101001111100111110101101101001110";
		-- -0.333880
		y <= "1111111111111111111111111111111111111111111110101010100001101101100111111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1465
		-- 244287.311025
		x <= "0000000000000000000000000011101110100011111101001111100111110101101101001110";
		-- -0.111293
		y <= "1111111111111111111111111111111111111111111111100011100000100100100010101000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1466
		-- 244287.311025
		x <= "0000000000000000000000000011101110100011111101001111100111110101101101001110";
		-- 0.111293
		y <= "0000000000000000000000000000000000000000000000011100011111011011011101010111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1467
		-- 244287.311025
		x <= "0000000000000000000000000011101110100011111101001111100111110101101101001110";
		-- 0.333880
		y <= "0000000000000000000000000000000000000000000001010101011110010010011000000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1468
		-- 244287.311025
		x <= "0000000000000000000000000011101110100011111101001111100111110101101101001110";
		-- 0.556466
		y <= "0000000000000000000000000000000000000000000010001110011101001001010010110111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1469
		-- 244287.311025
		x <= "0000000000000000000000000011101110100011111101001111100111110101101101001110";
		-- 0.779053
		y <= "0000000000000000000000000000000000000000000011000111011100000000001101100110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1470
		-- 244287.311025
		x <= "0000000000000000000000000011101110100011111101001111100111110101101101001110";
		-- 1.001639
		y <= "0000000000000000000000000000000000000000000100000000011010110111001000010110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1471
		-- 245960.511786
		x <= "0000000000000000000000000011110000001100100010000011000001000110010000111101";
		-- -1.001089
		y <= "1111111111111111111111111111111111111111111011111111101110001010011011110101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1472
		-- 245960.511786
		x <= "0000000000000000000000000011110000001100100010000011000001000110010000111101";
		-- -0.778625
		y <= "1111111111111111111111111111111111111111111100111000101011000001000000010100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1473
		-- 245960.511786
		x <= "0000000000000000000000000011110000001100100010000011000001000110010000111101";
		-- -0.556160
		y <= "1111111111111111111111111111111111111111111101110001100111110111100100110011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1474
		-- 245960.511786
		x <= "0000000000000000000000000011110000001100100010000011000001000110010000111101";
		-- -0.333696
		y <= "1111111111111111111111111111111111111111111110101010100100101110001001010001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1475
		-- 245960.511786
		x <= "0000000000000000000000000011110000001100100010000011000001000110010000111101";
		-- -0.111232
		y <= "1111111111111111111111111111111111111111111111100011100001100100101101110000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1476
		-- 245960.511786
		x <= "0000000000000000000000000011110000001100100010000011000001000110010000111101";
		-- 0.111232
		y <= "0000000000000000000000000000000000000000000000011100011110011011010010001111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1477
		-- 245960.511786
		x <= "0000000000000000000000000011110000001100100010000011000001000110010000111101";
		-- 0.333696
		y <= "0000000000000000000000000000000000000000000001010101011011010001110110101110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1478
		-- 245960.511786
		x <= "0000000000000000000000000011110000001100100010000011000001000110010000111101";
		-- 0.556160
		y <= "0000000000000000000000000000000000000000000010001110011000001000011011001100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1479
		-- 245960.511786
		x <= "0000000000000000000000000011110000001100100010000011000001000110010000111101";
		-- 0.778625
		y <= "0000000000000000000000000000000000000000000011000111010100111110111111101011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1480
		-- 245960.511786
		x <= "0000000000000000000000000011110000001100100010000011000001000110010000111101";
		-- 1.001089
		y <= "0000000000000000000000000000000000000000000100000000010001110101100100001010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1481
		-- 247633.712546
		x <= "0000000000000000000000000011110001110101000110110110011010010110110100101011";
		-- -1.000542
		y <= "1111111111111111111111111111111111111111111011111111110111000111011101001101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1482
		-- 247633.712546
		x <= "0000000000000000000000000011110001110101000110110110011010010110110100101011";
		-- -0.778199
		y <= "1111111111111111111111111111111111111111111100111000110001111110101100000011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1483
		-- 247633.712546
		x <= "0000000000000000000000000011110001110101000110110110011010010110110100101011";
		-- -0.555857
		y <= "1111111111111111111111111111111111111111111101110001101100110101111010111001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1484
		-- 247633.712546
		x <= "0000000000000000000000000011110001110101000110110110011010010110110100101011";
		-- -0.333514
		y <= "1111111111111111111111111111111111111111111110101010100111101101001001101111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1485
		-- 247633.712546
		x <= "0000000000000000000000000011110001110101000110110110011010010110110100101011";
		-- -0.111171
		y <= "1111111111111111111111111111111111111111111111100011100010100100011000100101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1486
		-- 247633.712546
		x <= "0000000000000000000000000011110001110101000110110110011010010110110100101011";
		-- 0.111171
		y <= "0000000000000000000000000000000000000000000000011100011101011011100111011010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1487
		-- 247633.712546
		x <= "0000000000000000000000000011110001110101000110110110011010010110110100101011";
		-- 0.333514
		y <= "0000000000000000000000000000000000000000000001010101011000010010110110010000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1488
		-- 247633.712546
		x <= "0000000000000000000000000011110001110101000110110110011010010110110100101011";
		-- 0.555857
		y <= "0000000000000000000000000000000000000000000010001110010011001010000101000110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1489
		-- 247633.712546
		x <= "0000000000000000000000000011110001110101000110110110011010010110110100101011";
		-- 0.778199
		y <= "0000000000000000000000000000000000000000000011000111001110000001010011111100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1490
		-- 247633.712546
		x <= "0000000000000000000000000011110001110101000110110110011010010110110100101011";
		-- 1.000542
		y <= "0000000000000000000000000000000000000000000100000000001000111000100010110010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1491
		-- 249306.913307
		x <= "0000000000000000000000000011110011011101101011101001110011100111011000011010";
		-- -1.000000
		y <= "1111111111111111111111111111111111111111111100000000000000000000000000000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1492
		-- 249306.913307
		x <= "0000000000000000000000000011110011011101101011101001110011100111011000011010";
		-- -0.777778
		y <= "1111111111111111111111111111111111111111111100111000111000111000111000111000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1493
		-- 249306.913307
		x <= "0000000000000000000000000011110011011101101011101001110011100111011000011010";
		-- -0.555556
		y <= "1111111111111111111111111111111111111111111101110001110001110001110001110001";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1494
		-- 249306.913307
		x <= "0000000000000000000000000011110011011101101011101001110011100111011000011010";
		-- -0.333333
		y <= "1111111111111111111111111111111111111111111110101010101010101010101010101010";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1495
		-- 249306.913307
		x <= "0000000000000000000000000011110011011101101011101001110011100111011000011010";
		-- -0.111111
		y <= "1111111111111111111111111111111111111111111111100011100011100011100011100011";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1496
		-- 249306.913307
		x <= "0000000000000000000000000011110011011101101011101001110011100111011000011010";
		-- 0.111111
		y <= "0000000000000000000000000000000000000000000000011100011100011100011100011100";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1497
		-- 249306.913307
		x <= "0000000000000000000000000011110011011101101011101001110011100111011000011010";
		-- 0.333333
		y <= "0000000000000000000000000000000000000000000001010101010101010101010101010101";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1498
		-- 249306.913307
		x <= "0000000000000000000000000011110011011101101011101001110011100111011000011010";
		-- 0.555556
		y <= "0000000000000000000000000000000000000000000010001110001110001110001110001110";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1499
		-- 249306.913307
		x <= "0000000000000000000000000011110011011101101011101001110011100111011000011010";
		-- 0.777778
		y <= "0000000000000000000000000000000000000000000011000111000111000111000111000111";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		-- Iteration 1500
		-- 249306.913307
		x <= "0000000000000000000000000011110011011101101011101001110011100111011000011010";
		-- 1.000000
		y <= "0000000000000000000000000000000000000000000100000000000000000000000000000000";
		start <= '1'; wait for 2 ns; start <= '0'; wait until done = '1'; wait for 20 ns;
		write(L1, output);
		writeline(test_out_data1,L1);

		stop(0);
	end process;
end Behavioral;
