library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use std.textio.all;
use ieee.std_logic_textio.all;
library std;
use std.env.all;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity Fixed_eToTheX_Generic_tb is
end Fixed_eToTheX_Generic_tb;

architecture Behavioral of Fixed_eToTheX_Generic_tb is
component Fixed_eToTheX is
	Generic ( filename1, filename2 : string; dataWidth, iterWidth, M, N : integer );
	Port ( clk, start : in STD_LOGIC;
		input, InverseScalingFactor : in STD_LOGIC_VECTOR (dataWidth-1 downto 0);
		output : out STD_LOGIC_VECTOR (dataWidth-1 downto 0);
		done : out STD_LOGIC );
end component;

constant file1 : string := "64_64BitExpandedLUT_Fixed.txt";
constant file2 : string := "64_64BitLUT_Fixed.txt";
constant dataWidth : integer := 128;
constant iterWidth : integer := 6;
constant M : integer := 5;
constant N : integer := 40;

signal clk_tb, start_tb, done_tb : std_logic;
signal input_tb, InvScalFact, output_tb : std_logic_vector (dataWidth-1 downto 0);

begin
	myCORDIC : Fixed_eToTheX Generic Map(fileName1 => file1, fileName2 => file2,
			dataWidth => dataWidth, iterWidth => iterWidth, M => M, N => N)
		Port Map(clk_tb, start_tb, input_tb, InvScalFact, output_tb, done_tb);

clock : process begin
	clk_tb <= '0'; wait for 1 ns;
	clk_tb <= '1'; wait for 1 ns;
end process;

testProc : process
	FILE test_out_data1: TEXT open WRITE_MODE is "40iterations128bits_eToTheX_fixed.txt";
	variable L1 : LINE;

begin

--------------------------Begin Tests-----------------------------
	-- The main pieces that need to be in place to get standard, nonscaled e^x values
	-- InvScalFact := 1988.7411;
	InvScalFact <= "00000000000000000000000000000000000000000000000000000111110001001011110110110111110000001110111010000000000000000000000000000000";


	--input <= "-12.4264";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111001001011010100110101000000001001001011001101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.4016";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111001100100110011001101111000011001000010110110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.3767";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111001111110010001100110110000101000111010100000001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.3518";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111010010111101111111111101000111000110010001001101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.3269";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111010110001001110011000100001001000101001110011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.3021";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111011001010101100110001011001011000100001011100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.2772";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111011100100001011001010010001101000011001000110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.2523";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111011111101101001100011001001111000010000101111111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.2274";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111100010111000111111100000010001000001000011001011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.2025";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111100110000100110010100111010011000000000000011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.1777";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111101001010000100101101110010100111110111101100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.1528";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111101100011100011000110101010110111101111010110001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.1279";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111101111101000001011111100011000111100110111111101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.103";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111110010110011111111000011011010111011110101001001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.0782";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111110101111111110010001010011100111010110010010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.0533";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111111001001011100101010001011110111001101111100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.0284";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111111100010111011000011000100000111000101100101111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-12.0035";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111100111111111100011001011011111100010110111101001111011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.9786";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000000010101110111110100110100100110110100111000111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.9538";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000000101111010110001101101100110110101100100010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.9289";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000001001000110100100110100101000110100100001100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.904";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000001100010010010111111011101010110011011110101101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.8791";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000001111011110001011000010101100110010011011111001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.8543";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000010010101001111110001001101110110001011001000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.8294";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000010101110101110001010000110000110000010110010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.8045";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000011001000001100100010111110010101111010011011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.7796";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000011100001101010111011110110100101110010000101011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.7547";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000011111011001001010100101110110101101001101110111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.7299";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000100010100100111101101100111000101100001011000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.705";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000100101110000110000110011111010101011001000010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.6801";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000101000111100100011111010111100101010000101011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.6552";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000101100001000010111000001111110101001000010101001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.6304";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000101111010100001010001001000000100111111111110101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.6055";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000110010011111111101010000000010100110111101000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.5806";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000110101101011110000010111000100100101111010001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.5557";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000111000110111100011011110000110100100110111011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.5308";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000111100000011010110100101001000100011110100100111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.506";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101000111111001111001001101100001010100010110001110011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.4811";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001000010011010111100110011001100100001101111000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.4562";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001000101100110101111111010001110100000101100001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.4313";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001001000110010100011000001010000011111101001011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.4065";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001001011111110010110001000010010011110100110100101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.3816";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001001111001010001001001111010100011101100011110001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.3567";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001010010010101111100010110010110011100100000111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.3318";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001010101100001101111011101011000011011011110001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.3069";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001011000101101100010100100011010011010011011010111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.2821";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001011011111001010101101011011100011001011000100011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.2572";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001011111000101001000110010011110011000010101101111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.2323";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001100010010000111011111001100000010111010010111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.2074";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001100101011100101111000000100010010110010000001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.1826";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001101000101000100010000111100100010101001101010101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.1577";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001101011110100010101001110100110010100001010100001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.1328";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001101111000000001000010101101000010011000111101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.1079";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001110010001011111011011100101010010010000100111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.083";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001110101010111101110100011101100010001000010000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.0582";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001111000100011100001101010101110001111111111010011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.0333";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001111011101111010100110001110000001110111100011111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-11.0084";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101001111110111011000111111000110010001101111001101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.9835";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010000010000110111010111111110100001100110110111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.9587";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010000101010010101110000110110110001011110100000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.9338";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010001000011110100001001101111000001010110001010001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.9089";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010001011101010010100010100111010001001101110011101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.884";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010001110110110000111011011111100001000101011101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.8591";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010010010000001111010100010111110000111101000110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.8343";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010010101001101101101101010000000000110100110000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.8094";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010011000011001100000110001000010000101100011001111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.7845";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010011011100101010011111000000100000100100000011011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.7596";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010011110110001000110111111000110000011011101101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.7348";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010100001111100111010000110001000000010011010110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.7099";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010100101001000101101001101001010000001011000000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.685";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010101000010100100000010100001100000000010101001101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.6601";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010101011100000010011011011001101111111010010011001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.6352";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010101110101100000110100010001111111110001111100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.6104";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010110001110111111001101001010001111101001100110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.5855";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010110101000011101100110000010011111100001001111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.5606";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010111000001111011111110111010101111011000111001011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.5357";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010111011011011010010111110010111111010000100010111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.5109";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101010111110100111000110000101011001111001000001100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.486";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011000001110010111001001100011011110111111110110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.4611";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011000100111110101100010011011101110110111011111101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.4362";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011001000001010011111011010011111110101111001001001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.4113";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011001011010110010010100001100001110100110110010101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.3865";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011001110100010000101101000100011110011110011100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.3616";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011010001101101111000101111100101110010110000101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.3367";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011010100111001101011110110100111110001101101111011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.3118";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011011000000101011110111101101001110000101011000111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.287";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011011011010001010010000100101011101111101000010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.2621";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011011110011101000101001011101101101110100101100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.2372";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011100001101000111000010010101111101101100010101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.2123";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011100100110100101011011001110001101100011111111001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.1874";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011101000000000011110100000110011101011011101000101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.1626";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011101011001100010001100111110101101010011010010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.1377";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011101110011000000100101110110111101001010111011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.1128";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011110001100011110111110101111001101000010100101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.0879";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011110100101111101010111100111011100111010001110111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.0631";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011110111111011011110000011111101100110001111000011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.0382";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011111011000111010001001010111111100101001100010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-10.0133";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101011111110010011000100010010000001100100001001011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.9884";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100000001011110110111011001000011100011000110101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.9635";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100000100101010101010100000000101100010000011110101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.9387";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100000111110110011101100111000111100001000001000001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.9138";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100001011000010010000101110001001011111111110001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.8889";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100001110001110000011110101001011011110111011011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.864";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100010001011001110110111100001101011101111000100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.8392";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100010100100101101010000011001111011100110101110011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.8143";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100010111110001011101001010010001011011110011000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.7894";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100011010111101010000010001010011011010110000001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.7645";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100011110001001000011011000010101011001101101011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.7396";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100100001010100110110011111010111011000101010100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.7148";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100100100100000101001100110011001010111100111110001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.6899";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100100111101100011100101101011011010110100100111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.665";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100101010111000001111110100011101010101100010001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.6401";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100101110000100000010111011011111010100011111010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.6153";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100110001001111110110000010100001010011011100100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.5904";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100110100011011101001001001100011010010011001101111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.5655";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100110111100111011100010000100101010001010110111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.5406";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100111010110011001111010111100111010000010100001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.5157";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101100111101111111000010011110101001001111010001010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.4909";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101000001001010110101100101101011001110001110100001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.466";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101000100010110101000101100101101001101001011101101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.4411";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101000111100010011011110011101111001100001000111001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.4162";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101001010101110001110111010110001001011000110000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.3914";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101001101111010000010000001110011001010000011010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.3665";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101010001000101110101001000110101001001000000011111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.3416";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101010100010001101000001111110111000111111101101011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.3167";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101010111011101011011010110111001000110111010111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.2918";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101011010101001001110011101111011000101111000000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.267";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101011101110101000001100100111101000100110101010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.2421";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101100001000000110100101011111111000011110010011101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.2172";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101100100001100100111110011000001000010101111101001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.1923";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101100111011000011010111010000011000001101100110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.1675";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101101010100100001110000001000101000000101010000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.1426";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101101101110000000001001000000110111111100111001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.1177";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101110000111011110100001111001000111110100100011011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.0928";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101110100000111100111010110001010111101100001100111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.0679";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101110111010011011010011101001100111100011110110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.0431";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101111010011111001101100100001110111011011100000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-9.0182";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101101111101101011000000101011010000111010011001001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.9933";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110000000110110110011110010010010111001010110011001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.9684";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110000100000010100110111001010100111000010011100101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.9436";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110000111001110011010000000010110110111010000110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.9187";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110001010011010001101000111011000110110001101111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.8938";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110001101100110000000001110011010110101001011001011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.8689";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110010000110001110011010101011100110100001000010111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.844";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110010011111101100110011100011110110011000101100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.8192";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110010111001001011001100011100000110010000010110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.7943";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110011010010101001100101010100010110000111111111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.7694";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110011101100000111111110001100100101111111101001001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.7445";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110100000101100110010111000100110101110111010010101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.7197";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110100011111000100101111111101000101101110111100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.6948";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110100111000100011001000110101010101100110100101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.6699";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110101010010000001100001101101100101011110001111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.645";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110101101011011111111010100101110101010101111000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.6201";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110110000100111110010011011110000101001101100010011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.5953";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110110011110011100101100010110010101000101001100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.5704";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110110110111111011000101001110100100111100110101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.5455";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110111010001011001011110000110110100110100011111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.5206";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101110111101010110111110110111111000100101100001000101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.4958";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111000000100010110001111110111010100100011110010001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.4709";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111000011101110100101000101111100100011011011011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.446";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111000110111010011000001100111110100010011000101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.4211";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111001010000110001011010100000000100001010101110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.3962";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111001101010001111110011011000010100000010011000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.3714";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111010000011101110001100010000100011111010000010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.3465";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111010011101001100100101001000110011110001101011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.3216";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111010110110101010111110000001000011101001010101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.2967";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111011010000001001010110111001010011100000111110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.2719";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111011101001100111101111110001100011011000101000001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.247";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111100000011000110001000101001110011010000010001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.2221";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111100011100100100100001100010000011000111111011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.1972";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111100110110000010111010011010010010111111100100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.1723";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111101001111100001010011010010100010110111001110011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.1475";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111101101000111111101100001010110010101110110111111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.1226";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111110000010011110000101000011000010100110100001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.0977";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111110011011111100011101111011010010011110001011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.0728";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111110110101011010110110110011100010010101110100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.048";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111111001110111001001111101011110010001101011110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-8.0231";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111101111111101000010111101000100100000010000101000111101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.9982";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000000000001110110000001011100010001111100110001001100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.9733";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000000011011010100011010010100100001110100011010101100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.9484";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000000110100110010110011001100110001101100000100010100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.9236";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000001001110010001001100000101000001100011101101110100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.8987";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000001100111101111100100111101010001011011010111011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.8738";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000010000001001101111101110101100001010011000000111100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.8489";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000010011010101100010110101101110001001010101010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.8241";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000010110100001010101111100110000001000010010100000100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.7992";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000011001101101001001000011110010000111001111101100100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.7743";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000011100111000111100001010110100000110001100111001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.7494";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000100000000100101111010001110110000101001010000101100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.7245";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000100011010000100010011000111000000100000111010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.6997";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000100110011100010101011111111010000011000100011110100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.6748";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000101001101000001000100110111100000010000001101010100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.6499";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000101100110011111011101101111110000000111110110111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.625";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000101111111111101110110100111111111111111100000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.6002";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000110011001011100001111100000001111110111001010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.5753";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000110110010111010101000011000011111101110110011100100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.5504";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000111001100011001000001010000101111100110011101000100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.5255";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000111100101110111011010001000111111011110000110101100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.5006";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110000111111111010101110011000001001111010101110000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.4758";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001000011000110100001011111001011111001101011001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.4509";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001000110010010010100100110001101111000101000011010100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.426";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001001001011110000111101101001111110111100101100110100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.4011";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001001100101001111010110100010001110110100010110011100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.3763";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001001111110101101101111011010011110101100000000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.3514";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001010011000001100001000010010101110100011101001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.3265";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001010110001101010100001001010111110011011010011000100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.3016";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001011001011001000111010000011001110010010111100101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.2767";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001011100100100111010010111011011110001010100110001100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.2519";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001011111110000101101011110011101110000010001111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.227";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001100010111100100000100101011111101111001111001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.2021";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001100110001000010011101100100001101110001100010111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.1772";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001101001010100000110110011100011101101001001100011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.1524";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001101100011111111001111010100101101100000110101111100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.1275";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001101111101011101101000001100111101011000011111011100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.1026";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001110010110111100000001000101001101010000001001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.0777";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001110110000011010011001111101011101000111110010101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.0528";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001111001001111000110010110101101100111111011100001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.028";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001111100011010111001011101101111100110111000101101100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-7.0031";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110001111111100110101100100100110001100101110101111001100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.9782";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010000010110010011111101011110011100100110011000110100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.9533";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010000101111110010010110010110101100011110000010011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.9285";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010001001001010000101111001110111100010101101011111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.9036";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010001100010101111001000000111001100001101010101011100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.8787";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010001111100001101100000111111011100000100111111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.8538";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010010010101101011111001110111101011111100101000100100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.8289";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010010101111001010010010101111111011110100010010001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.8041";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010011001000101000101011101000001011101011111011101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.7792";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010011100010000111000100100000011011100011100101001100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.7543";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010011111011100101011101011000101011011011001110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.7294";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010100010101000011110110010000111011010010111000010100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.7046";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010100101110100010001111001001001011001010100001111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.6797";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010101001000000000101000000001011011000010001011011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.6548";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010101100001011111000000111001101010111001110101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.6299";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010101111010111101011001110001111010110001011110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.605";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010110010100011011110010101010001010101001001000000100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.5802";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010110101101111010001011100010011010100000110001101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.5553";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010111000111011000100100011010101010011000011011001100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.5304";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010111100000110110111101010010111010010000000100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.5055";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110010111111010010101010110001011001010000111101110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.4807";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011000010011110011101111000011011001111111010111110100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.4558";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011000101101010010000111111011101001110111000001010100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.4309";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011001000110110000100000110011111001101110101010111100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.406";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011001100000001110111001101100001001100110010100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.3811";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011001111001101101010010100100011001011101111110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.3563";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011010010011001011101011011100101001010101100111100100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.3314";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011010101100101010000100010100111001001101010001001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.3065";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011011000110001000011101001101001001000100111010101100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.2816";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011011011111100110110110000101011000111100100100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.2568";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011011111001000101001110111101101000110100001101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.2319";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011100010010100011100111110101111000101011110111011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.207";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011100101100000010000000101110001000100011100000111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.1821";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011101000101100000011001100110011000011011001010011100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.1572";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011101011110111110110010011110101000010010110100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.1324";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011101111000011101001011010110111000001010011101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.1075";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011110010001111011100100001111001000000010000111001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.0826";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011110101011011001111101000111010111111001110000101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.0577";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011111000100111000010101111111100111110001011010001100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.0329";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011111011110010110101110110111110111101001000011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-6.008";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110011111110111110101000111110000000111100000101101010100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.9831";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100000010001010011100000101000010111011000010110111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.9582";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100000101010110001111001100000100111010000000000011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.9333";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100001000100010000010010011000110111000111101001111100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.9085";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100001011101101110101011010001000110111111010011100100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.8836";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100001110111001101000100001001010110110110111101000100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.8587";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100010010000101011011101000001100110101110100110101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.8338";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100010101010001001110101111001110110100110010000001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.809";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100011000011101000001110110010000110011101111001101100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.7841";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100011011101000110100111101010010110010101100011010100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.7592";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100011110110100101000000100010100110001101001100110100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.7343";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100100010000000011011001011010110110000100110110011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.7094";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100100101001100001110010010011000101111100011111111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.6846";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100101000011000000001011001011010101110100001001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.6597";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100101011100011110100100000011100101101011110011000100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.6348";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100101110101111100111100111011110101100011011100100100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.6099";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100110001111011011010101110100000101011011000110001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.5851";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100110101000111001101110101100010101010010101111101100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.5602";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100111000010011000000111100100100101001010011001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.5353";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100111011011110110100000011100110101000010000010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.5104";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110100111110101010100111001010101000100111001101100010100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.4855";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101000001110110011010010001101010100110001010101111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.4607";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101000101000010001101011000101100100101000111111011100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.4358";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101001000001110000000011111101110100100000101001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.4109";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101001011011001110011100110110000100011000010010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.386";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101001110100101100110101101110010100001111111100000100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.3612";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101010001110001011001110100110100100000111100101101100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.3363";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101010100111101001100111011110110011111111001111001100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.3114";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101011000001001000000000010111000011110110111000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.2865";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101011011010100110011001001111010011101110100010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.2616";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101011110100000100110010000111100011100110001011111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.2368";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101100001101100011001010111111110011011101110101011100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.2119";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101100100111000001100011111000000011010101011110111100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.187";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101101000000011111111100110000010011001101001000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.1621";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101101011001111110010101101000100011000100110010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.1373";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101101110011011100101110100000110010111100011011101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.1124";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101110001100111011000111011001000010110100000101001100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.0875";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101110100110011001100000010001010010101011101110101100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.0626";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101110111111110111111001001001100010100011011000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.0377";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101111011001010110010010000001110010011011000001110100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-5.0129";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110101111110010110100101010111010000010010010101011011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.988";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110000001100010011000011110010010010001010010100111100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.9631";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110000100101110001011100101010100010000001111110011100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.9382";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110000111111001111110101100010110001111001101000000100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.9134";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110001011000101110001110011011000001110001010001100100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.8885";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110001110010001100100111010011010001101000111011001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.8636";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110010001011101011000000001011100001100000100100101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.8387";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110010100101001001011001000011110001011000001110001100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.8138";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110010111110100111110001111100000001001111110111110100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.789";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110011011000000110001010110100010001000111100001010100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.7641";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110011110001100100100011101100100000111111001010111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.7392";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110100001011000010111100100100110000110110110100011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.7143";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110100100100100001010101011101000000101110011110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.6895";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110100111101111111101110010101010000100110000111100100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.6646";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110101010111011110000111001101100000011101110001000100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.6397";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110101110000111100100000000101110000010101011010101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.6148";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110110001010011010111000111110000000001101000100001100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.5899";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110110100011111001010001110110010000000100101101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.5651";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110110111101010111101010101110011111111100010111010100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.5402";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110111010110110110000011100110101111110100000000110100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.5153";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110110111110000010100011100011110111111101011101010011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.4904";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111000001001110010110101010111001111100011010011111100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.4656";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111000100011010001001110001111011111011010111101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.4407";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111000111100101111100111000111101111010010100111000100000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.4158";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111001010110001101111111111111111111001010010000101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.3909";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111001101111101100011000111000001111000001111010001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.366";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111010001001001010110001110000011110111001100011101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.3412";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111010100010101001001010101000101110110001001101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.3163";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111010111100000111100011100000111110101000110110111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.2914";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111011010101100101111100011001001110100000100000011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.2665";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111011101111000100010101010001011110011000001001111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.2417";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111100001000100010101110001001101110001111110011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.2168";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111100100010000001000111000001111110000111011101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.1919";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111100111011011111011111111010001101111111000110101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.167";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111101010100111101111000110010011101110110110000001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.1421";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111101101110011100010001101010101101101110011001101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.1173";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111110000111111010101010100010111101100110000011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.0924";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111110100001011001000011011011001101011101101100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.0675";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111110111010110111011100010011011101010101010110011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.0426";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111111010100010101110101001011101101001100111111111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-4.0178";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111110111111101101110100001110000011111101000100101001011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.9929";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000000000111010010100110111100001100111100010011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.968";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000000100000110000111111110100011100110011111100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.9431";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000000111010001111011000101100101100101011100110001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.9182";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000001010011101101110001100100111100100011001111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.8934";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000001101101001100001010011101001100011010111001001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.8685";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000010000110101010100011010101011100010010100010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.8436";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000010100000001000111100001101101100001010001100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.8187";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000010111001100111010101000101111100000001110101111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.7939";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000011010011000101101101111110001011111001011111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.769";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000011101100100100000110110110011011110001001000111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.7441";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000100000110000010011111101110101011101000110010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.7192";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000100011111100000111000100110111011100000011100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.6943";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000100111000111111010001011111001011011000000101101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.6695";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000101010010011101101010010111011011001111101111001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.6446";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000101101011111100000011001111101011000111011000101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.6197";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000110000101011010011100000111111010111111000010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.5948";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000110011110111000110101000000001010110110101011111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.57";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000110111000010111001101111000011010101110010101011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.5451";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000111010001110101100110110000101010100101111110111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.5202";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111000111101011010011111111101000111010011101101000011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.4953";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001000000100110010011000100001001010010101010010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.4704";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001000011110010000110001011001011010001100111011101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.4456";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001000110111101111001010010001101010000100100101001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.4207";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001001010001001101100011001001111001111100001110101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.3958";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001001101010101011111100000010001001110011111000001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.3709";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001010000100001010010100111010011001101011100001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.3461";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001010011101101000101101110010101001100011001011011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.3212";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001010110111000111000110101010111001011010110100111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.2963";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001011010000100101011111100011001001010010011110011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.2714";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001011101010000011111000011011011001001010001000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.2465";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001100000011100010010001010011101001000001110001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.2217";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001100011101000000101010001011111000111001011011001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.1968";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001100110110011111000011000100001000110001000100101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.1719";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001101001111111101011011111100011000101000101110001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.147";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001101101001011011110100110100101000100000010111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.1222";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001110000010111010001101101100111000011000000001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.0973";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001110011100011000100110100101001000001111101010111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.0724";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001110110101110110111111011101011000000111010100011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.0475";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001111001111010101011000010101100111111110111101111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-3.0226";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111001111101000110011110001001101110111110110100111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.9978";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010000000010010010001010000110000111101110010001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.9729";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010000011011110000100010111110010111100101111010101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.948";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010000110101001110111011110110100111011101100100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.9231";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010001001110101101010100101110110111010101001101101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.8983";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010001101000001011101101100111000111001100110111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.8734";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010010000001101010000110011111010111000100100000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.8485";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010010011011001000011111010111100110111100001010011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.8236";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010010110100100110111000001111110110110011110100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.7987";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010011001110000101010001001000000110101011011101011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.7739";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010011100111100011101010000000010110100011000111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.749";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010100000001000010000010111000100110011010110000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.7241";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010100011010100000011011110000110110010010011010001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.6992";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010100110011111110110100101001000110001010000011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.6744";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010101001101011101001101100001010110000001101101001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.6495";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010101100110111011100110011001100101111001010110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.6246";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010110000000011001111111010001110101110001000000011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.5997";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010110011001111000011000001010000101101000101001111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.5748";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010110110011010110110001000010010101100000010011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.55";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010111001100110101001001111010100101010111111100111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.5251";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010111100110010011100010110010110101001111100110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.5002";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111010111111111110001111011101011000101000111010000001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.4753";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011000011001010000010100100011010100111110111001101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.4505";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011000110010101110101101011011100100110110100011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.4256";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011001001100001101000110010011110100101110001100101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.4007";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011001100101101011011111001100000100100101110110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.3758";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011001111111001001111000000100010100011101011111111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.3509";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011010011000101000010000111100100100010101001001011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.3261";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011010110010000110101001110100110100001100110011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.3012";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011011001011100101000010101101000100000100011100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.2763";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011011100101000011011011100101010011111100000110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.2514";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011011111110100001110100011101100011110011101111101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.2266";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011100011000000000001101010101110011101011011001001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.2017";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011100110001011110100110001110000011100011000010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.1768";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011101001010111100111111000110010011011010101100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.1519";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011101100100011011010111111110100011010010010101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.127";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011101111101111001110000110110110011001001111111011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.1022";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011110010111011000001001101111000011000001101000111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.0773";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011110110000110110100010100111010010111001010010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.0524";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011111001010010100111011011111100010110000111100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.0275";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011111100011110011010100010111110010101000100101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-2.0027";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111011111111101010001101101010000000010100000001111001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.9778";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100000010110110000000110001000010010010111111000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.9529";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100000110000001110011111000000100010001111100010001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.928";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100001001001101100110111111000110010000111001011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.9031";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100001100011001011010000110001000001111110110101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.8783";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100001111100101001101001101001010001110110011110111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.8534";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100010010110001000000010100001100001101110001000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.8285";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100010101111100110011011011001110001100101110001111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.8036";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100011001001000100110100010010000001011101011011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.7788";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100011100010100011001101001010010001010101000101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.7539";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100011111100000001100110000010100001001100101110101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.729";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100100010101011111111110111010110001000100011000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.7041";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100100101110111110010111110011000000111100000001101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.6792";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100101001000011100110000101011010000110011101011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.6544";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100101100001111011001001100011100000101011010100111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.6295";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100101111011011001100010011011110000100010111110011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.6046";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100110010100110111111011010100000000011010101000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.5797";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100110101110010110010100001100010000010010010001011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.5549";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100111000111110100101101000100100000001001111011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.53";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100111100001010011000101111100110000000001100100101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.5051";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111100111111010110001011110110100111111111001001110001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.4802";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101000010100001111110111101101001111110000110111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.4553";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101000101101101110010000100101011111101000100001001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.4305";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101001000111001100101001011101101111100000001010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.4056";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101001100000101011000010010101111111010111110100011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.3807";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101001111010001001011011001110001111001111011101111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.3558";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101010010011100111110100000110011111000111000111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.331";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101010101101000110001100111110101110111110110001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.3061";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101011000110100100100101110110111110110110011010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.2812";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101011100000000010111110101111001110101110000100001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.2563";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101011111001100001010111100111011110100101101101101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.2314";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101100010010111111110000011111101110011101010111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.2066";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101100101100011110001001010111111110010101000000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.1817";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101101000101111100100010010000001110001100101010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.1568";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101101011111011010111011001000011110000100010011111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.1319";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101101111000111001010100000000101101111011111101011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.1071";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101110010010010111101100111000111101110011100111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.0822";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101110101011110110000101110001001101101011010000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.0573";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101111000101010100011110101001011101100010111010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.0324";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101111011110110010110111100001101101011010100011101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-1.0075";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111101111111000010001010000011001111101010010001101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.98267";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110000010001101111101001010010001101001001110110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.95779";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110000101011001110000010001010011101000001100000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.93292";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110001000100101100011011000010101100111001001001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.90804";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110001011110001010110011111010111100110000110011011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.88316";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110001110111101001001100110011001100101000011101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.85828";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110010010001000111100101101011011100100000000110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.8334";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110010101010100101111110100011101100010111110000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.80853";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110011000100000100010111011011111100001111011001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.78365";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110011011101100010110000010100001100000111000011001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.75877";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110011110111000001001001001100011011111110101100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.73389";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110100010000011111100010000100101011110110010110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.70902";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110100101001111101111010111100111011101101111111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.68414";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110101000011011100010011110101001011100101101001011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.65926";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110101011100111010101100101101011011011101010010111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.63438";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110101110110011001000101100101101011010100111100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.60951";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110110001111110111011110011101111011001100100110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.58463";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110110101001010101110111010110001011000100001111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.55975";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110111000010110100010000001110011010111011111001001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.53487";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110111011100010010101001000110101010110011100010101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.50999";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111110111110101110001000001111110111010101011001100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.48512";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111000001111001111011010110111001010100010110101101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.46024";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111000101000101101110011101111011010011010011111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.43536";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111001000010001100001100100111101010010010001000111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.41048";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111001011011101010100101011111111010001001110010011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.38561";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111001110101001000111110011000001010000001011100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.36073";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111010001110100111010111010000011001111001000101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.33585";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111010101000000101110000001000101001110000101111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.31097";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111011000001100100001001000000111001101000011000101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.28609";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111011011011000010100001111001001001100000000010001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.26122";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111011110100100000111010110001011001010111101011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.23634";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111100001101111111010011101001101001001111010101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.21146";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111100100111011101101100100001111001000110111110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.18658";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111101000000111100000101011010001000111110101000011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.16171";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111101011010011010011110010010011000110110010001111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.13683";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111101110011111000110111001010101000101101111011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.11195";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111110001101010111010000000010111000100101100101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.087072";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111110100110110101101000111011001000011101001110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.062194";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111111000000010100000001110011011000010100111000001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.037317";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111111011001110010011010101011101000001100100001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "-0.012439";
	input_tb <= "11111111111111111111111111111111111111111111111111111111111111111111110011010000110011100011111000000100001011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.012439";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000000001100101111001100011100000111111011110100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.037317";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000000100110001101100101010100010111110011011110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.062194";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000000111111101011111110001100100111101011000111111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.087072";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000001011001001010010111000100110111100010110001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.11195";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000001110010101000101111111101000111011010011011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.13683";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000010001100000111001000110101010111010010000100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.16171";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000010100101100101100001101101100111001001101110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.18658";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000010111111000011111010100101110111000001010111101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.21146";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000011011000100010010011011110000110111001000001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.23634";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000011110010000000101100010110010110110000101010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.26122";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000100001011011111000101001110100110101000010100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.28609";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000100100100111101011110000110110110011111111101111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.31097";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000100111110011011110110111111000110010111100111011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.33585";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000101010111111010001111110111010110001111010001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.36073";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000101110001011000101000101111100110000110111010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.38561";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000110001010110111000001100111110101111110100100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.41048";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000110100100010101011010100000000101110110001101101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.43536";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000110111101110011110011011000010101101101110111001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.46024";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000111010111010010001100010000100101100101100000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.48512";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000000111110000110000100101001000110101011101001010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.50999";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001000001010001110111110000001000101010100110011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.53487";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001000100011101101010110111001010101001100011101011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.55975";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001000111101001011101111110001100101000100000110111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.58463";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001001010110101010001000101001110100111011110000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.60951";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001001110000001000100001100010000100110011011010001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.63438";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001010001001100110111010011010010100101011000011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.65926";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001010100011000101010011010010100100100010101101001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.68414";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001010111100100011101100001010110100011010010110101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.70902";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001011010110000010000101000011000100010010000000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.73389";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001011101111100000011101111011010100001001101001111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.75877";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001100001000111110110110110011100100000001010011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.78365";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001100100010011101001111101011110011111000111100111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.80853";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001100111011111011101000100100000011110000100110011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.8334";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001101010101011010000001011100010011101000010000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.85828";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001101101110111000011010010100100011011111111001101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.88316";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001110001000010110110011001100110011010111100011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.90804";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001110100001110101001100000101000011001111001100101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.93292";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001110111011010011100100111101010011000110110110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.95779";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001111010100110001111101110101100010111110011111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "0.98267";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000001111101110010000010110101101110010110110001001011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.0075";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010000000111101110101111100110000010101101110010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.0324";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010000100001001101001000011110010010100101011100011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.0573";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010000111010101011100001010110100010011101000110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.0822";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010001010100001001111010001110110010010100101111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.1071";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010001101101101000010011000111000010001100011001001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.1319";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010010000111000110101011111111010010000100000010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.1568";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010010100000100101000100110111100001111011101100001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.1817";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010010111010000011011101101111110001110011010101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.2066";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010011010011100001110110101000000001101010111111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.2314";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010011101101000000001111100000010001100010101000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.2563";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010100000110011110101000011000100001011010010010011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.2812";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010100011111111101000001010000110001010001111011111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.3061";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010100111001011011011010001001000001001001100101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.331";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010101010010111001110011000001010001000001001111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.3558";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010101101100011000001011111001100000111000111000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.3807";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010110000101110110100100110001110000110000100010001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.4056";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010110011111010100111101101010000000101000001011101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.4305";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010110111000110011010110100010010000011111110101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.4553";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010111010010010001101111011010100000010111011110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.4802";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000010111101011110000001000010010110000001111001000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.5051";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011000000101001110100001001011000000000110110001111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.53";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011000011110101100111010000011001111111110011011011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.5549";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011000111000001011010010111011011111110110000101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.5797";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011001010001101001101011110011101111101101101110101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.6046";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011001101011001000000100101011111111100101011000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.6295";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011010000100100110011101100100001111011101000001101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.6544";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011010011110000100110110011100011111010100101011001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.6792";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011010110111100011001111010100101111001100010100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.7041";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011011010001000001101000001100111111000011111110011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.729";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011011101010100000000001000101001110111011100111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.7539";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011100000011111110011001111101011110110011010001011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.7788";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011100011101011100110010110101101110101010111010111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.8036";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011100110110111011001011101101111110100010100100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.8285";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011101010000011001100100100110001110011010001110001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.8534";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011101101001110111111101011110011110010001110111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.8783";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011110000011010110010110010110101110001001100001001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.9031";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011110011100110100101111001110111110000001001010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.928";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011110110110010011001000000111001101111000110100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.9529";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011111001111110001100000111111011101110000011101111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "1.9778";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000011111101001001111111001110111101101101000000111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.0027";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100000000010101110010010101111111101011111110000111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.0275";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100000011100001100101011101000001101010111011010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.0524";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100000110101101011000100100000011101001111000100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.0773";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100001001111001001011101011000101101000110101101101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.1022";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100001101000100111110110010000111100111110010111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.127";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100010000010000110001111001001001100110110000000101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.1519";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100010011011100100101000000001011100101101101010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.1768";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100010110101000011000000111001101100100101010011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.2017";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100011001110100001011001110001111100011100111101011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.2266";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100011100111111111110010101010001100010100100110111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.2514";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100100000001011110001011100010011100001100010000011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.2763";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100100011010111100100100011010101100000011111010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.3012";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100100110100011010111101010010111011111011100011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.3261";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100101001101111001010110001011001011110011001101001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.3509";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100101100111010111101111000011011011101010110110101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.3758";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100110000000110110000111111011101011100010100000001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.4007";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100110011010010100100000110011111011011010001001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.4256";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100110110011110010111001101100001011010001110011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.4505";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100111001101010001010010100100011011001001011100111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.4753";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000100111100110101111101011011100101011000001000110011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.5002";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101000000000001110000100010100111010111000101111111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.5251";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101000011001101100011101001101001010110000011001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.55";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101000110011001010110110000101011010101000000011001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.5748";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101001001100101001001110111101101010011111101100101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.5997";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101001100110000111100111110101111010010111010110001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.6246";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101001111111100110000000101110001010001110111111101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.6495";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101010011001000100011001100110011010000110101001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.6744";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101010110010100010110010011110101001111110010010111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.6992";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101011001100000001001011010110111001110101111100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.7241";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101011100101011111100100001111001001101101100101111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.749";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101011111110111101111101000111011001100101001111011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.7739";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101100011000011100010101111111101001011100111001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.7987";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101100110001111010101110110111111001010100100010101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.8236";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101101001011011001000111110000001001001100001100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.8485";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101101100100110111100000101000011001000011110101101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.8734";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101101111110010101111001100000101000111011011111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.8983";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101110010111110100010010011000111000110011001000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.9231";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101110110001010010101011010001001000101010110010011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.948";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101111001010110001000100001001011000100010011011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.9729";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101111100100001111011101000001101000011010000101011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "2.9978";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000101111111101101101110101111001111000010001101111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.0226";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110000010111001100001110110010001000001001011000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.0475";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110000110000101010100111101010011000000001000010001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.0724";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110001001010001001000000100010100111111000101011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.0973";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110001100011100111011001011010110111110000010101001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.1222";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110001111101000101110010010011000111100111111110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.147";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110010010110100100001011001011010111011111101000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.1719";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110010110000000010100100000011100111010111010001111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.1968";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110011001001100000111100111011110111001110111011011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.2217";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110011100010111111010101110100000111000110100100111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.2465";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110011111100011101101110101100010110111110001110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.2714";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110100010101111100000111100100100110110101111000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.2963";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110100101111011010100000011100110110101101100001101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.3212";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110101001000111000111001010101000110100101001011001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.3461";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110101100010010111010010001101010110011100110100101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.3709";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110101111011110101101011000101100110010100011110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.3958";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110110010101010100000011111101110110001100000111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.4207";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110110101110110010011100110110000110000011110001011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.4456";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110111001000010000110101101110010101111011011010111000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.4704";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110111100001101111001110100110100101110011000100011000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.4953";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000110111111011001101100111011110110101101010101110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.5202";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111000010100101100000000010111000101100010010111101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.5451";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111000101110001010011001001111010101011010000001001000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.57";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111001000111101000110010000111100101010001101010101000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.5948";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111001100001000111001010111111110101001001010100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.6197";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111001111010100101100011111000000101000000111101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.6446";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111010010100000011111100110000010100111000100111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.6695";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111010101101100010010101101000100100110000010001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.6943";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111011000111000000101110100000110100100111111010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.7192";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111011100000011111000111011001000100011111100100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.7441";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111011111001111101100000010001010100010111001101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.769";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111100010011011011111001001001100100001110110111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.7939";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111100101100111010010010000001110100000110100000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.8187";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111101000110011000101010111010000011111110001010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.8436";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111101011111110111000011110010010011110101110011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.8685";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111101111001010101011100101010100011101101011101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.8934";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111110010010110011110101100010110011100101000110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.9182";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111110101100010010001110011011000011011100110000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.9431";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111111000101110000100111010011010011010100011010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.968";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111111011111001111000000001011100011001100000011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "3.9929";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000000111111111000101101011001000011110011000011101101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.0178";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000000010010001011110001111100000010111011010110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.0426";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000000101011101010001010110100010010110011000000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.0675";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000001000101001000100011101100100010101010101001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.0924";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000001011110100110111100100100110010100010010011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.1173";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000001111000000101010101011101000010011001111100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.1421";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000010010001100011101110010101010010010001100110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.167";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000010101011000010000111001101100010001001010000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.1919";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000011000100100000100000000101110010000000111001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.2168";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000011011101111110111000111110000001111000100011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.2417";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000011110111011101010001110110010001110000001100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.2665";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000100010000111011101010101110100001100111110110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.2914";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000100101010011010000011100110110001011111011111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.3163";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000101000011111000011100011111000001010111001001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.3412";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000101011101010110110101010111010001001110110010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.366";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000101110110110101001110001111100001000110011100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.3909";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000110010000010011100111000111110000111110000101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.4158";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000110101001110010000000000000000000110101101111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.4407";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000111000011010000011000111000010000101101011001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.4656";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000111011100101110110001110000100000100101000010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.4904";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001000111110110001101001010101000110000011100101100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.5153";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001000001111101011100011100001000000010100010101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.5402";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001000101001001001111100011001010000001011111111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.5651";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001001000010101000010101010001100000000011101000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.5899";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001001011100000110101110001001101111111011010010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.6148";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001001110101100101000111000001111111110010111011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.6397";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001010001111000011011111111010001111101010100101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.6646";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001010101000100001111000110010011111100010001111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.6895";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001011000010000000010001101010101111011001111000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.7143";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001011011011011110101010100010111111010001100010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.7392";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001011110100111101000011011011001111001001001011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.7641";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001100001110011011011100010011011111000000110101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.789";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001100100111111001110101001011101110111000011110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.8138";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001101000001011000001110000011111110110000001000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.8387";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001101011010110110100110111100001110100111110010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.8636";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001101110100010100111111110100011110011111011011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.8885";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001110001101110011011000101100101110010111000100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.9134";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001110100111010001110001100100111110001110101110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.9382";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001111000000110000001010011101001110000110011000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.9631";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001111011010001110100011010101011101111110000001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "4.988";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001001111110011101100111100001101101101110101101011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.0129";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010000001101001011010101000101111101101101010100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.0377";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010000100110101001101101111110001101100100111110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.0626";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010001000000001000000110110110011101011100100111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.0875";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010001011001100110011111101110101101010100010001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.1124";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010001110011000100111000100110111101001011111010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.1373";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010010001100100011010001011111001101000011100100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.1621";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010010100110000001101010010111011100111011001110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.187";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010010111111100000000011001111101100110010110111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.2119";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010011011000111110011100000111111100101010100001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.2368";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010011110010011100110101000000001100100010001010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.2616";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010100001011111011001101111000011100011001110100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.2865";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010100100101011001100110110000101100010001011101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.3114";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010100111110110111111111101000111100001001000111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.3363";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010101011000010110011000100001001100000000110000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.3612";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010101110001110100110001011001011011111000011010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.386";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010110001011010011001010010001101011110000000011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.4109";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010110100100110001100011001001111011100111101101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.4358";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010110111110001111111100000010001011011111010111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.4607";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010111010111101110010100111010011011010111000000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.4855";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001010111110001001100101101110010101011001110101010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.5104";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011000001010101011000110101010111011000110010011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.5353";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011000100100001001011111100011001010111101111101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.5602";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011000111101100111111000011011011010110101100110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.5851";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011001010111000110010001010011101010101101010000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.6099";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011001110000100100101010001011111010100100111010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.6348";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011010001010000011000011000100001010011100100011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.6597";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011010100011100001011011111100011010010100001101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.6846";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011010111100111111110100110100101010001011110110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.7094";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011011010110011110001101101100111010000011100000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.7343";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011011101111111100100110100101001001111011001001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.7592";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011100001001011010111111011101011001110010110011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.7841";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011100100010111001011000010101101001101010011100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.809";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011100111100010111110001001101111001100010000110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.8338";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011101010101110110001010000110001001011001101111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.8587";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011101101111010100100010111110011001010001011001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.8836";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011110001000110010111011110110101001001001000011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.9085";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011110100010010001010100101110111001000000101100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.9333";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011110111011101111101101100111001000111000010110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.9582";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011111010101001110000110011111011000101111111111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "5.9831";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001011111101110101100011111010111101000100111101001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.008";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100000001000001010111000001111111000011111010010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.0329";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100000100001101001010001001000001000010110111100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.0577";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100000111011000111101010000000011000001110100101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.0826";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100001010100100110000010111000101000000110001111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.1075";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100001101110000100011011110000110111111101111001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.1324";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100010000111100010110100101001000111110101100010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.1572";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100010100001000001001101100001010111101101001100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.1821";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100010111010011111100110011001100111100100110101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.207";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100011010011111101111111010001110111011100011111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.2319";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100011101101011100011000001010000111010100001000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.2568";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100100000110111010110001000010010111001011110010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.2816";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100100100000011001001001111010100111000011011011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.3065";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100100111001110111100010110010110110111011000101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.3314";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100101010011010101111011101011000110110010101110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.3563";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100101101100110100010100100011010110101010011000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.3811";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100110000110010010101101011011100110100010000010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.406";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100110011111110001000110010011110110011001101011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.4309";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100110111001001111011111001100000110010001010101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.4558";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100111010010101101111000000100010110001000111110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.4807";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001100111101100001100010000111100100110000000101000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.5055";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101000000101101010101001110100110101111000010001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.5304";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101000011111001001000010101101000101101111111011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.5553";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101000111000100111011011100101010101100111100100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.5802";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101001010010000101110100011101100101011111001110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.605";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101001101011100100001101010101110101010110111000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.6299";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101010000101000010100110001110000101001110100001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.6548";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101010011110100000111111000110010101000110001011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.6797";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101010110111111111010111111110100100111101110100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.7046";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101011010001011101110000110110110100110101011110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.7294";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101011101010111100001001101111000100101101000111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.7543";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101100000100011010100010100111010100100100110001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.7792";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101100011101111000111011011111100100011100011011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.8041";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101100110111010111010100010111110100010100000100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.8289";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101101010000110101101101010000000100001011101101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.8538";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101101101010010100000110001000010100000011010111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.8787";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101110000011110010011111000000100011111011000001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.9036";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101110011101010000110111111000110011110010101010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.9285";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101110110110101111010000110001000011101010010100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.9533";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101111010000001101101001101001010011100001111101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "6.9782";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001101111101001101100000010100001100011011001100111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.0031";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110000000011001010011011011001110011010001010000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.028";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110000011100101000110100010010000011001000111010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.0528";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110000110110000111001101001010010011000000100011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.0777";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110001001111100101100110000010100010111000001101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.1026";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110001101001000011111110111010110010101111110111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.1275";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110010000010100010010111110011000010100111100000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.1524";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110010011100000000110000101011010010011111001010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.1772";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110010110101011111001001100011100010010110110011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.2021";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110011001110111101100010011011110010001110011101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.227";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110011101000011011111011010100000010000110000110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.2519";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110100000001111010010100001100010001111101110000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.2767";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110100011011011000101101000100100001110101011010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.3016";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110100110100110111000101111100110001101101000011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.3265";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110101001110010101011110110101000001100100101100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.3514";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110101100111110011110111101101010001011100010110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.3763";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110110000001010010010000100101100001010100000000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.4011";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110110011010110000101001011101110001001011101001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.426";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110110110100001111000010010110000001000011010011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.4509";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110111001101101101011011001110010000111010111100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.4758";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001110111100111001011110100000110100000110010100110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.5006";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111000000000101010001100111110110000101010001111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.5255";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111000011010001000100101110111000000100001111001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.5504";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111000110011100110111110101111010000011001100011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.5753";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111001001101000101010111100111100000010001001100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.6002";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111001100110100011110000011111110000001000110110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.625";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111010000000000010001001011000000000000000011111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.6499";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111010011001100000100010010000001111111000001001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.6748";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111010110010111110111011001000011111101111110010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.6997";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111011001100011101010100000000101111100111011100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.7245";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111011100101111011101100111000111111011111000101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.7494";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111011111111011010000101110001001111010110101111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.7743";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111100011000111000011110101001011111001110011001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.7992";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111100110010010110110111100001101111000110000010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.8241";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111101001011110101010000011001111110111101101100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.8489";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111101100101010011101001010010001110110101010101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.8738";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111101111110110010000010001010011110101100111111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.8987";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111110011000010000011011000010101110100100101000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.9236";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111110110001101110110011111010111110011100010010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.9484";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111111001011001101001100110011001110010011111011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.9733";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111111100100101011100101101011011110001011100101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "7.9982";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000001111111111110001001111110100011101110000011001110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.0231";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000000010111101000010111011011111101111010111000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.048";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000000110001000110110000010100001101110010100010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.0728";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000001001010100101001001001100011101101010001011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.0977";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000001100100000011100010000100101101100001110101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.1226";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000001111101100001111010111100111101011001011110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.1475";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000010010111000000010011110101001101010001001000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.1723";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000010110000011110101100101101011101001000110001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.1972";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000011001001111101000101100101101101000000011011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.2221";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000011100011011011011110011101111100111000000100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.247";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000011111100111001110111010110001100101111101110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.2719";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000100010110011000010000001110011100100111011000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.2967";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000100101111110110101001000110101100011111000001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.3216";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000101001001010101000001111110111100010110101011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.3465";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000101100010110011011010110111001100001110010100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.3714";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000101111100010001110011101111011100000101111110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.3962";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000110010101110000001100100111101011111101100111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.4211";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000110101111001110100101011111111011110101010001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.446";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000111001000101100111110011000001011101100111010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.4709";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000111100010001011010111010000011011100100100100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.4958";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010000111111011101001110000001000101011011100001101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.5206";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001000010101001000001001000000111011010011110111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.5455";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001000101110100110100001111001001011001011100001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.5704";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001001001000000100111010110001011011000011001010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.5953";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001001100001100011010011101001101010111010110100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.6201";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001001111011000001101100100001111010110010011101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.645";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001010010100100000000101011010001010101010000111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.6699";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001010101101111110011110010010011010100001110000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.6948";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001011000111011100110111001010101010011001011010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.7197";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001011100000111011010000000010111010010001000100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.7445";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001011111010011001101000111011001010001000101101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.7694";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001100010011111000000001110011011010000000010110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.7943";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001100101101010110011010101011101001111000000000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.8192";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001101000110110100110011100011111001101111101010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.844";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001101100000010011001100011100001001100111010011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.8689";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001101111001110001100101010100011001011110111101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.8938";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001110010011001111111110001100101001010110100110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.9187";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001110101100101110010111000100111001001110010000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.9436";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001111000110001100101111111101001001000101111001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.9684";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001111011111101011001000110101011000111101100011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "8.9933";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010001111111001001001100001101101101000110101001100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.0182";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010000010010100111111010100101111000101100110110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.0431";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010000101100000110010011011110001000100100100000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.0679";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010001000101100100101100010110011000011100001001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.0928";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010001011111000011000101001110101000010011110011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.1177";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010001111000100001011110000110111000001011011100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.1426";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010010010001111111110110111111001000000011000110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.1675";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010010101011011110001111110111010111111010101111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.1923";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010011000100111100101000101111100111110010011001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.2172";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010011011110011011000001100111110111101010000011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.2421";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010011110111111001011010100000000111100001101100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.267";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010100010001010111110011011000010111011001010101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.2918";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010100101010110110001100010000100111010000111111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.3167";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010101000100010100100101001000110111001000101001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.3416";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010101011101110010111110000001000111000000010010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.3665";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010101110111010001010110111001010110110111111100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.3914";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010110010000101111101111110001100110101111100101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.4162";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010110101010001110001000101001110110100111001111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.4411";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010111000011101100100001100010000110011110111000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.466";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010111011101001010111010011010010110010110100010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.4909";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010010111110110101001010011010010100110001110001100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.5157";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011000010000000111101100001010110110000101110101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.5406";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011000101001100110000101000011000101111101011111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.5655";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011001000011000100011101111011010101110101001000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.5904";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011001011100100010110110110011100101101100110010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.6153";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011001110110000001001111101011110101100100011011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.6401";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011010001111011111101000100100000101011100000101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.665";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011010101000111110000001011100010101010011101110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.6899";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011011000010011100011010010100100101001011011000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.7148";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011011011011111010110011001100110101000011000010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.7396";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011011110101011001001100000101000100111010101011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.7645";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011100001110110111100100111101010100110010010101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.7894";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011100101000010101111101110101100100101001111110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.8143";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011101000001110100010110101101110100100001101000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.8392";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011101011011010010101111100110000100011001010001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.864";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011101110100110001001000011110010100010000111011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.8889";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011110001110001111100001010110100100001000100100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.9138";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011110100111101101111010001110110100000000001110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.9387";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011111000001001100010011000111000011110111110111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.9635";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011111011010101010101011111111010011101111100001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "9.9884";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010011111110100001001000100110111100011100111001011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.0133";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100000001101100111011101101111110011011110110100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.0382";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100000100111000101110110101000000011010110011110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.0631";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100001000000100100001111100000010011001110000111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.0879";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100001011010000010101000011000100011000101110001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.1128";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100001110011100001000001010000110010111101011010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.1377";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100010001100111111011010001001000010110101000100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.1626";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100010100110011101110011000001010010101100101101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.1874";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100010111111111100001011111001100010100100010111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.2123";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100011011001011010100100110001110010011100000001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.2372";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100011110010111000111101101010000010010011101010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.2621";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100100001100010111010110100010010010001011010100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.287";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100100100101110101101111011010100010000010111101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.3118";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100100111111010100001000010010110001111010100111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.3367";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100101011000110010100001001011000001110010010000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.3616";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100101110010010000111010000011010001101001111010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.3865";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100110001011101111010010111011100001100001100011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.4113";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100110100101001101101011110011110001011001001101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.4362";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100110111110101100000100101100000001010000110110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.4611";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100111011000001010011101100100010001001000100000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.486";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010100111110001101000110110011100100001000000001010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.5109";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101000001011000111001111010100110000110111110011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.5357";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101000100100100101101000001101000000101111011101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.5606";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101000111110000100000001000101010000100111000110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.5855";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101001010111100010011001111101100000011110110000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.6104";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101001110001000000110010110101110000010110011001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.6352";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101010001010011111001011101110000000001110000011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.6601";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101010100011111101100100100110010000000101101101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.685";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101010111101011011111101011110011111111101010110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.7099";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101011010110111010010110010110101111110101000000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.7348";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101011110000011000101111001110111111101100101001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.7596";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101100001001110111001000000111001111100100010011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.7845";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101100100011010101100000111111011111011011111100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.8094";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101100111100110011111001110111101111010011100110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.8343";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101101010110010010010010101111111111001011001111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.8591";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101101101111110000101011101000001111000010111001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.884";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101110001001001111000100100000011110111010100010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.9089";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101110100010101101011101011000101110110010001100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.9338";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101110111100001011110110010000111110101001110101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.9587";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101111010101101010001111001001001110100001011111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "10.9835";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010101111101111001000101000000001011110011001001001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.0084";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110000001000100111000000111001101110010000110010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.0333";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110000100010000101011001110001111110001000011100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.0582";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110000111011100011110010101010001110000000000101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.083";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110001010101000010001011100010011101110111101111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.1079";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110001101110100000100100011010101101101111011000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.1328";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110010000111111110111101010010111101100111000010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.1577";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110010100001011101010110001011001101011110101100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.1826";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110010111010111011101111000011011101010110010101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.2074";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110011010100011010000111111011101101001101111111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.2323";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110011101101111000100000110011111101000101101000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.2572";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110100000111010110111001101100001100111101010010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.2821";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110100100000110101010010100100011100110100111011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.3069";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110100111010010011101011011100101100101100100101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.3318";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110101010011110010000100010100111100100100001110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.3567";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110101101101010000011101001101001100011011111000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.3816";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110110000110101110110110000101011100010011100001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.4065";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110110100000001101001110111101101100001011001011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.4313";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110110111001101011100111110101111100000010110101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.4562";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110111010011001010000000101110001011111010011110010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.4811";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010110111101100101000011001100110011011110010001000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.506";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111000000110000110110010011110101011101001110001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.5308";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111000011111100101001011010110111011100001011011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.5557";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111000111001000011100100001111001011011001000100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.5806";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111001010010100001111101000111011011010000101110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.6055";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111001101100000000010101111111101011001000010111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.6304";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111010000101011110101110110111111011000000000001010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.6552";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111010011110111101000111110000001010110111101011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.6801";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111010111000011011100000101000011010101111010100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.705";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111011010001111001111001100000101010100110111110000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.7299";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111011101011011000010010011000111010011110100111100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.7547";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111100000100110110101011010001001010010110010001000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.7796";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111100011110010101000100001001011010001101111010110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.8045";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111100110111110011011101000001101010000101100100010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.8294";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111101010001010001110101111001111001111101001101110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.8543";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111101101010110000001110110010001001110100110111010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.8791";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111110000100001110100111101010011001101100100000110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.904";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111110011101101101000000100010101001100100001010100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.9289";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111110110111001011011001011010111001011011110100000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.9538";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111111010000101001110010010011001001010011011101100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "11.9786";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000010111111101010001000001011001011011001001011000111000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.0035";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000000000011100110100100000011101001000010110000100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.0284";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000000011101000100111100111011111000111010011010010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.0533";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000000110110100011010101110100001000110010000011110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.0782";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000001010000000001101110101100011000101001101101010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.103";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000001101001100000000111100100101000100001010110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.1279";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000010000010111110100000011100111000011001000000010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.1528";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000010011100011100111001010101001000010000101010000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.1777";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000010110101111011010010001101011000001000010011100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.2025";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000011001111011001101011000101100111111111111101000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.2274";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000011101000111000000011111101110111110111100110110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.2523";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000100000010010110011100110110000111101111010000000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.2772";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000100011011110100110101101110010111100110111001110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.3021";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000100110101010011001110100110100111011110100011010000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.3269";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000101001110110001100111011110110111010110001100110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.3518";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000101101000010000000000010111000111001101110110100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.3767";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000110000001101110011001001111010111000101011111110000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.4016";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000110011011001100110010000111100110111101001001100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

	--input <= "12.4264";
	input_tb <= "00000000000000000000000000000000000000000000000000000000000011000110110100101011001010111111110110110100110011000000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait until done_tb = '1'; wait for 20 ns;
	write(L1,output_tb);
	writeline(test_out_data1,L1);

stop(0);
end process;
end Behavioral;
