library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use std.textio.all;
use ieee.std_logic_textio.all;
library std;
use std.env.all;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity Fixed_FullCORDIC_Generic_tb is
end Fixed_FullCORDIC_Generic_tb;

architecture Behavioral of Fixed_FullCORDIC_Generic_tb is
component FXCordic_Expanded is
	Generic ( filename1 : string; filename2 : string; dataWidth : integer; iterWidth : integer;
		N : integer; M : integer );
	Port ( clk, start, mode : in STD_LOGIC;
		x0 : in STD_LOGIC_VECTOR (dataWidth-1 downto 0);
		y0 : in STD_LOGIC_VECTOR (dataWidth-1 downto 0);
		z0 : in STD_LOGIC_VECTOR (dataWidth-1 downto 0);
		xOut : out STD_LOGIC_VECTOR (dataWidth-1 downto 0);
		yOut : out STD_LOGIC_VECTOR (dataWidth-1 downto 0);
		zOut : out STD_LOGIC_VECTOR (dataWidth-1 downto 0);
		done : out STD_LOGIC );
end component;

constant fileName1 : string := "32_32BitExpandedLUT_Fixed.txt";
constant fileName2 : string := "32_32BitLUT_Fixed.txt";
constant dataWidth : integer := 64;
constant iterWidth : integer := 6;
constant N : integer := 32;
constant M : integer := 5;

signal clk_tb, start_tb, mode_tb, done : std_logic;
signal x0, y0, z0, xn, yn, zn : std_logic_vector (dataWidth-1 downto 0);

begin
	myCORDIC : FXCordic_Expanded Generic Map(fileName1 => fileName1, fileName2 => fileName2,
			dataWidth => dataWidth, iterWidth => iterWidth, M => M, N => N)
		Port Map(clk_tb, start_tb, mode_tb, x0, y0, z0, xn, yn, zn, done);

clock : process begin
	clk_tb <= '0'; wait for 1 ns;
	clk_tb <= '1'; wait for 1 ns;
end process;

testProc : process
	FILE test_out_data1: TEXT open WRITE_MODE is "32iterations64bits_cosh_fixed.txt";
	FILE test_out_data2: TEXT open WRITE_MODE is "32iterations64bits_sinh_fixed.txt";
	variable L1 : LINE;
	variable L2 : LINE;

begin

--------------------------Rotation Mode Tests-----------------------------
	mode_tb <= '0';
	-- The main pieces that need to be in place to get nonscaled, separated values of Cosh and Sinh.
	-- x0 := 1988.7411;
	x0 <= "0000000000000000000001111100010010111101101101111100000011101110";
	-- y0 := 0
	y0 <= "0000000000000000000000000000000000000000000000000000000000000000";


	--z0 <= "-12.4264";
	z0 <= "1111111111111111111111111111001110010010110101001101010000000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.4016";
	z0 <= "1111111111111111111111111111001110011001001100110011011110000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.3767";
	z0 <= "1111111111111111111111111111001110011111100100011001101100001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.3518";
	z0 <= "1111111111111111111111111111001110100101111011111111111010001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.3269";
	z0 <= "1111111111111111111111111111001110101100010011100110001000010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.3021";
	z0 <= "1111111111111111111111111111001110110010101011001100010110010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.2772";
	z0 <= "1111111111111111111111111111001110111001000010110010100100011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.2523";
	z0 <= "1111111111111111111111111111001110111111011010011000110010011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.2274";
	z0 <= "1111111111111111111111111111001111000101110001111111000000100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.2025";
	z0 <= "1111111111111111111111111111001111001100001001100101001110100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.1777";
	z0 <= "1111111111111111111111111111001111010010100001001011011100101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.1528";
	z0 <= "1111111111111111111111111111001111011000111000110001101010101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.1279";
	z0 <= "1111111111111111111111111111001111011111010000010111111000110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.103";
	z0 <= "1111111111111111111111111111001111100101100111111110000110110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.0782";
	z0 <= "1111111111111111111111111111001111101011111111100100010100111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.0533";
	z0 <= "1111111111111111111111111111001111110010010111001010100010111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.0284";
	z0 <= "1111111111111111111111111111001111111000101110110000110001000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-12.0035";
	z0 <= "1111111111111111111111111111001111111111000110010110111111000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.9786";
	z0 <= "1111111111111111111111111111010000000101011101111101001101001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.9538";
	z0 <= "1111111111111111111111111111010000001011110101100011011011001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.9289";
	z0 <= "1111111111111111111111111111010000010010001101001001101001010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.904";
	z0 <= "1111111111111111111111111111010000011000100100101111110111010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.8791";
	z0 <= "1111111111111111111111111111010000011110111100010110000101011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.8543";
	z0 <= "1111111111111111111111111111010000100101010011111100010011011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.8294";
	z0 <= "1111111111111111111111111111010000101011101011100010100001100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.8045";
	z0 <= "1111111111111111111111111111010000110010000011001000101111100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.7796";
	z0 <= "1111111111111111111111111111010000111000011010101110111101101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.7547";
	z0 <= "1111111111111111111111111111010000111110110010010101001011101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.7299";
	z0 <= "1111111111111111111111111111010001000101001001111011011001110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.705";
	z0 <= "1111111111111111111111111111010001001011100001100001100111110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.6801";
	z0 <= "1111111111111111111111111111010001010001111001000111110101111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.6552";
	z0 <= "1111111111111111111111111111010001011000010000101110000011111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.6304";
	z0 <= "1111111111111111111111111111010001011110101000010100010010000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.6055";
	z0 <= "1111111111111111111111111111010001100100111111111010100000000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.5806";
	z0 <= "1111111111111111111111111111010001101011010111100000101110001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.5557";
	z0 <= "1111111111111111111111111111010001110001101111000110111100001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.5308";
	z0 <= "1111111111111111111111111111010001111000000110101101001010010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.506";
	z0 <= "1111111111111111111111111111010001111110011110010011011000010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.4811";
	z0 <= "1111111111111111111111111111010010000100110101111001100110011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.4562";
	z0 <= "1111111111111111111111111111010010001011001101011111110100011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.4313";
	z0 <= "1111111111111111111111111111010010010001100101000110000010100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.4065";
	z0 <= "1111111111111111111111111111010010010111111100101100010000100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.3816";
	z0 <= "1111111111111111111111111111010010011110010100010010011110101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.3567";
	z0 <= "1111111111111111111111111111010010100100101011111000101100101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.3318";
	z0 <= "1111111111111111111111111111010010101011000011011110111010110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.3069";
	z0 <= "1111111111111111111111111111010010110001011011000101001000110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.2821";
	z0 <= "1111111111111111111111111111010010110111110010101011010110111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.2572";
	z0 <= "1111111111111111111111111111010010111110001010010001100100111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.2323";
	z0 <= "1111111111111111111111111111010011000100100001110111110011000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.2074";
	z0 <= "1111111111111111111111111111010011001010111001011110000001000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.1826";
	z0 <= "1111111111111111111111111111010011010001010001000100001111001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.1577";
	z0 <= "1111111111111111111111111111010011010111101000101010011101001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.1328";
	z0 <= "1111111111111111111111111111010011011110000000010000101011010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.1079";
	z0 <= "1111111111111111111111111111010011100100010111110110111001010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.083";
	z0 <= "1111111111111111111111111111010011101010101111011101000111011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.0582";
	z0 <= "1111111111111111111111111111010011110001000111000011010101011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.0333";
	z0 <= "1111111111111111111111111111010011110111011110101001100011100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-11.0084";
	z0 <= "1111111111111111111111111111010011111101110110001111110001100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.9835";
	z0 <= "1111111111111111111111111111010100000100001101110101111111101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.9587";
	z0 <= "1111111111111111111111111111010100001010100101011100001101101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.9338";
	z0 <= "1111111111111111111111111111010100010000111101000010011011110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.9089";
	z0 <= "1111111111111111111111111111010100010111010100101000101001110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.884";
	z0 <= "1111111111111111111111111111010100011101101100001110110111111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.8591";
	z0 <= "1111111111111111111111111111010100100100000011110101000101111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.8343";
	z0 <= "1111111111111111111111111111010100101010011011011011010100000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.8094";
	z0 <= "1111111111111111111111111111010100110000110011000001100010000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.7845";
	z0 <= "1111111111111111111111111111010100110111001010100111110000001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.7596";
	z0 <= "1111111111111111111111111111010100111101100010001101111110001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.7348";
	z0 <= "1111111111111111111111111111010101000011111001110100001100010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.7099";
	z0 <= "1111111111111111111111111111010101001010010001011010011010010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.685";
	z0 <= "1111111111111111111111111111010101010000101001000000101000011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.6601";
	z0 <= "1111111111111111111111111111010101010111000000100110110110011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.6352";
	z0 <= "1111111111111111111111111111010101011101011000001101000100011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.6104";
	z0 <= "1111111111111111111111111111010101100011101111110011010010100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.5855";
	z0 <= "1111111111111111111111111111010101101010000111011001100000100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.5606";
	z0 <= "1111111111111111111111111111010101110000011110111111101110101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.5357";
	z0 <= "1111111111111111111111111111010101110110110110100101111100101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.5109";
	z0 <= "1111111111111111111111111111010101111101001110001100001010110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.486";
	z0 <= "1111111111111111111111111111010110000011100101110010011000110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.4611";
	z0 <= "1111111111111111111111111111010110001001111101011000100110111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.4362";
	z0 <= "1111111111111111111111111111010110010000010100111110110100111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.4113";
	z0 <= "1111111111111111111111111111010110010110101100100101000011000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.3865";
	z0 <= "1111111111111111111111111111010110011101000100001011010001000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.3616";
	z0 <= "1111111111111111111111111111010110100011011011110001011111001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.3367";
	z0 <= "1111111111111111111111111111010110101001110011010111101101001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.3118";
	z0 <= "1111111111111111111111111111010110110000001010111101111011010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.287";
	z0 <= "1111111111111111111111111111010110110110100010100100001001010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.2621";
	z0 <= "1111111111111111111111111111010110111100111010001010010111011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.2372";
	z0 <= "1111111111111111111111111111010111000011010001110000100101011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.2123";
	z0 <= "1111111111111111111111111111010111001001101001010110110011100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.1874";
	z0 <= "1111111111111111111111111111010111010000000000111101000001100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.1626";
	z0 <= "1111111111111111111111111111010111010110011000100011001111101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.1377";
	z0 <= "1111111111111111111111111111010111011100110000001001011101101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.1128";
	z0 <= "1111111111111111111111111111010111100011000111101111101011110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.0879";
	z0 <= "1111111111111111111111111111010111101001011111010101111001110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.0631";
	z0 <= "1111111111111111111111111111010111101111110110111100000111111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.0382";
	z0 <= "1111111111111111111111111111010111110110001110100010010101111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-10.0133";
	z0 <= "1111111111111111111111111111010111111100100110001000100100000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.9884";
	z0 <= "1111111111111111111111111111011000000010111101101110110010000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.9635";
	z0 <= "1111111111111111111111111111011000001001010101010101000000001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.9387";
	z0 <= "1111111111111111111111111111011000001111101100111011001110001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.9138";
	z0 <= "1111111111111111111111111111011000010110000100100001011100010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.8889";
	z0 <= "1111111111111111111111111111011000011100011100000111101010010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.864";
	z0 <= "1111111111111111111111111111011000100010110011101101111000011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.8392";
	z0 <= "1111111111111111111111111111011000101001001011010100000110011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.8143";
	z0 <= "1111111111111111111111111111011000101111100010111010010100100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.7894";
	z0 <= "1111111111111111111111111111011000110101111010100000100010100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.7645";
	z0 <= "1111111111111111111111111111011000111100010010000110110000101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.7396";
	z0 <= "1111111111111111111111111111011001000010101001101100111110101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.7148";
	z0 <= "1111111111111111111111111111011001001001000001010011001100110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.6899";
	z0 <= "1111111111111111111111111111011001001111011000111001011010110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.665";
	z0 <= "1111111111111111111111111111011001010101110000011111101000111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.6401";
	z0 <= "1111111111111111111111111111011001011100001000000101110110111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.6153";
	z0 <= "1111111111111111111111111111011001100010011111101100000101000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.5904";
	z0 <= "1111111111111111111111111111011001101000110111010010010011000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.5655";
	z0 <= "1111111111111111111111111111011001101111001110111000100001001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.5406";
	z0 <= "1111111111111111111111111111011001110101100110011110101111001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.5157";
	z0 <= "1111111111111111111111111111011001111011111110000100111101010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.4909";
	z0 <= "1111111111111111111111111111011010000010010101101011001011010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.466";
	z0 <= "1111111111111111111111111111011010001000101101010001011001011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.4411";
	z0 <= "1111111111111111111111111111011010001111000100110111100111011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.4162";
	z0 <= "1111111111111111111111111111011010010101011100011101110101100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.3914";
	z0 <= "1111111111111111111111111111011010011011110100000100000011100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.3665";
	z0 <= "1111111111111111111111111111011010100010001011101010010001101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.3416";
	z0 <= "1111111111111111111111111111011010101000100011010000011111101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.3167";
	z0 <= "1111111111111111111111111111011010101110111010110110101101110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.2918";
	z0 <= "1111111111111111111111111111011010110101010010011100111011110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.267";
	z0 <= "1111111111111111111111111111011010111011101010000011001001111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.2421";
	z0 <= "1111111111111111111111111111011011000010000001101001010111111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.2172";
	z0 <= "1111111111111111111111111111011011001000011001001111100110000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.1923";
	z0 <= "1111111111111111111111111111011011001110110000110101110100000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.1675";
	z0 <= "1111111111111111111111111111011011010101001000011100000010001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.1426";
	z0 <= "1111111111111111111111111111011011011011100000000010010000001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.1177";
	z0 <= "1111111111111111111111111111011011100001110111101000011110010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.0928";
	z0 <= "1111111111111111111111111111011011101000001111001110101100010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.0679";
	z0 <= "1111111111111111111111111111011011101110100110110100111010011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.0431";
	z0 <= "1111111111111111111111111111011011110100111110011011001000011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-9.0182";
	z0 <= "1111111111111111111111111111011011111011010110000001010110100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.9933";
	z0 <= "1111111111111111111111111111011100000001101101100111100100100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.9684";
	z0 <= "1111111111111111111111111111011100001000000101001101110010101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.9436";
	z0 <= "1111111111111111111111111111011100001110011100110100000000101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.9187";
	z0 <= "1111111111111111111111111111011100010100110100011010001110110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.8938";
	z0 <= "1111111111111111111111111111011100011011001100000000011100110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.8689";
	z0 <= "1111111111111111111111111111011100100001100011100110101010111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.844";
	z0 <= "1111111111111111111111111111011100100111111011001100111000111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.8192";
	z0 <= "1111111111111111111111111111011100101110010010110011000111000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.7943";
	z0 <= "1111111111111111111111111111011100110100101010011001010101000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.7694";
	z0 <= "1111111111111111111111111111011100111011000001111111100011001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.7445";
	z0 <= "1111111111111111111111111111011101000001011001100101110001001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.7197";
	z0 <= "1111111111111111111111111111011101000111110001001011111111010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.6948";
	z0 <= "1111111111111111111111111111011101001110001000110010001101010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.6699";
	z0 <= "1111111111111111111111111111011101010100100000011000011011011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.645";
	z0 <= "1111111111111111111111111111011101011010110111111110101001011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.6201";
	z0 <= "1111111111111111111111111111011101100001001111100100110111100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.5953";
	z0 <= "1111111111111111111111111111011101100111100111001011000101100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.5704";
	z0 <= "1111111111111111111111111111011101101101111110110001010011101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.5455";
	z0 <= "1111111111111111111111111111011101110100010110010111100001101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.5206";
	z0 <= "1111111111111111111111111111011101111010101101111101101111110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.4958";
	z0 <= "1111111111111111111111111111011110000001000101100011111101110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.4709";
	z0 <= "1111111111111111111111111111011110000111011101001010001011111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.446";
	z0 <= "1111111111111111111111111111011110001101110100110000011001111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.4211";
	z0 <= "1111111111111111111111111111011110010100001100010110101000000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.3962";
	z0 <= "1111111111111111111111111111011110011010100011111100110110000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.3714";
	z0 <= "1111111111111111111111111111011110100000111011100011000100001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.3465";
	z0 <= "1111111111111111111111111111011110100111010011001001010010001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.3216";
	z0 <= "1111111111111111111111111111011110101101101010101111100000010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.2967";
	z0 <= "1111111111111111111111111111011110110100000010010101101110010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.2719";
	z0 <= "1111111111111111111111111111011110111010011001111011111100011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.247";
	z0 <= "1111111111111111111111111111011111000000110001100010001010011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.2221";
	z0 <= "1111111111111111111111111111011111000111001001001000011000100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.1972";
	z0 <= "1111111111111111111111111111011111001101100000101110100110100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.1723";
	z0 <= "1111111111111111111111111111011111010011111000010100110100101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.1475";
	z0 <= "1111111111111111111111111111011111011010001111111011000010101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.1226";
	z0 <= "1111111111111111111111111111011111100000100111100001010000110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.0977";
	z0 <= "1111111111111111111111111111011111100110111111000111011110110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.0728";
	z0 <= "1111111111111111111111111111011111101101010110101101101100111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.048";
	z0 <= "1111111111111111111111111111011111110011101110010011111010111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-8.0231";
	z0 <= "1111111111111111111111111111011111111010000101111010001001000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.9982";
	z0 <= "1111111111111111111111111111100000000000011101100000010111000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.9733";
	z0 <= "1111111111111111111111111111100000000110110101000110100101001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.9484";
	z0 <= "1111111111111111111111111111100000001101001100101100110011001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.9236";
	z0 <= "1111111111111111111111111111100000010011100100010011000001010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.8987";
	z0 <= "1111111111111111111111111111100000011001111011111001001111010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.8738";
	z0 <= "1111111111111111111111111111100000100000010011011111011101011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.8489";
	z0 <= "1111111111111111111111111111100000100110101011000101101011011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.8241";
	z0 <= "1111111111111111111111111111100000101101000010101011111001100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.7992";
	z0 <= "1111111111111111111111111111100000110011011010010010000111100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.7743";
	z0 <= "1111111111111111111111111111100000111001110001111000010101101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.7494";
	z0 <= "1111111111111111111111111111100001000000001001011110100011101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.7245";
	z0 <= "1111111111111111111111111111100001000110100001000100110001110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.6997";
	z0 <= "1111111111111111111111111111100001001100111000101010111111110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.6748";
	z0 <= "1111111111111111111111111111100001010011010000010001001101111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.6499";
	z0 <= "1111111111111111111111111111100001011001100111110111011011111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.625";
	z0 <= "1111111111111111111111111111100001011111111111011101101001111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.6002";
	z0 <= "1111111111111111111111111111100001100110010111000011111000000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.5753";
	z0 <= "1111111111111111111111111111100001101100101110101010000110000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.5504";
	z0 <= "1111111111111111111111111111100001110011000110010000010100001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.5255";
	z0 <= "1111111111111111111111111111100001111001011101110110100010001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.5006";
	z0 <= "1111111111111111111111111111100001111111110101011100110000010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.4758";
	z0 <= "1111111111111111111111111111100010000110001101000010111110010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.4509";
	z0 <= "1111111111111111111111111111100010001100100100101001001100011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.426";
	z0 <= "1111111111111111111111111111100010010010111100001111011010011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.4011";
	z0 <= "1111111111111111111111111111100010011001010011110101101000100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.3763";
	z0 <= "1111111111111111111111111111100010011111101011011011110110100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.3514";
	z0 <= "1111111111111111111111111111100010100110000011000010000100101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.3265";
	z0 <= "1111111111111111111111111111100010101100011010101000010010101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.3016";
	z0 <= "1111111111111111111111111111100010110010110010001110100000110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.2767";
	z0 <= "1111111111111111111111111111100010111001001001110100101110110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.2519";
	z0 <= "1111111111111111111111111111100010111111100001011010111100111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.227";
	z0 <= "1111111111111111111111111111100011000101111001000001001010111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.2021";
	z0 <= "1111111111111111111111111111100011001100010000100111011001000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.1772";
	z0 <= "1111111111111111111111111111100011010010101000001101100111000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.1524";
	z0 <= "1111111111111111111111111111100011011000111111110011110101001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.1275";
	z0 <= "1111111111111111111111111111100011011111010111011010000011001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.1026";
	z0 <= "1111111111111111111111111111100011100101101111000000010001010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.0777";
	z0 <= "1111111111111111111111111111100011101100000110100110011111010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.0528";
	z0 <= "1111111111111111111111111111100011110010011110001100101101011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.028";
	z0 <= "1111111111111111111111111111100011111000110101110010111011011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-7.0031";
	z0 <= "1111111111111111111111111111100011111111001101011001001001100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.9782";
	z0 <= "1111111111111111111111111111100100000101100100111111010111100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.9533";
	z0 <= "1111111111111111111111111111100100001011111100100101100101101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.9285";
	z0 <= "1111111111111111111111111111100100010010010100001011110011101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.9036";
	z0 <= "1111111111111111111111111111100100011000101011110010000001110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.8787";
	z0 <= "1111111111111111111111111111100100011111000011011000001111110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.8538";
	z0 <= "1111111111111111111111111111100100100101011010111110011101111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.8289";
	z0 <= "1111111111111111111111111111100100101011110010100100101011111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.8041";
	z0 <= "1111111111111111111111111111100100110010001010001010111010000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.7792";
	z0 <= "1111111111111111111111111111100100111000100001110001001000000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.7543";
	z0 <= "1111111111111111111111111111100100111110111001010111010110001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.7294";
	z0 <= "1111111111111111111111111111100101000101010000111101100100001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.7046";
	z0 <= "1111111111111111111111111111100101001011101000100011110010010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.6797";
	z0 <= "1111111111111111111111111111100101010010000000001010000000010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.6548";
	z0 <= "1111111111111111111111111111100101011000010111110000001110011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.6299";
	z0 <= "1111111111111111111111111111100101011110101111010110011100011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.605";
	z0 <= "1111111111111111111111111111100101100101000110111100101010100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.5802";
	z0 <= "1111111111111111111111111111100101101011011110100010111000100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.5553";
	z0 <= "1111111111111111111111111111100101110001110110001001000110101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.5304";
	z0 <= "1111111111111111111111111111100101111000001101101111010100101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.5055";
	z0 <= "1111111111111111111111111111100101111110100101010101100010110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.4807";
	z0 <= "1111111111111111111111111111100110000100111100111011110000110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.4558";
	z0 <= "1111111111111111111111111111100110001011010100100001111110111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.4309";
	z0 <= "1111111111111111111111111111100110010001101100001000001100111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.406";
	z0 <= "1111111111111111111111111111100110011000000011101110011011000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.3811";
	z0 <= "1111111111111111111111111111100110011110011011010100101001000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.3563";
	z0 <= "1111111111111111111111111111100110100100110010111010110111001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.3314";
	z0 <= "1111111111111111111111111111100110101011001010100001000101001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.3065";
	z0 <= "1111111111111111111111111111100110110001100010000111010011010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.2816";
	z0 <= "1111111111111111111111111111100110110111111001101101100001010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.2568";
	z0 <= "1111111111111111111111111111100110111110010001010011101111011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.2319";
	z0 <= "1111111111111111111111111111100111000100101000111001111101011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.207";
	z0 <= "1111111111111111111111111111100111001011000000100000001011100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.1821";
	z0 <= "1111111111111111111111111111100111010001011000000110011001100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.1572";
	z0 <= "1111111111111111111111111111100111010111101111101100100111101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.1324";
	z0 <= "1111111111111111111111111111100111011110000111010010110101101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.1075";
	z0 <= "1111111111111111111111111111100111100100011110111001000011110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.0826";
	z0 <= "1111111111111111111111111111100111101010110110011111010001110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.0577";
	z0 <= "1111111111111111111111111111100111110001001110000101011111111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.0329";
	z0 <= "1111111111111111111111111111100111110111100101101011101101111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-6.008";
	z0 <= "1111111111111111111111111111100111111101111101010001111100000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.9831";
	z0 <= "1111111111111111111111111111101000000100010100111000001010000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.9582";
	z0 <= "1111111111111111111111111111101000001010101100011110011000001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.9333";
	z0 <= "1111111111111111111111111111101000010001000100000100100110001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.9085";
	z0 <= "1111111111111111111111111111101000010111011011101010110100010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.8836";
	z0 <= "1111111111111111111111111111101000011101110011010001000010010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.8587";
	z0 <= "1111111111111111111111111111101000100100001010110111010000011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.8338";
	z0 <= "1111111111111111111111111111101000101010100010011101011110011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.809";
	z0 <= "1111111111111111111111111111101000110000111010000011101100100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.7841";
	z0 <= "1111111111111111111111111111101000110111010001101001111010100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.7592";
	z0 <= "1111111111111111111111111111101000111101101001010000001000101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.7343";
	z0 <= "1111111111111111111111111111101001000100000000110110010110101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.7094";
	z0 <= "1111111111111111111111111111101001001010011000011100100100110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.6846";
	z0 <= "1111111111111111111111111111101001010000110000000010110010110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.6597";
	z0 <= "1111111111111111111111111111101001010111000111101001000000111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.6348";
	z0 <= "1111111111111111111111111111101001011101011111001111001110111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.6099";
	z0 <= "1111111111111111111111111111101001100011110110110101011101000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.5851";
	z0 <= "1111111111111111111111111111101001101010001110011011101011000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.5602";
	z0 <= "1111111111111111111111111111101001110000100110000001111001001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.5353";
	z0 <= "1111111111111111111111111111101001110110111101101000000111001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.5104";
	z0 <= "1111111111111111111111111111101001111101010101001110010101010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.4855";
	z0 <= "1111111111111111111111111111101010000011101100110100100011010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.4607";
	z0 <= "1111111111111111111111111111101010001010000100011010110001011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.4358";
	z0 <= "1111111111111111111111111111101010010000011100000000111111011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.4109";
	z0 <= "1111111111111111111111111111101010010110110011100111001101100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.386";
	z0 <= "1111111111111111111111111111101010011101001011001101011011100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.3612";
	z0 <= "1111111111111111111111111111101010100011100010110011101001101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.3363";
	z0 <= "1111111111111111111111111111101010101001111010011001110111101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.3114";
	z0 <= "1111111111111111111111111111101010110000010010000000000101110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.2865";
	z0 <= "1111111111111111111111111111101010110110101001100110010011110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.2616";
	z0 <= "1111111111111111111111111111101010111101000001001100100001111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.2368";
	z0 <= "1111111111111111111111111111101011000011011000110010101111111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.2119";
	z0 <= "1111111111111111111111111111101011001001110000011000111110000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.187";
	z0 <= "1111111111111111111111111111101011010000000111111111001100000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.1621";
	z0 <= "1111111111111111111111111111101011010110011111100101011010001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.1373";
	z0 <= "1111111111111111111111111111101011011100110111001011101000001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.1124";
	z0 <= "1111111111111111111111111111101011100011001110110001110110010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.0875";
	z0 <= "1111111111111111111111111111101011101001100110011000000100010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.0626";
	z0 <= "1111111111111111111111111111101011101111111101111110010010011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.0377";
	z0 <= "1111111111111111111111111111101011110110010101100100100000011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-5.0129";
	z0 <= "1111111111111111111111111111101011111100101101001010101110100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.988";
	z0 <= "1111111111111111111111111111101100000011000100110000111100100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.9631";
	z0 <= "1111111111111111111111111111101100001001011100010111001010101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.9382";
	z0 <= "1111111111111111111111111111101100001111110011111101011000101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.9134";
	z0 <= "1111111111111111111111111111101100010110001011100011100110110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.8885";
	z0 <= "1111111111111111111111111111101100011100100011001001110100110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.8636";
	z0 <= "1111111111111111111111111111101100100010111010110000000010111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.8387";
	z0 <= "1111111111111111111111111111101100101001010010010110010000111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.8138";
	z0 <= "1111111111111111111111111111101100101111101001111100011111000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.789";
	z0 <= "1111111111111111111111111111101100110110000001100010101101000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.7641";
	z0 <= "1111111111111111111111111111101100111100011001001000111011001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.7392";
	z0 <= "1111111111111111111111111111101101000010110000101111001001001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.7143";
	z0 <= "1111111111111111111111111111101101001001001000010101010111010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.6895";
	z0 <= "1111111111111111111111111111101101001111011111111011100101010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.6646";
	z0 <= "1111111111111111111111111111101101010101110111100001110011011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.6397";
	z0 <= "1111111111111111111111111111101101011100001111001000000001011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.6148";
	z0 <= "1111111111111111111111111111101101100010100110101110001111100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.5899";
	z0 <= "1111111111111111111111111111101101101000111110010100011101100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.5651";
	z0 <= "1111111111111111111111111111101101101111010101111010101011100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.5402";
	z0 <= "1111111111111111111111111111101101110101101101100000111001101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.5153";
	z0 <= "1111111111111111111111111111101101111100000101000111000111101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.4904";
	z0 <= "1111111111111111111111111111101110000010011100101101010101110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.4656";
	z0 <= "1111111111111111111111111111101110001000110100010011100011110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.4407";
	z0 <= "1111111111111111111111111111101110001111001011111001110001111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.4158";
	z0 <= "1111111111111111111111111111101110010101100011011111111111111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.3909";
	z0 <= "1111111111111111111111111111101110011011111011000110001110000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.366";
	z0 <= "1111111111111111111111111111101110100010010010101100011100000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.3412";
	z0 <= "1111111111111111111111111111101110101000101010010010101010001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.3163";
	z0 <= "1111111111111111111111111111101110101111000001111000111000001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.2914";
	z0 <= "1111111111111111111111111111101110110101011001011111000110010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.2665";
	z0 <= "1111111111111111111111111111101110111011110001000101010100010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.2417";
	z0 <= "1111111111111111111111111111101111000010001000101011100010011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.2168";
	z0 <= "1111111111111111111111111111101111001000100000010001110000011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.1919";
	z0 <= "1111111111111111111111111111101111001110110111110111111110100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.167";
	z0 <= "1111111111111111111111111111101111010101001111011110001100100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.1421";
	z0 <= "1111111111111111111111111111101111011011100111000100011010101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.1173";
	z0 <= "1111111111111111111111111111101111100001111110101010101000101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.0924";
	z0 <= "1111111111111111111111111111101111101000010110010000110110110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.0675";
	z0 <= "1111111111111111111111111111101111101110101101110111000100110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.0426";
	z0 <= "1111111111111111111111111111101111110101000101011101010010111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-4.0178";
	z0 <= "1111111111111111111111111111101111111011011101000011100000111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.9929";
	z0 <= "1111111111111111111111111111110000000001110100101001101111000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.968";
	z0 <= "1111111111111111111111111111110000001000001100001111111101000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.9431";
	z0 <= "1111111111111111111111111111110000001110100011110110001011001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.9182";
	z0 <= "1111111111111111111111111111110000010100111011011100011001001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.8934";
	z0 <= "1111111111111111111111111111110000011011010011000010100111010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.8685";
	z0 <= "1111111111111111111111111111110000100001101010101000110101010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.8436";
	z0 <= "1111111111111111111111111111110000101000000010001111000011011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.8187";
	z0 <= "1111111111111111111111111111110000101110011001110101010001011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.7939";
	z0 <= "1111111111111111111111111111110000110100110001011011011111100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.769";
	z0 <= "1111111111111111111111111111110000111011001001000001101101100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.7441";
	z0 <= "1111111111111111111111111111110001000001100000100111111011101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.7192";
	z0 <= "1111111111111111111111111111110001000111111000001110001001101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.6943";
	z0 <= "1111111111111111111111111111110001001110001111110100010111110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.6695";
	z0 <= "1111111111111111111111111111110001010100100111011010100101110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.6446";
	z0 <= "1111111111111111111111111111110001011010111111000000110011111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.6197";
	z0 <= "1111111111111111111111111111110001100001010110100111000001111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.5948";
	z0 <= "1111111111111111111111111111110001100111101110001101010000000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.57";
	z0 <= "1111111111111111111111111111110001101110000101110011011110000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.5451";
	z0 <= "1111111111111111111111111111110001110100011101011001101100001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.5202";
	z0 <= "1111111111111111111111111111110001111010110100111111111010001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.4953";
	z0 <= "1111111111111111111111111111110010000001001100100110001000010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.4704";
	z0 <= "1111111111111111111111111111110010000111100100001100010110010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.4456";
	z0 <= "1111111111111111111111111111110010001101111011110010100100011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.4207";
	z0 <= "1111111111111111111111111111110010010100010011011000110010011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.3958";
	z0 <= "1111111111111111111111111111110010011010101010111111000000100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.3709";
	z0 <= "1111111111111111111111111111110010100001000010100101001110100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.3461";
	z0 <= "1111111111111111111111111111110010100111011010001011011100101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.3212";
	z0 <= "1111111111111111111111111111110010101101110001110001101010101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.2963";
	z0 <= "1111111111111111111111111111110010110100001001010111111000110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.2714";
	z0 <= "1111111111111111111111111111110010111010100000111110000110110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.2465";
	z0 <= "1111111111111111111111111111110011000000111000100100010100111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.2217";
	z0 <= "1111111111111111111111111111110011000111010000001010100010111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.1968";
	z0 <= "1111111111111111111111111111110011001101100111110000110001000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.1719";
	z0 <= "1111111111111111111111111111110011010011111111010110111111000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.147";
	z0 <= "1111111111111111111111111111110011011010010110111101001101001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.1222";
	z0 <= "1111111111111111111111111111110011100000101110100011011011001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.0973";
	z0 <= "1111111111111111111111111111110011100111000110001001101001010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.0724";
	z0 <= "1111111111111111111111111111110011101101011101101111110111010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.0475";
	z0 <= "1111111111111111111111111111110011110011110101010110000101011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-3.0226";
	z0 <= "1111111111111111111111111111110011111010001100111100010011011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.9978";
	z0 <= "1111111111111111111111111111110100000000100100100010100001100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.9729";
	z0 <= "1111111111111111111111111111110100000110111100001000101111100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.948";
	z0 <= "1111111111111111111111111111110100001101010011101110111101101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.9231";
	z0 <= "1111111111111111111111111111110100010011101011010101001011101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.8983";
	z0 <= "1111111111111111111111111111110100011010000010111011011001110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.8734";
	z0 <= "1111111111111111111111111111110100100000011010100001100111110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.8485";
	z0 <= "1111111111111111111111111111110100100110110010000111110101111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.8236";
	z0 <= "1111111111111111111111111111110100101101001001101110000011111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.7987";
	z0 <= "1111111111111111111111111111110100110011100001010100010010000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.7739";
	z0 <= "1111111111111111111111111111110100111001111000111010100000000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.749";
	z0 <= "1111111111111111111111111111110101000000010000100000101110001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.7241";
	z0 <= "1111111111111111111111111111110101000110101000000110111100001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.6992";
	z0 <= "1111111111111111111111111111110101001100111111101101001010010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.6744";
	z0 <= "1111111111111111111111111111110101010011010111010011011000010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.6495";
	z0 <= "1111111111111111111111111111110101011001101110111001100110011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.6246";
	z0 <= "1111111111111111111111111111110101100000000110011111110100011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.5997";
	z0 <= "1111111111111111111111111111110101100110011110000110000010100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.5748";
	z0 <= "1111111111111111111111111111110101101100110101101100010000100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.55";
	z0 <= "1111111111111111111111111111110101110011001101010010011110101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.5251";
	z0 <= "1111111111111111111111111111110101111001100100111000101100101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.5002";
	z0 <= "1111111111111111111111111111110101111111111100011110111010110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.4753";
	z0 <= "1111111111111111111111111111110110000110010100000101001000110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.4505";
	z0 <= "1111111111111111111111111111110110001100101011101011010110111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.4256";
	z0 <= "1111111111111111111111111111110110010011000011010001100100111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.4007";
	z0 <= "1111111111111111111111111111110110011001011010110111110011000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.3758";
	z0 <= "1111111111111111111111111111110110011111110010011110000001000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.3509";
	z0 <= "1111111111111111111111111111110110100110001010000100001111001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.3261";
	z0 <= "1111111111111111111111111111110110101100100001101010011101001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.3012";
	z0 <= "1111111111111111111111111111110110110010111001010000101011010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.2763";
	z0 <= "1111111111111111111111111111110110111001010000110110111001010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.2514";
	z0 <= "1111111111111111111111111111110110111111101000011101000111011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.2266";
	z0 <= "1111111111111111111111111111110111000110000000000011010101011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.2017";
	z0 <= "1111111111111111111111111111110111001100010111101001100011100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.1768";
	z0 <= "1111111111111111111111111111110111010010101111001111110001100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.1519";
	z0 <= "1111111111111111111111111111110111011001000110110101111111101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.127";
	z0 <= "1111111111111111111111111111110111011111011110011100001101101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.1022";
	z0 <= "1111111111111111111111111111110111100101110110000010011011110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.0773";
	z0 <= "1111111111111111111111111111110111101100001101101000101001110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.0524";
	z0 <= "1111111111111111111111111111110111110010100101001110110111111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.0275";
	z0 <= "1111111111111111111111111111110111111000111100110101000101111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-2.0027";
	z0 <= "1111111111111111111111111111110111111111010100011011010100000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.9778";
	z0 <= "1111111111111111111111111111111000000101101100000001100010000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.9529";
	z0 <= "1111111111111111111111111111111000001100000011100111110000001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.928";
	z0 <= "1111111111111111111111111111111000010010011011001101111110001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.9031";
	z0 <= "1111111111111111111111111111111000011000110010110100001100010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.8783";
	z0 <= "1111111111111111111111111111111000011111001010011010011010010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.8534";
	z0 <= "1111111111111111111111111111111000100101100010000000101000011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.8285";
	z0 <= "1111111111111111111111111111111000101011111001100110110110011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.8036";
	z0 <= "1111111111111111111111111111111000110010010001001101000100100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.7788";
	z0 <= "1111111111111111111111111111111000111000101000110011010010100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.7539";
	z0 <= "1111111111111111111111111111111000111111000000011001100000101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.729";
	z0 <= "1111111111111111111111111111111001000101010111111111101110101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.7041";
	z0 <= "1111111111111111111111111111111001001011101111100101111100110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.6792";
	z0 <= "1111111111111111111111111111111001010010000111001100001010110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.6544";
	z0 <= "1111111111111111111111111111111001011000011110110010011000111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.6295";
	z0 <= "1111111111111111111111111111111001011110110110011000100110111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.6046";
	z0 <= "1111111111111111111111111111111001100101001101111110110101000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.5797";
	z0 <= "1111111111111111111111111111111001101011100101100101000011000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.5549";
	z0 <= "1111111111111111111111111111111001110001111101001011010001001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.53";
	z0 <= "1111111111111111111111111111111001111000010100110001011111001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.5051";
	z0 <= "1111111111111111111111111111111001111110101100010111101101001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.4802";
	z0 <= "1111111111111111111111111111111010000101000011111101111011010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.4553";
	z0 <= "1111111111111111111111111111111010001011011011100100001001010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.4305";
	z0 <= "1111111111111111111111111111111010010001110011001010010111011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.4056";
	z0 <= "1111111111111111111111111111111010011000001010110000100101011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.3807";
	z0 <= "1111111111111111111111111111111010011110100010010110110011100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.3558";
	z0 <= "1111111111111111111111111111111010100100111001111101000001100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.331";
	z0 <= "1111111111111111111111111111111010101011010001100011001111101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.3061";
	z0 <= "1111111111111111111111111111111010110001101001001001011101101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.2812";
	z0 <= "1111111111111111111111111111111010111000000000101111101011110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.2563";
	z0 <= "1111111111111111111111111111111010111110011000010101111001110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.2314";
	z0 <= "1111111111111111111111111111111011000100101111111100000111111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.2066";
	z0 <= "1111111111111111111111111111111011001011000111100010010101111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.1817";
	z0 <= "1111111111111111111111111111111011010001011111001000100100000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.1568";
	z0 <= "1111111111111111111111111111111011010111110110101110110010000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.1319";
	z0 <= "1111111111111111111111111111111011011110001110010101000000001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.1071";
	z0 <= "1111111111111111111111111111111011100100100101111011001110001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.0822";
	z0 <= "1111111111111111111111111111111011101010111101100001011100010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.0573";
	z0 <= "1111111111111111111111111111111011110001010101000111101010010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.0324";
	z0 <= "1111111111111111111111111111111011110111101100101101111000011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-1.0075";
	z0 <= "1111111111111111111111111111111011111110000100010100000110011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.98267";
	z0 <= "1111111111111111111111111111111100000100011011111010010100100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.95779";
	z0 <= "1111111111111111111111111111111100001010110011100000100010100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.93292";
	z0 <= "1111111111111111111111111111111100010001001011000110110000101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.90804";
	z0 <= "1111111111111111111111111111111100010111100010101100111110101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.88316";
	z0 <= "1111111111111111111111111111111100011101111010010011001100110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.85828";
	z0 <= "1111111111111111111111111111111100100100010001111001011010110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.8334";
	z0 <= "1111111111111111111111111111111100101010101001011111101000111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.80853";
	z0 <= "1111111111111111111111111111111100110001000001000101110110111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.78365";
	z0 <= "1111111111111111111111111111111100110111011000101100000101000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.75877";
	z0 <= "1111111111111111111111111111111100111101110000010010010011000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.73389";
	z0 <= "1111111111111111111111111111111101000100000111111000100001001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.70902";
	z0 <= "1111111111111111111111111111111101001010011111011110101111001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.68414";
	z0 <= "1111111111111111111111111111111101010000110111000100111101010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.65926";
	z0 <= "1111111111111111111111111111111101010111001110101011001011010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.63438";
	z0 <= "1111111111111111111111111111111101011101100110010001011001011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.60951";
	z0 <= "1111111111111111111111111111111101100011111101110111100111011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.58463";
	z0 <= "1111111111111111111111111111111101101010010101011101110101100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.55975";
	z0 <= "1111111111111111111111111111111101110000101101000100000011100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.53487";
	z0 <= "1111111111111111111111111111111101110111000100101010010001101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.50999";
	z0 <= "1111111111111111111111111111111101111101011100010000011111101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.48512";
	z0 <= "1111111111111111111111111111111110000011110011110110101101110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.46024";
	z0 <= "1111111111111111111111111111111110001010001011011100111011110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.43536";
	z0 <= "1111111111111111111111111111111110010000100011000011001001111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.41048";
	z0 <= "1111111111111111111111111111111110010110111010101001010111111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.38561";
	z0 <= "1111111111111111111111111111111110011101010010001111100110000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.36073";
	z0 <= "1111111111111111111111111111111110100011101001110101110100000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.33585";
	z0 <= "1111111111111111111111111111111110101010000001011100000010001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.31097";
	z0 <= "1111111111111111111111111111111110110000011001000010010000001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.28609";
	z0 <= "1111111111111111111111111111111110110110110000101000011110010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.26122";
	z0 <= "1111111111111111111111111111111110111101001000001110101100010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.23634";
	z0 <= "1111111111111111111111111111111111000011011111110100111010011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.21146";
	z0 <= "1111111111111111111111111111111111001001110111011011001000011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.18658";
	z0 <= "1111111111111111111111111111111111010000001111000001010110100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.16171";
	z0 <= "1111111111111111111111111111111111010110100110100111100100100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.13683";
	z0 <= "1111111111111111111111111111111111011100111110001101110010101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.11195";
	z0 <= "1111111111111111111111111111111111100011010101110100000000101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.087072";
	z0 <= "1111111111111111111111111111111111101001101101011010001110110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.062194";
	z0 <= "1111111111111111111111111111111111110000000101000000011100110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.037317";
	z0 <= "1111111111111111111111111111111111110110011100100110101010111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "-0.012439";
	z0 <= "1111111111111111111111111111111111111100110100001100111000111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.012439";
	z0 <= "0000000000000000000000000000000000000011001011110011000111000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.037317";
	z0 <= "0000000000000000000000000000000000001001100011011001010101000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.062194";
	z0 <= "0000000000000000000000000000000000001111111010111111100011001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.087072";
	z0 <= "0000000000000000000000000000000000010110010010100101110001001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.11195";
	z0 <= "0000000000000000000000000000000000011100101010001011111111010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.13683";
	z0 <= "0000000000000000000000000000000000100011000001110010001101010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.16171";
	z0 <= "0000000000000000000000000000000000101001011001011000011011011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.18658";
	z0 <= "0000000000000000000000000000000000101111110000111110101001011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.21146";
	z0 <= "0000000000000000000000000000000000110110001000100100110111100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.23634";
	z0 <= "0000000000000000000000000000000000111100100000001011000101100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.26122";
	z0 <= "0000000000000000000000000000000001000010110111110001010011101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.28609";
	z0 <= "0000000000000000000000000000000001001001001111010111100001101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.31097";
	z0 <= "0000000000000000000000000000000001001111100110111101101111110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.33585";
	z0 <= "0000000000000000000000000000000001010101111110100011111101110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.36073";
	z0 <= "0000000000000000000000000000000001011100010110001010001011111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.38561";
	z0 <= "0000000000000000000000000000000001100010101101110000011001111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.41048";
	z0 <= "0000000000000000000000000000000001101001000101010110101000000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.43536";
	z0 <= "0000000000000000000000000000000001101111011100111100110110000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.46024";
	z0 <= "0000000000000000000000000000000001110101110100100011000100001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.48512";
	z0 <= "0000000000000000000000000000000001111100001100001001010010001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.50999";
	z0 <= "0000000000000000000000000000000010000010100011101111100000010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.53487";
	z0 <= "0000000000000000000000000000000010001000111011010101101110010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.55975";
	z0 <= "0000000000000000000000000000000010001111010010111011111100011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.58463";
	z0 <= "0000000000000000000000000000000010010101101010100010001010011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.60951";
	z0 <= "0000000000000000000000000000000010011100000010001000011000100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.63438";
	z0 <= "0000000000000000000000000000000010100010011001101110100110100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.65926";
	z0 <= "0000000000000000000000000000000010101000110001010100110100101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.68414";
	z0 <= "0000000000000000000000000000000010101111001000111011000010101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.70902";
	z0 <= "0000000000000000000000000000000010110101100000100001010000110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.73389";
	z0 <= "0000000000000000000000000000000010111011111000000111011110110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.75877";
	z0 <= "0000000000000000000000000000000011000010001111101101101100111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.78365";
	z0 <= "0000000000000000000000000000000011001000100111010011111010111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.80853";
	z0 <= "0000000000000000000000000000000011001110111110111010001001000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.8334";
	z0 <= "0000000000000000000000000000000011010101010110100000010111000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.85828";
	z0 <= "0000000000000000000000000000000011011011101110000110100101001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.88316";
	z0 <= "0000000000000000000000000000000011100010000101101100110011001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.90804";
	z0 <= "0000000000000000000000000000000011101000011101010011000001010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.93292";
	z0 <= "0000000000000000000000000000000011101110110100111001001111010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.95779";
	z0 <= "0000000000000000000000000000000011110101001100011111011101011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "0.98267";
	z0 <= "0000000000000000000000000000000011111011100100000101101011011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.0075";
	z0 <= "0000000000000000000000000000000100000001111011101011111001100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.0324";
	z0 <= "0000000000000000000000000000000100001000010011010010000111100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.0573";
	z0 <= "0000000000000000000000000000000100001110101010111000010101101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.0822";
	z0 <= "0000000000000000000000000000000100010101000010011110100011101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.1071";
	z0 <= "0000000000000000000000000000000100011011011010000100110001110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.1319";
	z0 <= "0000000000000000000000000000000100100001110001101010111111110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.1568";
	z0 <= "0000000000000000000000000000000100101000001001010001001101111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.1817";
	z0 <= "0000000000000000000000000000000100101110100000110111011011111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.2066";
	z0 <= "0000000000000000000000000000000100110100111000011101101010000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.2314";
	z0 <= "0000000000000000000000000000000100111011010000000011111000000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.2563";
	z0 <= "0000000000000000000000000000000101000001100111101010000110001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.2812";
	z0 <= "0000000000000000000000000000000101000111111111010000010100001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.3061";
	z0 <= "0000000000000000000000000000000101001110010110110110100010010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.331";
	z0 <= "0000000000000000000000000000000101010100101110011100110000010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.3558";
	z0 <= "0000000000000000000000000000000101011011000110000010111110011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.3807";
	z0 <= "0000000000000000000000000000000101100001011101101001001100011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.4056";
	z0 <= "0000000000000000000000000000000101100111110101001111011010100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.4305";
	z0 <= "0000000000000000000000000000000101101110001100110101101000100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.4553";
	z0 <= "0000000000000000000000000000000101110100100100011011110110101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.4802";
	z0 <= "0000000000000000000000000000000101111010111100000010000100101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.5051";
	z0 <= "0000000000000000000000000000000110000001010011101000010010110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.53";
	z0 <= "0000000000000000000000000000000110000111101011001110100000110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.5549";
	z0 <= "0000000000000000000000000000000110001110000010110100101110110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.5797";
	z0 <= "0000000000000000000000000000000110010100011010011010111100111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.6046";
	z0 <= "0000000000000000000000000000000110011010110010000001001010111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.6295";
	z0 <= "0000000000000000000000000000000110100001001001100111011001000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.6544";
	z0 <= "0000000000000000000000000000000110100111100001001101100111000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.6792";
	z0 <= "0000000000000000000000000000000110101101111000110011110101001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.7041";
	z0 <= "0000000000000000000000000000000110110100010000011010000011001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.729";
	z0 <= "0000000000000000000000000000000110111010101000000000010001010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.7539";
	z0 <= "0000000000000000000000000000000111000000111111100110011111010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.7788";
	z0 <= "0000000000000000000000000000000111000111010111001100101101011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.8036";
	z0 <= "0000000000000000000000000000000111001101101110110010111011011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.8285";
	z0 <= "0000000000000000000000000000000111010100000110011001001001100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.8534";
	z0 <= "0000000000000000000000000000000111011010011101111111010111100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.8783";
	z0 <= "0000000000000000000000000000000111100000110101100101100101101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.9031";
	z0 <= "0000000000000000000000000000000111100111001101001011110011101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.928";
	z0 <= "0000000000000000000000000000000111101101100100110010000001110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.9529";
	z0 <= "0000000000000000000000000000000111110011111100011000001111110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "1.9778";
	z0 <= "0000000000000000000000000000000111111010010011111110011101111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.0027";
	z0 <= "0000000000000000000000000000001000000000101011100100101011111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.0275";
	z0 <= "0000000000000000000000000000001000000111000011001010111010000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.0524";
	z0 <= "0000000000000000000000000000001000001101011010110001001000000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.0773";
	z0 <= "0000000000000000000000000000001000010011110010010111010110001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.1022";
	z0 <= "0000000000000000000000000000001000011010001001111101100100001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.127";
	z0 <= "0000000000000000000000000000001000100000100001100011110010010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.1519";
	z0 <= "0000000000000000000000000000001000100110111001001010000000010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.1768";
	z0 <= "0000000000000000000000000000001000101101010000110000001110011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.2017";
	z0 <= "0000000000000000000000000000001000110011101000010110011100011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.2266";
	z0 <= "0000000000000000000000000000001000111001111111111100101010100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.2514";
	z0 <= "0000000000000000000000000000001001000000010111100010111000100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.2763";
	z0 <= "0000000000000000000000000000001001000110101111001001000110101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.3012";
	z0 <= "0000000000000000000000000000001001001101000110101111010100101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.3261";
	z0 <= "0000000000000000000000000000001001010011011110010101100010110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.3509";
	z0 <= "0000000000000000000000000000001001011001110101111011110000110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.3758";
	z0 <= "0000000000000000000000000000001001100000001101100001111110111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.4007";
	z0 <= "0000000000000000000000000000001001100110100101001000001100111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.4256";
	z0 <= "0000000000000000000000000000001001101100111100101110011011000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.4505";
	z0 <= "0000000000000000000000000000001001110011010100010100101001000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.4753";
	z0 <= "0000000000000000000000000000001001111001101011111010110111001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.5002";
	z0 <= "0000000000000000000000000000001010000000000011100001000101001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.5251";
	z0 <= "0000000000000000000000000000001010000110011011000111010011010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.55";
	z0 <= "0000000000000000000000000000001010001100110010101101100001010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.5748";
	z0 <= "0000000000000000000000000000001010010011001010010011101111011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.5997";
	z0 <= "0000000000000000000000000000001010011001100001111001111101011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.6246";
	z0 <= "0000000000000000000000000000001010011111111001100000001011100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.6495";
	z0 <= "0000000000000000000000000000001010100110010001000110011001100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.6744";
	z0 <= "0000000000000000000000000000001010101100101000101100100111101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.6992";
	z0 <= "0000000000000000000000000000001010110011000000010010110101101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.7241";
	z0 <= "0000000000000000000000000000001010111001010111111001000011110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.749";
	z0 <= "0000000000000000000000000000001010111111101111011111010001110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.7739";
	z0 <= "0000000000000000000000000000001011000110000111000101011111111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.7987";
	z0 <= "0000000000000000000000000000001011001100011110101011101101111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.8236";
	z0 <= "0000000000000000000000000000001011010010110110010001111100000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.8485";
	z0 <= "0000000000000000000000000000001011011001001101111000001010000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.8734";
	z0 <= "0000000000000000000000000000001011011111100101011110011000001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.8983";
	z0 <= "0000000000000000000000000000001011100101111101000100100110001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.9231";
	z0 <= "0000000000000000000000000000001011101100010100101010110100010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.948";
	z0 <= "0000000000000000000000000000001011110010101100010001000010010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.9729";
	z0 <= "0000000000000000000000000000001011111001000011110111010000011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "2.9978";
	z0 <= "0000000000000000000000000000001011111111011011011101011110011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.0226";
	z0 <= "0000000000000000000000000000001100000101110011000011101100100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.0475";
	z0 <= "0000000000000000000000000000001100001100001010101001111010100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.0724";
	z0 <= "0000000000000000000000000000001100010010100010010000001000101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.0973";
	z0 <= "0000000000000000000000000000001100011000111001110110010110101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.1222";
	z0 <= "0000000000000000000000000000001100011111010001011100100100110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.147";
	z0 <= "0000000000000000000000000000001100100101101001000010110010110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.1719";
	z0 <= "0000000000000000000000000000001100101100000000101001000000111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.1968";
	z0 <= "0000000000000000000000000000001100110010011000001111001110111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.2217";
	z0 <= "0000000000000000000000000000001100111000101111110101011101000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.2465";
	z0 <= "0000000000000000000000000000001100111111000111011011101011000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.2714";
	z0 <= "0000000000000000000000000000001101000101011111000001111001001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.2963";
	z0 <= "0000000000000000000000000000001101001011110110101000000111001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.3212";
	z0 <= "0000000000000000000000000000001101010010001110001110010101010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.3461";
	z0 <= "0000000000000000000000000000001101011000100101110100100011010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.3709";
	z0 <= "0000000000000000000000000000001101011110111101011010110001011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.3958";
	z0 <= "0000000000000000000000000000001101100101010101000000111111011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.4207";
	z0 <= "0000000000000000000000000000001101101011101100100111001101100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.4456";
	z0 <= "0000000000000000000000000000001101110010000100001101011011100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.4704";
	z0 <= "0000000000000000000000000000001101111000011011110011101001101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.4953";
	z0 <= "0000000000000000000000000000001101111110110011011001110111101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.5202";
	z0 <= "0000000000000000000000000000001110000101001011000000000101110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.5451";
	z0 <= "0000000000000000000000000000001110001011100010100110010011110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.57";
	z0 <= "0000000000000000000000000000001110010001111010001100100001111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.5948";
	z0 <= "0000000000000000000000000000001110011000010001110010101111111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.6197";
	z0 <= "0000000000000000000000000000001110011110101001011000111110000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.6446";
	z0 <= "0000000000000000000000000000001110100101000000111111001100000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.6695";
	z0 <= "0000000000000000000000000000001110101011011000100101011010001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.6943";
	z0 <= "0000000000000000000000000000001110110001110000001011101000001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.7192";
	z0 <= "0000000000000000000000000000001110111000000111110001110110010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.7441";
	z0 <= "0000000000000000000000000000001110111110011111011000000100010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.769";
	z0 <= "0000000000000000000000000000001111000100110110111110010010011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.7939";
	z0 <= "0000000000000000000000000000001111001011001110100100100000011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.8187";
	z0 <= "0000000000000000000000000000001111010001100110001010101110100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.8436";
	z0 <= "0000000000000000000000000000001111010111111101110000111100100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.8685";
	z0 <= "0000000000000000000000000000001111011110010101010111001010101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.8934";
	z0 <= "0000000000000000000000000000001111100100101100111101011000101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.9182";
	z0 <= "0000000000000000000000000000001111101011000100100011100110110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.9431";
	z0 <= "0000000000000000000000000000001111110001011100001001110100110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.968";
	z0 <= "0000000000000000000000000000001111110111110011110000000010111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "3.9929";
	z0 <= "0000000000000000000000000000001111111110001011010110010000111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.0178";
	z0 <= "0000000000000000000000000000010000000100100010111100011111000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.0426";
	z0 <= "0000000000000000000000000000010000001010111010100010101101000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.0675";
	z0 <= "0000000000000000000000000000010000010001010010001000111011001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.0924";
	z0 <= "0000000000000000000000000000010000010111101001101111001001001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.1173";
	z0 <= "0000000000000000000000000000010000011110000001010101010111010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.1421";
	z0 <= "0000000000000000000000000000010000100100011000111011100101010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.167";
	z0 <= "0000000000000000000000000000010000101010110000100001110011011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.1919";
	z0 <= "0000000000000000000000000000010000110001001000001000000001011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.2168";
	z0 <= "0000000000000000000000000000010000110111011111101110001111100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.2417";
	z0 <= "0000000000000000000000000000010000111101110111010100011101100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.2665";
	z0 <= "0000000000000000000000000000010001000100001110111010101011101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.2914";
	z0 <= "0000000000000000000000000000010001001010100110100000111001101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.3163";
	z0 <= "0000000000000000000000000000010001010000111110000111000111110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.3412";
	z0 <= "0000000000000000000000000000010001010111010101101101010101110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.366";
	z0 <= "0000000000000000000000000000010001011101101101010011100011111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.3909";
	z0 <= "0000000000000000000000000000010001100100000100111001110001111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.4158";
	z0 <= "0000000000000000000000000000010001101010011100100000000000000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.4407";
	z0 <= "0000000000000000000000000000010001110000110100000110001110000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.4656";
	z0 <= "0000000000000000000000000000010001110111001011101100011100001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.4904";
	z0 <= "0000000000000000000000000000010001111101100011010010101010001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.5153";
	z0 <= "0000000000000000000000000000010010000011111010111000111000010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.5402";
	z0 <= "0000000000000000000000000000010010001010010010011111000110010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.5651";
	z0 <= "0000000000000000000000000000010010010000101010000101010100011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.5899";
	z0 <= "0000000000000000000000000000010010010111000001101011100010011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.6148";
	z0 <= "0000000000000000000000000000010010011101011001010001110000011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.6397";
	z0 <= "0000000000000000000000000000010010100011110000110111111110100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.6646";
	z0 <= "0000000000000000000000000000010010101010001000011110001100100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.6895";
	z0 <= "0000000000000000000000000000010010110000100000000100011010101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.7143";
	z0 <= "0000000000000000000000000000010010110110110111101010101000101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.7392";
	z0 <= "0000000000000000000000000000010010111101001111010000110110110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.7641";
	z0 <= "0000000000000000000000000000010011000011100110110111000100110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.789";
	z0 <= "0000000000000000000000000000010011001001111110011101010010111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.8138";
	z0 <= "0000000000000000000000000000010011010000010110000011100000111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.8387";
	z0 <= "0000000000000000000000000000010011010110101101101001101111000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.8636";
	z0 <= "0000000000000000000000000000010011011101000101001111111101000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.8885";
	z0 <= "0000000000000000000000000000010011100011011100110110001011001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.9134";
	z0 <= "0000000000000000000000000000010011101001110100011100011001001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.9382";
	z0 <= "0000000000000000000000000000010011110000001100000010100111010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.9631";
	z0 <= "0000000000000000000000000000010011110110100011101000110101010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "4.988";
	z0 <= "0000000000000000000000000000010011111100111011001111000011011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.0129";
	z0 <= "0000000000000000000000000000010100000011010010110101010001011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.0377";
	z0 <= "0000000000000000000000000000010100001001101010011011011111100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.0626";
	z0 <= "0000000000000000000000000000010100010000000010000001101101100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.0875";
	z0 <= "0000000000000000000000000000010100010110011001100111111011101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.1124";
	z0 <= "0000000000000000000000000000010100011100110001001110001001101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.1373";
	z0 <= "0000000000000000000000000000010100100011001000110100010111110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.1621";
	z0 <= "0000000000000000000000000000010100101001100000011010100101110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.187";
	z0 <= "0000000000000000000000000000010100101111111000000000110011111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.2119";
	z0 <= "0000000000000000000000000000010100110110001111100111000001111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.2368";
	z0 <= "0000000000000000000000000000010100111100100111001101010000000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.2616";
	z0 <= "0000000000000000000000000000010101000010111110110011011110000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.2865";
	z0 <= "0000000000000000000000000000010101001001010110011001101100001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.3114";
	z0 <= "0000000000000000000000000000010101001111101101111111111010001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.3363";
	z0 <= "0000000000000000000000000000010101010110000101100110001000010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.3612";
	z0 <= "0000000000000000000000000000010101011100011101001100010110010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.386";
	z0 <= "0000000000000000000000000000010101100010110100110010100100011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.4109";
	z0 <= "0000000000000000000000000000010101101001001100011000110010011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.4358";
	z0 <= "0000000000000000000000000000010101101111100011111111000000100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.4607";
	z0 <= "0000000000000000000000000000010101110101111011100101001110100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.4855";
	z0 <= "0000000000000000000000000000010101111100010011001011011100101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.5104";
	z0 <= "0000000000000000000000000000010110000010101010110001101010101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.5353";
	z0 <= "0000000000000000000000000000010110001001000010010111111000110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.5602";
	z0 <= "0000000000000000000000000000010110001111011001111110000110110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.5851";
	z0 <= "0000000000000000000000000000010110010101110001100100010100111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.6099";
	z0 <= "0000000000000000000000000000010110011100001001001010100010111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.6348";
	z0 <= "0000000000000000000000000000010110100010100000110000110001000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.6597";
	z0 <= "0000000000000000000000000000010110101000111000010110111111000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.6846";
	z0 <= "0000000000000000000000000000010110101111001111111101001101001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.7094";
	z0 <= "0000000000000000000000000000010110110101100111100011011011001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.7343";
	z0 <= "0000000000000000000000000000010110111011111111001001101001010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.7592";
	z0 <= "0000000000000000000000000000010111000010010110101111110111010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.7841";
	z0 <= "0000000000000000000000000000010111001000101110010110000101011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.809";
	z0 <= "0000000000000000000000000000010111001111000101111100010011011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.8338";
	z0 <= "0000000000000000000000000000010111010101011101100010100001100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.8587";
	z0 <= "0000000000000000000000000000010111011011110101001000101111100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.8836";
	z0 <= "0000000000000000000000000000010111100010001100101110111101101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.9085";
	z0 <= "0000000000000000000000000000010111101000100100010101001011101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.9333";
	z0 <= "0000000000000000000000000000010111101110111011111011011001110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.9582";
	z0 <= "0000000000000000000000000000010111110101010011100001100111110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "5.9831";
	z0 <= "0000000000000000000000000000010111111011101011000111110101111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.008";
	z0 <= "0000000000000000000000000000011000000010000010101110000011111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.0329";
	z0 <= "0000000000000000000000000000011000001000011010010100010010000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.0577";
	z0 <= "0000000000000000000000000000011000001110110001111010100000000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.0826";
	z0 <= "0000000000000000000000000000011000010101001001100000101110001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.1075";
	z0 <= "0000000000000000000000000000011000011011100001000110111100001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.1324";
	z0 <= "0000000000000000000000000000011000100001111000101101001010010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.1572";
	z0 <= "0000000000000000000000000000011000101000010000010011011000010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.1821";
	z0 <= "0000000000000000000000000000011000101110100111111001100110011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.207";
	z0 <= "0000000000000000000000000000011000110100111111011111110100011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.2319";
	z0 <= "0000000000000000000000000000011000111011010111000110000010100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.2568";
	z0 <= "0000000000000000000000000000011001000001101110101100010000100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.2816";
	z0 <= "0000000000000000000000000000011001001000000110010010011110101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.3065";
	z0 <= "0000000000000000000000000000011001001110011101111000101100101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.3314";
	z0 <= "0000000000000000000000000000011001010100110101011110111010110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.3563";
	z0 <= "0000000000000000000000000000011001011011001101000101001000110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.3811";
	z0 <= "0000000000000000000000000000011001100001100100101011010110111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.406";
	z0 <= "0000000000000000000000000000011001100111111100010001100100111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.4309";
	z0 <= "0000000000000000000000000000011001101110010011110111110011000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.4558";
	z0 <= "0000000000000000000000000000011001110100101011011110000001000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.4807";
	z0 <= "0000000000000000000000000000011001111011000011000100001111001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.5055";
	z0 <= "0000000000000000000000000000011010000001011010101010011101001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.5304";
	z0 <= "0000000000000000000000000000011010000111110010010000101011010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.5553";
	z0 <= "0000000000000000000000000000011010001110001001110110111001010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.5802";
	z0 <= "0000000000000000000000000000011010010100100001011101000111011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.605";
	z0 <= "0000000000000000000000000000011010011010111001000011010101011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.6299";
	z0 <= "0000000000000000000000000000011010100001010000101001100011100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.6548";
	z0 <= "0000000000000000000000000000011010100111101000001111110001100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.6797";
	z0 <= "0000000000000000000000000000011010101101111111110101111111101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.7046";
	z0 <= "0000000000000000000000000000011010110100010111011100001101101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.7294";
	z0 <= "0000000000000000000000000000011010111010101111000010011011110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.7543";
	z0 <= "0000000000000000000000000000011011000001000110101000101001110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.7792";
	z0 <= "0000000000000000000000000000011011000111011110001110110111111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.8041";
	z0 <= "0000000000000000000000000000011011001101110101110101000101111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.8289";
	z0 <= "0000000000000000000000000000011011010100001101011011010100000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.8538";
	z0 <= "0000000000000000000000000000011011011010100101000001100010000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.8787";
	z0 <= "0000000000000000000000000000011011100000111100100111110000001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.9036";
	z0 <= "0000000000000000000000000000011011100111010100001101111110001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.9285";
	z0 <= "0000000000000000000000000000011011101101101011110100001100010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.9533";
	z0 <= "0000000000000000000000000000011011110100000011011010011010010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "6.9782";
	z0 <= "0000000000000000000000000000011011111010011011000000101000011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.0031";
	z0 <= "0000000000000000000000000000011100000000110010100110110110011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.028";
	z0 <= "0000000000000000000000000000011100000111001010001101000100100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.0528";
	z0 <= "0000000000000000000000000000011100001101100001110011010010100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.0777";
	z0 <= "0000000000000000000000000000011100010011111001011001100000101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.1026";
	z0 <= "0000000000000000000000000000011100011010010000111111101110101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.1275";
	z0 <= "0000000000000000000000000000011100100000101000100101111100110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.1524";
	z0 <= "0000000000000000000000000000011100100111000000001100001010110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.1772";
	z0 <= "0000000000000000000000000000011100101101010111110010011000111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.2021";
	z0 <= "0000000000000000000000000000011100110011101111011000100110111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.227";
	z0 <= "0000000000000000000000000000011100111010000110111110110101000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.2519";
	z0 <= "0000000000000000000000000000011101000000011110100101000011000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.2767";
	z0 <= "0000000000000000000000000000011101000110110110001011010001001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.3016";
	z0 <= "0000000000000000000000000000011101001101001101110001011111001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.3265";
	z0 <= "0000000000000000000000000000011101010011100101010111101101010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.3514";
	z0 <= "0000000000000000000000000000011101011001111100111101111011010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.3763";
	z0 <= "0000000000000000000000000000011101100000010100100100001001011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.4011";
	z0 <= "0000000000000000000000000000011101100110101100001010010111011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.426";
	z0 <= "0000000000000000000000000000011101101101000011110000100101100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.4509";
	z0 <= "0000000000000000000000000000011101110011011011010110110011100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.4758";
	z0 <= "0000000000000000000000000000011101111001110010111101000001101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.5006";
	z0 <= "0000000000000000000000000000011110000000001010100011001111101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.5255";
	z0 <= "0000000000000000000000000000011110000110100010001001011101110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.5504";
	z0 <= "0000000000000000000000000000011110001100111001101111101011110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.5753";
	z0 <= "0000000000000000000000000000011110010011010001010101111001111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.6002";
	z0 <= "0000000000000000000000000000011110011001101000111100000111111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.625";
	z0 <= "0000000000000000000000000000011110100000000000100010010110000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.6499";
	z0 <= "0000000000000000000000000000011110100110011000001000100100000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.6748";
	z0 <= "0000000000000000000000000000011110101100101111101110110010000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.6997";
	z0 <= "0000000000000000000000000000011110110011000111010101000000001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.7245";
	z0 <= "0000000000000000000000000000011110111001011110111011001110001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.7494";
	z0 <= "0000000000000000000000000000011110111111110110100001011100010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.7743";
	z0 <= "0000000000000000000000000000011111000110001110000111101010010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.7992";
	z0 <= "0000000000000000000000000000011111001100100101101101111000011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.8241";
	z0 <= "0000000000000000000000000000011111010010111101010100000110011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.8489";
	z0 <= "0000000000000000000000000000011111011001010100111010010100100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.8738";
	z0 <= "0000000000000000000000000000011111011111101100100000100010100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.8987";
	z0 <= "0000000000000000000000000000011111100110000100000110110000101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.9236";
	z0 <= "0000000000000000000000000000011111101100011011101100111110101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.9484";
	z0 <= "0000000000000000000000000000011111110010110011010011001100110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.9733";
	z0 <= "0000000000000000000000000000011111111001001010111001011010110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "7.9982";
	z0 <= "0000000000000000000000000000011111111111100010011111101000111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.0231";
	z0 <= "0000000000000000000000000000100000000101111010000101110110111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.048";
	z0 <= "0000000000000000000000000000100000001100010001101100000101000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.0728";
	z0 <= "0000000000000000000000000000100000010010101001010010010011000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.0977";
	z0 <= "0000000000000000000000000000100000011001000000111000100001001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.1226";
	z0 <= "0000000000000000000000000000100000011111011000011110101111001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.1475";
	z0 <= "0000000000000000000000000000100000100101110000000100111101010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.1723";
	z0 <= "0000000000000000000000000000100000101100000111101011001011010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.1972";
	z0 <= "0000000000000000000000000000100000110010011111010001011001011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.2221";
	z0 <= "0000000000000000000000000000100000111000110110110111100111011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.247";
	z0 <= "0000000000000000000000000000100000111111001110011101110101100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.2719";
	z0 <= "0000000000000000000000000000100001000101100110000100000011100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.2967";
	z0 <= "0000000000000000000000000000100001001011111101101010010001101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.3216";
	z0 <= "0000000000000000000000000000100001010010010101010000011111101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.3465";
	z0 <= "0000000000000000000000000000100001011000101100110110101101110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.3714";
	z0 <= "0000000000000000000000000000100001011111000100011100111011110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.3962";
	z0 <= "0000000000000000000000000000100001100101011100000011001001111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.4211";
	z0 <= "0000000000000000000000000000100001101011110011101001010111111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.446";
	z0 <= "0000000000000000000000000000100001110010001011001111100110000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.4709";
	z0 <= "0000000000000000000000000000100001111000100010110101110100000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.4958";
	z0 <= "0000000000000000000000000000100001111110111010011100000010001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.5206";
	z0 <= "0000000000000000000000000000100010000101010010000010010000001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.5455";
	z0 <= "0000000000000000000000000000100010001011101001101000011110010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.5704";
	z0 <= "0000000000000000000000000000100010010010000001001110101100010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.5953";
	z0 <= "0000000000000000000000000000100010011000011000110100111010011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.6201";
	z0 <= "0000000000000000000000000000100010011110110000011011001000011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.645";
	z0 <= "0000000000000000000000000000100010100101001000000001010110100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.6699";
	z0 <= "0000000000000000000000000000100010101011011111100111100100100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.6948";
	z0 <= "0000000000000000000000000000100010110001110111001101110010101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.7197";
	z0 <= "0000000000000000000000000000100010111000001110110100000000101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.7445";
	z0 <= "0000000000000000000000000000100010111110100110011010001110110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.7694";
	z0 <= "0000000000000000000000000000100011000100111110000000011100110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.7943";
	z0 <= "0000000000000000000000000000100011001011010101100110101010111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.8192";
	z0 <= "0000000000000000000000000000100011010001101101001100111000111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.844";
	z0 <= "0000000000000000000000000000100011011000000100110011000111000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.8689";
	z0 <= "0000000000000000000000000000100011011110011100011001010101000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.8938";
	z0 <= "0000000000000000000000000000100011100100110011111111100011001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.9187";
	z0 <= "0000000000000000000000000000100011101011001011100101110001001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.9436";
	z0 <= "0000000000000000000000000000100011110001100011001011111111010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.9684";
	z0 <= "0000000000000000000000000000100011110111111010110010001101010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "8.9933";
	z0 <= "0000000000000000000000000000100011111110010010011000011011011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.0182";
	z0 <= "0000000000000000000000000000100100000100101001111110101001011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.0431";
	z0 <= "0000000000000000000000000000100100001011000001100100110111100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.0679";
	z0 <= "0000000000000000000000000000100100010001011001001011000101100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.0928";
	z0 <= "0000000000000000000000000000100100010111110000110001010011101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.1177";
	z0 <= "0000000000000000000000000000100100011110001000010111100001101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.1426";
	z0 <= "0000000000000000000000000000100100100100011111111101101111110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.1675";
	z0 <= "0000000000000000000000000000100100101010110111100011111101110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.1923";
	z0 <= "0000000000000000000000000000100100110001001111001010001011111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.2172";
	z0 <= "0000000000000000000000000000100100110111100110110000011001111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.2421";
	z0 <= "0000000000000000000000000000100100111101111110010110101000000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.267";
	z0 <= "0000000000000000000000000000100101000100010101111100110110000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.2918";
	z0 <= "0000000000000000000000000000100101001010101101100011000100001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.3167";
	z0 <= "0000000000000000000000000000100101010001000101001001010010001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.3416";
	z0 <= "0000000000000000000000000000100101010111011100101111100000010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.3665";
	z0 <= "0000000000000000000000000000100101011101110100010101101110010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.3914";
	z0 <= "0000000000000000000000000000100101100100001011111011111100011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.4162";
	z0 <= "0000000000000000000000000000100101101010100011100010001010011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.4411";
	z0 <= "0000000000000000000000000000100101110000111011001000011000100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.466";
	z0 <= "0000000000000000000000000000100101110111010010101110100110100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.4909";
	z0 <= "0000000000000000000000000000100101111101101010010100110100101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.5157";
	z0 <= "0000000000000000000000000000100110000100000001111011000010101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.5406";
	z0 <= "0000000000000000000000000000100110001010011001100001010000110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.5655";
	z0 <= "0000000000000000000000000000100110010000110001000111011110110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.5904";
	z0 <= "0000000000000000000000000000100110010111001000101101101100111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.6153";
	z0 <= "0000000000000000000000000000100110011101100000010011111010111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.6401";
	z0 <= "0000000000000000000000000000100110100011110111111010001001000001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.665";
	z0 <= "0000000000000000000000000000100110101010001111100000010111000101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.6899";
	z0 <= "0000000000000000000000000000100110110000100111000110100101001001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.7148";
	z0 <= "0000000000000000000000000000100110110110111110101100110011001101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.7396";
	z0 <= "0000000000000000000000000000100110111101010110010011000001010001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.7645";
	z0 <= "0000000000000000000000000000100111000011101101111001001111010101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.7894";
	z0 <= "0000000000000000000000000000100111001010000101011111011101011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.8143";
	z0 <= "0000000000000000000000000000100111010000011101000101101011011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.8392";
	z0 <= "0000000000000000000000000000100111010110110100101011111001100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.864";
	z0 <= "0000000000000000000000000000100111011101001100010010000111100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.8889";
	z0 <= "0000000000000000000000000000100111100011100011111000010101101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.9138";
	z0 <= "0000000000000000000000000000100111101001111011011110100011101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.9387";
	z0 <= "0000000000000000000000000000100111110000010011000100110001110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.9635";
	z0 <= "0000000000000000000000000000100111110110101010101010111111110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "9.9884";
	z0 <= "0000000000000000000000000000100111111101000010010001001101111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.0133";
	z0 <= "0000000000000000000000000000101000000011011001110111011011111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.0382";
	z0 <= "0000000000000000000000000000101000001001110001011101101010000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.0631";
	z0 <= "0000000000000000000000000000101000010000001001000011111000000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.0879";
	z0 <= "0000000000000000000000000000101000010110100000101010000110001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.1128";
	z0 <= "0000000000000000000000000000101000011100111000010000010100001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.1377";
	z0 <= "0000000000000000000000000000101000100011001111110110100010010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.1626";
	z0 <= "0000000000000000000000000000101000101001100111011100110000010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.1874";
	z0 <= "0000000000000000000000000000101000101111111111000010111110011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.2123";
	z0 <= "0000000000000000000000000000101000110110010110101001001100011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.2372";
	z0 <= "0000000000000000000000000000101000111100101110001111011010100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.2621";
	z0 <= "0000000000000000000000000000101001000011000101110101101000100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.287";
	z0 <= "0000000000000000000000000000101001001001011101011011110110101000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.3118";
	z0 <= "0000000000000000000000000000101001001111110101000010000100101100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.3367";
	z0 <= "0000000000000000000000000000101001010110001100101000010010110000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.3616";
	z0 <= "0000000000000000000000000000101001011100100100001110100000110100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.3865";
	z0 <= "0000000000000000000000000000101001100010111011110100101110111000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.4113";
	z0 <= "0000000000000000000000000000101001101001010011011010111100111100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.4362";
	z0 <= "0000000000000000000000000000101001101111101011000001001011000000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.4611";
	z0 <= "0000000000000000000000000000101001110110000010100111011001000100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.486";
	z0 <= "0000000000000000000000000000101001111100011010001101100111001000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.5109";
	z0 <= "0000000000000000000000000000101010000010110001110011110101001100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.5357";
	z0 <= "0000000000000000000000000000101010001001001001011010000011010000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.5606";
	z0 <= "0000000000000000000000000000101010001111100001000000010001010100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.5855";
	z0 <= "0000000000000000000000000000101010010101111000100110011111011000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.6104";
	z0 <= "0000000000000000000000000000101010011100010000001100101101011100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.6352";
	z0 <= "0000000000000000000000000000101010100010100111110010111011100000";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.6601";
	z0 <= "0000000000000000000000000000101010101000111111011001001001100100";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.685";
	z0 <= "0000000000000000000000000000101010101111010110111111010111100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.7099";
	z0 <= "0000000000000000000000000000101010110101101110100101100101101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.7348";
	z0 <= "0000000000000000000000000000101010111100000110001011110011101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.7596";
	z0 <= "0000000000000000000000000000101011000010011101110010000001110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.7845";
	z0 <= "0000000000000000000000000000101011001000110101011000001111110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.8094";
	z0 <= "0000000000000000000000000000101011001111001100111110011101111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.8343";
	z0 <= "0000000000000000000000000000101011010101100100100100101011111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.8591";
	z0 <= "0000000000000000000000000000101011011011111100001010111010000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.884";
	z0 <= "0000000000000000000000000000101011100010010011110001001000000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.9089";
	z0 <= "0000000000000000000000000000101011101000101011010111010110001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.9338";
	z0 <= "0000000000000000000000000000101011101111000010111101100100001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.9587";
	z0 <= "0000000000000000000000000000101011110101011010100011110010010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "10.9835";
	z0 <= "0000000000000000000000000000101011111011110010001010000000010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.0084";
	z0 <= "0000000000000000000000000000101100000010001001110000001110011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.0333";
	z0 <= "0000000000000000000000000000101100001000100001010110011100011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.0582";
	z0 <= "0000000000000000000000000000101100001110111000111100101010100011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.083";
	z0 <= "0000000000000000000000000000101100010101010000100010111000100111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.1079";
	z0 <= "0000000000000000000000000000101100011011101000001001000110101011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.1328";
	z0 <= "0000000000000000000000000000101100100001111111101111010100101111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.1577";
	z0 <= "0000000000000000000000000000101100101000010111010101100010110011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.1826";
	z0 <= "0000000000000000000000000000101100101110101110111011110000110111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.2074";
	z0 <= "0000000000000000000000000000101100110101000110100001111110111011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.2323";
	z0 <= "0000000000000000000000000000101100111011011110001000001100111111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.2572";
	z0 <= "0000000000000000000000000000101101000001110101101110011011000011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.2821";
	z0 <= "0000000000000000000000000000101101001000001101010100101001000111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.3069";
	z0 <= "0000000000000000000000000000101101001110100100111010110111001011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.3318";
	z0 <= "0000000000000000000000000000101101010100111100100001000101001111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.3567";
	z0 <= "0000000000000000000000000000101101011011010100000111010011010011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.3816";
	z0 <= "0000000000000000000000000000101101100001101011101101100001010111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.4065";
	z0 <= "0000000000000000000000000000101101101000000011010011101111011011";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.4313";
	z0 <= "0000000000000000000000000000101101101110011010111001111101011111";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.4562";
	z0 <= "0000000000000000000000000000101101110100110010100000001011100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.4811";
	z0 <= "0000000000000000000000000000101101111011001010000110011001100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.506";
	z0 <= "0000000000000000000000000000101110000001100001101100100111101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.5308";
	z0 <= "0000000000000000000000000000101110000111111001010010110101101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.5557";
	z0 <= "0000000000000000000000000000101110001110010000111001000011110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.5806";
	z0 <= "0000000000000000000000000000101110010100101000011111010001110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.6055";
	z0 <= "0000000000000000000000000000101110011011000000000101011111111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.6304";
	z0 <= "0000000000000000000000000000101110100001010111101011101101111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.6552";
	z0 <= "0000000000000000000000000000101110100111101111010001111100000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.6801";
	z0 <= "0000000000000000000000000000101110101110000110111000001010000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.705";
	z0 <= "0000000000000000000000000000101110110100011110011110011000001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.7299";
	z0 <= "0000000000000000000000000000101110111010110110000100100110001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.7547";
	z0 <= "0000000000000000000000000000101111000001001101101010110100010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.7796";
	z0 <= "0000000000000000000000000000101111000111100101010001000010010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.8045";
	z0 <= "0000000000000000000000000000101111001101111100110111010000011010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.8294";
	z0 <= "0000000000000000000000000000101111010100010100011101011110011110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.8543";
	z0 <= "0000000000000000000000000000101111011010101100000011101100100010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.8791";
	z0 <= "0000000000000000000000000000101111100001000011101001111010100110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.904";
	z0 <= "0000000000000000000000000000101111100111011011010000001000101010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.9289";
	z0 <= "0000000000000000000000000000101111101101110010110110010110101110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.9538";
	z0 <= "0000000000000000000000000000101111110100001010011100100100110010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "11.9786";
	z0 <= "0000000000000000000000000000101111111010100010000010110010110110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.0035";
	z0 <= "0000000000000000000000000000110000000000111001101001000000111010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.0284";
	z0 <= "0000000000000000000000000000110000000111010001001111001110111110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.0533";
	z0 <= "0000000000000000000000000000110000001101101000110101011101000010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.0782";
	z0 <= "0000000000000000000000000000110000010100000000011011101011000110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.103";
	z0 <= "0000000000000000000000000000110000011010011000000001111001001010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.1279";
	z0 <= "0000000000000000000000000000110000100000101111101000000111001110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.1528";
	z0 <= "0000000000000000000000000000110000100111000111001110010101010010";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.1777";
	z0 <= "0000000000000000000000000000110000101101011110110100100011010110";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.2025";
	z0 <= "0000000000000000000000000000110000110011110110011010110001011001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.2274";
	z0 <= "0000000000000000000000000000110000111010001110000000111111011101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.2523";
	z0 <= "0000000000000000000000000000110001000000100101100111001101100001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.2772";
	z0 <= "0000000000000000000000000000110001000110111101001101011011100101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.3021";
	z0 <= "0000000000000000000000000000110001001101010100110011101001101001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.3269";
	z0 <= "0000000000000000000000000000110001010011101100011001110111101101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.3518";
	z0 <= "0000000000000000000000000000110001011010000100000000000101110001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.3767";
	z0 <= "0000000000000000000000000000110001100000011011100110010011110101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.4016";
	z0 <= "0000000000000000000000000000110001100110110011001100100001111001";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

	--z0 <= "12.4264";
	z0 <= "0000000000000000000000000000110001101101001010110010101111111101";
	start_tb <= '1'; wait for 2 ns; start_tb <= '0'; wait for 250 ns;
	write(L1,xn);
	writeline(test_out_data1,L1);
	write(L2,yn);
	writeline(test_out_data2,L2);

stop(0);
end process;
end Behavioral;
