%% Joshua Mack, Sam Bellestri, Nia Simmonds, IREECE 2015
%Testing rotation mode -- cosh and sinh

%Initialization
%range = -pi/2:0.001:pi/2;
range = linspace(-1.118, 1.118, 10000);
[myCosh, mySinh] = deal(zeros(length(range), 1));
i = 1;
%Calculation
for val = range
%   [myCosh(i), mySinh(i)] = CORDIC_Model('r', length(range), 1.20749706776307212887772, 0, val);
  [myCosh(i), mySinh(i)] = Improved_CORDIC_Model_OG('r', 128, 1.20749706776307212887772, 0, val);
  i = i + 1;
end
%Plotting
figure();
%Plotting myCosh
subplot(2,2,1); plot(range, myCosh); axis([-2 2 0 3]); title('CORDIC Model Cosh');
%Plotting MATLAB Cosh
subplot(2,2,2); plot(range, cosh(range)); axis([-2 2 0 3]); title('MATLAB Cosh');
%Plotting mySinh
subplot(2,2,3); plot(range, mySinh); axis([-2 2 -2 2]); title('CORDIC Model Sinh');
%Plotting MATLAB Sinh
subplot(2,2,4); plot(range, sinh(range)); axis([-2 2 -2 2]); title('MATLAB Sinh');
%Calculating error vs number of iterations
i = 1;
numIterations = 1:30;
coshError = zeros(length(numIterations),1);
sinhError = zeros(length(numIterations),1);
for iter = numIterations
    [myCosh, mySinh] = CORDIC_Model_OG('r', iter, 1.20749706776307212887772, 0, 0.78);
    coshError(i) = abs(myCosh - cosh(0.78));
    sinhError(i) = abs(mySinh - sinh(0.78));
    i = i + 1;
end
figure();
subplot(2,1,1); plot(numIterations, coshError, 'ro'); title('Cosh Error');
subplot(2,1,2); plot(numIterations, sinhError, 'ro'); title('Sinh Error');

%Testing vectoring mode -- arctanh
range = linspace(-0.80694, 0.80694);
myATanh = zeros(length(range),1);
i = 1;
%Calculation
for val = range
   myATanh(i) = CORDIC_Model_OG('v', 128, 1, val, 0);
   i = i + 1;
end
%Plotting
figure();
%Plotting myATanh
subplot(2,1,1); plot(range, myATanh); axis([-2 2 -2 2]); title('CORDIC Model ATanh');
%Plotting MATLAB ATanh
subplot(2,1,2); plot(range, atanh(range)); axis([-2 2 -2 2]); title('MATLAB ATanh');

%Error vs Num-Iterations
i = 1;
error = zeros(length(1:1:100),1);
for numIterations = 1:1:100
    error(i) = abs(CORDIC_Model_OG('v',numIterations, 4, 1, 0) - atanh(1/4));
    i = i + 1;
end
%Plotting
figure();
plot(1:1:100, error, 'ro'); title('CORDIC ATanh Error');