%% Joshua Mack, Sam Bellestri, Nia Simmonds, IREECE 2015

%---------Rotation Mode----------%
% Plotting with a fixed value of M

%Initialization
%The initial range that default CORDIC converges within.
% range = linspace(-1.118, 1.118, 10000);
%The range that the expanded one converges within for M > 2
% range = linspace(-5.16215, 5.16215, 100);
%An arbitrary range that should require M > 4
% range = linspace(-10, 10, 10000);
range = linspace(-12.42644, 12.42644, 1000);
[myCosh, mySinh] = deal(zeros(length(range), 1));
i = 1;
%Calculation
for val = range
%   [myCosh(i), mySinh(i)] = CORDIC_Model('r', length(range), 1.20749706776307212887772, 0, val);
  [myCosh(i), mySinh(i)] = Improved_Expanded_CORDIC('r', 5, 128, 1, 0, val);
%   coshPSNR(i) = psnr(myCosh(i), cosh(val));
%   sinhPSNR(i) = psnr(mySinh(i), sinh(val));
  i = i + 1;
end
%Plotting
figure();
%Plotting myCosh
subplot(2,2,1); plot(range, myCosh); axis([-6 6 0 100]); title('CORDIC Model Cosh');
%Plotting MATLAB Cosh
subplot(2,2,2); plot(range, cosh(range)); axis([-6 6 0 100]); title('MATLAB Cosh');
%Plotting mySinh
subplot(2,2,3); plot(range, mySinh); axis([-6 6 -100 100]); title('CORDIC Model Sinh');
%Plotting MATLAB Sinh
subplot(2,2,4); plot(range, sinh(range)); axis([-6 6 -100 100]); title('MATLAB Sinh');

% %PSNR (Peak Signal-to-Noise Ratio) in the given interval above.
% i = 1;
% coshPSNR = psnr(myCosh, cosh(range)');
% sinhPSNR = psnr(mySinh, sinh(range)');
% figure();
% subplot(2,1,1); plot(range, coshPSNR); title('Cosh PSNR');
% subplot(2,1,2); plot(range, sinhPSNR); title('Sinh PSNR');


% Pure (Non Relative) Error vs Number Iterations for Cosh & Sinh
% i = 1;
% numIterations = 1:100;
% coshError = zeros(length(numIterations), 1);
% sinhError = zeros(length(numIterations), 1);
% for iter = numIterations
%     [myCosh, mySinh] = Expanded_CORDIC_Model('r', 5, iter, 1, 0, 1.1625);
% %     coshError(i) = abs(myCosh - cosh(-5.1625));
% %     sinhError(i) = abs(mySinh - sinh(-5.1625));
% %     coshError(i) = psnr(myCosh, cosh(1.1625));
% %     sinhError(i) = psnr(mySinh, sinh(1.1625));
%     i = i + 1;
% end
% figure();
% subplot(2,1,1); plot(numIterations,coshError,'ro');title('Cosh Error');
% subplot(2,1,2); plot(numIterations,sinhError,'ro');title('Sinh Error');

% %---------3D Plot PSNR/Error---------%
% i = 1;
% numIterations = 1:1:20;    
% coshError = zeros(length(numIterations), 1);
% sinhError = zeros(length(numIterations), 1);
% for val = range
%     j = 1;
%     for iter = numIterations
%         [myCosh, mySinh] = Improved_Expanded_CORDIC('r', 9, iter, 1, 0, val);
% %         coshError(i, j) = (abs(myCosh - cosh(val)));%/abs(cosh(val));
% %         sinhError(i, j) = (abs(mySinh - sinh(val)));%/abs(sinh(val));
%         coshError(i, j) = psnr(myCosh, cosh(val));
%         sinhError(i, j) = psnr(mySinh, sinh(val));
%         j = j + 1;
%     end
%     i = i + 1;
% end
% figure();
% surf(coshError); title('Cosh PSNR');
% xlabel('Number Iterations'); ylabel('Value'); zlabel('PSNR');
% % set(gca, 'YTickLabel', linspace(range(1), range(length(range)-1), 6));
% figure();
% surf(sinhError); title('Sinh PSNR');
% xlabel('Number Iterations'); ylabel('Value'); zlabel('PSNR');

%-------PSNR Version 2.0-------%
% % This one compares the entire vector of coordic(range) to cosh(range)
% i = 1;
% numIterations = 1:1:100;    
% % coshError = zeros(length(numIterations), 1);
% % sinhError = zeros(length(numIterations), 1);
% coshPSNR = zeros(length(numIterations), 1);
% sinhPSNR = zeros(length(numIterations), 1);
% for iter = numIterations
%     j = 1;
%     for val = range
%         [myCosh(j), mySinh(j)] = Expanded_CORDIC_Model('r', 9, iter, 1, 0, val);
% %         coshError(i, j) = (abs(myCosh - cosh(val)));%/abs(cosh(val));
% %         sinhError(i, j) = (abs(mySinh - sinh(val)));%/abs(sinh(val));
% %         coshError(i, j) = psnr(myCosh, cosh(val));
% %         sinhError(i, j) = psnr(mySinh, sinh(val));
%         j = j + 1;
%     end
%     coshPSNR(i) = psnr(myCosh, cosh(range)');
%     sinhPSNR(i) = psnr(mySinh, sinh(range)');
%     i = i + 1;
% end
% figure();
% plot(numIterations, coshPSNR); title('Cosh PSNR');
% figure();
% plot(numIterations, sinhPSNR); title('Sinh PSNR');

%---------Vectoring-----------%
%Plotting with a fixed value of M
%Initialization
%Default range that standard CORDIC converges within given x0 = 1.
% range = linspace(-0.80694, 0.80694, 10000);

%Range that should be fine for any |atanh(y/x)| ~ 12.42644
%So, roughly any (x, y) below y = x. Fix x0 = 1, then it's any y satisfying
%|y| <= 1.
range = linspace(-1, 1, 10000);

myATanh = zeros(length(range),1);
i = 1;
%Calculation
for val = range
   myATanh(i) = Expanded_CORDIC_Model('v', 5, 128, 1, val, 0);
   i = i + 1;
end
%Plotting
figure();
% %Plotting myATanh
subplot(2,1,1); plot(range, myATanh); axis([-2 2 -4 4]); title('CORDIC Model ATanh');
%Plotting MATLAB ATanh
subplot(2,1,2); plot(range, atanh(range)); axis([-2 2 -4 4]); title('MATLAB ATanh');

% %Error vs Num-Iterations for fixed M
% i = 1;
% error = zeros(length(1:1:100),1);
% for numIterations = 1:1:100
%     error(i) = abs(Expanded_CORDIC_Model('v', 5, numIterations, 1, 0.9, 0) - atanh(0.9));
%     i = i + 1;
% end
% %Plotting
% figure();
% plot(1:1:100, error, 'ro'); title('CORDIC ATanh Error');

% ATanh PSNR
i = 1;
range = linspace(-1, 1, 100);
numIterations = 1:1:100;    
aTanhError = zeros(length(range), length(numIterations));
for val = range
    j = 1;
    for iter = numIterations
          [myATanh, throwAway] = Expanded_CORDIC_Model('v', 9, iter, 1, val, 0);
%         coshError(i, j) = (abs(myCosh - cosh(val)));%/abs(cosh(val));
%         sinhError(i, j) = (abs(mySinh - sinh(val)));%/abs(sinh(val));
%         coshError(i, j) = psnr(myCosh, cosh(val));
%         sinhError(i, j) = psnr(mySinh, sinh(val));
          aTanhError(i, j) = psnr(myATanh, atanh(val)');
        j = j + 1;
    end
    i = i + 1;
end
figure();
surf(aTanhError); title('ATanh PSNR');
xlabel('Number Iterations'); ylabel('Value'); zlabel('PSNR');
% set(gca, 'YTickLabel', linspace(range(1), range(length(range)-1), 6));