---------------------------------------------------------------------------
-- This VHDL file was developed by Daniel Llamocca (2014).  It may be
-- freely copied and/or distributed at no cost.  Any persons using this
-- file for any purpose do so at their own risk, and are responsible for
-- the results of such use.  Daniel Llamocca does not guarantee that
-- this file is complete, correct, or fit for any particular purpose.
-- NO WARRANTY OF ANY KIND IS EXPRESSED OR IMPLIED.  This notice must
-- accompany any copy of this file.
--------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

library UNISIM;
use UNISIM.vcomponents.all;

library work;
use work.pack_xtras.all;
--use work.lpm_components.all;

entity vga_ctrl_simple is
	generic (clock_pixel_ratio : integer:= 2;
	         nbits: integer:= 3); -- number of bits for each pixel. Example: 3, 8, 12, 15 
	port ( clock: in std_logic;	
			 resetn: in std_logic;   
			 SW: in std_logic_vector (nbits-1 downto 0);
			 RGB: out std_logic_vector (nbits-1 downto 0);
			 HS, VS: out std_logic;
			 vga_clk: out std_logic;
			 -- debug signals
			 video_on: out std_logic;
			 hcount, vcount: out std_logic_vector (9 downto 0));
end vga_ctrl_simple;

architecture structure of vga_ctrl_simple is	
	signal RGB_buf: std_logic_vector (nbits-1 downto 0);
	signal vga_tick: std_logic;
	signal video_on_buf: std_logic;
	signal hcount_buf, vcount_buf: std_logic_vector (9 downto 0);
	
begin
	
vga_clk <= vga_tick;

vga: vga_display generic map (clock_pixel_ratio => clock_pixel_ratio) 
	  port map (clock, resetn, vga_tick, video_on_buf, hcount_buf, vcount_buf, HS,VS);

ro: my_rege generic map (N => nbits)
    port map (clock => clock, resetn => '1', E => vga_tick, sclr => '0', D => sw, Q => RGB_buf);
	 
    -- This is very important, zeros MUST BE WRITEN when we are in the back or front porch	 
	 RGB <= rgb_buf when video_on_buf = '1' else (others => '0');	 
	 -- Usually, the controller will perform this task by itself:
	 -- 'vga_display' provides hc, vc, so that we know that we are not in hc=[0,639], we MUST write zero

video_on <= video_on_buf;
hcount <= hcount_buf;
vcount <= vcount_buf;

end structure;
