
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
 
ENTITY atb_vga_ctrl IS
END atb_vga_ctrl;
 
architecture behavior OF atb_vga_ctrl IS  
   -- Component Declaration for the Unit Under Test (UUT) 	 
	component vga_ctrl_12b
		port ( clock: in std_logic;	
				 resetn: in std_logic; -- low level reset		   
				 SW: in std_logic_vector (11 downto 0);
				 R, G, B: out std_logic_vector (3 downto 0);
				 HS, VS: out std_logic);
				 --vga_clk: out std_logic;
				 -- debug signals
				 --video_on: out std_logic;
				 --hcount, vcount: out std_logic_vector (9 downto 0));
	end component;

   --Inputs
   signal clock : std_logic := '0';
   signal resetn : std_logic := '0';
   signal SW : std_logic_vector(11 downto 0) := (others => '0');

 	--Outputs
   signal R : std_logic_vector (3 downto 0);
   signal G : std_logic_vector (3 downto 0);
   signal B : std_logic_vector (3 downto 0);
   signal HS : std_logic;
   signal VS : std_logic;

   -- Clock period definitions
	signal CYCLE: integer := 1;
	constant PERIOD : time := 20 ns; -- 50 MHz clock
	constant DUTY_CYCLE : real := 0.5;
   constant OFFSET : time := 100 ns;
 
begin
 
	-- Instantiate the Unit Under Test (UUT)
   uut: vga_ctrl_12b port map (clock, resetn, SW, R,G,B, HS,VS);

   -- Clock process definitions
ck: process
		begin
			wait for OFFSET; -- Wait 100 ns for global reset to finish
			clock_loop: loop -- loop that defines the PLB_clock
				clock <= '0';
				wait for (PERIOD - (PERIOD*DUTY_CYCLE));
				clock <= '1';
				cycle <= cycle + 1;
				wait for (PERIOD*DUTY_CYCLE);
			end loop clock_loop;
	 end process;
 
   -- Stimulus process
   stim_proc: process
   begin		
      -- hold reset state for 100 ns.
      wait for OFFSET;	resetn <= '1';

      wait for PERIOD*5;
		wait;
      
   end process;

END;
