---------------------------------------------------------------------------
-- This VHDL file was developed by Daniel Llamocca (2013).  It may be
-- freely copied and/or distributed at no cost.  Any persons using this
-- file for any purpose do so at their own risk, and are responsible for
-- the results of such use.  Daniel Llamocca does not guarantee that
-- this file is complete, correct, or fit for any particular purpose.
-- NO WARRANTY OF ANY KIND IS EXPRESSED OR IMPLIED.  This notice must
-- accompany any copy of this file.
--------------------------------------------------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
use ieee.std_logic_arith.all;
 
ENTITY tb_mydec4to16 IS
END tb_mydec4to16;
 
ARCHITECTURE behavior OF tb_mydec4to16 IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
    component mydec4to16
        port ( w: in std_logic_vector (3 downto 0);
               E: in std_logic;
               y: out std_logic_vector (15 downto 0));
    end component;
    
   --Inputs
   signal w : std_logic_vector(3 downto 0) := (others => '0');
   signal E : std_logic := '0';

 	--Outputs
   signal y : std_logic_vector(15 downto 0);
   
BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: mydec4to16 PORT MAP ( w => w, E => E, y => y);
   
   -- Stimulus process
   stim_proc: process
   begin		
      -- hold reset state for 100 ns.
      wait for 100 ns;	

      -- insert stimulus here 
		E <= '1';
		gi: for i in 0 to 15 loop
		          w <= conv_std_logic_vector(i,4); wait for 20 ns;
		    end loop;
--		w <= "0000"; wait for 20 ns;
--		w <= "0001"; wait for 20 ns;
--		w <= "0010"; wait for 20 ns;
--		w <= "0011"; wait for 20 ns;
--		w <= "0100"; wait for 20 ns;
--		w <= "0101"; wait for 20 ns;
--		w <= "0110"; wait for 20 ns;
--		w <= "0111"; wait for 20 ns;
--		w <= "1000"; wait for 20 ns;
--        w <= "1001"; wait for 20 ns;
--        w <= "1010"; wait for 20 ns;
--        w <= "1011"; wait for 20 ns;
--        w <= "1100"; wait for 20 ns;
--        w <= "1101"; wait for 20 ns;
--        w <= "1110"; wait for 20 ns;
--        w <= "1111"; wait for 20 ns;		
		E <= '0'; w <= "0000";

      wait;
   end process;

END;
